/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.io.CharConversionException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.ui.ColorHighlighter;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

public class UnitDetails
extends DetailsPanel {
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.UnitDetails");
    private RequestProcessor.Task unitDetailsTask = null;
    private static final RequestProcessor UNIT_DETAILS_PROCESSOR = new RequestProcessor("unit-details-processor", 1, true);

    public UnitDetails() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UnitDetails"));
    }

    public void setUnit(Unit u) {
        this.setUnit(u, null);
    }

    public void setUnit(final Unit u, Action action) {
        if (this.unitDetailsTask != null && !this.unitDetailsTask.isFinished()) {
            this.unitDetailsTask.cancel();
        }
        if (u == null) {
            this.getDetails().setText("<i>" + UnitDetails.getBundle("UnitDetails_Category_NoDescription") + "</i>");
            this.setTitle(null);
        } else {
            try {
                this.setTitle(XMLUtil.toElementContent((String)u.getDisplayName()));
            }
            catch (CharConversionException e) {
                this.err.log(Level.INFO, null, e);
                return;
            }
            this.setActionListener(action);
            this.setUnitText(u, this.getUnitText(u, false));
            if (u instanceof Unit.Update) {
                this.unitDetailsTask = UNIT_DETAILS_PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final StringBuilder text = UnitDetails.this.getUnitText(u, true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UnitDetails.this.setUnitText(u, text);
                            }
                        });
                    }
                });
            }
        }
    }

    private void setUnitText(Unit u, StringBuilder text) {
        this.getDetails().setText(text.toString());
        this.setUnitHighlighing(u);
    }

    private StringBuilder getUnitText(Unit u, boolean collectDependencies) {
        StringBuilder text = new StringBuilder();
        if (u instanceof Unit.Available) {
            Unit.Available u1 = (Unit.Available)u;
            UpdateUnitProvider.CATEGORY c = u1.getSourceCategory();
            String categoryName = Utilities.getCategoryName(c);
            URL icon = Utilities.getCategoryIcon(c);
            text.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
            text.append("<td><img src=\"" + icon.toExternalForm() + "\"></img></td>");
            text.append("<td>&nbsp;&nbsp;</td>");
            text.append("<td><b>" + categoryName + "</b></td>");
            text.append("</tr></table><br>");
        }
        if (Utilities.modulesOnly() || Utilities.showExtendedDescription()) {
            text.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_CodeName") + "</b>" + u.updateUnit.getCodeName());
            text.append("<br>");
        }
        String desc = null;
        if (u instanceof Unit.Update) {
            Unit.Update uu = (Unit.Update)u;
            text.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_InstalledVersion") + "</b>" + uu.getInstalledVersion() + "<br>");
            text.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_AvailableVersion") + "</b>" + uu.getAvailableVersion() + "<br>");
            desc = this.getDependencies(uu, collectDependencies);
        } else {
            text.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Version") + "</b>" + u.getDisplayVersion() + "<br>");
        }
        if (u.getAuthor() != null && u.getAuthor().length() > 0) {
            text.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Author") + "</b>" + u.getAuthor() + "<br>");
        }
        if (u.getDisplayDate() != null && u.getDisplayDate().length() > 0) {
            text.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Date") + "</b>" + u.getDisplayDate() + "<br>");
        }
        text.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Source") + "</b>" + u.getSource() + "<br>");
        if (u.getHomepage() != null && u.getHomepage().length() > 0) {
            text.append("<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Homepage") + "</b><a href=\"" + u.getHomepage() + "\">" + u.getHomepage() + "</a><br>");
        }
        if (u.getNotification() != null && u.getNotification().length() > 0) {
            text.append("<br><h3>" + UnitDetails.getBundle("UnitDetails_Plugin_Notification") + "</h3>");
            text.append("<font color=\"red\">");
            text.append(u.getNotification());
            text.append("</font><br>");
        }
        if (u.getDescription() != null && u.getDescription().length() > 0) {
            text.append("<br><h3>" + UnitDetails.getBundle("UnitDetails_Plugin_Description") + "</h3>");
            text.append(u.getDescription());
        }
        if (desc != null && desc.length() > 0) {
            text.append("<br><br><h4>" + UnitDetails.getBundle("Unit_InternalUpdates_Title") + "</h4>");
            text.append(desc);
        }
        return text;
    }

    private void setUnitHighlighing(Unit u) {
        Color highlightColor = Color.YELLOW;
        ColorHighlighter highlighter = new ColorHighlighter(this.getDetails(), highlightColor);
        int idx = highlighter.highlight(u.getFilter());
        this.getDetails().setCaretPosition(idx > 0 ? idx : 0);
    }

    private String getDependencies(Unit.Update uu, boolean collectDependencies) {
        if (!collectDependencies) {
            return "<i>" + UnitDetails.getBundle("UnitDetails_Plugin_Collecting_Dependencies") + "</i><br>";
        }
        Unit.Update u = uu;
        HashSet<UpdateElement> internalUpdates = new HashSet<UpdateElement>();
        if (!(u instanceof Unit.InternalUpdate)) {
            OperationContainer container = OperationContainer.createForUpdate();
            container.add(u.updateUnit, uu.getRelevantElement());
            LinkedHashSet<UpdateElement> required = new LinkedHashSet<UpdateElement>();
            List infos = container.listAll();
            for (OperationContainer.OperationInfo info : infos) {
                Set reqs = info.getRequiredElements();
                for (UpdateElement req : reqs) {
                    if (req.getUpdateUnit().getInstalled() == null || req.getUpdateUnit().isPending()) continue;
                    required.add(req);
                }
            }
            for (OperationContainer.OperationInfo i : infos) {
                if (i.getUpdateUnit().equals((Object)u.updateUnit) || i.getUpdateUnit().isPending()) continue;
                required.add(i.getUpdateElement());
            }
            if (required.size() != 0) {
                ArrayList<UpdateElement> visibleRequirements = new ArrayList<UpdateElement>();
                for (UpdateElement ue : required) {
                    if (!ue.getUpdateUnit().getType().equals((Object)UpdateManager.TYPE.KIT_MODULE)) continue;
                    visibleRequirements.add(ue);
                }
                OperationContainer containerForVisibleUpdate = OperationContainer.createForUpdate();
                OperationContainer containerForVisibleInstall = OperationContainer.createForInstall();
                ArrayList<OperationContainer.OperationInfo> infoList = new ArrayList<OperationContainer.OperationInfo>();
                for (UpdateElement ue : visibleRequirements) {
                    if (containerForVisibleUpdate.canBeAdded(ue.getUpdateUnit(), ue)) {
                        infoList.add(containerForVisibleUpdate.add(ue));
                        continue;
                    }
                    if (!containerForVisibleInstall.canBeAdded(ue.getUpdateUnit(), ue)) continue;
                    infoList.add(containerForVisibleInstall.add(ue));
                }
                ArrayList<UpdateElement> requiredElementsCoveredByVisible = new ArrayList<UpdateElement>();
                for (OperationContainer.OperationInfo i : infoList) {
                    Set visibleRequired = i.getRequiredElements();
                    for (UpdateElement r : visibleRequired) {
                        if (requiredElementsCoveredByVisible.contains(r)) continue;
                        requiredElementsCoveredByVisible.add(r);
                    }
                }
                for (UpdateElement ue : required) {
                    if (requiredElementsCoveredByVisible.contains(ue) || ue.getUpdateUnit().getType().equals((Object)UpdateManager.TYPE.KIT_MODULE)) continue;
                    internalUpdates.add(ue);
                }
            }
        } else {
            Unit.InternalUpdate iu = (Unit.InternalUpdate)u;
            OperationContainer updContainer = OperationContainer.createForUpdate();
            for (UpdateUnit inv : iu.getUpdateUnits()) {
                updContainer.add((UpdateElement)inv.getAvailableUpdates().get(0));
            }
            for (OperationContainer.OperationInfo info : updContainer.listAll()) {
                internalUpdates.add(info.getUpdateElement());
                for (UpdateElement r : info.getRequiredElements()) {
                    if (r.getUpdateUnit().getInstalled() == null || r.getUpdateUnit().isPending()) continue;
                    internalUpdates.add(r);
                }
            }
        }
        StringBuilder desc = new StringBuilder();
        try {
            TreeSet<UpdateElement> sorted = new TreeSet<UpdateElement>(new Comparator<UpdateElement>(){

                @Override
                public int compare(UpdateElement o1, UpdateElement o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            sorted.addAll(internalUpdates);
            for (UpdateElement ue : sorted) {
                this.appendInternalUpdates(desc, ue);
            }
        }
        catch (Exception e) {
            this.err.log(Level.INFO, "Exception", e);
        }
        return desc.toString();
    }

    private void appendInternalUpdates(StringBuilder desc, UpdateElement ue) {
        desc.append("&nbsp;&nbsp;&nbsp;&nbsp;");
        desc.append(ue.getDisplayName());
        if (ue.getUpdateUnit().getInstalled() != null) {
            desc.append(" [" + ue.getUpdateUnit().getInstalled().getSpecificationVersion() + "->");
        } else {
            desc.append(" <span color=\"red\">" + UnitDetails.getBundle("UnitDetails_New_Internal_Update_Mark") + "</span> [");
        }
        desc.append(((UpdateElement)ue.getUpdateUnit().getAvailableUpdates().get(0)).getSpecificationVersion());
        desc.append("]<br>");
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage(UnitDetails.class, (String)key);
    }
}

