/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.persistence.mapping.core.util;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.utility.MergedBundle;
import com.sun.jdo.spi.persistence.utility.logging.LogHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.openide.util.NbBundle;

public class MappingContext {
    protected static final String _componentName = "mapping.module";
    private static final String _baseName = "org.netbeans.modules.j2ee.sun.persistence.mapping.core.resources.Bundle";
    private final Model _model;
    private final String _brandingSuffix;
    private final boolean _isJDOExposed;
    private final ResourceBundle _bundle;
    private final ClassLoader _classLoader;

    protected MappingContext(Model model) {
        this(model, null, MappingContext.class.getClassLoader());
    }

    protected MappingContext(Model model, String brandingSuffix, ClassLoader classLoader) {
        this(model, brandingSuffix, true, classLoader);
    }

    protected MappingContext(Model model, String brandingSuffix, boolean isJDOExposed, ClassLoader classLoader) {
        this._model = model;
        this._brandingSuffix = brandingSuffix;
        this._isJDOExposed = isJDOExposed;
        this._classLoader = classLoader;
        this._bundle = this.getBrandedBundle(_baseName);
    }

    public Model getModel() {
        return this._model;
    }

    public String getBrandingSuffix() {
        return this._brandingSuffix;
    }

    public boolean isJDOExposed() {
        return this._isJDOExposed;
    }

    public ResourceBundle getBrandedBundle(String baseName) {
        ResourceBundle bundle = NbBundle.getBundle((String)baseName, (Locale)Locale.getDefault(), (ClassLoader)this._classLoader);
        if (this._brandingSuffix != null) {
            ResourceBundle extraBundle = null;
            try {
                extraBundle = NbBundle.getBundle((String)(baseName + '_' + this._brandingSuffix), (Locale)Locale.getDefault(), (ClassLoader)this._classLoader);
            }
            catch (MissingResourceException e) {
                String message = MessageFormat.format(bundle.getString("mapping.module.context.extra_bundle_not_found"), this._brandingSuffix);
                this.getLogger().log(900, message, (Throwable)e);
            }
            if (extraBundle != null) {
                bundle = new MergedBundle(extraBundle, bundle);
            }
        }
        return bundle;
    }

    public String getString(String key) {
        return this._bundle.getString(key);
    }

    public char getMnemonic(String key) {
        return this.getString(key).trim().charAt(0);
    }

    public Logger getLogger() {
        return LogHelper.getLogger((String)_componentName, (String)_baseName, (ClassLoader)MappingContext.class.getClassLoader());
    }
}

