/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast.util;

import org.jruby.nb.ast.AliasNode;
import org.jruby.nb.ast.ArgumentNode;
import org.jruby.nb.ast.AttrAssignNode;
import org.jruby.nb.ast.BackRefNode;
import org.jruby.nb.ast.BignumNode;
import org.jruby.nb.ast.BlockArgNode;
import org.jruby.nb.ast.CallNode;
import org.jruby.nb.ast.ClassVarAsgnNode;
import org.jruby.nb.ast.ClassVarDeclNode;
import org.jruby.nb.ast.ClassVarNode;
import org.jruby.nb.ast.Colon2Node;
import org.jruby.nb.ast.Colon3Node;
import org.jruby.nb.ast.ConstDeclNode;
import org.jruby.nb.ast.ConstNode;
import org.jruby.nb.ast.DAsgnNode;
import org.jruby.nb.ast.DRegexpNode;
import org.jruby.nb.ast.DVarNode;
import org.jruby.nb.ast.DotNode;
import org.jruby.nb.ast.FCallNode;
import org.jruby.nb.ast.FixnumNode;
import org.jruby.nb.ast.FlipNode;
import org.jruby.nb.ast.FloatNode;
import org.jruby.nb.ast.GlobalAsgnNode;
import org.jruby.nb.ast.GlobalVarNode;
import org.jruby.nb.ast.InstAsgnNode;
import org.jruby.nb.ast.InstVarNode;
import org.jruby.nb.ast.LocalAsgnNode;
import org.jruby.nb.ast.LocalVarNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NthRefNode;
import org.jruby.nb.ast.OpElementAsgnNode;
import org.jruby.nb.ast.RegexpNode;
import org.jruby.nb.ast.StrNode;
import org.jruby.nb.ast.SymbolNode;
import org.jruby.nb.ast.UndefNode;
import org.jruby.nb.ast.VAliasNode;
import org.jruby.nb.ast.VCallNode;
import org.jruby.nb.ast.XStrNode;

public class SexpMaker {
    private final StringBuilder sb = new StringBuilder();

    public static String create(Node node) {
        SexpMaker maker = new SexpMaker();
        maker.process(node);
        return maker.toString();
    }

    public static String create(String methodName, Node argsNode, Node body) {
        SexpMaker maker = new SexpMaker();
        maker.processMethod(methodName, argsNode, body);
        return maker.toString();
    }

    private SexpMaker() {
    }

    private void processMethod(String methodName, Node argsNode, Node body) {
        this.sb.append("(method ").append(methodName).append(' ');
        this.process(argsNode);
        this.sb.append(" ");
        this.process(body);
        this.sb.append(")");
    }

    public String toString() {
        return this.sb.toString();
    }

    private void process(Node node) {
        if (node == null) {
            this.sb.append("null");
            return;
        }
        this.sb.append("(");
        this.shortName(node);
        this.leafInfo(node);
        for (Node child : node.childNodes()) {
            this.sb.append(" ");
            this.process(child);
        }
        this.sb.append(")");
    }

    private void shortName(Node node) {
        int index;
        String className = node.getClass().getName();
        if (className.endsWith("Node") && (index = (className = className.substring(0, className.length() - 4)).lastIndexOf(46)) != -1) {
            className = className.substring(index + 1);
        }
        this.sb.append(className.toLowerCase());
    }

    private void leafInfo(Node node) {
        switch (node.nodeId) {
            case ALIASNODE: {
                this.aliasNode((AliasNode)node);
                break;
            }
            case ANDNODE: {
                this.nothing(node);
                break;
            }
            case ARGSCATNODE: {
                this.nothing(node);
                break;
            }
            case ARGSPUSHNODE: {
                this.nothing(node);
                break;
            }
            case ARGUMENTNODE: {
                this.argumentNode((ArgumentNode)node);
                break;
            }
            case ARRAYNODE: {
                this.nothing(node);
                break;
            }
            case ATTRASSIGNNODE: {
                this.attrAssignNode((AttrAssignNode)node);
                break;
            }
            case BACKREFNODE: {
                this.backRefNode((BackRefNode)node);
                break;
            }
            case BEGINNODE: {
                this.nothing(node);
                break;
            }
            case BIGNUMNODE: {
                this.bignumNode((BignumNode)node);
                break;
            }
            case BLOCKARGNODE: {
                this.blockArgNode((BlockArgNode)node);
                break;
            }
            case BLOCKNODE: {
                this.nothing(node);
                break;
            }
            case BLOCKPASSNODE: {
                this.nothing(node);
                break;
            }
            case BREAKNODE: {
                this.nothing(node);
                break;
            }
            case CALLNODE: {
                this.callNode((CallNode)node);
                break;
            }
            case CASENODE: {
                this.nothing(node);
                break;
            }
            case CLASSNODE: {
                this.nothing(node);
                break;
            }
            case CLASSVARASGNNODE: {
                this.classVarAsgnNode((ClassVarAsgnNode)node);
                break;
            }
            case CLASSVARDECLNODE: {
                this.classVarDeclNode((ClassVarDeclNode)node);
                break;
            }
            case CLASSVARNODE: {
                this.classVarNode((ClassVarNode)node);
                break;
            }
            case COLON2NODE: {
                this.colon2Node((Colon2Node)node);
                break;
            }
            case COLON3NODE: {
                this.colon3Node((Colon3Node)node);
                break;
            }
            case CONSTDECLNODE: {
                this.constDeclNode((ConstDeclNode)node);
                break;
            }
            case CONSTNODE: {
                this.constNode((ConstNode)node);
                break;
            }
            case DASGNNODE: {
                this.dAsgnNode((DAsgnNode)node);
                break;
            }
            case DEFINEDNODE: {
                this.nothing(node);
                break;
            }
            case DEFNNODE: {
                this.nothing(node);
                break;
            }
            case DEFSNODE: {
                this.nothing(node);
                break;
            }
            case DOTNODE: {
                this.dotNode((DotNode)node);
                break;
            }
            case DREGEXPNODE: {
                this.dRegexpNode((DRegexpNode)node);
                break;
            }
            case DSTRNODE: {
                this.nothing(node);
                break;
            }
            case DSYMBOLNODE: {
                this.nothing(node);
                break;
            }
            case DVARNODE: {
                this.dVarNode((DVarNode)node);
                break;
            }
            case DXSTRNODE: {
                this.nothing(node);
                break;
            }
            case ENSURENODE: {
                this.nothing(node);
                break;
            }
            case EVSTRNODE: {
                this.nothing(node);
                break;
            }
            case FALSENODE: {
                this.nothing(node);
                break;
            }
            case FCALLNODE: {
                this.fCallNode((FCallNode)node);
                break;
            }
            case FIXNUMNODE: {
                this.fixnumNode((FixnumNode)node);
                break;
            }
            case FLIPNODE: {
                this.flipNode((FlipNode)node);
                break;
            }
            case FLOATNODE: {
                this.floatNode((FloatNode)node);
                break;
            }
            case FORNODE: {
                this.nothing(node);
                break;
            }
            case GLOBALASGNNODE: {
                this.globalAsgnNode((GlobalAsgnNode)node);
                break;
            }
            case GLOBALVARNODE: {
                this.globalVarNode((GlobalVarNode)node);
                break;
            }
            case HASHNODE: {
                this.nothing(node);
                break;
            }
            case IFNODE: {
                this.nothing(node);
                break;
            }
            case INSTASGNNODE: {
                this.nothing(node);
                this.instAsgnNode((InstAsgnNode)node);
                break;
            }
            case INSTVARNODE: {
                this.nothing(node);
                this.instVarNode((InstVarNode)node);
                break;
            }
            case ITERNODE: {
                this.nothing(node);
                break;
            }
            case LOCALASGNNODE: {
                this.localAsgnNode((LocalAsgnNode)node);
                break;
            }
            case LOCALVARNODE: {
                this.localVarNode((LocalVarNode)node);
                break;
            }
            case MATCH2NODE: {
                this.nothing(node);
                break;
            }
            case MATCH3NODE: {
                this.nothing(node);
                break;
            }
            case MATCHNODE: {
                this.nothing(node);
                break;
            }
            case MODULENODE: {
                this.nothing(node);
                break;
            }
            case MULTIPLEASGNNODE: {
                this.nothing(node);
                break;
            }
            case NEWLINENODE: {
                this.nothing(node);
                break;
            }
            case NEXTNODE: {
                this.nothing(node);
                break;
            }
            case NILNODE: {
                this.nothing(node);
                break;
            }
            case NOTNODE: {
                this.nothing(node);
                break;
            }
            case NTHREFNODE: {
                this.nthRefNode((NthRefNode)node);
                break;
            }
            case OPASGNANDNODE: {
                this.nothing(node);
                break;
            }
            case OPASGNNODE: {
                this.nothing(node);
                break;
            }
            case OPASGNORNODE: {
                this.nothing(node);
                break;
            }
            case OPELEMENTASGNNODE: {
                this.opElementAsgnNode((OpElementAsgnNode)node);
                break;
            }
            case ORNODE: {
                this.nothing(node);
                break;
            }
            case PREEXENODE: {
                this.nothing(node);
                break;
            }
            case POSTEXENODE: {
                this.nothing(node);
                break;
            }
            case REDONODE: {
                this.nothing(node);
                break;
            }
            case REGEXPNODE: {
                this.regexpNode((RegexpNode)node);
                break;
            }
            case RESCUEBODYNODE: {
                this.nothing(node);
                break;
            }
            case RESCUENODE: {
                this.nothing(node);
                break;
            }
            case RETRYNODE: {
                this.nothing(node);
                break;
            }
            case RETURNNODE: {
                this.nothing(node);
                break;
            }
            case ROOTNODE: {
                this.nothing(node);
                break;
            }
            case SCLASSNODE: {
                this.nothing(node);
                break;
            }
            case SELFNODE: {
                this.nothing(node);
                break;
            }
            case SPLATNODE: {
                this.nothing(node);
                break;
            }
            case STRNODE: {
                this.strNode((StrNode)node);
                break;
            }
            case SUPERNODE: {
                this.nothing(node);
                break;
            }
            case SVALUENODE: {
                this.nothing(node);
                break;
            }
            case SYMBOLNODE: {
                this.symbolNode((SymbolNode)node);
                break;
            }
            case TOARYNODE: {
                this.nothing(node);
                break;
            }
            case TRUENODE: {
                this.nothing(node);
                break;
            }
            case UNDEFNODE: {
                this.undefNode((UndefNode)node);
                break;
            }
            case UNTILNODE: {
                this.nothing(node);
                break;
            }
            case VALIASNODE: {
                this.valiasNode((VAliasNode)node);
                break;
            }
            case VCALLNODE: {
                this.vcallNode((VCallNode)node);
                break;
            }
            case WHENNODE: {
                this.nothing(node);
                break;
            }
            case WHILENODE: {
                this.nothing(node);
                break;
            }
            case XSTRNODE: {
                this.xStrNode((XStrNode)node);
                break;
            }
            case YIELDNODE: {
                this.nothing(node);
                break;
            }
            case ZARRAYNODE: {
                this.nothing(node);
                break;
            }
            case ZSUPERNODE: {
                this.nothing(node);
                break;
            }
        }
    }

    private void xStrNode(XStrNode node) {
        this.sb.append(" '").append((CharSequence)node.getValue()).append("'");
    }

    private void vcallNode(VCallNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void valiasNode(VAliasNode node) {
        this.sb.append(" ").append(node.getOldName()).append(node.getNewName());
    }

    private void undefNode(UndefNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void strNode(StrNode node) {
        this.sb.append(" '").append((CharSequence)node.getValue()).append("'");
    }

    private void regexpNode(RegexpNode node) {
        this.sb.append(" ").append((CharSequence)node.getValue()).append(" ").append(node.getOptions());
    }

    private void opElementAsgnNode(OpElementAsgnNode node) {
        this.sb.append(" ").append(node.getOperatorName());
    }

    private void nthRefNode(NthRefNode node) {
        this.sb.append(" ").append(node.getMatchNumber());
    }

    private void localAsgnNode(LocalAsgnNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void instVarNode(InstVarNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void instAsgnNode(InstAsgnNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void globalVarNode(GlobalVarNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void globalAsgnNode(GlobalAsgnNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void floatNode(FloatNode node) {
        this.sb.append(" ").append(node.getValue());
    }

    private void flipNode(FlipNode node) {
        this.sb.append(" ").append(node.isExclusive());
    }

    private void fixnumNode(FixnumNode node) {
        this.sb.append(" ").append(node.getValue());
    }

    private void fCallNode(FCallNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void dVarNode(DVarNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void blockArgNode(BlockArgNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void backRefNode(BackRefNode node) {
        this.sb.append(" ").append(node.getType());
    }

    private void symbolNode(SymbolNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void localVarNode(LocalVarNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void argumentNode(ArgumentNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void dRegexpNode(DRegexpNode node) {
        this.sb.append(" ").append(node.getOnce()).append(" ").append(node.getOptions());
    }

    private void dotNode(DotNode node) {
        this.sb.append(" ").append(node.isExclusive()).append(" ").append(node.isLiteral());
    }

    private void dAsgnNode(DAsgnNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void constNode(ConstNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void constDeclNode(ConstDeclNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void colon3Node(Colon3Node node) {
        this.sb.append(" ").append(node.getName());
    }

    private void colon2Node(Colon2Node node) {
        this.sb.append(" ").append(node.getName());
    }

    private void classVarNode(ClassVarNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void classVarDeclNode(ClassVarDeclNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void classVarAsgnNode(ClassVarAsgnNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void callNode(CallNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void bignumNode(BignumNode node) {
        this.sb.append(" ").append(node.getValue());
    }

    private void attrAssignNode(AttrAssignNode node) {
        this.sb.append(" ").append(node.getName());
    }

    private void aliasNode(AliasNode node) {
        this.sb.append(" ").append(node.getOldName()).append(node.getNewName());
    }

    private void nothing(Node node) {
    }
}

