/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EjbGenerationUtil {
    private static final String[] EJB_NAME_CONTEXTS = new String[]{"Session", "Entity", "MessageDriven"};

    public static String getFullClassName(String string, String string2) {
        return string == null || string.length() == 0 ? string2 : string + "." + string2;
    }

    public static String getBaseName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String[] getPackages(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            EjbGenerationUtil.findPackages(sourceGroupArray[i].getRootFolder(), "", treeSet);
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    private static void findPackages(FileObject fileObject, String string, Set<String> set) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            String string2 = string + (string.length() != 0 ? "." : "") + fileObject2.getName();
            set.add(string2);
            EjbGenerationUtil.findPackages(fileObject2, string2, set);
        }
    }

    public static boolean isEjbNameInDD(String string, EjbJar ejbJar) {
        EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
        CommonDDBean commonDDBean = null;
        if (enterpriseBeans != null) {
            for (int i = 0; i < EJB_NAME_CONTEXTS.length && (commonDDBean = enterpriseBeans.findBeanByName(EJB_NAME_CONTEXTS[i], "EjbName", string)) == null; ++i) {
            }
        }
        return enterpriseBeans != null && commonDDBean != null;
    }

    public static FileObject getPackageFileObject(SourceGroup sourceGroup, String string, Project project) {
        String string2 = string.replace('.', '/');
        FileObject fileObject = null;
        fileObject = sourceGroup.getRootFolder().getFileObject(string2);
        if (fileObject != null) {
            return fileObject;
        }
        File file = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
        File file2 = new File(file, string2);
        file2.mkdirs();
        fileObject = sourceGroup.getRootFolder().getFileObject(string2);
        return fileObject;
    }

    public static String getSelectedPackageName(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        String string = null;
        for (int i = 0; i < sourceGroupArray.length && string == null; ++i) {
            string = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
        }
        if (string != null) {
            string = string.replaceAll("/", ".");
        }
        return string + "";
    }
}

