/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.actions.ContextAction;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public abstract class NodeAction<T>
extends ContextAction<Node> {
    protected FileObject defaultDir = null;

    protected NodeAction(String name) {
        super(Node.class);
        this.putValue("Name", name);
    }

    private void perform(T[] obj, Node node, J2MEProjectProperties j2meProperties) {
        J2MEProject project = (J2MEProject)node.getLookup().lookup(J2MEProject.class);
        ProjectConfiguration conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
        assert (project != null);
        String propName = conf.getDisplayName().equals(project.getConfigurationHelper().getDefaultConfiguration().getDisplayName()) ? "libs.classpath" : "configs." + conf.getDisplayName() + "." + "libs.classpath";
        List list = (List)j2meProperties.get(propName);
        if (list == null) {
            throw new NullPointerException("Could not get a list of properties for " + propName);
        }
        List<VisualClassPathItem> newList = new ArrayList<VisualClassPathItem>(list);
        newList = this.addItems(obj, newList, node);
        j2meProperties.put(propName, (Object)newList);
    }

    private static void save(final HashMap<J2MEProject, J2MEProjectProperties> map) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                for (J2MEProject project : map.keySet()) {
                    J2MEProjectProperties j2meProperties = (J2MEProjectProperties)map.get(project);
                    j2meProperties.store();
                    try {
                        ProjectManager.getDefault().saveProject((Project)project);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            }
        });
    }

    public static void pasteAction(final HashSet<VisualClassPathItem> items, Node node) {
        final J2MEProject project = (J2MEProject)node.getLookup().lookup(J2MEProject.class);
        final ProjectConfiguration conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
        final HashMap map = new HashMap();
        assert (project != null);
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                J2MEProjectProperties j2meProperties = new J2MEProjectProperties(project, (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class), project.getConfigurationHelper());
                String propName = conf.getDisplayName().equals(project.getConfigurationHelper().getDefaultConfiguration().getDisplayName()) ? "libs.classpath" : "configs." + conf.getDisplayName() + "." + "libs.classpath";
                List list = (List)j2meProperties.get(propName);
                HashSet set = new HashSet(list);
                set.addAll(items);
                list.clear();
                list.addAll(set);
                j2meProperties.put(propName, (Object)list);
                map.put(project, j2meProperties);
                NodeAction.save(map);
            }
        });
    }

    protected synchronized void performAction(Node[] activatedNodes) {
        J2MEProject proj = (J2MEProject)activatedNodes[0].getLookup().lookup(J2MEProject.class);
        for (Node node : activatedNodes) {
            J2MEProject project = (J2MEProject)node.getLookup().lookup(J2MEProject.class);
            if (proj == project) continue;
            proj = null;
            break;
        }
        this.defaultDir = proj != null ? proj.getProjectDirectory() : null;
        T[] obj = this.getItems();
        if (obj != null) {
            HashMap<J2MEProject, J2MEProjectProperties> map = new HashMap<J2MEProject, J2MEProjectProperties>();
            for (Node node : activatedNodes) {
                J2MEProject project = (J2MEProject)node.getLookup().lookup(J2MEProject.class);
                J2MEProjectProperties j2meProperties = map.get(project);
                if (j2meProperties == null) {
                    j2meProperties = new J2MEProjectProperties(project, (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class), (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class), project.getConfigurationHelper());
                    map.put(project, j2meProperties);
                }
                this.perform(obj, node, j2meProperties);
            }
            NodeAction.save(map);
        }
    }

    public final void actionPerformed(Collection<? extends Node> nodes) {
        Node[] n = nodes.toArray(new Node[nodes.size()]);
        this.performAction(n);
    }

    protected abstract List<VisualClassPathItem> addItems(T[] var1, List<VisualClassPathItem> var2, Node var3);

    protected abstract T[] getItems();
}

