/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.GlobalAbilitiesCache;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.customizer.AddAbilityPanel;
import org.netbeans.modules.mobility.project.ui.customizer.AddAttributePanel;
import org.netbeans.modules.mobility.project.ui.customizer.CustomizerAbilities;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AbilitiesPanel
implements NavigatorPanel {
    static ABHint hintInstance = new ABHint();
    private static String MULTIPLE_VALUES = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_MultipleValues");
    private static String REMOVE = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_RemoveAbility");
    private static String ADD = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_AddAbility");
    private static String COPY = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_CopyAbility");
    private static String PASTE = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_PasteAbility");
    private Reference<ABPanel> instance;

    public JComponent getComponent() {
        return this.getComponent(true);
    }

    private ABPanel getComponent(boolean create) {
        ABPanel result = null;
        if (this.instance != null) {
            result = this.instance.get();
        }
        if (result == null) {
            result = new ABPanel();
            this.instance = new WeakReference<ABPanel>(result);
        }
        return result;
    }

    public String getDisplayName() {
        String cf = "";
        if (ABPanel.selectedNodes != null) {
            cf = ABPanel.selectedNodes.length == 1 ? " : " + ((ProjectConfiguration)ABPanel.selectedNodes[0].getLookup().lookup(ProjectConfiguration.class)).getDisplayName() : " : " + NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_MultipleConfigs");
        }
        return "Abilities" + cf;
    }

    public String getDisplayHint() {
        return "Abilities";
    }

    public void panelActivated(Lookup context) {
        context.lookupAll(Node.class);
        Node[] nodes = context.lookupAll(Node.class).toArray(new Node[context.lookupAll(Node.class).size()]);
        ABPanel pnl = this.getComponent(true);
        pnl.setAbilities(nodes);
    }

    public void panelDeactivated() {
        ABPanel pnl = this.getComponent(false);
        if (pnl != null) {
            pnl.setAbilities(new Node[0]);
        }
    }

    public Lookup getLookup() {
        return null;
    }

    static class EditableTableModel
    extends CustomizerAbilities.StorableTableModel {
        private boolean editable = true;

        EditableTableModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && this.editable;
        }

        void setEditable(boolean edit) {
            this.editable = edit;
        }

        void removeListeners() {
            Object[] list;
            for (Object l : list = this.listenerList.getListenerList()) {
                if (!(l instanceof TableModelListener) || l instanceof JTable) continue;
                this.listenerList.remove(TableModelListener.class, (TableModelListener)l);
            }
        }
    }

    static class ABPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private static JScrollPane scrollPane;
        private static final EditableTableModel tableModel;
        private static final JTable table;
        private static final Object[] emptyTable;
        private static J2MEProject project;
        private static Node[] selectedNodes;
        private static Node defaultConfig;
        private Action[] actions = new Action[]{new AddAction(), new RemoveAction(), new CopyAction(), new PasteAction()};
        private static ExplorerManager manager;
        private static HashMap<String, String> copiedAbilities;
        private static boolean pasteActionEnabled;

        void addAbility(EditableProperties ep, AntProjectHelper helper, String key, String value) {
            if (defaultConfig != null) {
                String abilities = ep.getProperty("abilities");
                Map ab = CommentingPreProcessor.decodeAbilitiesMap((String)abilities);
                if (!ab.containsKey(key)) {
                    ab.put(key, value);
                    abilities = CommentingPreProcessor.encodeAbilitiesMap((Map)ab);
                    ep.put("abilities", abilities);
                    helper.putProperties("nbproject/project.properties", ep);
                } else {
                    ErrorManager.getDefault().log(16, "Ability " + key + " already exist in the configuration " + "DefaultConfiguration" + ". Its value will not be modified");
                }
            }
            for (Node node : selectedNodes) {
                ProjectConfiguration conf;
                if (node == defaultConfig || (conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class)) == null) continue;
                String abilities = ep.getProperty("configs." + conf.getDisplayName() + "." + "abilities");
                if (abilities == null) {
                    abilities = ep.getProperty("abilities");
                }
                Map ab = CommentingPreProcessor.decodeAbilitiesMap((String)abilities);
                String oldVal = (String)ab.get(key);
                if (!ab.containsKey(key)) {
                    ab.put(key, value);
                    abilities = CommentingPreProcessor.encodeAbilitiesMap((Map)ab);
                    ep.put("configs." + conf.getDisplayName() + "." + "abilities", abilities);
                    continue;
                }
                ErrorManager.getDefault().log(16, "Ability " + key + " already exist in the configuration " + conf.getDisplayName() + ". Its value will not be modified");
            }
            helper.putProperties("nbproject/project.properties", ep);
        }

        private ABPanel() {
            this.actions[3].setEnabled(pasteActionEnabled);
            this.initComponents();
            scrollPane.setViewportView(table);
            table.setSelectionMode(1);
            final TableCellEditor editor = table.getDefaultEditor(String.class);
            final JPopupMenu pm = new JPopupMenu();
            for (Action act : this.actions) {
                pm.add(act);
            }
            MouseAdapter listener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        int row = table.rowAtPoint(e.getPoint());
                        int[] selRows = table.getSelectedRows();
                        if (row >= 0 && (selRows.length >= 2 && (row < selRows[0] || row > selRows[selRows.length - 1]) || selRows.length < 2)) {
                            table.setRowSelectionInterval(row, row);
                        }
                        pm.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            };
            scrollPane.addMouseListener(listener);
            table.addMouseListener(listener);
            editor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    String newValue;
                    int row = table.getSelectedRow();
                    int column = table.getSelectedColumn();
                    if (row < 0 || column < 0) {
                        return;
                    }
                    final String key = tableModel.getValueAt(row, 0);
                    String value = tableModel.getValueAt(row, 1);
                    if (!value.equals(newValue = (String)editor.getCellEditorValue())) {
                        tableModel.editRow(key, newValue);
                        ProjectManager.mutex().writeAccess(new Runnable(){

                            @Override
                            public void run() {
                                AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
                                EditableProperties ep = helper.getProperties("nbproject/project.properties");
                                if (defaultConfig != null) {
                                    String abilities = ep.getProperty("abilities");
                                    Map ab = CommentingPreProcessor.decodeAbilitiesMap((String)abilities);
                                    ab.put(key, newValue);
                                    abilities = CommentingPreProcessor.encodeAbilitiesMap((Map)ab);
                                    ep.put("abilities", abilities);
                                    helper.putProperties("nbproject/project.properties", ep);
                                }
                                for (Node node : selectedNodes) {
                                    Map ab;
                                    String defCf;
                                    if (node == defaultConfig) continue;
                                    ProjectConfiguration conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                                    String abilities = ep.getProperty("configs." + conf.getDisplayName() + "." + "abilities");
                                    if (abilities == null) {
                                        abilities = ep.getProperty("abilities");
                                    }
                                    if (((defCf = (String)(ab = CommentingPreProcessor.decodeAbilitiesMap((String)abilities)).get(key)) != null || newValue == null) && defCf.equals(newValue)) continue;
                                    ab.put(key, newValue);
                                    abilities = CommentingPreProcessor.encodeAbilitiesMap((Map)ab);
                                    ep.put("configs." + conf.getDisplayName() + "." + "abilities", abilities);
                                }
                                helper.putProperties("nbproject/project.properties", ep);
                                try {
                                    ProjectManager.getDefault().saveProject((Project)project);
                                }
                                catch (Exception ex) {
                                    ErrorManager.getDefault().notify((Throwable)ex);
                                }
                            }
                        });
                    }
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                }
            });
        }

        public Action[] getActions() {
            return this.actions;
        }

        void setAbilities(Node[] nodes) {
            HashSet abSet = new HashSet();
            HashMap<String, String> abIntersection = new HashMap<String, String>();
            J2MEProject prj = null;
            boolean setExt = false;
            defaultConfig = null;
            for (Node n : nodes) {
                AntProjectHelper helper;
                EditableProperties ep;
                String abilities;
                ABHint data;
                Lookup lookup = n.getLookup();
                if (lookup == null || (data = (ABHint)lookup.lookup(ABHint.class)) == null) continue;
                tableModel.removeListeners();
                Node node = (Node)lookup.lookup(Node.class);
                project = (J2MEProject)node.getLookup().lookup(J2MEProject.class);
                ProjectConfiguration conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                assert (project != null);
                if (conf.getDisplayName().equals("DefaultConfiguration")) {
                    defaultConfig = n;
                }
                if ((abilities = (ep = (helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class)).getProperties("nbproject/project.properties")).getProperty("configs." + conf.getDisplayName() + "." + "abilities")) == null) {
                    abilities = ep.getProperty("abilities");
                }
                Map ab = CommentingPreProcessor.decodeAbilitiesMap((String)abilities);
                if (setExt) {
                    if (prj != project) {
                        defaultConfig = null;
                        tableModel.setDataDelegates(emptyTable);
                        return;
                    }
                    abSet.retainAll(ab.keySet());
                    for (String key : abSet) {
                        if (abIntersection.containsKey(key)) {
                            String value1 = (String)abIntersection.get(key);
                            String value2 = (String)ab.get(key);
                            if ((value1 == null || value1.equals(value2)) && (value1 != null || value2 == null)) continue;
                            abIntersection.put(key, MULTIPLE_VALUES);
                            continue;
                        }
                        abIntersection.put(key, (String)ab.get(key));
                    }
                    continue;
                }
                prj = project;
                setExt = true;
                abSet.addAll(ab.keySet());
                abIntersection.putAll(ab);
            }
            abIntersection.keySet().retainAll(abSet);
            tableModel.setEditable(true);
            table.setBackground(UIManager.getDefaults().getColor("Table.background"));
            tableModel.setDataDelegates(new Object[]{abIntersection});
            selectedNodes = nodes;
            boolean enabled = false;
            for (Node node : nodes) {
                ProjectConfiguration conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                if (conf == null) continue;
                enabled = true;
            }
            for (Action action : this.actions) {
                action.setEnabled(enabled);
            }
            if (enabled) {
                this.actions[3].setEnabled(pasteActionEnabled);
            }
        }

        private void initComponents() {
            scrollPane = new JScrollPane();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)scrollPane, gridBagConstraints);
        }

        public ExplorerManager getExplorerManager() {
            return manager;
        }

        static {
            tableModel = new EditableTableModel();
            table = new JTable(tableModel);
            emptyTable = new Object[]{new HashMap()};
            project = null;
            selectedNodes = null;
            defaultConfig = null;
            manager = new ExplorerManager();
            copiedAbilities = new HashMap();
            pasteActionEnabled = false;
        }

        private static class RemoveAction
        extends AbstractAction {
            private RemoveAction() {
                this.putValue("Name", REMOVE);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = e.getSource();
                final int[] rows = table.getSelectedRows();
                if (project == null) {
                    return;
                }
                ProjectManager.mutex().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        for (int row : rows) {
                            String key = tableModel.getValueAt(rows[0], 0);
                            tableModel.removeRow(rows[0]);
                            AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
                            EditableProperties ep = helper.getProperties("nbproject/project.properties");
                            if (defaultConfig != null) {
                                String abilities = ep.getProperty("abilities");
                                Map ab = CommentingPreProcessor.decodeAbilitiesMap((String)abilities);
                                ab.remove(key);
                                abilities = CommentingPreProcessor.encodeAbilitiesMap((Map)ab);
                                ep.put("abilities", abilities);
                                helper.putProperties("nbproject/project.properties", ep);
                            }
                            for (Node node : selectedNodes) {
                                Map ab;
                                ProjectConfiguration conf;
                                if (node == defaultConfig || (conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class)) == null) continue;
                                String abilities = ep.getProperty("configs." + conf.getDisplayName() + "." + "abilities");
                                if (abilities == null) {
                                    abilities = ep.getProperty("abilities");
                                }
                                if (!(ab = CommentingPreProcessor.decodeAbilitiesMap((String)abilities)).containsKey(key)) continue;
                                ab.remove(key);
                                abilities = CommentingPreProcessor.encodeAbilitiesMap((Map)ab);
                                ep.put("configs." + conf.getDisplayName() + "." + "abilities", abilities);
                            }
                            helper.putProperties("nbproject/project.properties", ep);
                        }
                        try {
                            ProjectManager.getDefault().saveProject((Project)project);
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                });
            }
        }

        private class AddAction
        extends AbstractAction {
            private AddAction() {
                this.putValue("Name", ADD);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                final AddAbilityPanel add = new AddAbilityPanel();
                HashSet<String> usedAbilities = new HashSet<String>();
                final AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
                final EditableProperties ep = helper.getProperties("nbproject/project.properties");
                for (Node node : selectedNodes) {
                    ProjectConfiguration conf = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                    if (conf == null) continue;
                    String abilities = ep.getProperty("configs." + conf.getDisplayName() + "." + "abilities");
                    if (abilities == null) {
                        abilities = ep.getProperty("abilities");
                    }
                    Map ab = CommentingPreProcessor.decodeAbilitiesMap((String)abilities);
                    usedAbilities.addAll(ab.keySet());
                }
                Vector<String> proposedAbilities = new Vector<String>(GlobalAbilitiesCache.getDefault().getAllAbilities());
                proposedAbilities.removeAll(usedAbilities);
                add.init(false, proposedAbilities, usedAbilities, null, null);
                DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(CustomizerAbilities.class, (String)"TITLE_AddAbility"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (NotifyDescriptor.OK_OPTION.equals(e.getSource())) {
                            final String key = add.getKey();
                            final String value = add.getValue();
                            GlobalAbilitiesCache.getDefault().addAbility(key);
                            int row = tableModel.addRow(key, value);
                            table.getSelectionModel().setSelectionInterval(row, row);
                            ProjectManager.mutex().writeAccess(new Runnable(){

                                @Override
                                public void run() {
                                    ABPanel.this.addAbility(ep, helper, key, value);
                                    try {
                                        ProjectManager.getDefault().saveProject((Project)project);
                                    }
                                    catch (Exception ex) {
                                        ErrorManager.getDefault().notify((Throwable)ex);
                                    }
                                }
                            });
                        }
                    }
                });
                add.setDialogDescriptor(dd);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                dialog.setVisible(true);
            }
        }

        private class PasteAction
        extends AbstractAction {
            private PasteAction() {
                this.putValue("Name", PASTE);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl V"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectManager.mutex().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
                        EditableProperties ep = helper.getProperties("nbproject/project.properties");
                        for (Map.Entry entry : copiedAbilities.entrySet()) {
                            String value = (String)entry.getValue();
                            if (MULTIPLE_VALUES.equals(value)) {
                                value = "";
                            }
                            ABPanel.this.addAbility(ep, helper, (String)entry.getKey(), value);
                            tableModel.addRow((String)entry.getKey(), value);
                        }
                        try {
                            ProjectManager.getDefault().saveProject((Project)project);
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                        ABPanel.this.actions[3].setEnabled(pasteActionEnabled = false);
                    }
                });
            }
        }

        private class CopyAction
        extends AbstractAction {
            private CopyAction() {
                this.putValue("Name", COPY);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl C"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = table.getSelectedRows();
                copiedAbilities = new HashMap(rows.length);
                for (int row : rows) {
                    String key = tableModel.getValueAt(row, 0);
                    String value = tableModel.getValueAt(row, 1);
                    copiedAbilities.put(key, value);
                }
                ABPanel.this.actions[3].setEnabled(pasteActionEnabled = true);
            }
        }
    }

    static class ABHint
    implements NavigatorLookupHint {
        static String hint = "j2me/abilities";

        ABHint() {
        }

        public String getContentType() {
            return hint;
        }
    }
}

