/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Arrays;
import java.util.Map;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.IR_Closure;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.MultiOperandInstr;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.StringLiteral;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallInstruction
extends MultiOperandInstr {
    Operand _methAddr;
    Operand _closure;
    private boolean _flagsComputed;
    private boolean _canBeEval;
    private boolean _requiresFrame;
    private int _numArgs;

    public CallInstruction(Variable result, Operand methAddr, Operand[] args2, Operand closure) {
        super(Operation.CALL, result, CallInstruction.buildAllArgs(methAddr, closure, args2));
        this._methAddr = methAddr;
        this._closure = closure;
        this._flagsComputed = false;
        this._canBeEval = true;
        this._requiresFrame = true;
        this._numArgs = args2.length;
    }

    public CallInstruction(Operation op, Variable result, Operand methAddr, Operand[] args2, Operand closure) {
        super(op, result, CallInstruction.buildAllArgs(methAddr, closure, args2));
        this._methAddr = methAddr;
        this._closure = closure;
        this._flagsComputed = false;
        this._canBeEval = true;
        this._requiresFrame = true;
        this._numArgs = args2.length;
    }

    public Operand getMethodAddr() {
        return this._methAddr;
    }

    public Operand getClosureArg() {
        return this._closure;
    }

    public Operand getReceiver() {
        return this._args[1];
    }

    public int getNumArgs() {
        return this._numArgs;
    }

    public Operand[] getCallArgs() {
        Operand[] callArgs = new Operand[this._numArgs];
        for (int i = 0; i < this._numArgs; ++i) {
            callArgs[i] = this._args[i + 1];
        }
        return callArgs;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        super.simplifyOperands(valueMap);
        this._methAddr = this._args[0];
        this._closure = this._closure == null ? null : this._args[this._args.length - 1];
        this._flagsComputed = false;
    }

    public boolean isRubyInternalsCall() {
        return false;
    }

    public boolean isStaticCallTarget() {
        return this.getTargetMethod() != null;
    }

    public IRMethod getTargetMethodWithReceiver(Operand receiver2) {
        if (!(this._methAddr instanceof MethAddr)) {
            return null;
        }
        String mname = ((MethAddr)this._methAddr).getName();
        if (receiver2 instanceof MetaObject) {
            IR_Module m = (IR_Module)((MetaObject)receiver2)._scope;
            return m.getClassMethod(mname);
        }
        if (receiver2 instanceof Variable && ((Variable)receiver2).isSelf()) {
            Object c = null;
            return null;
        }
        IR_Class c = receiver2.getTargetClass();
        return c == null ? null : c.getInstanceMethod(mname);
    }

    public IRMethod getTargetMethod() {
        return this.getTargetMethodWithReceiver(this.getReceiver());
    }

    public boolean canModifyCode() {
        IRMethod method2 = this.getTargetMethod();
        return method2 == null ? true : method2.modifiesCode();
    }

    private boolean getEvalFlag() {
        Operand ma = this.getMethodAddr();
        if (ma instanceof MethAddr) {
            Operand[] args2;
            String mname = ((MethAddr)ma).getName();
            if (mname.equals("call") || mname.equals("eval")) {
                return true;
            }
            if (mname.equals("send") && (args2 = this.getCallArgs()).length >= 2) {
                Operand meth = args2[1];
                if (!(meth instanceof StringLiteral)) {
                    return true;
                }
                String name2 = ((StringLiteral)meth)._str_value;
                if (name2.equals("call") || name2.equals("eval") || name2.equals("send")) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean getRequiresFrameFlag() {
        Operand ma;
        if (this.canBeEval()) {
            return true;
        }
        if (this._closure != null) {
            if (!(this._closure instanceof MetaObject)) {
                return false;
            }
            IR_Closure cl = (IR_Closure)((MetaObject)this._closure)._scope;
            if (cl.requiresFrame()) {
                return true;
            }
        }
        if (!((ma = this.getMethodAddr()) instanceof MethAddr)) {
            return true;
        }
        String mname = ((MethAddr)ma).getName();
        if (mname.equals("lambda")) {
            return true;
        }
        if (mname.equals("new")) {
            Operand receiver2 = this.getReceiver();
            if (!(receiver2 instanceof MetaObject)) {
                return true;
            }
            IR_Scope c = ((MetaObject)receiver2)._scope;
            if (c instanceof IR_Class && ((IR_Class)c)._name.equals("Proc")) {
                return true;
            }
        }
        return false;
    }

    private void computeFlags() {
        this._flagsComputed = true;
        this._canBeEval = this.getEvalFlag();
        this._requiresFrame = this.getRequiresFrameFlag();
    }

    public boolean canBeEval() {
        if (!this._flagsComputed) {
            this.computeFlags();
        }
        return this._canBeEval;
    }

    public boolean requiresFrame() {
        if (!this._flagsComputed) {
            this.computeFlags();
        }
        return this._requiresFrame;
    }

    public boolean canCaptureCallersFrame() {
        Operand r = this.getReceiver();
        IRMethod rm = this.getTargetMethodWithReceiver(r);
        return rm == null || rm.canCaptureCallersFrame();
    }

    public boolean isLVADataflowBarrier() {
        return this.canBeEval() || this.getClosureArg() != null && this.canCaptureCallersFrame();
    }

    @Override
    public String toString() {
        return "\t" + (this._result == null ? "" : this._result + " = ") + (Object)((Object)this._op) + "(" + this._methAddr + ", " + Arrays.toString(this.getCallArgs()) + (this._closure == null ? "" : ", &" + this._closure) + ")";
    }

    private static Operand[] buildAllArgs(Operand methAddr, Operand closure, Operand[] callArgs) {
        Operand[] allArgs = new Operand[callArgs.length + 1 + (closure != null ? 1 : 0)];
        allArgs[0] = methAddr;
        for (int i = 0; i < callArgs.length; ++i) {
            allArgs[i + 1] = callArgs[i];
        }
        if (closure != null) {
            allArgs[callArgs.length + 1] = closure;
        }
        return allArgs;
    }
}

