/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class BreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    public BreakpointActionProvider() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-php5", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorContextDispatcher.getDefault()));
    }

    public void doAction(Object action) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addBreakpoints();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BreakpointActionProvider.this.addBreakpoints();
                }
            });
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    private void addBreakpoints() {
        Line line = Utils.getCurrentLine();
        if (line == null) {
            return;
        }
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        boolean add = true;
        for (Breakpoint breakpoint : breakpoints) {
            if (!(breakpoint instanceof LineBreakpoint) || !((LineBreakpoint)breakpoint).getLine().equals(line)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpoint);
            add = false;
            break;
        }
        if (add) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)new LineBreakpoint(line));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = Utils.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, enabled);
    }
}

