/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.card;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.DeclarableCapabilities;
import org.netbeans.modules.javacard.spi.ICardCapability;
import org.netbeans.modules.javacard.spi.capabilities.CapabilitiesProvider;
import org.netbeans.modules.propdos.ObservableProperties;
import org.netbeans.modules.propdos.PropertiesAdapter;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbCollections;

final class CardProperties
implements ICardCapability,
CapabilitiesProvider {
    public static final String DEBUG = "debug";
    public static final String SUSPEND = "suspend";
    private static final String DEFAULT_RAM_SIZE = "24K";
    private static final String DEFAULT_E2P_SIZE = "128K";
    private static final String DEFULT_COR_SIZE = "2K";
    private static final String DEFAULT_LOGGER_LEVEL = "none";
    private static final String DEFAULT_HTTP_PORT = "8019";
    private static final String DEFAULT_PROXY_TO_EMULATOR_PORT = "7019";
    private static final String DEFAULT_PROXY_TO_IDE_PORT = "7020";
    private static final String DEFAULT_CONTACTED_PORT = "9025";
    private static final String DEFAULT_CONTACTED_PROTOCOL = "T=1";
    private static final String DEFAULT_CONTACTLESS_PORT = "9026";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String DEFAULT_CAPABILITIES = "START,STOP,RESUME,DEBUG,EPROM_FILE,CLEAR_EPROM,CONTENTS,CUSTOMIZER,INTERCEPTOR,PORTS,URL,DELETE";
    private static final String E2P_FILE_DEF = "${javacard.device.eeprom.folder}${file.separator}${javacard.device.name}.eprom";
    static final String DEFAULT_DEBUG_PROXY_COMMAND_LINE = "${java.home}/bin/java -classpath ${javacard.debug.proxy.classpath} {{{-Djc.home=${javacard.ri.home}}}} com.sun.javacard.debugproxy.Main {{{debug}}} --listen ${javacard.device.proxy2idePort} --remote ${javacard.device.host}:${javacard.device.proxy2cjcrePort} --classpath ${class.path}";
    static final String NEW_RUN_COMMAND_LINE = "${javacard.emulator} -debug ${debug} -suspend ${suspend} -ramsize ${javacard.device.ramSize} -e2psize ${javacard.device.e2pSize} -corsize ${javacard.device.corSize} -e2pfile ${javacard.device.eeprom.folder}${file.separator}${javacard.device.name}.eprom -loggerlevel ${javacard.device.loggerLevel} -httpport ${javacard.device.httpPort} -contactedport ${javacard.device.contactedPort} -contactedprotocol ${javacard.device.contactedProtocol} -contactlessport ${javacard.device.contactlessPort}";
    static final String DEFAULT_RESUME_COMMAND_LINE = "${javacard.emulator} -debug ${debug} -suspend ${suspend} -resume -e2pfile ${javacard.device.eeprom.folder}${file.separator}${javacard.device.name}.eprom";
    private PropertiesAdapter props;
    private static final Logger LOGGER = Logger.getLogger(CardProperties.class.getPackage().getName());

    CardProperties(PropertiesAdapter props) {
        this.props = props;
    }

    Properties toProperties() {
        return this.props.asProperties();
    }

    public String getContactedPort() {
        return "" + this.getAsInt("javacard.device.contactedPort", DEFAULT_CONTACTED_PORT);
    }

    public void setContactedPort(String contactedPort) {
        this.setAsInt("javacard.device.contactedPort", contactedPort);
    }

    public String getContactedProtocol() {
        return this.getProp("javacard.device.contactedProtocol", DEFAULT_CONTACTED_PROTOCOL);
    }

    public void setContactedProtocol(String contactedProtocol) {
        this.setProp("javacard.device.contactedProtocol", contactedProtocol);
    }

    public String getContactlessPort() {
        return "" + this.getAsInt("javacard.device.contactlessPort", DEFAULT_CONTACTLESS_PORT);
    }

    public void setContactlessPort(String contactlessPort) {
        this.setAsInt("javacard.device.contactlessPort", contactlessPort);
    }

    public String getCorSize() {
        return this.getProp("javacard.device.corSize", DEFULT_COR_SIZE);
    }

    public void setCorSize(String corSize) {
        this.setProp("javacard.device.corSize", corSize);
    }

    public String getE2pSize() {
        return this.getProp("javacard.device.e2pSize", DEFAULT_E2P_SIZE);
    }

    public void setE2pSize(String e2pSize) {
        this.setProp("javacard.device.e2pSize", e2pSize);
    }

    public String getHttpPort() {
        return this.getProp("javacard.device.httpPort", DEFAULT_HTTP_PORT);
    }

    public void setHttpPort(String httpPort) {
        this.setAsInt("javacard.device.httpPort", httpPort);
    }

    public String getLoggerLevel() {
        return this.getProp("javacard.device.loggerLevel", DEFAULT_LOGGER_LEVEL);
    }

    public void setLoggerLevel(String loggerLevel) {
        this.setProp("javacard.device.loggerLevel", loggerLevel);
    }

    public boolean isSuspend() {
        String val = this.getProp("javacard.device.suspend", "false");
        return val == null ? false : Boolean.parseBoolean(val);
    }

    public void setSuspend(boolean suspend) {
        this.setProp("javacard.device.suspend", "" + suspend);
    }

    public String getProxy2cjcrePort() {
        return this.getAsInt("javacard.device.proxy2cjcrePort", DEFAULT_PROXY_TO_EMULATOR_PORT) + "";
    }

    public void setProxy2cjcrePort(String proxy2cjcrePort) {
        this.setAsInt("javacard.device.proxy2cjcrePort", proxy2cjcrePort);
    }

    public String getProxy2idePort() {
        return this.getAsInt("javacard.device.proxy2idePort", DEFAULT_PROXY_TO_IDE_PORT) + "";
    }

    public void setProxy2idePort(String proxy2idePort) {
        this.setAsInt("javacard.device.proxy2idePort", proxy2idePort);
    }

    public String getRamSize() {
        return this.getProp("javacard.device.ramSize", DEFAULT_RAM_SIZE);
    }

    public void setRamSize(String ramSize) {
        this.setProp("javacard.device.ramSize", ramSize);
    }

    public boolean isRemote() {
        String val = this.getProp("javacard.device.is.remotehost", "true");
        return val == null ? false : Boolean.parseBoolean(val);
    }

    public void setRemote(boolean remote) {
        this.setProp("javacard.device.is.remotehost", "" + remote);
    }

    public String getHost() {
        return this.getProp("javacard.device.host", DEFAULT_HOST);
    }

    public void setHost(String host) {
        this.setProp("javacard.device.host", host);
    }

    public Set<Integer> getPorts() {
        HashSet<Integer> result = new HashSet<Integer>();
        result.add(Integer.parseInt(this.getContactedPort()));
        result.add(Integer.parseInt(this.getContactlessPort()));
        result.add(Integer.parseInt(this.getHttpPort()));
        result.add(Integer.parseInt(this.getProxy2cjcrePort()));
        result.add(Integer.parseInt(this.getProxy2idePort()));
        return result;
    }

    private void setProp(String key, String value) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Set javacard device property '{0}' to '{1}'", new Object[]{key, value});
        }
        this.props.asProperties().setProperty(key, value);
    }

    private void setProp(String key, int value) {
        this.setProp(key, "" + value);
    }

    private void setAsInt(String key, String value) throws NumberFormatException {
        this.setProp(key, Integer.parseInt(value.trim()));
    }

    private String getProp(String key, String defawlt) {
        String result = this.props.asProperties().getProperty(key);
        if (result == null) {
            Logger.getLogger(CardProperties.class.getName()).log(Level.SEVERE, "Property {0} not found in {1}", new Object[]{key, this.props});
            result = defawlt;
        }
        return result;
    }

    private int getAsInt(String key, String defawlt) {
        int result;
        String val = this.getProp(key, defawlt).trim();
        try {
            result = Integer.parseInt(val);
            if (result > 65535 || result < 0) {
                throw new NumberFormatException("Illegal port value for " + key + ": " + val);
            }
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger(CardProperties.class.getName()).log(Level.SEVERE, "Property {0} has non integer value in {1}", new Object[]{key, this.props});
            result = Integer.parseInt(defawlt);
        }
        return result;
    }

    public Set<Class<? extends ICardCapability>> getSupportedCapabilityTypes() {
        String val = this.getProp("javacard.device.capabilities", DEFAULT_CAPABILITIES);
        Set caps = DeclarableCapabilities.forString((String)val);
        return DeclarableCapabilities.types((Set)caps);
    }

    public String[] getDebugProxyCommandLine(Properties platformProps, String classpathClosure) {
        Map<String, String> projectInfo = this.prepPlatformProps(platformProps, true);
        projectInfo.put("class.path", classpathClosure);
        String[] result = Utils.shellSplit((String)this.evaluated(projectInfo, "javacard.device.debugger.cmdline", DEFAULT_DEBUG_PROXY_COMMAND_LINE));
        return result;
    }

    public String[] getRunCommandLine(Properties platformProps, boolean forDebug, boolean suspend, boolean resume) {
        Map<String, String> platform = this.prepPlatformProps(platformProps, true);
        platform.put(DEBUG, forDebug ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        platform.put(SUSPEND, suspend ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        String key = !resume ? "javacard.device.run.cmdline" : "javacard.device.resume.cmdline";
        String defawlt = !resume ? NEW_RUN_COMMAND_LINE : DEFAULT_RESUME_COMMAND_LINE;
        String cmdline = this.evaluated(platform, key, defawlt);
        String[] result = Utils.shellSplit((String)cmdline);
        return result;
    }

    private Map<String, String> prepPlatformProps(Properties platformProps, boolean addEpromPath) {
        String dataObjectName;
        HashMap<String, String> m = new HashMap<String, String>();
        m.putAll(NbCollections.checkedMapByCopy((Map)platformProps, String.class, String.class, (boolean)true));
        if (addEpromPath && (dataObjectName = platformProps.getProperty("javacard.instance.id")) != null) {
            FileObject eepromFolder = Utils.sfsFolderForDeviceEepromsForPlatformNamed((String)dataObjectName, (boolean)true);
            assert (eepromFolder != null);
            File f = FileUtil.toFile((FileObject)eepromFolder);
            String path = f == null ? eepromFolder.getPath() : f.getAbsolutePath();
            m.put("javacard.device.eeprom.folder", path);
        }
        m.put("file.separator", File.separator);
        m.put("java.io.tmpdir", System.getProperty("java.io.tmpdir"));
        m.put("java.home", System.getProperty("java.home"));
        return m;
    }

    private String evaluated(Map<String, String> pre, String key, String defawlt) {
        ObservableProperties p = this.props.asProperties();
        String value = p.getProperty(key);
        value = value == null ? defawlt : value;
        Map<String, String> m = this.prepPlatformProps((Properties)p, false);
        PropertyProvider prov = PropertyUtils.fixedPropertyProvider(m);
        PropertyEvaluator eval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)PropertyUtils.fixedPropertyProvider(pre), (PropertyProvider[])new PropertyProvider[]{prov});
        return eval.evaluate(value);
    }
}

