/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.helper.Platform;

public class NbiProperties
extends Properties {
    public NbiProperties() {
    }

    public NbiProperties(Properties properties) {
        this.putAll((Map<?, ?>)properties);
    }

    public String getProperty(String name) {
        return this.getProperty(name, SystemUtils.getCurrentPlatform(), Locale.getDefault());
    }

    public String getProperty(String name, Platform platform, Locale locale) {
        Object[] platformParts = this.getPlatformParts(platform);
        Object[] localeParts = this.getLocaleParts(locale);
        for (int i = platformParts.length; i >= 0; --i) {
            for (int j = localeParts.length; j >= 0; --j) {
                String platformString = StringUtils.asString(platformParts, 0, i, "-");
                String localeString = StringUtils.asString(localeParts, 0, j, "_");
                String candidateName = name + (platformString.equals("") ? "" : "." + platformString) + (localeString.equals("") ? "" : "." + localeString);
                String value = super.getProperty(candidateName);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public Object setProperty(String name, String value) {
        return this.setProperty(name, value, SystemUtils.getCurrentPlatform(), Locale.getDefault());
    }

    public Object setProperty(String name, String value, Platform platform, Locale locale) {
        Object[] platformParts = this.getPlatformParts(platform);
        Object[] localeParts = this.getLocaleParts(locale);
        for (int i = platformParts.length; i >= 0; --i) {
            for (int j = localeParts.length; j >= 0; --j) {
                String platformString = StringUtils.asString(platformParts, 0, i, "-");
                String localeString = StringUtils.asString(localeParts, 0, j, "_");
                String candidateName = name + (platformString.equals("") ? "" : "." + platformString) + (localeString.equals("") ? "" : "." + localeString);
                if (super.getProperty(candidateName) == null) continue;
                return super.setProperty(candidateName, value);
            }
        }
        return super.setProperty(name, value);
    }

    private String[] getPlatformParts(Platform platform) {
        if (platform == null) {
            return new String[0];
        }
        if (platform.getOsFamily() != null) {
            if (platform.getHardwareArch() != null) {
                if (platform.getOsVersion() != null) {
                    if (platform.getOsFlavor() != null) {
                        return new String[]{platform.getOsFamily(), platform.getHardwareArch(), platform.getOsVersion(), platform.getOsFlavor()};
                    }
                    return new String[]{platform.getOsFamily(), platform.getHardwareArch(), platform.getOsVersion()};
                }
                return new String[]{platform.getOsFamily(), platform.getHardwareArch()};
            }
            return new String[]{platform.getOsFamily()};
        }
        return new String[0];
    }

    private String[] getLocaleParts(Locale locale) {
        if (locale == null) {
            return new String[0];
        }
        if (!locale.getLanguage().equals("")) {
            if (!locale.getCountry().equals("")) {
                if (!locale.getVariant().equals("")) {
                    return new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
                }
                return new String[]{locale.getLanguage(), locale.getCountry()};
            }
            return new String[]{locale.getLanguage()};
        }
        return new String[0];
    }
}

