/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.services;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.installer.downloader.DownloadListener;
import org.netbeans.installer.downloader.DownloadManager;
import org.netbeans.installer.downloader.Pumping;
import org.netbeans.installer.downloader.services.EmptyQueueListener;
import org.netbeans.installer.downloader.services.PersistentCache;
import org.netbeans.installer.utils.exceptions.DownloadException;

public class FileProvider {
    private static final FileProvider fileProvider = new FileProvider();
    private final DownloadManager downloadManager = DownloadManager.instance;
    private final DownloadListener listener = new MyListener();
    private final PersistentCache cache = new PersistentCache();
    private final Map<URL, Pumping.State> scheduledURL2State = new HashMap<URL, Pumping.State>();

    public static FileProvider getProvider() {
        return fileProvider;
    }

    protected FileProvider() {
        this.downloadManager.registerListener(this.listener);
    }

    public synchronized void clearCaches() {
        for (URL url : this.cache.keys()) {
            this.cache.delete(url);
        }
    }

    public synchronized boolean isInCache(URL url) {
        return this.cache.isIn(url);
    }

    public synchronized void asynchDownload(URL url, File folder) {
        if (this.isInCache(url)) {
            return;
        }
        if (this.scheduledURL2State.containsKey(url)) {
            return;
        }
        if (!this.downloadManager.isActive()) {
            this.downloadManager.invoke();
        }
        this.scheduledURL2State.put(url, Pumping.State.NOT_PROCESSED);
        this.downloadManager.queue().add(url, folder != null ? folder : this.downloadManager.defaultFolder());
    }

    public synchronized File get(URL url) throws DownloadException {
        return this.get(url, null, true);
    }

    public synchronized File get(URL url, File folder) throws DownloadException {
        return this.get(url, folder, true);
    }

    public synchronized File get(URL url, boolean useCache) throws DownloadException {
        return this.get(url, null, useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File get(URL url, File folder, boolean useCache) throws DownloadException {
        while (true) {
            File file;
            if ((file = this.tryGet(url)) != null) {
                if (useCache) {
                    return file;
                }
                this.cache.delete(url);
                useCache = true;
            }
            URL uRL = url;
            synchronized (uRL) {
                this.asynchDownload(url, folder);
                try {
                    url.wait();
                }
                catch (InterruptedException interrupt) {
                    throw new DownloadException("download faild " + url, interrupt);
                }
            }
            switch (this.scheduledURL2State.get(url)) {
                case FAILED: {
                    this.scheduledURL2State.remove(url);
                    throw new DownloadException("download faild " + url);
                }
                case DELETED: {
                    this.scheduledURL2State.remove(url);
                    throw new DownloadException("download faild - externaly deleted " + url);
                }
                case FINISHED: {
                    this.scheduledURL2State.remove(url);
                }
            }
        }
    }

    public synchronized File tryGet(URL url) {
        if (this.cache.isIn(url)) {
            return this.cache.getByURL(url);
        }
        return null;
    }

    public synchronized void manuallyDelete(URL url) {
        this.downloadManager.queue().delete(url);
        this.cache.delete(url);
    }

    private class MyListener
    extends EmptyQueueListener {
        private MyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pumpingStateChange(String id) {
            Pumping pumping = FileProvider.this.downloadManager.queue().getById(id);
            URL url = pumping.declaredURL();
            FileProvider.this.scheduledURL2State.put(url, pumping.state());
            switch (pumping.state()) {
                case FINISHED: {
                    FileProvider.this.cache.put(url, pumping.outputFile());
                }
                case FAILED: 
                case DELETED: {
                    URL uRL = url;
                    synchronized (uRL) {
                        url.notifyAll();
                        break;
                    }
                }
            }
        }
    }
}

