/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ViewWSDLAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        WsdlSaas saas = this.getWsdlSaas(nodes);
        if (saas != null) {
            return saas.getState() == Saas.State.RETRIEVED || saas.getState() == Saas.State.READY;
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(ViewWSDLAction.class, (String)"VIEW_WSDL");
    }

    private WsdlSaas getWsdlSaas(Node[] nodes) {
        WsdlSaasMethod method;
        WsdlSaasPort port;
        if (nodes == null || nodes.length != 1) {
            return null;
        }
        WsdlSaas saas = (WsdlSaas)nodes[0].getLookup().lookup(WsdlSaas.class);
        if (saas == null && (port = (WsdlSaasPort)nodes[0].getLookup().lookup(WsdlSaasPort.class)) != null) {
            saas = port.getParentSaas();
        }
        if (saas == null && (method = (WsdlSaasMethod)nodes[0].getLookup().lookup(WsdlSaasMethod.class)) != null) {
            saas = method.getSaas();
        }
        return saas;
    }

    protected void performAction(Node[] nodes) {
        WsdlSaas saas = this.getWsdlSaas(nodes);
        if (saas == null) {
            throw new IllegalArgumentException("No nodes assoaciated WsdlSaas in lookup.");
        }
        if (saas.getState() != Saas.State.RETRIEVED && saas.getState() != Saas.State.READY) {
            throw new IllegalStateException("Unexpected state: " + saas.getState());
        }
        String location = saas.getWsdlData().getWsdlFile();
        FileObject wsdlFileObject = saas.getLocalWsdlFile();
        if (null == wsdlFileObject) {
            String errorMessage = NbBundle.getMessage(ViewWSDLAction.class, (String)"WSDL_FILE_NOT_FOUND", (Object)location);
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            return;
        }
        try {
            DataObject wsdlDataObject = DataObject.find((FileObject)wsdlFileObject);
            EditorCookie editorCookie = (EditorCookie)wsdlDataObject.getCookie(EditorCookie.class);
            editorCookie.open();
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public boolean asynchronous() {
        return true;
    }
}

