/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.pm;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.impl.pm.NFABasedBulkSearch;

public abstract class BulkSearch {
    private static final BulkSearch INSTANCE = new NFABasedBulkSearch();
    private final boolean requiresLightweightVerification;

    public static BulkSearch getDefault() {
        return INSTANCE;
    }

    protected BulkSearch(boolean bl) {
        this.requiresLightweightVerification = bl;
    }

    public final Map<String, Collection<TreePath>> match(CompilationInfo compilationInfo, TreePath treePath, BulkPattern bulkPattern) {
        return this.match(compilationInfo, treePath, bulkPattern, null);
    }

    public final boolean requiresLightweightVerification() {
        return this.requiresLightweightVerification;
    }

    public abstract Map<String, Collection<TreePath>> match(CompilationInfo var1, TreePath var2, BulkPattern var3, Map<String, Long> var4);

    public abstract boolean matches(InputStream var1, BulkPattern var2);

    public abstract boolean matches(CompilationInfo var1, TreePath var2, BulkPattern var3);

    public abstract void encode(Tree var1, EncodingContext var2);

    public final BulkPattern create(CompilationInfo compilationInfo, String ... stringArray) {
        return this.create(compilationInfo, Arrays.asList(stringArray));
    }

    public final BulkPattern create(CompilationInfo compilationInfo, Collection<? extends String> collection) {
        LinkedList<Tree> linkedList = new LinkedList<Tree>();
        for (String string : collection) {
            linkedList.add(Utilities.parseAndAttribute(compilationInfo, string, null));
        }
        return this.create(collection, linkedList);
    }

    public abstract BulkPattern create(Collection<? extends String> var1, Collection<? extends Tree> var2);

    public static final class EncodingContext {
        private final OutputStream out;
        private Set<? extends String> identifiers;
        private Set<? extends String> kinds;

        public EncodingContext(OutputStream outputStream) {
            this.out = outputStream;
        }

        public Set<? extends String> getIdentifiers() {
            return this.identifiers;
        }

        public Set<? extends String> getKinds() {
            return this.kinds;
        }

        public OutputStream getOut() {
            return this.out;
        }

        public void setIdentifiers(Set<? extends String> set) {
            this.identifiers = set;
        }

        public void setKinds(Set<? extends String> set) {
            this.kinds = set;
        }
    }

    public static abstract class BulkPattern {
        private final List<? extends Set<? extends String>> identifiers;
        private final List<? extends Set<? extends String>> kinds;

        public BulkPattern(List<? extends Set<? extends String>> list, List<? extends Set<? extends String>> list2) {
            this.identifiers = list;
            this.kinds = list2;
        }

        public List<? extends Set<? extends String>> getIdentifiers() {
            return this.identifiers;
        }

        public List<? extends Set<? extends String>> getKinds() {
            return this.kinds;
        }
    }
}

