/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AssignmentIssues {
    public static List<ErrorDescription> assignmentToForLoopParam(HintContext hintContext) {
        TreePath treePath;
        Trees trees = hintContext.getInfo().getTrees();
        Element element = trees.getElement(treePath = hintContext.getVariables().get("$param"));
        if (element == null || element.getKind() != ElementKind.LOCAL_VARIABLE) {
            return null;
        }
        TreePath treePath2 = hintContext.getVariables().get("$statement");
        LinkedList linkedList = new LinkedList();
        new AssignmentFinder(trees, element).scan(treePath2, linkedList);
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>(linkedList.size());
        for (TreePath treePath3 : linkedList) {
            arrayList.add(ErrorDescriptionFactory.forTree(hintContext, treePath3, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_AssignmentToForLoopParam", (Object)element.getSimpleName()), new Fix[0]));
        }
        return arrayList;
    }

    public static List<ErrorDescription> assignmentToCatchBlockParameter(HintContext hintContext) {
        TreePath treePath;
        Trees trees = hintContext.getInfo().getTrees();
        Element element = trees.getElement(TreePath.getPath(treePath = hintContext.getPath(), (Tree)((CatchTree)treePath.getLeaf()).getParameter()));
        if (element == null || element.getKind() != ElementKind.EXCEPTION_PARAMETER) {
            return null;
        }
        TreePath treePath2 = TreePath.getPath(treePath, (Tree)((CatchTree)treePath.getLeaf()).getBlock());
        LinkedList linkedList = new LinkedList();
        new AssignmentFinder(trees, element).scan(treePath2, linkedList);
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>(linkedList.size());
        for (TreePath treePath3 : linkedList) {
            arrayList.add(ErrorDescriptionFactory.forTree(hintContext, treePath3, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_AssignmentToCatchBlockParameter", (Object)element.getSimpleName()), new Fix[0]));
        }
        return arrayList;
    }

    public static ErrorDescription assignmentToMethodParam(HintContext hintContext) {
        TreePath treePath = hintContext.getPath();
        Element element = null;
        switch (treePath.getLeaf().getKind()) {
            case ASSIGNMENT: {
                element = hintContext.getInfo().getTrees().getElement(TreePath.getPath(treePath, (Tree)((AssignmentTree)treePath.getLeaf()).getVariable()));
                break;
            }
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                element = hintContext.getInfo().getTrees().getElement(TreePath.getPath(treePath, (Tree)((UnaryTree)treePath.getLeaf()).getExpression()));
                break;
            }
            default: {
                element = hintContext.getInfo().getTrees().getElement(TreePath.getPath(treePath, (Tree)((CompoundAssignmentTree)treePath.getLeaf()).getVariable()));
            }
        }
        if (element != null && element.getKind() == ElementKind.PARAMETER) {
            return ErrorDescriptionFactory.forTree(hintContext, treePath, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_AssignmentToMethodParam", (Object)element.getSimpleName()), new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription nestedAssignment(HintContext hintContext) {
        TreePath treePath = hintContext.getPath();
        Tree.Kind kind = treePath.getParentPath().getLeaf().getKind();
        if (kind != Tree.Kind.EXPRESSION_STATEMENT && kind != Tree.Kind.ANNOTATION) {
            return ErrorDescriptionFactory.forTree(hintContext, treePath, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_NestedAssignment", (Object)treePath.getLeaf()), new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription incrementDecrementUsed(HintContext hintContext) {
        TreePath treePath = hintContext.getPath();
        if (treePath.getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            Tree.Kind kind = treePath.getLeaf().getKind();
            return ErrorDescriptionFactory.forTree(hintContext, treePath, NbBundle.getMessage(AssignmentIssues.class, (String)(kind == Tree.Kind.PREFIX_INCREMENT || kind == Tree.Kind.POSTFIX_INCREMENT ? "MSG_IncrementUsedAsExpression" : "MSG_DecrementUsedAsExpression"), (Object)treePath.getLeaf()), new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription replaceAssignWithOpAssign(HintContext hintContext) {
        TreePath treePath = hintContext.getPath();
        return ErrorDescriptionFactory.forTree(hintContext, treePath, NbBundle.getMessage(AssignmentIssues.class, (String)"MSG_ReplaceAssignmentWithOperatorAssignment", (Object)treePath.getLeaf()), new ReplaceAssignmentFix(NbBundle.getMessage(AssignmentIssues.class, (String)"FIX_ReplaceAssignmentWithOperatorAssignment", (Object)treePath.getLeaf()), TreePathHandle.create((TreePath)treePath, (CompilationInfo)hintContext.getInfo())));
    }

    private static final class ReplaceAssignmentFix
    implements Fix {
        private final String text;
        private final TreePathHandle handle;

        public ReplaceAssignmentFix(String string, TreePathHandle treePathHandle) {
            this.text = string;
            this.handle = treePathHandle;
        }

        public String getText() {
            return this.text;
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.handle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = ReplaceAssignmentFix.this.handle.resolve((CompilationInfo)workingCopy);
                    if (treePath == null) {
                        return;
                    }
                    AssignmentTree assignmentTree = (AssignmentTree)treePath.getLeaf();
                    Tree.Kind kind = null;
                    switch (assignmentTree.getExpression().getKind()) {
                        case AND: {
                            kind = Tree.Kind.AND_ASSIGNMENT;
                            break;
                        }
                        case DIVIDE: {
                            kind = Tree.Kind.DIVIDE_ASSIGNMENT;
                            break;
                        }
                        case LEFT_SHIFT: {
                            kind = Tree.Kind.LEFT_SHIFT_ASSIGNMENT;
                            break;
                        }
                        case MINUS: {
                            kind = Tree.Kind.MINUS_ASSIGNMENT;
                            break;
                        }
                        case MULTIPLY: {
                            kind = Tree.Kind.MULTIPLY_ASSIGNMENT;
                            break;
                        }
                        case OR: {
                            kind = Tree.Kind.OR_ASSIGNMENT;
                            break;
                        }
                        case PLUS: {
                            kind = Tree.Kind.PLUS_ASSIGNMENT;
                            break;
                        }
                        case REMAINDER: {
                            kind = Tree.Kind.REMAINDER_ASSIGNMENT;
                            break;
                        }
                        case RIGHT_SHIFT: {
                            kind = Tree.Kind.RIGHT_SHIFT_ASSIGNMENT;
                            break;
                        }
                        case UNSIGNED_RIGHT_SHIFT: {
                            kind = Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT;
                            break;
                        }
                        case XOR: {
                            kind = Tree.Kind.XOR_ASSIGNMENT;
                        }
                    }
                    if (kind == null) {
                        return;
                    }
                    CompoundAssignmentTree compoundAssignmentTree = workingCopy.getTreeMaker().CompoundAssignment(kind, assignmentTree.getVariable(), ((BinaryTree)assignmentTree.getExpression()).getRightOperand());
                    workingCopy.rewrite((Tree)assignmentTree, (Tree)compoundAssignmentTree);
                }
            }).commit();
            return null;
        }
    }

    private static final class AssignmentFinder
    extends TreePathScanner<Void, List<TreePath>> {
        private final Trees trees;
        private final Element param;

        private AssignmentFinder(Trees trees, Element element) {
            this.trees = trees;
            this.param = element;
        }

        @Override
        public Void visitAssignment(AssignmentTree assignmentTree, List<TreePath> list) {
            if (this.param == this.trees.getElement(TreePath.getPath(this.getCurrentPath(), (Tree)assignmentTree.getVariable()))) {
                list.add(this.getCurrentPath());
                return null;
            }
            return (Void)super.visitAssignment(assignmentTree, list);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, List<TreePath> list) {
            if (this.param == this.trees.getElement(TreePath.getPath(this.getCurrentPath(), (Tree)compoundAssignmentTree.getVariable()))) {
                list.add(this.getCurrentPath());
                return null;
            }
            return (Void)super.visitCompoundAssignment(compoundAssignmentTree, list);
        }

        @Override
        public Void visitUnary(UnaryTree unaryTree, List<TreePath> list) {
            switch (unaryTree.getKind()) {
                case PREFIX_INCREMENT: 
                case PREFIX_DECREMENT: 
                case POSTFIX_INCREMENT: 
                case POSTFIX_DECREMENT: {
                    if (this.param != this.trees.getElement(TreePath.getPath(this.getCurrentPath(), (Tree)unaryTree.getExpression()))) break;
                    list.add(this.getCurrentPath());
                    return null;
                }
            }
            return (Void)super.visitUnary(unaryTree, list);
        }

        @Override
        public Void visitClass(ClassTree classTree, List<TreePath> list) {
            return null;
        }
    }
}

