/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterDeserializer;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;
import org.netbeans.modules.vmd.api.model.Versionable;
import org.netbeans.modules.vmd.api.model.common.DefaultVersionDescriptor;
import org.netbeans.modules.vmd.model.PresenterDeserializerSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLComponentDescriptor
extends ComponentDescriptor {
    public static final String COMPONENT_DESCRIPTOR_NODE = "ComponentDescriptor";
    public static final String VERSION_ATTR = "version";
    public static final String TYPE_NODE = "TypeDescriptor";
    public static final String SUPER_TYPEID_ATTR = "superTypeID";
    public static final String THIS_TYPEID_ATTR = "thisTypeID";
    public static final String CAN_INSTANTIATE_ATTR = "canInstantiate";
    public static final String CAN_DERIVE_ATTR = "canDerive";
    public static final String PALETTE_NODE = "PaletteDescriptor";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String TOOLTIP_ATTR = "toolTip";
    public static final String SMALL_ICON_ATTR = "smallIcon";
    public static final String LARGE_ICON_ATTR = "largeIcon";
    public static final String PREFERRED_CATEGORYID_ATTR = "preferredCategoryID";
    public static final String PROPERTY_DESCRIPTOR_NODE = "PropertyDescriptor";
    public static final String NAME_ATTR = "name";
    public static final String TYPEID_ATTR = "typeID";
    public static final String DEFAULT_VALUE_ATTR = "defaultValue";
    public static final String ALLOW_NULL = "allowNull";
    public static final String ALLOW_USER_CODE = "allowUserCode";
    public static final String USE_FOR_SERIALIZATION_ATTR = "useForSerialization";
    public static final String READ_ONLY_ATTR = "readOnly";
    public static final String PRESENTERS_NODE = "Presenters";
    public static final String VERSION_VALUE_1 = "1";
    private TypeDescriptor typeDescriptor;
    private PaletteDescriptor paletteDescriptor;
    private List<PropertyDescriptor> propertyDescriptors;
    private List<PresenterDeserializer.PresenterFactory> presenterDescriptors;

    @Override
    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public VersionDescriptor getVersionDescriptor() {
        return DefaultVersionDescriptor.createForeverCompatibleVersionDescriptor();
    }

    @Override
    public Collection<String> getExcludedPropertyDescriptorNames() {
        return Collections.emptySet();
    }

    @Override
    public List<PropertyDescriptor> getDeclaredPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public PaletteDescriptor getPaletteDescriptor() {
        return this.paletteDescriptor;
    }

    @Override
    protected List<? extends Presenter> createPresenters() {
        ArrayList<Presenter> presenters = new ArrayList<Presenter>();
        for (PresenterDeserializer.PresenterFactory factory : this.presenterDescriptors) {
            List<Presenter> list = factory.createPresenters(this);
            if (list == null) continue;
            presenters.addAll(list);
        }
        return presenters;
    }

    public boolean deserialize(String projectType, Document document) {
        Node rootNode = document.getFirstChild();
        if (!COMPONENT_DESCRIPTOR_NODE.equals(rootNode.getNodeName())) {
            Debug.warning("Invalid root node");
            return false;
        }
        String version = XMLComponentDescriptor.getAttributeValue(rootNode, VERSION_ATTR);
        if (VERSION_VALUE_1.equals(version)) {
            this.deserializeVersion1(projectType, rootNode);
            return true;
        }
        Debug.warning("Invalid version", version);
        return false;
    }

    private void deserializeVersion1(String projectType, Node rootNode) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        ArrayList<PresenterDeserializer.PresenterFactory> presenters = new ArrayList<PresenterDeserializer.PresenterFactory>();
        for (Node node : XMLComponentDescriptor.getChildNode(rootNode)) {
            if (TYPE_NODE.equals(node.getNodeName())) {
                String thisTypeID = XMLComponentDescriptor.getAttributeValue(node, THIS_TYPEID_ATTR);
                if (thisTypeID == null) {
                    Debug.warning("Missing thisTypeID attribute");
                    continue;
                }
                this.typeDescriptor = new TypeDescriptor(TypeID.createFrom(XMLComponentDescriptor.getAttributeValue(node, SUPER_TYPEID_ATTR)), TypeID.createFrom(thisTypeID), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node, CAN_INSTANTIATE_ATTR)), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node, CAN_DERIVE_ATTR)));
                continue;
            }
            if (PALETTE_NODE.equals(node.getNodeName())) {
                this.paletteDescriptor = new PaletteDescriptor(XMLComponentDescriptor.getAttributeValue(node, PREFERRED_CATEGORYID_ATTR), XMLComponentDescriptor.getAttributeValue(node, DISPLAY_NAME_ATTR), XMLComponentDescriptor.getAttributeValue(node, TOOLTIP_ATTR), XMLComponentDescriptor.getAttributeValue(node, SMALL_ICON_ATTR), XMLComponentDescriptor.getAttributeValue(node, LARGE_ICON_ATTR));
                continue;
            }
            if (!PROPERTY_DESCRIPTOR_NODE.equals(node.getNodeName())) continue;
            String name = XMLComponentDescriptor.getAttributeValue(node, NAME_ATTR);
            if (name == null) {
                Debug.warning("Missing name attribute");
                continue;
            }
            TypeID typeID = TypeID.createFrom(XMLComponentDescriptor.getAttributeValue(node, TYPEID_ATTR));
            if (typeID == null) {
                Debug.warning("Missing typeID attribute", name);
                continue;
            }
            String defaultValue = XMLComponentDescriptor.getAttributeValue(node, DEFAULT_VALUE_ATTR);
            properties.add(new PropertyDescriptor(name, typeID, defaultValue != null ? PropertyValue.createUserCode(defaultValue) : PropertyValue.createNull(), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node, ALLOW_NULL)), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node, ALLOW_USER_CODE)), Versionable.FOREVER, Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node, USE_FOR_SERIALIZATION_ATTR)), Boolean.parseBoolean(XMLComponentDescriptor.getAttributeValue(node, READ_ONLY_ATTR))));
        }
        this.deserializePresenters(rootNode, projectType, presenters);
        this.propertyDescriptors = properties;
        this.presenterDescriptors = presenters;
    }

    private void deserializePresenters(Node rootNode, String projectType, ArrayList<PresenterDeserializer.PresenterFactory> presenters) {
        for (Node presentersNode : XMLComponentDescriptor.getChildNode(rootNode)) {
            if (!PRESENTERS_NODE.equals(presentersNode.getNodeName())) continue;
            for (Node node : XMLComponentDescriptor.getChildNode(presentersNode)) {
                PresenterDeserializer.PresenterFactory presenterFactory = PresenterDeserializerSupport.deserialize(projectType, node);
                if (presenterFactory == null) continue;
                presenters.add(presenterFactory);
            }
        }
    }

    static String getAttributeValue(Node node, String attr) {
        try {
            NamedNodeMap map;
            if (node != null && (map = node.getAttributes()) != null && (node = map.getNamedItem(attr)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException e) {
            Debug.warning(e);
        }
        return null;
    }

    static Node[] getChildNode(Node node) {
        NodeList childNodes = node.getChildNodes();
        Node[] nodes = new Node[childNodes != null ? childNodes.getLength() : 0];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = childNodes.item(i);
        }
        return nodes;
    }
}

