/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;

public class DiscriminatorClassMetadata
extends ORMetadata {
    private MetadataClass m_value;
    private String m_valueName;
    private String m_discriminator;

    public DiscriminatorClassMetadata() {
        super("<discriminator-class>");
    }

    public DiscriminatorClassMetadata(MetadataAnnotation discriminatorClass, MetadataAccessibleObject accessibleObject) {
        super(discriminatorClass, accessibleObject);
        this.setDiscriminator((String)discriminatorClass.getAttribute("discriminator"));
        this.setValue(this.getMetadataClass((String)discriminatorClass.getAttribute("value")));
    }

    public String getDiscriminator() {
        return this.m_discriminator;
    }

    public MetadataClass getValue() {
        return this.m_value;
    }

    public String getValueName() {
        return this.m_valueName;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_value = this.initXMLClassName(this.m_valueName);
    }

    public void process(VariableOneToOneMapping mapping) {
        if (mapping.getTypeIndicatorNameTranslation().containsValue(this.m_discriminator)) {
            throw ValidationException.multipleClassesForTheSameDiscriminator(this.m_discriminator, mapping.getAttributeName());
        }
        mapping.addClassNameIndicator(this.m_value.getName(), this.m_discriminator);
    }

    public void setDiscriminator(String discriminator) {
        this.m_discriminator = discriminator;
    }

    public void setValue(MetadataClass value) {
        this.m_value = value;
    }

    public void setValueName(String valueName) {
        this.m_valueName = valueName;
    }
}

