/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.SyntaxParserResult;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.completion.AttrValuesCompletion;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;

public class HtmlCompletionQuery
extends UserTask {
    private static final String SCRIPT_TAG_NAME = "script";
    private static final String STYLE_TAG_NAME = "style";
    private static boolean lowerCase;
    private static boolean isXHtml;
    private Document document;
    private FileObject file;
    private int offset;
    private CompletionResult completionResult;

    public HtmlCompletionQuery(Document document, int offset) {
        this.document = document;
        this.offset = offset;
        this.file = DataLoadersBridge.getDefault().getFileObject(document);
    }

    public CompletionResult query() throws ParseException {
        Source source = Source.create((Document)this.document);
        ParserManager.parse(Collections.singleton(source), (UserTask)this);
        return this.completionResult;
    }

    public void run(ResultIterator resultIterator) throws Exception {
        Parser.Result parserResult = resultIterator.getParserResult(this.offset);
        if (parserResult == null) {
            return;
        }
        Snapshot snapshot = parserResult.getSnapshot();
        int embeddedOffset = snapshot.getEmbeddedOffset(this.offset);
        String resultMimeType = parserResult.getSnapshot().getMimeType();
        if (resultMimeType.equals("text/html")) {
            this.completionResult = this.query((HtmlParserResult)parserResult);
        } else if (resultMimeType.equals("text/javascript")) {
            this.completionResult = this.queryHtmlEndTagInEmbeddedCode(snapshot, embeddedOffset, SCRIPT_TAG_NAME);
        } else if (resultMimeType.equals("text/x-css")) {
            this.completionResult = this.queryHtmlEndTagInEmbeddedCode(snapshot, embeddedOffset, STYLE_TAG_NAME);
        }
    }

    private CompletionResult queryHtmlEndTagInEmbeddedCode(final Snapshot snapshot, final int embeddedOffset, final String endTagName) {
        final Document doc = snapshot.getSource().getDocument(false);
        if (doc != null) {
            final AtomicReference result = new AtomicReference();
            doc.render(new Runnable(){

                @Override
                public void run() {
                    Token<HTMLTokenId> openTagToken;
                    int documentItemOffset = snapshot.getOriginalOffset(embeddedOffset);
                    TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(doc, documentItemOffset - 1);
                    if (ts != null && ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && CharSequenceUtilities.equals((CharSequence)ts.token().text(), (Object)">") && (openTagToken = Utils.findTagOpenToken(ts)) != null && CharSequenceUtilities.equals((CharSequence)openTagToken.text(), (Object)endTagName)) {
                        List<HtmlCompletionItem> items = Collections.singletonList(HtmlCompletionItem.createAutocompleteEndTag(endTagName, documentItemOffset));
                        result.set(new CompletionResult(items, HtmlCompletionQuery.this.offset));
                    }
                }
            });
            if (result.get() != null) {
                return (CompletionResult)result.get();
            }
        }
        String expectedCode = "</" + endTagName;
        int patternSize = Math.max(embeddedOffset, embeddedOffset - expectedCode.length());
        CharSequence pattern = snapshot.getText().subSequence(embeddedOffset - patternSize, embeddedOffset);
        int ltIndex = CharSequenceUtilities.lastIndexOf((CharSequence)pattern, (int)60);
        if (ltIndex == -1) {
            return null;
        }
        boolean match = true;
        for (int i = ltIndex; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == expectedCode.charAt(i - ltIndex)) continue;
            match = false;
            break;
        }
        if (match) {
            int itemOffset = embeddedOffset - patternSize + ltIndex;
            int documentItemOffset = snapshot.getOriginalOffset(itemOffset);
            List<HtmlCompletionItem> items = Collections.singletonList(HtmlCompletionItem.createEndTag(endTagName, documentItemOffset, null, -1, HtmlCompletionItem.EndTag.Type.DEFAULT));
            return new CompletionResult(items, this.offset);
        }
        return null;
    }

    private CompletionResult query(HtmlParserResult result) {
        return this.query(result, result.dtd());
    }

    CompletionResult query(HtmlParserResult parserResult, DTD dtd) {
        List<CompletionItem> result;
        int anchor;
        block53: {
            boolean queryHtmlContent;
            AstNode root;
            AstNode undeclaredTagsLeafNode;
            AstNode node;
            int len;
            TokenId id;
            String itemText;
            String preText;
            int documentItemOffset;
            int itemOffset;
            Token item;
            TokenSequence ts;
            int astOffset;
            String sourceMimetype;
            block54: {
                boolean inside;
                block52: {
                    Snapshot snapshot = parserResult.getSnapshot();
                    sourceMimetype = snapshot.getSource().getMimeType();
                    astOffset = snapshot.getEmbeddedOffset(this.offset);
                    lowerCase = this.usesLowerCase(parserResult, astOffset);
                    isXHtml = parserResult.getHtmlVersion().isXhtml();
                    TokenHierarchy hi = snapshot.getTokenHierarchy();
                    ts = hi.tokenSequence(HTMLTokenId.language());
                    assert (ts != null);
                    int diff = ts.move(astOffset);
                    boolean backward = false;
                    if (ts.moveNext()) {
                        if (diff == 0 && (ts.token().id() == HTMLTokenId.TEXT || ts.token().id() == HTMLTokenId.WS || ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL || ts.token().id() == HTMLTokenId.TAG_OPEN_SYMBOL)) {
                            backward = true;
                            if (!ts.movePrevious()) {
                                return null;
                            }
                        }
                    } else if (!ts.movePrevious()) {
                        return null;
                    }
                    anchor = -1;
                    item = ts.token();
                    itemOffset = ts.offset();
                    documentItemOffset = snapshot.getOriginalOffset(itemOffset);
                    itemText = preText = ((Object)item.text()).toString();
                    if (astOffset - itemOffset < 0) {
                        StringBuilder b = new StringBuilder();
                        b.append("just happened Bug 182267 -  StringIndexOutOfBoundsException: String index out of range: -1\n");
                        b.append("current's snapshot token sequence:\n");
                        b.append(ts.toString());
                        b.append(String.format("astOffset = %1$s, itemOffset = %2$s\n", astOffset, itemOffset));
                        Logger.getAnonymousLogger().warning(b.toString());
                    }
                    if (diff < preText.length()) {
                        preText = preText.substring(0, astOffset - itemOffset);
                    }
                    id = item.id();
                    inside = ts.offset() < astOffset;
                    result = null;
                    len = 1;
                    int searchAstOffset = astOffset == snapshot.getText().length() ? astOffset - 1 : astOffset;
                    node = parserResult.findLeaf(searchAstOffset, backward);
                    if (node == null) {
                        return null;
                    }
                    AstNode undeclaredTagsParseTreeRoot = parserResult.root(SyntaxParserResult.UNDECLARED_TAGS_NAMESPACE);
                    assert (undeclaredTagsParseTreeRoot != null);
                    undeclaredTagsLeafNode = AstNodeUtils.findDescendant((AstNode)undeclaredTagsParseTreeRoot, (int)searchAstOffset, (boolean)backward);
                    root = node.getRootNode();
                    String namespace = (String)root.getProperty("namespace");
                    queryHtmlContent = namespace == null || namespace.equals(parserResult.getHtmlVersion().getDefaultNamespace());
                    int ampIndex = preText.lastIndexOf(38);
                    if (id != HTMLTokenId.TEXT && id != HTMLTokenId.VALUE || ampIndex <= -1) break block52;
                    String refNamePrefix = preText.substring(ampIndex + 1);
                    anchor = this.offset;
                    result = this.translateCharRefs(this.offset - len, dtd.getCharRefList(refNamePrefix));
                    break block53;
                }
                if (id != HTMLTokenId.CHARACTER) break block54;
                if (!inside && preText.endsWith(";")) break block53;
                anchor = documentItemOffset + 1;
                result = this.translateCharRefs(documentItemOffset, dtd.getCharRefList(preText.length() > 0 ? preText.substring(1) : ""));
                break block53;
            }
            if (id == HTMLTokenId.TAG_OPEN) {
                anchor = documentItemOffset;
                astOffset -= preText.length() + 1;
                result = new ArrayList<CompletionItem>();
                if (queryHtmlContent) {
                    Collection openTags = AstNodeUtils.getPossibleOpenTagElements((AstNode)root, (int)astOffset);
                    result.addAll(this.translateTags(documentItemOffset - 1, this.filterElements(openTags, preText), this.filterElements(dtd.getElementList(null), preText)));
                }
                HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, documentItemOffset - 1, preText, itemText);
                for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                    result.addAll(e.completeOpenTags(context));
                }
            } else if (id != HTMLTokenId.BLOCK_COMMENT && preText.endsWith("<") || id == HTMLTokenId.TAG_OPEN_SYMBOL && "<".equals(((Object)item.text()).toString())) {
                anchor = this.offset;
                result = new ArrayList<CompletionItem>();
                if (queryHtmlContent) {
                    Collection openTags = AstNodeUtils.getPossibleOpenTagElements((AstNode)root, (int)astOffset);
                    result.addAll(this.translateTags(this.offset - 1, openTags, dtd.getElementList(null)));
                    if (HtmlPreferences.completionOffersEndTagAfterLt()) {
                        result.addAll(this.getPossibleEndTags(node, undeclaredTagsLeafNode, this.offset, ""));
                    }
                }
                HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, this.offset - 1, "", "");
                for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                    List<CompletionItem> items = e.completeOpenTags(context);
                    result.addAll(items);
                }
            } else if (id == HTMLTokenId.TEXT && preText.endsWith("</") || id == HTMLTokenId.TAG_OPEN_SYMBOL && preText.endsWith("</")) {
                anchor = this.offset;
                result = this.getPossibleEndTags(node, undeclaredTagsLeafNode, this.offset, "");
            } else if (id == HTMLTokenId.TAG_CLOSE) {
                anchor = documentItemOffset;
                result = this.getPossibleEndTags(node, undeclaredTagsLeafNode, this.offset, preText);
            } else if (id == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                anchor = this.offset;
                result = this.getAutocompletedEndTag(node, undeclaredTagsLeafNode, astOffset, this.offset);
            } else if (id == HTMLTokenId.WS || id == HTMLTokenId.ARGUMENT) {
                String prefix = id == HTMLTokenId.ARGUMENT ? preText : "";
                len = prefix.length();
                anchor = this.offset - len;
                if (!queryHtmlContent) {
                    ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
                    HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, anchor, prefix, itemText, node);
                    for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                        items.addAll(e.completeAttributes(context));
                    }
                    result = items;
                } else {
                    String wordAtCursor;
                    if (node.type() == AstNode.NodeType.UNKNOWN_TAG || node.type() == AstNode.NodeType.DECLARATION || node.type() == AstNode.NodeType.ROOT) {
                        return null;
                    }
                    assert (node.type() == AstNode.NodeType.OPEN_TAG) : "Unexpecet node type " + node.type();
                    DTD.Element tag = node.getDTDElement();
                    List possible = tag.getAttributeList(prefix);
                    Collection existingAttrsNames = node.getAttributeKeys();
                    String string = wordAtCursor = item == null ? null : ((Object)item.text()).toString();
                    if (wordAtCursor == null) {
                        wordAtCursor = "";
                    }
                    ArrayList<DTD.Attribute> attribs = new ArrayList<DTD.Attribute>();
                    for (DTD.Attribute attr : possible) {
                        String aName = attr.getName();
                        if (!aName.equals(prefix) && (existingAttrsNames.contains(isXHtml ? aName : aName.toUpperCase(Locale.ENGLISH)) || existingAttrsNames.contains(isXHtml ? aName : aName.toLowerCase(Locale.ENGLISH))) && (!wordAtCursor.equals(aName) || prefix.length() <= 0)) continue;
                        attribs.add(attr);
                    }
                    result = this.translateAttribs(anchor, attribs, tag);
                }
            } else if (id == HTMLTokenId.VALUE || id == HTMLTokenId.OPERATOR || id == HTMLTokenId.WS) {
                if (id == HTMLTokenId.WS) {
                    ts.move(itemOffset);
                    ts.movePrevious();
                    Token t = ts.token();
                    if (t.id() != HTMLTokenId.OPERATOR) {
                        return null;
                    }
                }
                if (node.type() == AstNode.NodeType.OPEN_TAG) {
                    DTD.Element tag;
                    ts.move(itemOffset);
                    ts.moveNext();
                    Token argItem = ts.token();
                    while (argItem.id() != HTMLTokenId.ARGUMENT && ts.movePrevious()) {
                        argItem = ts.token();
                    }
                    if (argItem.id() != HTMLTokenId.ARGUMENT) {
                        return null;
                    }
                    String argName = ((Object)argItem.text()).toString();
                    if (!isXHtml) {
                        argName = argName.toLowerCase(Locale.ENGLISH);
                    }
                    DTD.Attribute arg = (tag = node.getDTDElement()) == null ? null : tag.getAttribute(argName);
                    result = new ArrayList<CompletionItem>();
                    if (id != HTMLTokenId.VALUE) {
                        anchor = this.offset;
                        if (arg != null) {
                            result.addAll(this.translateValues(anchor, arg.getValueList("")));
                            ValueCompletion<HtmlCompletionItem> valuesCompletion = AttrValuesCompletion.getSupport(node.name(), argName);
                            if (valuesCompletion != null) {
                                result.addAll(valuesCompletion.getItems(this.file, this.offset, ""));
                            }
                        }
                        HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, anchor, "", itemText, node, argName, false);
                        for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                            result.addAll(e.completeAttributeValue(context));
                        }
                    } else {
                        String quotationChar = null;
                        if (preText != null && preText.length() > 0) {
                            if (preText.substring(0, 1).equals("'")) {
                                quotationChar = "'";
                            }
                            if (preText.substring(0, 1).equals("\"")) {
                                quotationChar = "\"";
                            }
                        }
                        String prefix = quotationChar == null ? preText : preText.substring(1);
                        anchor = documentItemOffset + (quotationChar != null ? 1 : 0);
                        if (arg != null) {
                            result.addAll(this.translateValues(documentItemOffset, arg.getValueList(prefix), quotationChar));
                            ValueCompletion<HtmlCompletionItem> valuesCompletion = AttrValuesCompletion.getSupport(node.name(), argName);
                            if (valuesCompletion != null) {
                                result.addAll(valuesCompletion.getItems(this.file, this.offset, prefix));
                            }
                        }
                        HtmlExtension.CompletionContext context = new HtmlExtension.CompletionContext(parserResult, itemOffset, astOffset, anchor, prefix, itemText, node, argName, quotationChar != null);
                        for (HtmlExtension e : HtmlExtension.getRegisteredExtensions(sourceMimetype)) {
                            result.addAll(e.completeAttributeValue(context));
                        }
                    }
                }
            }
        }
        return result == null ? null : new CompletionResult(result, anchor);
    }

    private boolean usesLowerCase(HtmlParserResult result, int astOffset) {
        AstNode node = AstNodeUtils.getTagNode((AstNode)result.root(), (int)astOffset);
        return node != null ? Character.isLowerCase(node.name().charAt(0)) : true;
    }

    public List<CompletionItem> getAutocompletedEndTag(AstNode node, AstNode undeclaredTagsLeafNode, int astOffset, int documentOffset) {
        List<CompletionItem> result = this.getAutocompletedEndTag(node, astOffset, documentOffset);
        if (result == null) {
            result = this.getAutocompletedEndTag(undeclaredTagsLeafNode, astOffset, documentOffset);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public List<CompletionItem> getAutocompletedEndTag(AstNode node, int astOffset, int documentOffset) {
        if (node.type() == AstNode.NodeType.OPEN_TAG && node.endOffset() == astOffset && !node.isEmpty() && !AstNodeUtils.hasForbiddenEndTag((AstNode)node)) {
            return Collections.singletonList(HtmlCompletionItem.createAutocompleteEndTag(node.name(), documentOffset));
        }
        return null;
    }

    private List<CompletionItem> translateCharRefs(int offset, List refs) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(refs.size());
        for (DTD.CharRef chr : refs) {
            String name = chr.getName();
            result.add(HtmlCompletionItem.createCharacterReference(name, chr.getValue(), offset, name));
        }
        return result;
    }

    private List<CompletionItem> getPossibleEndTags(AstNode leaf, AstNode undeclaredTagsLeafNode, int offset, String prefix) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.addAll(this.getPossibleHtmlEndTags(leaf, offset, prefix));
        items.addAll(this.getPossibleHtmlEndTags(undeclaredTagsLeafNode, offset, prefix));
        return items;
    }

    private List<CompletionItem> getPossibleHtmlEndTags(AstNode leaf, int offset, String prefix) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        while (leaf.type() != AstNode.NodeType.ROOT) {
            if (!(leaf.getDTDElement() != null && AstNodeUtils.hasForbiddenEndTag((AstNode)leaf) || leaf.type() != AstNode.NodeType.OPEN_TAG)) {
                String tagName = leaf.name();
                if (tagName.startsWith(prefix.toLowerCase(Locale.ENGLISH))) {
                    int order = offset - leaf.startOffset();
                    items.add(HtmlCompletionItem.createEndTag(tagName, offset - 2 - prefix.length(), tagName, order++, this.getEndTagType(leaf)));
                }
                if (leaf.needsToHaveMatchingTag() && leaf.getMatchingTag() == null) break;
            }
            leaf = leaf.parent();
            assert (leaf != null);
        }
        return items;
    }

    private HtmlCompletionItem.EndTag.Type getEndTagType(AstNode leaf) {
        if (leaf.getMatchingTag() != null) {
            return leaf.needsToHaveMatchingTag() ? HtmlCompletionItem.EndTag.Type.REQUIRED_EXISTING : HtmlCompletionItem.EndTag.Type.OPTIONAL_EXISTING;
        }
        return leaf.needsToHaveMatchingTag() ? HtmlCompletionItem.EndTag.Type.REQUIRED_MISSING : HtmlCompletionItem.EndTag.Type.OPTIONAL_MISSING;
    }

    private Collection<DTD.Element> filterElements(Collection<DTD.Element> elements, String elementNamePrefix) {
        ArrayList<DTD.Element> filtered = new ArrayList<DTD.Element>();
        elementNamePrefix = elementNamePrefix.toLowerCase(Locale.ENGLISH);
        for (DTD.Element e : elements) {
            if (!e.getName().toLowerCase(Locale.ENGLISH).startsWith(elementNamePrefix)) continue;
            filtered.add(e);
        }
        return filtered;
    }

    List<CompletionItem> translateTags(int offset, Collection<DTD.Element> possible, Collection<DTD.Element> all) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(all.size());
        all.removeAll(possible);
        for (DTD.Element e : possible) {
            result.add(this.item4Element(e, offset, true));
        }
        for (DTD.Element e : all) {
            result.add(this.item4Element(e, offset, false));
        }
        return result;
    }

    private HtmlCompletionItem item4Element(DTD.Element e, int offset, boolean possible) {
        String name = e.getName();
        name = isXHtml ? name : (lowerCase ? name.toLowerCase(Locale.ENGLISH) : name.toUpperCase(Locale.ENGLISH));
        return HtmlCompletionItem.createTag(name, offset, name, possible);
    }

    List<CompletionItem> translateAttribs(int offset, List<DTD.Attribute> attribs, DTD.Element tag) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>(attribs.size());
        String tagName = tag.getName() + "#";
        for (DTD.Attribute attrib : attribs) {
            String name = attrib.getName();
            switch (attrib.getType()) {
                case 0: {
                    result.add(HtmlCompletionItem.createBooleanAttribute(name, offset, attrib.isRequired(), tagName + name));
                    break;
                }
                case 1: 
                case 2: {
                    result.add(HtmlCompletionItem.createAttribute(name, offset, attrib.isRequired(), tagName + name));
                }
            }
        }
        return result;
    }

    List<HtmlCompletionItem> translateValues(int offset, List values) {
        return this.translateValues(offset, values, null);
    }

    List<HtmlCompletionItem> translateValues(int offset, List values, String quotationChar) {
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList<HtmlCompletionItem> result = new ArrayList<HtmlCompletionItem>(values.size());
        if (quotationChar != null) {
            ++offset;
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            result.add(HtmlCompletionItem.createAttributeValue(((DTD.Value)i.next()).getName(), offset));
        }
        return result;
    }

    static {
        isXHtml = false;
    }

    public static class CompletionResult {
        private Collection<? extends CompletionItem> items;
        int anchor;

        CompletionResult(Collection<? extends CompletionItem> items, int anchor) {
            this.items = items;
            this.anchor = anchor;
        }

        public int getAnchor() {
            return this.anchor;
        }

        public Collection<? extends CompletionItem> getItems() {
            return this.items;
        }
    }
}

