/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class RecipInfo {
    private int version;
    private IssuerAndSerialNumber issuerAndSerial;
    private AlgorithmIdentifier keyEncAlgor;
    private ASN1OctetString encKey;
    private X509AuxCertificate cert;

    public void set(X509AuxCertificate cert) throws PKCS7Exception {
        this.version = 0;
        X500Name issuer = X500Name.getInstance((Object)cert.getIssuerX500Principal().getEncoded());
        BigInteger serial = cert.getSerialNumber();
        this.issuerAndSerial = new IssuerAndSerialNumber(issuer, serial);
        String algo = this.addEncryptionIfNeeded(cert.getPublicKey().getAlgorithm());
        this.keyEncAlgor = new AlgorithmIdentifier(ASN1Registry.sym2oid(algo));
        this.cert = cert;
    }

    private String addEncryptionIfNeeded(String input) {
        if ((input = input.toLowerCase()).equals("rsa")) {
            return input + "Encryption";
        }
        if (input.equals("dsa")) {
            return input + "Encryption";
        }
        return input;
    }

    public boolean equals(Object other) {
        boolean ret;
        boolean bl = ret = this == other;
        if (!ret && other instanceof RecipInfo) {
            RecipInfo o = (RecipInfo)other;
            ret = this.version == o.version && (this.issuerAndSerial == null ? o.issuerAndSerial == null : this.issuerAndSerial.equals((Object)o.issuerAndSerial)) && (this.keyEncAlgor == null ? o.keyEncAlgor == null : this.keyEncAlgor.equals((Object)o.keyEncAlgor)) && (this.encKey == null ? o.encKey == null : this.encKey.equals((Object)o.encKey));
        }
        return ret;
    }

    public int hashCode() {
        int result = 31;
        result += 13 * this.version;
        result += this.issuerAndSerial == null ? 0 : 13 * this.issuerAndSerial.hashCode();
        result += this.keyEncAlgor == null ? 0 : 13 * this.keyEncAlgor.hashCode();
        return result += this.encKey == null ? 0 : 13 * this.encKey.hashCode();
    }

    public String toString() {
        return "#<Recipient version=" + this.version + " issuerAndSerial=[" + this.issuerAndSerial.getName() + "," + this.issuerAndSerial.getCertificateSerialNumber() + "] keyEncAlgor=" + ASN1Registry.o2a(this.keyEncAlgor.getAlgorithm()) + " encKey=" + this.encKey + ">";
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int newVersion) {
        this.version = newVersion;
    }

    public final IssuerAndSerialNumber getIssuerAndSerial() {
        return this.issuerAndSerial;
    }

    public final void setIssuerAndSerial(IssuerAndSerialNumber newIssuerAndSerial) {
        this.issuerAndSerial = newIssuerAndSerial;
    }

    public final AlgorithmIdentifier getKeyEncAlgor() {
        return this.keyEncAlgor;
    }

    public final void setKeyEncAlgor(AlgorithmIdentifier newKeyEncAlgor) {
        this.keyEncAlgor = newKeyEncAlgor;
    }

    public final ASN1OctetString getEncKey() {
        return this.encKey;
    }

    public final void setEncKey(ASN1OctetString newEncKey) {
        this.encKey = newEncKey;
    }

    public final X509AuxCertificate getCert() {
        return this.cert;
    }

    public final void setCert(X509AuxCertificate newCert) {
        this.cert = newCert;
    }

    public boolean compare(X509AuxCertificate pcert) {
        if (!new Name(this.issuerAndSerial.getName()).isEqual(pcert.getIssuerX500Principal())) {
            return false;
        }
        return pcert.getSerialNumber().compareTo(this.issuerAndSerial.getCertificateSerialNumber().getValue()) == 0;
    }

    public static RecipInfo fromASN1(ASN1Encodable content) {
        ASN1Sequence sequence = (ASN1Sequence)content;
        RecipInfo ri = new RecipInfo();
        ri.setVersion(((ASN1Integer)sequence.getObjectAt(0)).getValue().intValue());
        ri.setIssuerAndSerial(IssuerAndSerialNumber.getInstance((Object)sequence.getObjectAt(1)));
        ri.setKeyEncAlgor(AlgorithmIdentifier.getInstance((Object)sequence.getObjectAt(2)));
        ri.setEncKey((ASN1OctetString)sequence.getObjectAt(3));
        return ri;
    }

    public ASN1Encodable asASN1() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(BigInteger.valueOf(this.getVersion())));
        vector.add((ASN1Encodable)this.issuerAndSerial.toASN1Primitive());
        vector.add((ASN1Encodable)this.keyEncAlgor.toASN1Primitive());
        vector.add((ASN1Encodable)this.encKey.toASN1Primitive());
        return new DLSequence(vector);
    }
}

