/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;

public class ASN1Registry {
    private static final Map<String, ASN1ObjectIdentifier> SYM_TO_OID = new HashMap<String, ASN1ObjectIdentifier>(X509Name.DefaultLookUp);
    private static final Map<ASN1ObjectIdentifier, String> OID_TO_SYM = new HashMap<ASN1ObjectIdentifier, String>(X509Name.DefaultSymbols);
    private static final Map<ASN1ObjectIdentifier, Integer> OID_TO_NID = new HashMap<ASN1ObjectIdentifier, Integer>();
    private static final Map<Integer, ASN1ObjectIdentifier> NID_TO_OID = new HashMap<Integer, ASN1ObjectIdentifier>();
    private static final Map<Integer, String> NID_TO_SN = new HashMap<Integer, String>();
    private static final Map<Integer, String> NID_TO_LN = new HashMap<Integer, String>();
    public static final int NID_id_pkix = 127;
    public static final String SN_id_pkix = "PKIX";
    public static final String OBJ_id_pkix = "1.3.6.1.5.5.7";
    public static final int NID_id_ad = 176;
    public static final String SN_id_ad = "id-ad";
    public static final String OBJ_id_ad = "1.3.6.1.5.5.7.48";
    public static final int NID_ad_OCSP = 178;
    public static final String SN_ad_OCSP = "OCSP";
    public static final String LN_ad_OCSP = "OCSP";
    public static final String OBJ_ad_OCSP = "1.3.6.1.5.5.7.48.1";
    public static final String OBJ_id_pkix_OCSP = "1.3.6.1.5.5.7.48.1";
    public static final int NID_iso = 181;
    public static final String SN_iso = "ISO";
    public static final String LN_iso = "iso";
    public static final String OBJ_iso = "1";
    public static final int NID_org = 379;
    public static final String SN_org = "ORG";
    public static final String LN_org = "org";
    public static final String OBJ_org = "1.3";
    public static final int NID_dod = 380;
    public static final String SN_dod = "DOD";
    public static final String LN_dod = "dod";
    public static final String OBJ_dod = "1.3.6";
    public static final int NID_iana = 381;
    public static final String SN_iana = "IANA";
    public static final String LN_iana = "iana";
    public static final String OBJ_iana = "1.3.6.1";
    public static final String OBJ_internet = "1.3.6.1";
    public static final String OBJ_csor = "2.16.840.1.101.3";
    public static final int NID_member_body = 182;
    public static final String SN_member_body = "member-body";
    public static final String LN_member_body = "ISO Member Body";
    public static final String OBJ_member_body = "1.2";
    public static final int NID_ISO_US = 183;
    public static final String SN_ISO_US = "ISO-US";
    public static final String LN_ISO_US = "ISO US Member Body";
    public static final String OBJ_ISO_US = "1.2.840";
    public static final int NID_rsadsi = 1;
    public static final String SN_rsadsi = "rsadsi";
    public static final String LN_rsadsi = "RSA Data Security, Inc.";
    public static final String OBJ_rsadsi = "1.2.840.113549";
    public static final int NID_pkcs = 2;
    public static final String SN_pkcs = "pkcs";
    public static final String LN_pkcs = "RSA Data Security, Inc. PKCS";
    public static final String OBJ_pkcs = "1.2.840.113549.1";
    public static final String OBJ_pkcs12 = "1.2.840.113549.1.12";
    public static final int NID_X9_57 = 184;
    public static final String SN_X9_57 = "X9-57";
    public static final String LN_X9_57 = "X9.57";
    public static final String OBJ_X9_57 = "1.2.840.10040";
    public static final int NID_ansi_X9_62 = 405;
    public static final String SN_ansi_X9_62 = "ansi-X9-62";
    public static final String LN_ansi_X9_62 = "ANSI X9.62";
    public static final String OBJ_ansi_X9_62 = "1.2.840.10045";
    public static final String OBJ_holdInstruction = "1.2.840.10040.2";
    public static final String OBJ_X9_62_id_fieldType = "1.2.840.10045.1";
    public static final String OBJ_X9_62_ellipticCurve = "1.2.840.10045.3";
    public static final String OBJ_X9_62_id_publicKeyType = "1.2.840.10045.2";
    public static final String OBJ_X9_62_id_ecSigType = "1.2.840.10045.4";
    public static final String OBJ_X9_62_primeCurve = "1.2.840.10045.3.1";
    public static final String OBJ_X9_62_c_TwoCurve = "1.2.840.10045.3.0";
    public static final String OBJ_nistAlgorithms = "2.16.840.1.101.3.4";
    public static final int NID_joint_iso_itu_t = 646;
    public static final String SN_joint_iso_itu_t = "JOINT-ISO-ITU-T";
    public static final String LN_joint_iso_itu_t = "joint-iso-itu-t";
    public static final String OBJ_joint_iso_itu_t = "2";
    public static final int NID_international_organizations = 647;
    public static final String SN_international_organizations = "international-organizations";
    public static final String LN_international_organizations = "International Organizations";
    public static final String OBJ_international_organizations = "2.23";
    public static final int NID_wap = 678;
    public static final String SN_wap = "wap";
    public static final String OBJ_wap = "2.23.43";
    public static final int NID_wap_wsg = 679;
    public static final String SN_wap_wsg = "wap-wsg";
    public static final String OBJ_wap_wsg = "2.23.43.13";
    public static final String OBJ_wap_wsg_idm_ecid = "2.23.43.13.4";
    public static final String OBJ_nist_hashalgs = "2.16.840.1.101.3.4.2";
    public static final String OBJ_pkcs12_Version1 = "1.2.840.113549.1.12.10";
    public static final int NID_pkcs9 = 47;
    public static final String SN_pkcs9 = "pkcs9";
    public static final String OBJ_pkcs9 = "1.2.840.113549.1.9";
    public static final String OBJ_certTypes = "1.2.840.113549.1.9.22";
    public static final String OBJ_crlTypes = "1.2.840.113549.1.9.23";
    public static final int NID_identified_organization = 676;
    public static final String SN_identified_organization = "identified-organization";
    public static final String OBJ_identified_organization = "1.3";
    public static final int NID_certicom_arc = 677;
    public static final String SN_certicom_arc = "certicom-arc";
    public static final String OBJ_certicom_arc = "1.3.132";
    public static final String OBJ_secg_ellipticCurve = "1.3.132.0";
    public static final String OBJ_aes = "2.16.840.1.101.3.4.1";
    public static final String OBJ_pkcs12_BagIds = "1.2.840.113549.1.12.10.1";
    public static final String OBJ_dsa_with_sha2 = "2.16.840.1.101.3.4.3";
    public static final int NID_undef = 0;
    public static final String SN_undef = "UNDEF";
    public static final String LN_undef = "undefined";
    public static final String OBJ_undef = "0";
    public static final int NID_md2 = 3;
    public static final String SN_md2 = "MD2";
    public static final String LN_md2 = "md2";
    public static final String OBJ_md2 = "1.2.840.113549.2.2";
    public static final int NID_md5 = 4;
    public static final String SN_md5 = "MD5";
    public static final String LN_md5 = "md5";
    public static final String OBJ_md5 = "1.2.840.113549.2.5";
    public static final int NID_rc4 = 5;
    public static final String SN_rc4 = "RC4";
    public static final String LN_rc4 = "rc4";
    public static final String OBJ_rc4 = "1.2.840.113549.3.4";
    public static final int NID_pkcs1 = 186;
    public static final String SN_pkcs1 = "pkcs1";
    public static final String OBJ_pkcs1 = "1.2.840.113549.1.1";
    public static final int NID_rsaEncryption = 6;
    public static final String LN_rsaEncryption = "rsaEncryption";
    public static final String OBJ_rsaEncryption = "1.2.840.113549.1.1.1";
    public static final ASN1ObjectIdentifier OID_rsaEncryption = new ASN1ObjectIdentifier("1.2.840.113549.1.1.1");
    public static final int NID_md2WithRSAEncryption = 7;
    public static final String SN_md2WithRSAEncryption = "RSA-MD2";
    public static final String LN_md2WithRSAEncryption = "md2WithRSAEncryption";
    public static final String OBJ_md2WithRSAEncryption = "1.2.840.113549.1.1.2";
    public static final int NID_md5WithRSAEncryption = 8;
    public static final String SN_md5WithRSAEncryption = "RSA-MD5";
    public static final String LN_md5WithRSAEncryption = "md5WithRSAEncryption";
    public static final String OBJ_md5WithRSAEncryption = "1.2.840.113549.1.1.4";
    public static final int NID_pkcs5 = 187;
    public static final String SN_pkcs5 = "pkcs5";
    public static final String OBJ_pkcs5 = "1.2.840.113549.1.5";
    public static final int NID_pbeWithMD2AndDES_CBC = 9;
    public static final String SN_pbeWithMD2AndDES_CBC = "PBE-MD2-DES";
    public static final String LN_pbeWithMD2AndDES_CBC = "pbeWithMD2AndDES-CBC";
    public static final String OBJ_pbeWithMD2AndDES_CBC = "1.2.840.113549.1.5.1";
    public static final int NID_pbeWithMD5AndDES_CBC = 10;
    public static final String SN_pbeWithMD5AndDES_CBC = "PBE-MD5-DES";
    public static final String LN_pbeWithMD5AndDES_CBC = "pbeWithMD5AndDES-CBC";
    public static final String OBJ_pbeWithMD5AndDES_CBC = "1.2.840.113549.1.5.3";
    public static final int NID_X500 = 11;
    public static final String SN_X500 = "X500";
    public static final String LN_X500 = "directory services (X.500)";
    public static final String OBJ_X500 = "2.5";
    public static final int NID_X509 = 12;
    public static final String SN_X509 = "X509";
    public static final String OBJ_X509 = "2.5.4";
    public static final int NID_commonName = 13;
    public static final String SN_commonName = "CN";
    public static final String LN_commonName = "commonName";
    public static final String OBJ_commonName = "2.5.4.3";
    public static final int NID_countryName = 14;
    public static final String SN_countryName = "C";
    public static final String LN_countryName = "countryName";
    public static final String OBJ_countryName = "2.5.4.6";
    public static final int NID_localityName = 15;
    public static final String SN_localityName = "L";
    public static final String LN_localityName = "localityName";
    public static final String OBJ_localityName = "2.5.4.7";
    public static final int NID_stateOrProvinceName = 16;
    public static final String SN_stateOrProvinceName = "ST";
    public static final String LN_stateOrProvinceName = "stateOrProvinceName";
    public static final String OBJ_stateOrProvinceName = "2.5.4.8";
    public static final int NID_organizationName = 17;
    public static final String SN_organizationName = "O";
    public static final String LN_organizationName = "organizationName";
    public static final String OBJ_organizationName = "2.5.4.10";
    public static final int NID_organizationalUnitName = 18;
    public static final String SN_organizationalUnitName = "OU";
    public static final String LN_organizationalUnitName = "organizationalUnitName";
    public static final String OBJ_organizationalUnitName = "2.5.4.11";
    public static final int NID_X500algorithms = 378;
    public static final String SN_X500algorithms = "X500algorithms";
    public static final String LN_X500algorithms = "directory services - algorithms";
    public static final String OBJ_X500algorithms = "2.5.8";
    public static final int NID_rsa = 19;
    public static final String SN_rsa = "RSA";
    public static final String LN_rsa = "rsa";
    public static final String OBJ_rsa = "2.5.8.1.1";
    public static final int NID_pkcs7 = 20;
    public static final String SN_pkcs7 = "pkcs7";
    public static final String OBJ_pkcs7 = "1.2.840.113549.1.7";
    public static final int NID_pkcs7_data = 21;
    public static final String LN_pkcs7_data = "pkcs7-data";
    public static final String OBJ_pkcs7_data = "1.2.840.113549.1.7.1";
    public static final ASN1ObjectIdentifier OID_pkcs7_data = new ASN1ObjectIdentifier("1.2.840.113549.1.7.1");
    public static final int NID_pkcs7_signed = 22;
    public static final String LN_pkcs7_signed = "pkcs7-signedData";
    public static final String OBJ_pkcs7_signed = "1.2.840.113549.1.7.2";
    public static final int NID_pkcs7_enveloped = 23;
    public static final String LN_pkcs7_enveloped = "pkcs7-envelopedData";
    public static final String OBJ_pkcs7_enveloped = "1.2.840.113549.1.7.3";
    public static final int NID_pkcs7_signedAndEnveloped = 24;
    public static final String LN_pkcs7_signedAndEnveloped = "pkcs7-signedAndEnvelopedData";
    public static final String OBJ_pkcs7_signedAndEnveloped = "1.2.840.113549.1.7.4";
    public static final int NID_pkcs7_digest = 25;
    public static final String LN_pkcs7_digest = "pkcs7-digestData";
    public static final String OBJ_pkcs7_digest = "1.2.840.113549.1.7.5";
    public static final int NID_pkcs7_encrypted = 26;
    public static final String LN_pkcs7_encrypted = "pkcs7-encryptedData";
    public static final String OBJ_pkcs7_encrypted = "1.2.840.113549.1.7.6";
    public static final int NID_pkcs3 = 27;
    public static final String SN_pkcs3 = "pkcs3";
    public static final String OBJ_pkcs3 = "1.2.840.113549.1.3";
    public static final int NID_dhKeyAgreement = 28;
    public static final String LN_dhKeyAgreement = "dhKeyAgreement";
    public static final String OBJ_dhKeyAgreement = "1.2.840.113549.1.3.1";
    public static final int NID_algorithm = 376;
    public static final String SN_algorithm = "algorithm";
    public static final String LN_algorithm = "algorithm";
    public static final String OBJ_algorithm = "1.3.14.3.2";
    public static final int NID_des_ecb = 29;
    public static final String SN_des_ecb = "DES-ECB";
    public static final String LN_des_ecb = "des-ecb";
    public static final String OBJ_des_ecb = "1.3.14.3.2.6";
    public static final int NID_des_cfb64 = 30;
    public static final String SN_des_cfb64 = "DES-CFB";
    public static final String LN_des_cfb64 = "des-cfb";
    public static final String OBJ_des_cfb64 = "1.3.14.3.2.9";
    public static final int NID_des_cbc = 31;
    public static final String SN_des_cbc = "DES-CBC";
    public static final String LN_des_cbc = "des-cbc";
    public static final String OBJ_des_cbc = "1.3.14.3.2.7";
    public static final ASN1ObjectIdentifier OID_des_cbc = new ASN1ObjectIdentifier("1.3.14.3.2.7");
    public static final int NID_des_ede_ecb = 32;
    public static final String SN_des_ede_ecb = "DES-EDE";
    public static final String LN_des_ede_ecb = "des-ede";
    public static final String OBJ_des_ede_ecb = "1.3.14.3.2.17";
    public static final int NID_des_ede3_ecb = 33;
    public static final String SN_des_ede3_ecb = "DES-EDE3";
    public static final String LN_des_ede3_ecb = "des-ede3";
    public static final int NID_idea_cbc = 34;
    public static final String SN_idea_cbc = "IDEA-CBC";
    public static final String LN_idea_cbc = "idea-cbc";
    public static final String OBJ_idea_cbc = "1.3.6.1.4.1.188.7.1.1.2";
    public static final int NID_idea_cfb64 = 35;
    public static final String SN_idea_cfb64 = "IDEA-CFB";
    public static final String LN_idea_cfb64 = "idea-cfb";
    public static final int NID_idea_ecb = 36;
    public static final String SN_idea_ecb = "IDEA-ECB";
    public static final String LN_idea_ecb = "idea-ecb";
    public static final int NID_rc2_cbc = 37;
    public static final String SN_rc2_cbc = "RC2-CBC";
    public static final String LN_rc2_cbc = "rc2-cbc";
    public static final String OBJ_rc2_cbc = "1.2.840.113549.3.2";
    public static final ASN1ObjectIdentifier OID_rc2_cbc = new ASN1ObjectIdentifier("1.2.840.113549.3.2");
    public static final int NID_rc2_ecb = 38;
    public static final String SN_rc2_ecb = "RC2-ECB";
    public static final String LN_rc2_ecb = "rc2-ecb";
    public static final int NID_rc2_cfb64 = 39;
    public static final String SN_rc2_cfb64 = "RC2-CFB";
    public static final String LN_rc2_cfb64 = "rc2-cfb";
    public static final int NID_rc2_ofb64 = 40;
    public static final String SN_rc2_ofb64 = "RC2-OFB";
    public static final String LN_rc2_ofb64 = "rc2-ofb";
    public static final int NID_sha = 41;
    public static final String SN_sha = "SHA";
    public static final String LN_sha = "sha";
    public static final String OBJ_sha = "1.3.14.3.2.18";
    public static final int NID_shaWithRSAEncryption = 42;
    public static final String SN_shaWithRSAEncryption = "RSA-SHA";
    public static final String LN_shaWithRSAEncryption = "shaWithRSAEncryption";
    public static final String OBJ_shaWithRSAEncryption = "1.3.14.3.2.15";
    public static final int NID_des_ede_cbc = 43;
    public static final String SN_des_ede_cbc = "DES-EDE-CBC";
    public static final String LN_des_ede_cbc = "des-ede-cbc";
    public static final int NID_des_ede3_cbc = 44;
    public static final String SN_des_ede3_cbc = "DES-EDE3-CBC";
    public static final String LN_des_ede3_cbc = "des-ede3-cbc";
    public static final String OBJ_des_ede3_cbc = "1.2.840.113549.3.7";
    public static final ASN1ObjectIdentifier OID_des_ede3_cbc = new ASN1ObjectIdentifier("1.2.840.113549.3.7");
    public static final int NID_des_ofb64 = 45;
    public static final String SN_des_ofb64 = "DES-OFB";
    public static final String LN_des_ofb64 = "des-ofb";
    public static final String OBJ_des_ofb64 = "1.3.14.3.2.8";
    public static final int NID_idea_ofb64 = 46;
    public static final String SN_idea_ofb64 = "IDEA-OFB";
    public static final String LN_idea_ofb64 = "idea-ofb";
    public static final int NID_pkcs9_emailAddress = 48;
    public static final String LN_pkcs9_emailAddress = "emailAddress";
    public static final String OBJ_pkcs9_emailAddress = "1.2.840.113549.1.9.1";
    public static final int NID_pkcs9_unstructuredName = 49;
    public static final String LN_pkcs9_unstructuredName = "unstructuredName";
    public static final String OBJ_pkcs9_unstructuredName = "1.2.840.113549.1.9.2";
    public static final int NID_pkcs9_contentType = 50;
    public static final String LN_pkcs9_contentType = "contentType";
    public static final String OBJ_pkcs9_contentType = "1.2.840.113549.1.9.3";
    public static final int NID_pkcs9_messageDigest = 51;
    public static final String LN_pkcs9_messageDigest = "messageDigest";
    public static final String OBJ_pkcs9_messageDigest = "1.2.840.113549.1.9.4";
    public static final int NID_pkcs9_signingTime = 52;
    public static final String LN_pkcs9_signingTime = "signingTime";
    public static final String OBJ_pkcs9_signingTime = "1.2.840.113549.1.9.5";
    public static final int NID_pkcs9_countersignature = 53;
    public static final String LN_pkcs9_countersignature = "countersignature";
    public static final String OBJ_pkcs9_countersignature = "1.2.840.113549.1.9.6";
    public static final int NID_pkcs9_challengePassword = 54;
    public static final String LN_pkcs9_challengePassword = "challengePassword";
    public static final String OBJ_pkcs9_challengePassword = "1.2.840.113549.1.9.7";
    public static final int NID_pkcs9_unstructuredAddress = 55;
    public static final String LN_pkcs9_unstructuredAddress = "unstructuredAddress";
    public static final String OBJ_pkcs9_unstructuredAddress = "1.2.840.113549.1.9.8";
    public static final int NID_pkcs9_extCertAttributes = 56;
    public static final String LN_pkcs9_extCertAttributes = "extendedCertificateAttributes";
    public static final String OBJ_pkcs9_extCertAttributes = "1.2.840.113549.1.9.9";
    public static final int NID_netscape = 57;
    public static final String SN_netscape = "Netscape";
    public static final String LN_netscape = "Netscape Communications Corp.";
    public static final String OBJ_netscape = "2.16.840.1.113730";
    public static final int NID_netscape_cert_extension = 58;
    public static final String SN_netscape_cert_extension = "nsCertExt";
    public static final String LN_netscape_cert_extension = "Netscape Certificate Extension";
    public static final String OBJ_netscape_cert_extension = "2.16.840.1.113730.1";
    public static final int NID_netscape_data_type = 59;
    public static final String SN_netscape_data_type = "nsDataType";
    public static final String LN_netscape_data_type = "Netscape Data Type";
    public static final String OBJ_netscape_data_type = "2.16.840.1.113730.2";
    public static final int NID_des_ede_cfb64 = 60;
    public static final String SN_des_ede_cfb64 = "DES-EDE-CFB";
    public static final String LN_des_ede_cfb64 = "des-ede-cfb";
    public static final int NID_des_ede3_cfb64 = 61;
    public static final String SN_des_ede3_cfb64 = "DES-EDE3-CFB";
    public static final String LN_des_ede3_cfb64 = "des-ede3-cfb";
    public static final int NID_des_ede_ofb64 = 62;
    public static final String SN_des_ede_ofb64 = "DES-EDE-OFB";
    public static final String LN_des_ede_ofb64 = "des-ede-ofb";
    public static final int NID_des_ede3_ofb64 = 63;
    public static final String SN_des_ede3_ofb64 = "DES-EDE3-OFB";
    public static final String LN_des_ede3_ofb64 = "des-ede3-ofb";
    public static final int NID_sha1 = 64;
    public static final String SN_sha1 = "SHA1";
    public static final String LN_sha1 = "sha1";
    public static final String OBJ_sha1 = "1.3.14.3.2.26";
    public static final ASN1ObjectIdentifier OID_sha1 = new ASN1ObjectIdentifier("1.3.14.3.2.26");
    public static final int NID_sha1WithRSAEncryption = 65;
    public static final String SN_sha1WithRSAEncryption = "RSA-SHA1";
    public static final String LN_sha1WithRSAEncryption = "sha1WithRSAEncryption";
    public static final String OBJ_sha1WithRSAEncryption = "1.2.840.113549.1.1.5";
    public static final int NID_dsaWithSHA = 66;
    public static final String SN_dsaWithSHA = "DSA-SHA";
    public static final String LN_dsaWithSHA = "dsaWithSHA";
    public static final String OBJ_dsaWithSHA = "1.3.14.3.2.13";
    public static final int NID_dsa_2 = 67;
    public static final String SN_dsa_2 = "DSA-old";
    public static final String LN_dsa_2 = "dsaEncryption-old";
    public static final String OBJ_dsa_2 = "1.3.14.3.2.12";
    public static final int NID_pbeWithSHA1AndRC2_CBC = 68;
    public static final String SN_pbeWithSHA1AndRC2_CBC = "PBE-SHA1-RC2-64";
    public static final String LN_pbeWithSHA1AndRC2_CBC = "pbeWithSHA1AndRC2-CBC";
    public static final String OBJ_pbeWithSHA1AndRC2_CBC = "1.2.840.113549.1.5.11";
    public static final int NID_id_pbkdf2 = 69;
    public static final String LN_id_pbkdf2 = "PBKDF2";
    public static final String OBJ_id_pbkdf2 = "1.2.840.113549.1.5.12";
    public static final int NID_dsaWithSHA1_2 = 70;
    public static final String SN_dsaWithSHA1_2 = "DSA-SHA1-old";
    public static final String LN_dsaWithSHA1_2 = "dsaWithSHA1-old";
    public static final String OBJ_dsaWithSHA1_2 = "1.3.14.3.2.27";
    public static final int NID_netscape_cert_type = 71;
    public static final String SN_netscape_cert_type = "nsCertType";
    public static final String LN_netscape_cert_type = "Netscape Cert Type";
    public static final String OBJ_netscape_cert_type = "2.16.840.1.113730.1.1";
    public static final int NID_netscape_base_url = 72;
    public static final String SN_netscape_base_url = "nsBaseUrl";
    public static final String LN_netscape_base_url = "Netscape Base Url";
    public static final String OBJ_netscape_base_url = "2.16.840.1.113730.1.2";
    public static final int NID_netscape_revocation_url = 73;
    public static final String SN_netscape_revocation_url = "nsRevocationUrl";
    public static final String LN_netscape_revocation_url = "Netscape Revocation Url";
    public static final String OBJ_netscape_revocation_url = "2.16.840.1.113730.1.3";
    public static final int NID_netscape_ca_revocation_url = 74;
    public static final String SN_netscape_ca_revocation_url = "nsCaRevocationUrl";
    public static final String LN_netscape_ca_revocation_url = "Netscape CA Revocation Url";
    public static final String OBJ_netscape_ca_revocation_url = "2.16.840.1.113730.1.4";
    public static final int NID_netscape_renewal_url = 75;
    public static final String SN_netscape_renewal_url = "nsRenewalUrl";
    public static final String LN_netscape_renewal_url = "Netscape Renewal Url";
    public static final String OBJ_netscape_renewal_url = "2.16.840.1.113730.1.7";
    public static final int NID_netscape_ca_policy_url = 76;
    public static final String SN_netscape_ca_policy_url = "nsCaPolicyUrl";
    public static final String LN_netscape_ca_policy_url = "Netscape CA Policy Url";
    public static final String OBJ_netscape_ca_policy_url = "2.16.840.1.113730.1.8";
    public static final int NID_netscape_ssl_server_name = 77;
    public static final String SN_netscape_ssl_server_name = "nsSslServerName";
    public static final String LN_netscape_ssl_server_name = "Netscape SSL Server Name";
    public static final String OBJ_netscape_ssl_server_name = "2.16.840.1.113730.1.12";
    public static final int NID_netscape_comment = 78;
    public static final String SN_netscape_comment = "nsComment";
    public static final String LN_netscape_comment = "Netscape Comment";
    public static final String OBJ_netscape_comment = "2.16.840.1.113730.1.13";
    public static final int NID_netscape_cert_sequence = 79;
    public static final String SN_netscape_cert_sequence = "nsCertSequence";
    public static final String LN_netscape_cert_sequence = "Netscape Certificate Sequence";
    public static final String OBJ_netscape_cert_sequence = "2.16.840.1.113730.2.5";
    public static final int NID_desx_cbc = 80;
    public static final String SN_desx_cbc = "DESX-CBC";
    public static final String LN_desx_cbc = "desx-cbc";
    public static final int NID_id_ce = 81;
    public static final String SN_id_ce = "id-ce";
    public static final String OBJ_id_ce = "2.5.29";
    public static final int NID_subject_key_identifier = 82;
    public static final String SN_subject_key_identifier = "subjectKeyIdentifier";
    public static final String LN_subject_key_identifier = "X509v3 Subject Key Identifier";
    public static final String OBJ_subject_key_identifier = "2.5.29.14";
    public static final int NID_key_usage = 83;
    public static final String SN_key_usage = "keyUsage";
    public static final String LN_key_usage = "X509v3 Key Usage";
    public static final String OBJ_key_usage = "2.5.29.15";
    public static final int NID_private_key_usage_period = 84;
    public static final String SN_private_key_usage_period = "privateKeyUsagePeriod";
    public static final String LN_private_key_usage_period = "X509v3 Private Key Usage Period";
    public static final String OBJ_private_key_usage_period = "2.5.29.16";
    public static final int NID_subject_alt_name = 85;
    public static final String SN_subject_alt_name = "subjectAltName";
    public static final String LN_subject_alt_name = "X509v3 Subject Alternative Name";
    public static final String OBJ_subject_alt_name = "2.5.29.17";
    public static final int NID_issuer_alt_name = 86;
    public static final String SN_issuer_alt_name = "issuerAltName";
    public static final String LN_issuer_alt_name = "X509v3 Issuer Alternative Name";
    public static final String OBJ_issuer_alt_name = "2.5.29.18";
    public static final int NID_basic_constraints = 87;
    public static final String SN_basic_constraints = "basicConstraints";
    public static final String LN_basic_constraints = "X509v3 Basic Constraints";
    public static final String OBJ_basic_constraints = "2.5.29.19";
    public static final int NID_crl_number = 88;
    public static final String SN_crl_number = "crlNumber";
    public static final String LN_crl_number = "X509v3 CRL Number";
    public static final String OBJ_crl_number = "2.5.29.20";
    public static final int NID_certificate_policies = 89;
    public static final String SN_certificate_policies = "certificatePolicies";
    public static final String LN_certificate_policies = "X509v3 Certificate Policies";
    public static final String OBJ_certificate_policies = "2.5.29.32";
    public static final int NID_authority_key_identifier = 90;
    public static final String SN_authority_key_identifier = "authorityKeyIdentifier";
    public static final String LN_authority_key_identifier = "X509v3 Authority Key Identifier";
    public static final String OBJ_authority_key_identifier = "2.5.29.35";
    public static final int NID_bf_cbc = 91;
    public static final String SN_bf_cbc = "BF-CBC";
    public static final String LN_bf_cbc = "bf-cbc";
    public static final String OBJ_bf_cbc = "1.3.6.1.4.1.3029.1.2";
    public static final int NID_bf_ecb = 92;
    public static final String SN_bf_ecb = "BF-ECB";
    public static final String LN_bf_ecb = "bf-ecb";
    public static final int NID_bf_cfb64 = 93;
    public static final String SN_bf_cfb64 = "BF-CFB";
    public static final String LN_bf_cfb64 = "bf-cfb";
    public static final int NID_bf_ofb64 = 94;
    public static final String SN_bf_ofb64 = "BF-OFB";
    public static final String LN_bf_ofb64 = "bf-ofb";
    public static final int NID_mdc2 = 95;
    public static final String SN_mdc2 = "MDC2";
    public static final String LN_mdc2 = "mdc2";
    public static final String OBJ_mdc2 = "2.5.8.3.101";
    public static final int NID_mdc2WithRSA = 96;
    public static final String SN_mdc2WithRSA = "RSA-MDC2";
    public static final String LN_mdc2WithRSA = "mdc2WithRSA";
    public static final String OBJ_mdc2WithRSA = "2.5.8.3.100";
    public static final int NID_rc4_40 = 97;
    public static final String SN_rc4_40 = "RC4-40";
    public static final String LN_rc4_40 = "rc4-40";
    public static final int NID_rc2_40_cbc = 98;
    public static final String SN_rc2_40_cbc = "RC2-40-CBC";
    public static final String LN_rc2_40_cbc = "rc2-40-cbc";
    public static final String OBJ_rc2_40_cbc = "1.2.840.113549.3.2";
    public static final int NID_givenName = 99;
    public static final String SN_givenName = "GN";
    public static final String LN_givenName = "givenName";
    public static final String OBJ_givenName = "2.5.4.42";
    public static final int NID_surname = 100;
    public static final String SN_surname = "SN";
    public static final String LN_surname = "surname";
    public static final String OBJ_surname = "2.5.4.4";
    public static final int NID_initials = 101;
    public static final String LN_initials = "initials";
    public static final String OBJ_initials = "2.5.4.43";
    public static final int NID_crl_distribution_points = 103;
    public static final String SN_crl_distribution_points = "crlDistributionPoints";
    public static final String LN_crl_distribution_points = "X509v3 CRL Distribution Points";
    public static final String OBJ_crl_distribution_points = "2.5.29.31";
    public static final int NID_md5WithRSA = 104;
    public static final String SN_md5WithRSA = "RSA-NP-MD5";
    public static final String LN_md5WithRSA = "md5WithRSA";
    public static final String OBJ_md5WithRSA = "1.3.14.3.2.3";
    public static final int NID_serialNumber = 105;
    public static final String LN_serialNumber = "serialNumber";
    public static final String OBJ_serialNumber = "2.5.4.5";
    public static final int NID_title = 106;
    public static final String LN_title = "title";
    public static final String OBJ_title = "2.5.4.12";
    public static final int NID_description = 107;
    public static final String LN_description = "description";
    public static final String OBJ_description = "2.5.4.13";
    public static final int NID_cast5_cbc = 108;
    public static final String SN_cast5_cbc = "CAST5-CBC";
    public static final String LN_cast5_cbc = "cast5-cbc";
    public static final String OBJ_cast5_cbc = "1.2.840.113533.7.66.10";
    public static final int NID_cast5_ecb = 109;
    public static final String SN_cast5_ecb = "CAST5-ECB";
    public static final String LN_cast5_ecb = "cast5-ecb";
    public static final int NID_cast5_cfb64 = 110;
    public static final String SN_cast5_cfb64 = "CAST5-CFB";
    public static final String LN_cast5_cfb64 = "cast5-cfb";
    public static final int NID_cast5_ofb64 = 111;
    public static final String SN_cast5_ofb64 = "CAST5-OFB";
    public static final String LN_cast5_ofb64 = "cast5-ofb";
    public static final int NID_pbeWithMD5AndCast5_CBC = 112;
    public static final String LN_pbeWithMD5AndCast5_CBC = "pbeWithMD5AndCast5CBC";
    public static final String OBJ_pbeWithMD5AndCast5_CBC = "1.2.840.113533.7.66.12";
    public static final int NID_X9cm = 185;
    public static final String SN_X9cm = "X9cm";
    public static final String LN_X9cm = "X9.57 CM ?";
    public static final String OBJ_X9cm = "1.2.840.10040.4";
    public static final int NID_dsaWithSHA1 = 113;
    public static final String SN_dsaWithSHA1 = "DSA-SHA1";
    public static final String LN_dsaWithSHA1 = "dsaWithSHA1";
    public static final String OBJ_dsaWithSHA1 = "1.2.840.10040.4.3";
    public static final int NID_md5_sha1 = 114;
    public static final String SN_md5_sha1 = "MD5-SHA1";
    public static final String LN_md5_sha1 = "md5-sha1";
    public static final int NID_sha1WithRSA = 115;
    public static final String SN_sha1WithRSA = "RSA-SHA1-2";
    public static final String LN_sha1WithRSA = "sha1WithRSA";
    public static final String OBJ_sha1WithRSA = "1.3.14.3.2.29";
    public static final int NID_dsa = 116;
    public static final String SN_dsa = "DSA";
    public static final String LN_dsa = "dsaEncryption";
    public static final String OBJ_dsa = "1.2.840.10040.4.1";
    public static final ASN1ObjectIdentifier OID_dsa = new ASN1ObjectIdentifier("1.2.840.10040.4.1");
    public static final int NID_ripemd160 = 117;
    public static final String SN_ripemd160 = "RIPEMD160";
    public static final String LN_ripemd160 = "ripemd160";
    public static final String OBJ_ripemd160 = "1.3.36.3.2.1";
    public static final int NID_ripemd160WithRSA = 119;
    public static final String SN_ripemd160WithRSA = "RSA-RIPEMD160";
    public static final String LN_ripemd160WithRSA = "ripemd160WithRSA";
    public static final String OBJ_ripemd160WithRSA = "1.3.36.3.3.1.2";
    public static final int NID_rc5_cbc = 120;
    public static final String SN_rc5_cbc = "RC5-CBC";
    public static final String LN_rc5_cbc = "rc5-cbc";
    public static final String OBJ_rc5_cbc = "1.2.840.113549.3.8";
    public static final int NID_rc5_ecb = 121;
    public static final String SN_rc5_ecb = "RC5-ECB";
    public static final String LN_rc5_ecb = "rc5-ecb";
    public static final int NID_rc5_cfb64 = 122;
    public static final String SN_rc5_cfb64 = "RC5-CFB";
    public static final String LN_rc5_cfb64 = "rc5-cfb";
    public static final int NID_rc5_ofb64 = 123;
    public static final String SN_rc5_ofb64 = "RC5-OFB";
    public static final String LN_rc5_ofb64 = "rc5-ofb";
    public static final int NID_rle_compression = 124;
    public static final String SN_rle_compression = "RLE";
    public static final String LN_rle_compression = "run length compression";
    public static final String OBJ_rle_compression = "1.1.1.1.666.1";
    public static final int NID_zlib_compression = 125;
    public static final String SN_zlib_compression = "ZLIB";
    public static final String LN_zlib_compression = "zlib compression";
    public static final String OBJ_zlib_compression = "1.1.1.1.666.2";
    public static final int NID_ext_key_usage = 126;
    public static final String SN_ext_key_usage = "extendedKeyUsage";
    public static final String LN_ext_key_usage = "X509v3 Extended Key Usage";
    public static final String OBJ_ext_key_usage = "2.5.29.37";
    public static final int NID_id_kp = 128;
    public static final String SN_id_kp = "id-kp";
    public static final String OBJ_id_kp = "1.3.6.1.5.5.7.3";
    public static final int NID_server_auth = 129;
    public static final String SN_server_auth = "serverAuth";
    public static final String LN_server_auth = "TLS Web Server Authentication";
    public static final String OBJ_server_auth = "1.3.6.1.5.5.7.3.1";
    public static final int NID_client_auth = 130;
    public static final String SN_client_auth = "clientAuth";
    public static final String LN_client_auth = "TLS Web Client Authentication";
    public static final String OBJ_client_auth = "1.3.6.1.5.5.7.3.2";
    public static final int NID_code_sign = 131;
    public static final String SN_code_sign = "codeSigning";
    public static final String LN_code_sign = "Code Signing";
    public static final String OBJ_code_sign = "1.3.6.1.5.5.7.3.3";
    public static final int NID_email_protect = 132;
    public static final String SN_email_protect = "emailProtection";
    public static final String LN_email_protect = "E-mail Protection";
    public static final String OBJ_email_protect = "1.3.6.1.5.5.7.3.4";
    public static final int NID_time_stamp = 133;
    public static final String SN_time_stamp = "timeStamping";
    public static final String LN_time_stamp = "Time Stamping";
    public static final String OBJ_time_stamp = "1.3.6.1.5.5.7.3.8";
    public static final int NID_ms_code_ind = 134;
    public static final String SN_ms_code_ind = "msCodeInd";
    public static final String LN_ms_code_ind = "Microsoft Individual Code Signing";
    public static final String OBJ_ms_code_ind = "1.3.6.1.4.1.311.2.1.21";
    public static final int NID_ms_code_com = 135;
    public static final String SN_ms_code_com = "msCodeCom";
    public static final String LN_ms_code_com = "Microsoft Commercial Code Signing";
    public static final String OBJ_ms_code_com = "1.3.6.1.4.1.311.2.1.22";
    public static final int NID_ms_ctl_sign = 136;
    public static final String SN_ms_ctl_sign = "msCTLSign";
    public static final String LN_ms_ctl_sign = "Microsoft Trust List Signing";
    public static final String OBJ_ms_ctl_sign = "1.3.6.1.4.1.311.10.3.1";
    public static final int NID_ms_sgc = 137;
    public static final String SN_ms_sgc = "msSGC";
    public static final String LN_ms_sgc = "Microsoft Server Gated Crypto";
    public static final String OBJ_ms_sgc = "1.3.6.1.4.1.311.10.3.3";
    public static final int NID_ms_efs = 138;
    public static final String SN_ms_efs = "msEFS";
    public static final String LN_ms_efs = "Microsoft Encrypted File System";
    public static final String OBJ_ms_efs = "1.3.6.1.4.1.311.10.3.4";
    public static final int NID_ns_sgc = 139;
    public static final String SN_ns_sgc = "nsSGC";
    public static final String LN_ns_sgc = "Netscape Server Gated Crypto";
    public static final String OBJ_ns_sgc = "2.16.840.1.113730.4.1";
    public static final int NID_delta_crl = 140;
    public static final String SN_delta_crl = "deltaCRL";
    public static final String LN_delta_crl = "X509v3 Delta CRL Indicator";
    public static final String OBJ_delta_crl = "2.5.29.27";
    public static final int NID_crl_reason = 141;
    public static final String SN_crl_reason = "CRLReason";
    public static final String LN_crl_reason = "X509v3 CRL Reason Code";
    public static final String OBJ_crl_reason = "2.5.29.21";
    public static final int NID_invalidity_date = 142;
    public static final String SN_invalidity_date = "invalidityDate";
    public static final String LN_invalidity_date = "Invalidity Date";
    public static final String OBJ_invalidity_date = "2.5.29.24";
    public static final int NID_sxnet = 143;
    public static final String SN_sxnet = "SXNetID";
    public static final String LN_sxnet = "Strong Extranet ID";
    public static final String OBJ_sxnet = "1.3.101.1.4.1";
    public static final String OBJ_pkcs12_pbeids = "1.2.840.113549.1.12.1";
    public static final int NID_pbe_WithSHA1And128BitRC4 = 144;
    public static final String SN_pbe_WithSHA1And128BitRC4 = "PBE-SHA1-RC4-128";
    public static final String LN_pbe_WithSHA1And128BitRC4 = "pbeWithSHA1And128BitRC4";
    public static final String OBJ_pbe_WithSHA1And128BitRC4 = "1.2.840.113549.1.12.1.1";
    public static final int NID_pbe_WithSHA1And40BitRC4 = 145;
    public static final String SN_pbe_WithSHA1And40BitRC4 = "PBE-SHA1-RC4-40";
    public static final String LN_pbe_WithSHA1And40BitRC4 = "pbeWithSHA1And40BitRC4";
    public static final String OBJ_pbe_WithSHA1And40BitRC4 = "1.2.840.113549.1.12.1.2";
    public static final int NID_pbe_WithSHA1And3_Key_TripleDES_CBC = 146;
    public static final String SN_pbe_WithSHA1And3_Key_TripleDES_CBC = "PBE-SHA1-3DES";
    public static final String LN_pbe_WithSHA1And3_Key_TripleDES_CBC = "pbeWithSHA1And3-KeyTripleDES-CBC";
    public static final String OBJ_pbe_WithSHA1And3_Key_TripleDES_CBC = "1.2.840.113549.1.12.1.3";
    public static final int NID_pbe_WithSHA1And2_Key_TripleDES_CBC = 147;
    public static final String SN_pbe_WithSHA1And2_Key_TripleDES_CBC = "PBE-SHA1-2DES";
    public static final String LN_pbe_WithSHA1And2_Key_TripleDES_CBC = "pbeWithSHA1And2-KeyTripleDES-CBC";
    public static final String OBJ_pbe_WithSHA1And2_Key_TripleDES_CBC = "1.2.840.113549.1.12.1.4";
    public static final int NID_pbe_WithSHA1And128BitRC2_CBC = 148;
    public static final String SN_pbe_WithSHA1And128BitRC2_CBC = "PBE-SHA1-RC2-128";
    public static final String LN_pbe_WithSHA1And128BitRC2_CBC = "pbeWithSHA1And128BitRC2-CBC";
    public static final String OBJ_pbe_WithSHA1And128BitRC2_CBC = "1.2.840.113549.1.12.1.5";
    public static final int NID_pbe_WithSHA1And40BitRC2_CBC = 149;
    public static final String SN_pbe_WithSHA1And40BitRC2_CBC = "PBE-SHA1-RC2-40";
    public static final String LN_pbe_WithSHA1And40BitRC2_CBC = "pbeWithSHA1And40BitRC2-CBC";
    public static final String OBJ_pbe_WithSHA1And40BitRC2_CBC = "1.2.840.113549.1.12.1.6";
    public static final int NID_keyBag = 150;
    public static final String LN_keyBag = "keyBag";
    public static final String OBJ_keyBag = "1.2.840.113549.1.12.10.1.1";
    public static final int NID_pkcs8ShroudedKeyBag = 151;
    public static final String LN_pkcs8ShroudedKeyBag = "pkcs8ShroudedKeyBag";
    public static final String OBJ_pkcs8ShroudedKeyBag = "1.2.840.113549.1.12.10.1.2";
    public static final int NID_certBag = 152;
    public static final String LN_certBag = "certBag";
    public static final String OBJ_certBag = "1.2.840.113549.1.12.10.1.3";
    public static final int NID_crlBag = 153;
    public static final String LN_crlBag = "crlBag";
    public static final String OBJ_crlBag = "1.2.840.113549.1.12.10.1.4";
    public static final int NID_secretBag = 154;
    public static final String LN_secretBag = "secretBag";
    public static final String OBJ_secretBag = "1.2.840.113549.1.12.10.1.5";
    public static final int NID_safeContentsBag = 155;
    public static final String LN_safeContentsBag = "safeContentsBag";
    public static final String OBJ_safeContentsBag = "1.2.840.113549.1.12.10.1.6";
    public static final int NID_friendlyName = 156;
    public static final String LN_friendlyName = "friendlyName";
    public static final String OBJ_friendlyName = "1.2.840.113549.1.9.20";
    public static final int NID_localKeyID = 157;
    public static final String LN_localKeyID = "localKeyID";
    public static final String OBJ_localKeyID = "1.2.840.113549.1.9.21";
    public static final int NID_x509Certificate = 158;
    public static final String LN_x509Certificate = "x509Certificate";
    public static final String OBJ_x509Certificate = "1.2.840.113549.1.9.22.1";
    public static final int NID_sdsiCertificate = 159;
    public static final String LN_sdsiCertificate = "sdsiCertificate";
    public static final String OBJ_sdsiCertificate = "1.2.840.113549.1.9.22.2";
    public static final int NID_x509Crl = 160;
    public static final String LN_x509Crl = "x509Crl";
    public static final String OBJ_x509Crl = "1.2.840.113549.1.9.23.1";
    public static final int NID_pbes2 = 161;
    public static final String LN_pbes2 = "PBES2";
    public static final String OBJ_pbes2 = "1.2.840.113549.1.5.13";
    public static final int NID_pbmac1 = 162;
    public static final String LN_pbmac1 = "PBMAC1";
    public static final String OBJ_pbmac1 = "1.2.840.113549.1.5.14";
    public static final int NID_hmacWithSHA1 = 163;
    public static final String LN_hmacWithSHA1 = "hmacWithSHA1";
    public static final String OBJ_hmacWithSHA1 = "1.2.840.113549.2.7";
    public static final int NID_id_qt = 259;
    public static final String SN_id_qt = "id-qt";
    public static final String OBJ_id_qt = "1.3.6.1.5.5.7.2";
    public static final int NID_id_qt_cps = 164;
    public static final String SN_id_qt_cps = "id-qt-cps";
    public static final String LN_id_qt_cps = "Policy Qualifier CPS";
    public static final String OBJ_id_qt_cps = "1.3.6.1.5.5.7.2.1";
    public static final int NID_id_qt_unotice = 165;
    public static final String SN_id_qt_unotice = "id-qt-unotice";
    public static final String LN_id_qt_unotice = "Policy Qualifier User Notice";
    public static final String OBJ_id_qt_unotice = "1.3.6.1.5.5.7.2.2";
    public static final int NID_rc2_64_cbc = 166;
    public static final String SN_rc2_64_cbc = "RC2-64-CBC";
    public static final String LN_rc2_64_cbc = "rc2-64-cbc";
    public static final int NID_SMIMECapabilities = 167;
    public static final String SN_SMIMECapabilities = "SMIME-CAPS";
    public static final String LN_SMIMECapabilities = "S/MIME Capabilities";
    public static final String OBJ_SMIMECapabilities = "1.2.840.113549.1.9.15";
    public static final int NID_pbeWithMD2AndRC2_CBC = 168;
    public static final String SN_pbeWithMD2AndRC2_CBC = "PBE-MD2-RC2-64";
    public static final String LN_pbeWithMD2AndRC2_CBC = "pbeWithMD2AndRC2-CBC";
    public static final String OBJ_pbeWithMD2AndRC2_CBC = "1.2.840.113549.1.5.4";
    public static final int NID_pbeWithMD5AndRC2_CBC = 169;
    public static final String SN_pbeWithMD5AndRC2_CBC = "PBE-MD5-RC2-64";
    public static final String LN_pbeWithMD5AndRC2_CBC = "pbeWithMD5AndRC2-CBC";
    public static final String OBJ_pbeWithMD5AndRC2_CBC = "1.2.840.113549.1.5.6";
    public static final int NID_pbeWithSHA1AndDES_CBC = 170;
    public static final String SN_pbeWithSHA1AndDES_CBC = "PBE-SHA1-DES";
    public static final String LN_pbeWithSHA1AndDES_CBC = "pbeWithSHA1AndDES-CBC";
    public static final String OBJ_pbeWithSHA1AndDES_CBC = "1.2.840.113549.1.5.10";
    public static final int NID_ms_ext_req = 171;
    public static final String SN_ms_ext_req = "msExtReq";
    public static final String LN_ms_ext_req = "Microsoft Extension Request";
    public static final String OBJ_ms_ext_req = "1.3.6.1.4.1.311.2.1.14";
    public static final int NID_ext_req = 172;
    public static final String SN_ext_req = "extReq";
    public static final String LN_ext_req = "Extension Request";
    public static final String OBJ_ext_req = "1.2.840.113549.1.9.14";
    public static final int NID_name = 173;
    public static final String SN_name = "name";
    public static final String LN_name = "name";
    public static final String OBJ_name = "2.5.4.41";
    public static final int NID_dnQualifier = 174;
    public static final String SN_dnQualifier = "dnQualifier";
    public static final String LN_dnQualifier = "dnQualifier";
    public static final String OBJ_dnQualifier = "2.5.4.46";
    public static final int NID_id_pe = 175;
    public static final String SN_id_pe = "id-pe";
    public static final String OBJ_id_pe = "1.3.6.1.5.5.7.1";
    public static final int NID_info_access = 177;
    public static final String SN_info_access = "authorityInfoAccess";
    public static final String LN_info_access = "Authority Information Access";
    public static final String OBJ_info_access = "1.3.6.1.5.5.7.1.1";
    public static final int NID_ad_ca_issuers = 179;
    public static final String SN_ad_ca_issuers = "caIssuers";
    public static final String LN_ad_ca_issuers = "CA Issuers";
    public static final String OBJ_ad_ca_issuers = "1.3.6.1.5.5.7.48.2";
    public static final int NID_OCSP_sign = 180;
    public static final String SN_OCSP_sign = "OCSPSigning";
    public static final String LN_OCSP_sign = "OCSP Signing";
    public static final String OBJ_OCSP_sign = "1.3.6.1.5.5.7.3.9";
    public static final int NID_SMIME = 188;
    public static final String SN_SMIME = "SMIME";
    public static final String LN_SMIME = "S/MIME";
    public static final String OBJ_SMIME = "1.2.840.113549.1.9.16";
    public static final int NID_id_smime_mod = 189;
    public static final String SN_id_smime_mod = "id-smime-mod";
    public static final String OBJ_id_smime_mod = "1.2.840.113549.1.9.16.0";
    public static final int NID_id_smime_ct = 190;
    public static final String SN_id_smime_ct = "id-smime-ct";
    public static final String OBJ_id_smime_ct = "1.2.840.113549.1.9.16.1";
    public static final int NID_id_smime_aa = 191;
    public static final String SN_id_smime_aa = "id-smime-aa";
    public static final String OBJ_id_smime_aa = "1.2.840.113549.1.9.16.2";
    public static final int NID_id_smime_alg = 192;
    public static final String SN_id_smime_alg = "id-smime-alg";
    public static final String OBJ_id_smime_alg = "1.2.840.113549.1.9.16.3";
    public static final int NID_id_smime_cd = 193;
    public static final String SN_id_smime_cd = "id-smime-cd";
    public static final String OBJ_id_smime_cd = "1.2.840.113549.1.9.16.4";
    public static final int NID_id_smime_spq = 194;
    public static final String SN_id_smime_spq = "id-smime-spq";
    public static final String OBJ_id_smime_spq = "1.2.840.113549.1.9.16.5";
    public static final int NID_id_smime_cti = 195;
    public static final String SN_id_smime_cti = "id-smime-cti";
    public static final String OBJ_id_smime_cti = "1.2.840.113549.1.9.16.6";
    public static final int NID_id_smime_mod_cms = 196;
    public static final String SN_id_smime_mod_cms = "id-smime-mod-cms";
    public static final String OBJ_id_smime_mod_cms = "1.2.840.113549.1.9.16.0.1";
    public static final int NID_id_smime_mod_ess = 197;
    public static final String SN_id_smime_mod_ess = "id-smime-mod-ess";
    public static final String OBJ_id_smime_mod_ess = "1.2.840.113549.1.9.16.0.2";
    public static final int NID_id_smime_mod_oid = 198;
    public static final String SN_id_smime_mod_oid = "id-smime-mod-oid";
    public static final String OBJ_id_smime_mod_oid = "1.2.840.113549.1.9.16.0.3";
    public static final int NID_id_smime_mod_msg_v3 = 199;
    public static final String SN_id_smime_mod_msg_v3 = "id-smime-mod-msg-v3";
    public static final String OBJ_id_smime_mod_msg_v3 = "1.2.840.113549.1.9.16.0.4";
    public static final int NID_id_smime_mod_ets_eSignature_88 = 200;
    public static final String SN_id_smime_mod_ets_eSignature_88 = "id-smime-mod-ets-eSignature-88";
    public static final String OBJ_id_smime_mod_ets_eSignature_88 = "1.2.840.113549.1.9.16.0.5";
    public static final int NID_id_smime_mod_ets_eSignature_97 = 201;
    public static final String SN_id_smime_mod_ets_eSignature_97 = "id-smime-mod-ets-eSignature-97";
    public static final String OBJ_id_smime_mod_ets_eSignature_97 = "1.2.840.113549.1.9.16.0.6";
    public static final int NID_id_smime_mod_ets_eSigPolicy_88 = 202;
    public static final String SN_id_smime_mod_ets_eSigPolicy_88 = "id-smime-mod-ets-eSigPolicy-88";
    public static final String OBJ_id_smime_mod_ets_eSigPolicy_88 = "1.2.840.113549.1.9.16.0.7";
    public static final int NID_id_smime_mod_ets_eSigPolicy_97 = 203;
    public static final String SN_id_smime_mod_ets_eSigPolicy_97 = "id-smime-mod-ets-eSigPolicy-97";
    public static final String OBJ_id_smime_mod_ets_eSigPolicy_97 = "1.2.840.113549.1.9.16.0.8";
    public static final int NID_id_smime_ct_receipt = 204;
    public static final String SN_id_smime_ct_receipt = "id-smime-ct-receipt";
    public static final String OBJ_id_smime_ct_receipt = "1.2.840.113549.1.9.16.1.1";
    public static final int NID_id_smime_ct_authData = 205;
    public static final String SN_id_smime_ct_authData = "id-smime-ct-authData";
    public static final String OBJ_id_smime_ct_authData = "1.2.840.113549.1.9.16.1.2";
    public static final int NID_id_smime_ct_publishCert = 206;
    public static final String SN_id_smime_ct_publishCert = "id-smime-ct-publishCert";
    public static final String OBJ_id_smime_ct_publishCert = "1.2.840.113549.1.9.16.1.3";
    public static final int NID_id_smime_ct_TSTInfo = 207;
    public static final String SN_id_smime_ct_TSTInfo = "id-smime-ct-TSTInfo";
    public static final String OBJ_id_smime_ct_TSTInfo = "1.2.840.113549.1.9.16.1.4";
    public static final int NID_id_smime_ct_TDTInfo = 208;
    public static final String SN_id_smime_ct_TDTInfo = "id-smime-ct-TDTInfo";
    public static final String OBJ_id_smime_ct_TDTInfo = "1.2.840.113549.1.9.16.1.5";
    public static final int NID_id_smime_ct_contentInfo = 209;
    public static final String SN_id_smime_ct_contentInfo = "id-smime-ct-contentInfo";
    public static final String OBJ_id_smime_ct_contentInfo = "1.2.840.113549.1.9.16.1.6";
    public static final int NID_id_smime_ct_DVCSRequestData = 210;
    public static final String SN_id_smime_ct_DVCSRequestData = "id-smime-ct-DVCSRequestData";
    public static final String OBJ_id_smime_ct_DVCSRequestData = "1.2.840.113549.1.9.16.1.7";
    public static final int NID_id_smime_ct_DVCSResponseData = 211;
    public static final String SN_id_smime_ct_DVCSResponseData = "id-smime-ct-DVCSResponseData";
    public static final String OBJ_id_smime_ct_DVCSResponseData = "1.2.840.113549.1.9.16.1.8";
    public static final int NID_id_smime_ct_compressedData = 786;
    public static final String SN_id_smime_ct_compressedData = "id-smime-ct-compressedData";
    public static final String OBJ_id_smime_ct_compressedData = "1.2.840.113549.1.9.16.1.9";
    public static final int NID_id_smime_aa_receiptRequest = 212;
    public static final String SN_id_smime_aa_receiptRequest = "id-smime-aa-receiptRequest";
    public static final String OBJ_id_smime_aa_receiptRequest = "1.2.840.113549.1.9.16.2.1";
    public static final int NID_id_smime_aa_securityLabel = 213;
    public static final String SN_id_smime_aa_securityLabel = "id-smime-aa-securityLabel";
    public static final String OBJ_id_smime_aa_securityLabel = "1.2.840.113549.1.9.16.2.2";
    public static final int NID_id_smime_aa_mlExpandHistory = 214;
    public static final String SN_id_smime_aa_mlExpandHistory = "id-smime-aa-mlExpandHistory";
    public static final String OBJ_id_smime_aa_mlExpandHistory = "1.2.840.113549.1.9.16.2.3";
    public static final int NID_id_smime_aa_contentHint = 215;
    public static final String SN_id_smime_aa_contentHint = "id-smime-aa-contentHint";
    public static final String OBJ_id_smime_aa_contentHint = "1.2.840.113549.1.9.16.2.4";
    public static final int NID_id_smime_aa_msgSigDigest = 216;
    public static final String SN_id_smime_aa_msgSigDigest = "id-smime-aa-msgSigDigest";
    public static final String OBJ_id_smime_aa_msgSigDigest = "1.2.840.113549.1.9.16.2.5";
    public static final int NID_id_smime_aa_encapContentType = 217;
    public static final String SN_id_smime_aa_encapContentType = "id-smime-aa-encapContentType";
    public static final String OBJ_id_smime_aa_encapContentType = "1.2.840.113549.1.9.16.2.6";
    public static final int NID_id_smime_aa_contentIdentifier = 218;
    public static final String SN_id_smime_aa_contentIdentifier = "id-smime-aa-contentIdentifier";
    public static final String OBJ_id_smime_aa_contentIdentifier = "1.2.840.113549.1.9.16.2.7";
    public static final int NID_id_smime_aa_macValue = 219;
    public static final String SN_id_smime_aa_macValue = "id-smime-aa-macValue";
    public static final String OBJ_id_smime_aa_macValue = "1.2.840.113549.1.9.16.2.8";
    public static final int NID_id_smime_aa_equivalentLabels = 220;
    public static final String SN_id_smime_aa_equivalentLabels = "id-smime-aa-equivalentLabels";
    public static final String OBJ_id_smime_aa_equivalentLabels = "1.2.840.113549.1.9.16.2.9";
    public static final int NID_id_smime_aa_contentReference = 221;
    public static final String SN_id_smime_aa_contentReference = "id-smime-aa-contentReference";
    public static final String OBJ_id_smime_aa_contentReference = "1.2.840.113549.1.9.16.2.10";
    public static final int NID_id_smime_aa_encrypKeyPref = 222;
    public static final String SN_id_smime_aa_encrypKeyPref = "id-smime-aa-encrypKeyPref";
    public static final String OBJ_id_smime_aa_encrypKeyPref = "1.2.840.113549.1.9.16.2.11";
    public static final int NID_id_smime_aa_signingCertificate = 223;
    public static final String SN_id_smime_aa_signingCertificate = "id-smime-aa-signingCertificate";
    public static final String OBJ_id_smime_aa_signingCertificate = "1.2.840.113549.1.9.16.2.12";
    public static final int NID_id_smime_aa_smimeEncryptCerts = 224;
    public static final String SN_id_smime_aa_smimeEncryptCerts = "id-smime-aa-smimeEncryptCerts";
    public static final String OBJ_id_smime_aa_smimeEncryptCerts = "1.2.840.113549.1.9.16.2.13";
    public static final int NID_id_smime_aa_timeStampToken = 225;
    public static final String SN_id_smime_aa_timeStampToken = "id-smime-aa-timeStampToken";
    public static final String OBJ_id_smime_aa_timeStampToken = "1.2.840.113549.1.9.16.2.14";
    public static final int NID_id_smime_aa_ets_sigPolicyId = 226;
    public static final String SN_id_smime_aa_ets_sigPolicyId = "id-smime-aa-ets-sigPolicyId";
    public static final String OBJ_id_smime_aa_ets_sigPolicyId = "1.2.840.113549.1.9.16.2.15";
    public static final int NID_id_smime_aa_ets_commitmentType = 227;
    public static final String SN_id_smime_aa_ets_commitmentType = "id-smime-aa-ets-commitmentType";
    public static final String OBJ_id_smime_aa_ets_commitmentType = "1.2.840.113549.1.9.16.2.16";
    public static final int NID_id_smime_aa_ets_signerLocation = 228;
    public static final String SN_id_smime_aa_ets_signerLocation = "id-smime-aa-ets-signerLocation";
    public static final String OBJ_id_smime_aa_ets_signerLocation = "1.2.840.113549.1.9.16.2.17";
    public static final int NID_id_smime_aa_ets_signerAttr = 229;
    public static final String SN_id_smime_aa_ets_signerAttr = "id-smime-aa-ets-signerAttr";
    public static final String OBJ_id_smime_aa_ets_signerAttr = "1.2.840.113549.1.9.16.2.18";
    public static final int NID_id_smime_aa_ets_otherSigCert = 230;
    public static final String SN_id_smime_aa_ets_otherSigCert = "id-smime-aa-ets-otherSigCert";
    public static final String OBJ_id_smime_aa_ets_otherSigCert = "1.2.840.113549.1.9.16.2.19";
    public static final int NID_id_smime_aa_ets_contentTimestamp = 231;
    public static final String SN_id_smime_aa_ets_contentTimestamp = "id-smime-aa-ets-contentTimestamp";
    public static final String OBJ_id_smime_aa_ets_contentTimestamp = "1.2.840.113549.1.9.16.2.20";
    public static final int NID_id_smime_aa_ets_CertificateRefs = 232;
    public static final String SN_id_smime_aa_ets_CertificateRefs = "id-smime-aa-ets-CertificateRefs";
    public static final String OBJ_id_smime_aa_ets_CertificateRefs = "1.2.840.113549.1.9.16.2.21";
    public static final int NID_id_smime_aa_ets_RevocationRefs = 233;
    public static final String SN_id_smime_aa_ets_RevocationRefs = "id-smime-aa-ets-RevocationRefs";
    public static final String OBJ_id_smime_aa_ets_RevocationRefs = "1.2.840.113549.1.9.16.2.22";
    public static final int NID_id_smime_aa_ets_certValues = 234;
    public static final String SN_id_smime_aa_ets_certValues = "id-smime-aa-ets-certValues";
    public static final String OBJ_id_smime_aa_ets_certValues = "1.2.840.113549.1.9.16.2.23";
    public static final int NID_id_smime_aa_ets_revocationValues = 235;
    public static final String SN_id_smime_aa_ets_revocationValues = "id-smime-aa-ets-revocationValues";
    public static final String OBJ_id_smime_aa_ets_revocationValues = "1.2.840.113549.1.9.16.2.24";
    public static final int NID_id_smime_aa_ets_escTimeStamp = 236;
    public static final String SN_id_smime_aa_ets_escTimeStamp = "id-smime-aa-ets-escTimeStamp";
    public static final String OBJ_id_smime_aa_ets_escTimeStamp = "1.2.840.113549.1.9.16.2.25";
    public static final int NID_id_smime_aa_ets_certCRLTimestamp = 237;
    public static final String SN_id_smime_aa_ets_certCRLTimestamp = "id-smime-aa-ets-certCRLTimestamp";
    public static final String OBJ_id_smime_aa_ets_certCRLTimestamp = "1.2.840.113549.1.9.16.2.26";
    public static final int NID_id_smime_aa_ets_archiveTimeStamp = 238;
    public static final String SN_id_smime_aa_ets_archiveTimeStamp = "id-smime-aa-ets-archiveTimeStamp";
    public static final String OBJ_id_smime_aa_ets_archiveTimeStamp = "1.2.840.113549.1.9.16.2.27";
    public static final int NID_id_smime_aa_signatureType = 239;
    public static final String SN_id_smime_aa_signatureType = "id-smime-aa-signatureType";
    public static final String OBJ_id_smime_aa_signatureType = "1.2.840.113549.1.9.16.2.28";
    public static final int NID_id_smime_aa_dvcs_dvc = 240;
    public static final String SN_id_smime_aa_dvcs_dvc = "id-smime-aa-dvcs-dvc";
    public static final String OBJ_id_smime_aa_dvcs_dvc = "1.2.840.113549.1.9.16.2.29";
    public static final int NID_id_smime_alg_ESDHwith3DES = 241;
    public static final String SN_id_smime_alg_ESDHwith3DES = "id-smime-alg-ESDHwith3DES";
    public static final String OBJ_id_smime_alg_ESDHwith3DES = "1.2.840.113549.1.9.16.3.1";
    public static final int NID_id_smime_alg_ESDHwithRC2 = 242;
    public static final String SN_id_smime_alg_ESDHwithRC2 = "id-smime-alg-ESDHwithRC2";
    public static final String OBJ_id_smime_alg_ESDHwithRC2 = "1.2.840.113549.1.9.16.3.2";
    public static final int NID_id_smime_alg_3DESwrap = 243;
    public static final String SN_id_smime_alg_3DESwrap = "id-smime-alg-3DESwrap";
    public static final String OBJ_id_smime_alg_3DESwrap = "1.2.840.113549.1.9.16.3.3";
    public static final int NID_id_smime_alg_RC2wrap = 244;
    public static final String SN_id_smime_alg_RC2wrap = "id-smime-alg-RC2wrap";
    public static final String OBJ_id_smime_alg_RC2wrap = "1.2.840.113549.1.9.16.3.4";
    public static final int NID_id_smime_alg_ESDH = 245;
    public static final String SN_id_smime_alg_ESDH = "id-smime-alg-ESDH";
    public static final String OBJ_id_smime_alg_ESDH = "1.2.840.113549.1.9.16.3.5";
    public static final int NID_id_smime_alg_CMS3DESwrap = 246;
    public static final String SN_id_smime_alg_CMS3DESwrap = "id-smime-alg-CMS3DESwrap";
    public static final String OBJ_id_smime_alg_CMS3DESwrap = "1.2.840.113549.1.9.16.3.6";
    public static final int NID_id_smime_alg_CMSRC2wrap = 247;
    public static final String SN_id_smime_alg_CMSRC2wrap = "id-smime-alg-CMSRC2wrap";
    public static final String OBJ_id_smime_alg_CMSRC2wrap = "1.2.840.113549.1.9.16.3.7";
    public static final int NID_id_smime_cd_ldap = 248;
    public static final String SN_id_smime_cd_ldap = "id-smime-cd-ldap";
    public static final String OBJ_id_smime_cd_ldap = "1.2.840.113549.1.9.16.4.1";
    public static final int NID_id_smime_spq_ets_sqt_uri = 249;
    public static final String SN_id_smime_spq_ets_sqt_uri = "id-smime-spq-ets-sqt-uri";
    public static final String OBJ_id_smime_spq_ets_sqt_uri = "1.2.840.113549.1.9.16.5.1";
    public static final int NID_id_smime_spq_ets_sqt_unotice = 250;
    public static final String SN_id_smime_spq_ets_sqt_unotice = "id-smime-spq-ets-sqt-unotice";
    public static final String OBJ_id_smime_spq_ets_sqt_unotice = "1.2.840.113549.1.9.16.5.2";
    public static final int NID_id_smime_cti_ets_proofOfOrigin = 251;
    public static final String SN_id_smime_cti_ets_proofOfOrigin = "id-smime-cti-ets-proofOfOrigin";
    public static final String OBJ_id_smime_cti_ets_proofOfOrigin = "1.2.840.113549.1.9.16.6.1";
    public static final int NID_id_smime_cti_ets_proofOfReceipt = 252;
    public static final String SN_id_smime_cti_ets_proofOfReceipt = "id-smime-cti-ets-proofOfReceipt";
    public static final String OBJ_id_smime_cti_ets_proofOfReceipt = "1.2.840.113549.1.9.16.6.2";
    public static final int NID_id_smime_cti_ets_proofOfDelivery = 253;
    public static final String SN_id_smime_cti_ets_proofOfDelivery = "id-smime-cti-ets-proofOfDelivery";
    public static final String OBJ_id_smime_cti_ets_proofOfDelivery = "1.2.840.113549.1.9.16.6.3";
    public static final int NID_id_smime_cti_ets_proofOfSender = 254;
    public static final String SN_id_smime_cti_ets_proofOfSender = "id-smime-cti-ets-proofOfSender";
    public static final String OBJ_id_smime_cti_ets_proofOfSender = "1.2.840.113549.1.9.16.6.4";
    public static final int NID_id_smime_cti_ets_proofOfApproval = 255;
    public static final String SN_id_smime_cti_ets_proofOfApproval = "id-smime-cti-ets-proofOfApproval";
    public static final String OBJ_id_smime_cti_ets_proofOfApproval = "1.2.840.113549.1.9.16.6.5";
    public static final int NID_id_smime_cti_ets_proofOfCreation = 256;
    public static final String SN_id_smime_cti_ets_proofOfCreation = "id-smime-cti-ets-proofOfCreation";
    public static final String OBJ_id_smime_cti_ets_proofOfCreation = "1.2.840.113549.1.9.16.6.6";
    public static final int NID_md4 = 257;
    public static final String SN_md4 = "MD4";
    public static final String LN_md4 = "md4";
    public static final String OBJ_md4 = "1.2.840.113549.2.4";
    public static final int NID_id_pkix_mod = 258;
    public static final String SN_id_pkix_mod = "id-pkix-mod";
    public static final String OBJ_id_pkix_mod = "1.3.6.1.5.5.7.0";
    public static final int NID_id_it = 260;
    public static final String SN_id_it = "id-it";
    public static final String OBJ_id_it = "1.3.6.1.5.5.7.4";
    public static final int NID_id_pkip = 261;
    public static final String SN_id_pkip = "id-pkip";
    public static final String OBJ_id_pkip = "1.3.6.1.5.5.7.5";
    public static final int NID_id_alg = 262;
    public static final String SN_id_alg = "id-alg";
    public static final String OBJ_id_alg = "1.3.6.1.5.5.7.6";
    public static final int NID_id_cmc = 263;
    public static final String SN_id_cmc = "id-cmc";
    public static final String OBJ_id_cmc = "1.3.6.1.5.5.7.7";
    public static final int NID_id_on = 264;
    public static final String SN_id_on = "id-on";
    public static final String OBJ_id_on = "1.3.6.1.5.5.7.8";
    public static final int NID_id_pda = 265;
    public static final String SN_id_pda = "id-pda";
    public static final String OBJ_id_pda = "1.3.6.1.5.5.7.9";
    public static final int NID_id_aca = 266;
    public static final String SN_id_aca = "id-aca";
    public static final String OBJ_id_aca = "1.3.6.1.5.5.7.10";
    public static final int NID_id_qcs = 267;
    public static final String SN_id_qcs = "id-qcs";
    public static final String OBJ_id_qcs = "1.3.6.1.5.5.7.11";
    public static final int NID_id_cct = 268;
    public static final String SN_id_cct = "id-cct";
    public static final String OBJ_id_cct = "1.3.6.1.5.5.7.12";
    public static final int NID_id_pkix1_explicit_88 = 269;
    public static final String SN_id_pkix1_explicit_88 = "id-pkix1-explicit-88";
    public static final String OBJ_id_pkix1_explicit_88 = "1.3.6.1.5.5.7.0.1";
    public static final int NID_id_pkix1_implicit_88 = 270;
    public static final String SN_id_pkix1_implicit_88 = "id-pkix1-implicit-88";
    public static final String OBJ_id_pkix1_implicit_88 = "1.3.6.1.5.5.7.0.2";
    public static final int NID_id_pkix1_explicit_93 = 271;
    public static final String SN_id_pkix1_explicit_93 = "id-pkix1-explicit-93";
    public static final String OBJ_id_pkix1_explicit_93 = "1.3.6.1.5.5.7.0.3";
    public static final int NID_id_pkix1_implicit_93 = 272;
    public static final String SN_id_pkix1_implicit_93 = "id-pkix1-implicit-93";
    public static final String OBJ_id_pkix1_implicit_93 = "1.3.6.1.5.5.7.0.4";
    public static final int NID_id_mod_crmf = 273;
    public static final String SN_id_mod_crmf = "id-mod-crmf";
    public static final String OBJ_id_mod_crmf = "1.3.6.1.5.5.7.0.5";
    public static final int NID_id_mod_cmc = 274;
    public static final String SN_id_mod_cmc = "id-mod-cmc";
    public static final String OBJ_id_mod_cmc = "1.3.6.1.5.5.7.0.6";
    public static final int NID_id_mod_kea_profile_88 = 275;
    public static final String SN_id_mod_kea_profile_88 = "id-mod-kea-profile-88";
    public static final String OBJ_id_mod_kea_profile_88 = "1.3.6.1.5.5.7.0.7";
    public static final int NID_id_mod_kea_profile_93 = 276;
    public static final String SN_id_mod_kea_profile_93 = "id-mod-kea-profile-93";
    public static final String OBJ_id_mod_kea_profile_93 = "1.3.6.1.5.5.7.0.8";
    public static final int NID_id_mod_cmp = 277;
    public static final String SN_id_mod_cmp = "id-mod-cmp";
    public static final String OBJ_id_mod_cmp = "1.3.6.1.5.5.7.0.9";
    public static final int NID_id_mod_qualified_cert_88 = 278;
    public static final String SN_id_mod_qualified_cert_88 = "id-mod-qualified-cert-88";
    public static final String OBJ_id_mod_qualified_cert_88 = "1.3.6.1.5.5.7.0.10";
    public static final int NID_id_mod_qualified_cert_93 = 279;
    public static final String SN_id_mod_qualified_cert_93 = "id-mod-qualified-cert-93";
    public static final String OBJ_id_mod_qualified_cert_93 = "1.3.6.1.5.5.7.0.11";
    public static final int NID_id_mod_attribute_cert = 280;
    public static final String SN_id_mod_attribute_cert = "id-mod-attribute-cert";
    public static final String OBJ_id_mod_attribute_cert = "1.3.6.1.5.5.7.0.12";
    public static final int NID_id_mod_timestamp_protocol = 281;
    public static final String SN_id_mod_timestamp_protocol = "id-mod-timestamp-protocol";
    public static final String OBJ_id_mod_timestamp_protocol = "1.3.6.1.5.5.7.0.13";
    public static final int NID_id_mod_ocsp = 282;
    public static final String SN_id_mod_ocsp = "id-mod-ocsp";
    public static final String OBJ_id_mod_ocsp = "1.3.6.1.5.5.7.0.14";
    public static final int NID_id_mod_dvcs = 283;
    public static final String SN_id_mod_dvcs = "id-mod-dvcs";
    public static final String OBJ_id_mod_dvcs = "1.3.6.1.5.5.7.0.15";
    public static final int NID_id_mod_cmp2000 = 284;
    public static final String SN_id_mod_cmp2000 = "id-mod-cmp2000";
    public static final String OBJ_id_mod_cmp2000 = "1.3.6.1.5.5.7.0.16";
    public static final int NID_biometricInfo = 285;
    public static final String SN_biometricInfo = "biometricInfo";
    public static final String LN_biometricInfo = "Biometric Info";
    public static final String OBJ_biometricInfo = "1.3.6.1.5.5.7.1.2";
    public static final int NID_qcStatements = 286;
    public static final String SN_qcStatements = "qcStatements";
    public static final String OBJ_qcStatements = "1.3.6.1.5.5.7.1.3";
    public static final int NID_ac_auditEntity = 287;
    public static final String SN_ac_auditEntity = "ac-auditEntity";
    public static final String OBJ_ac_auditEntity = "1.3.6.1.5.5.7.1.4";
    public static final int NID_ac_targeting = 288;
    public static final String SN_ac_targeting = "ac-targeting";
    public static final String OBJ_ac_targeting = "1.3.6.1.5.5.7.1.5";
    public static final int NID_aaControls = 289;
    public static final String SN_aaControls = "aaControls";
    public static final String OBJ_aaControls = "1.3.6.1.5.5.7.1.6";
    public static final int NID_sbgp_ipAddrBlock = 290;
    public static final String SN_sbgp_ipAddrBlock = "sbgp-ipAddrBlock";
    public static final String OBJ_sbgp_ipAddrBlock = "1.3.6.1.5.5.7.1.7";
    public static final int NID_sbgp_autonomousSysNum = 291;
    public static final String SN_sbgp_autonomousSysNum = "sbgp-autonomousSysNum";
    public static final String OBJ_sbgp_autonomousSysNum = "1.3.6.1.5.5.7.1.8";
    public static final int NID_sbgp_routerIdentifier = 292;
    public static final String SN_sbgp_routerIdentifier = "sbgp-routerIdentifier";
    public static final String OBJ_sbgp_routerIdentifier = "1.3.6.1.5.5.7.1.9";
    public static final int NID_textNotice = 293;
    public static final String SN_textNotice = "textNotice";
    public static final String OBJ_textNotice = "1.3.6.1.5.5.7.2.3";
    public static final int NID_ipsecEndSystem = 294;
    public static final String SN_ipsecEndSystem = "ipsecEndSystem";
    public static final String LN_ipsecEndSystem = "IPSec End System";
    public static final String OBJ_ipsecEndSystem = "1.3.6.1.5.5.7.3.5";
    public static final int NID_ipsecTunnel = 295;
    public static final String SN_ipsecTunnel = "ipsecTunnel";
    public static final String LN_ipsecTunnel = "IPSec Tunnel";
    public static final String OBJ_ipsecTunnel = "1.3.6.1.5.5.7.3.6";
    public static final int NID_ipsecUser = 296;
    public static final String SN_ipsecUser = "ipsecUser";
    public static final String LN_ipsecUser = "IPSec User";
    public static final String OBJ_ipsecUser = "1.3.6.1.5.5.7.3.7";
    public static final int NID_dvcs = 297;
    public static final String SN_dvcs = "DVCS";
    public static final String LN_dvcs = "dvcs";
    public static final String OBJ_dvcs = "1.3.6.1.5.5.7.3.10";
    public static final int NID_id_it_caProtEncCert = 298;
    public static final String SN_id_it_caProtEncCert = "id-it-caProtEncCert";
    public static final String OBJ_id_it_caProtEncCert = "1.3.6.1.5.5.7.4.1";
    public static final int NID_id_it_signKeyPairTypes = 299;
    public static final String SN_id_it_signKeyPairTypes = "id-it-signKeyPairTypes";
    public static final String OBJ_id_it_signKeyPairTypes = "1.3.6.1.5.5.7.4.2";
    public static final int NID_id_it_encKeyPairTypes = 300;
    public static final String SN_id_it_encKeyPairTypes = "id-it-encKeyPairTypes";
    public static final String OBJ_id_it_encKeyPairTypes = "1.3.6.1.5.5.7.4.3";
    public static final int NID_id_it_preferredSymmAlg = 301;
    public static final String SN_id_it_preferredSymmAlg = "id-it-preferredSymmAlg";
    public static final String OBJ_id_it_preferredSymmAlg = "1.3.6.1.5.5.7.4.4";
    public static final int NID_id_it_caKeyUpdateInfo = 302;
    public static final String SN_id_it_caKeyUpdateInfo = "id-it-caKeyUpdateInfo";
    public static final String OBJ_id_it_caKeyUpdateInfo = "1.3.6.1.5.5.7.4.5";
    public static final int NID_id_it_currentCRL = 303;
    public static final String SN_id_it_currentCRL = "id-it-currentCRL";
    public static final String OBJ_id_it_currentCRL = "1.3.6.1.5.5.7.4.6";
    public static final int NID_id_it_unsupportedOIDs = 304;
    public static final String SN_id_it_unsupportedOIDs = "id-it-unsupportedOIDs";
    public static final String OBJ_id_it_unsupportedOIDs = "1.3.6.1.5.5.7.4.7";
    public static final int NID_id_it_subscriptionRequest = 305;
    public static final String SN_id_it_subscriptionRequest = "id-it-subscriptionRequest";
    public static final String OBJ_id_it_subscriptionRequest = "1.3.6.1.5.5.7.4.8";
    public static final int NID_id_it_subscriptionResponse = 306;
    public static final String SN_id_it_subscriptionResponse = "id-it-subscriptionResponse";
    public static final String OBJ_id_it_subscriptionResponse = "1.3.6.1.5.5.7.4.9";
    public static final int NID_id_it_keyPairParamReq = 307;
    public static final String SN_id_it_keyPairParamReq = "id-it-keyPairParamReq";
    public static final String OBJ_id_it_keyPairParamReq = "1.3.6.1.5.5.7.4.10";
    public static final int NID_id_it_keyPairParamRep = 308;
    public static final String SN_id_it_keyPairParamRep = "id-it-keyPairParamRep";
    public static final String OBJ_id_it_keyPairParamRep = "1.3.6.1.5.5.7.4.11";
    public static final int NID_id_it_revPassphrase = 309;
    public static final String SN_id_it_revPassphrase = "id-it-revPassphrase";
    public static final String OBJ_id_it_revPassphrase = "1.3.6.1.5.5.7.4.12";
    public static final int NID_id_it_implicitConfirm = 310;
    public static final String SN_id_it_implicitConfirm = "id-it-implicitConfirm";
    public static final String OBJ_id_it_implicitConfirm = "1.3.6.1.5.5.7.4.13";
    public static final int NID_id_it_confirmWaitTime = 311;
    public static final String SN_id_it_confirmWaitTime = "id-it-confirmWaitTime";
    public static final String OBJ_id_it_confirmWaitTime = "1.3.6.1.5.5.7.4.14";
    public static final int NID_id_it_origPKIMessage = 312;
    public static final String SN_id_it_origPKIMessage = "id-it-origPKIMessage";
    public static final String OBJ_id_it_origPKIMessage = "1.3.6.1.5.5.7.4.15";
    public static final int NID_id_regCtrl = 313;
    public static final String SN_id_regCtrl = "id-regCtrl";
    public static final String OBJ_id_regCtrl = "1.3.6.1.5.5.7.5.1";
    public static final int NID_id_regInfo = 314;
    public static final String SN_id_regInfo = "id-regInfo";
    public static final String OBJ_id_regInfo = "1.3.6.1.5.5.7.5.2";
    public static final int NID_id_regCtrl_regToken = 315;
    public static final String SN_id_regCtrl_regToken = "id-regCtrl-regToken";
    public static final String OBJ_id_regCtrl_regToken = "1.3.6.1.5.5.7.5.1.1";
    public static final int NID_id_regCtrl_authenticator = 316;
    public static final String SN_id_regCtrl_authenticator = "id-regCtrl-authenticator";
    public static final String OBJ_id_regCtrl_authenticator = "1.3.6.1.5.5.7.5.1.2";
    public static final int NID_id_regCtrl_pkiPublicationInfo = 317;
    public static final String SN_id_regCtrl_pkiPublicationInfo = "id-regCtrl-pkiPublicationInfo";
    public static final String OBJ_id_regCtrl_pkiPublicationInfo = "1.3.6.1.5.5.7.5.1.3";
    public static final int NID_id_regCtrl_pkiArchiveOptions = 318;
    public static final String SN_id_regCtrl_pkiArchiveOptions = "id-regCtrl-pkiArchiveOptions";
    public static final String OBJ_id_regCtrl_pkiArchiveOptions = "1.3.6.1.5.5.7.5.1.4";
    public static final int NID_id_regCtrl_oldCertID = 319;
    public static final String SN_id_regCtrl_oldCertID = "id-regCtrl-oldCertID";
    public static final String OBJ_id_regCtrl_oldCertID = "1.3.6.1.5.5.7.5.1.5";
    public static final int NID_id_regCtrl_protocolEncrKey = 320;
    public static final String SN_id_regCtrl_protocolEncrKey = "id-regCtrl-protocolEncrKey";
    public static final String OBJ_id_regCtrl_protocolEncrKey = "1.3.6.1.5.5.7.5.1.6";
    public static final int NID_id_regInfo_utf8Pairs = 321;
    public static final String SN_id_regInfo_utf8Pairs = "id-regInfo-utf8Pairs";
    public static final String OBJ_id_regInfo_utf8Pairs = "1.3.6.1.5.5.7.5.2.1";
    public static final int NID_id_regInfo_certReq = 322;
    public static final String SN_id_regInfo_certReq = "id-regInfo-certReq";
    public static final String OBJ_id_regInfo_certReq = "1.3.6.1.5.5.7.5.2.2";
    public static final int NID_id_alg_des40 = 323;
    public static final String SN_id_alg_des40 = "id-alg-des40";
    public static final String OBJ_id_alg_des40 = "1.3.6.1.5.5.7.6.1";
    public static final int NID_id_alg_noSignature = 324;
    public static final String SN_id_alg_noSignature = "id-alg-noSignature";
    public static final String OBJ_id_alg_noSignature = "1.3.6.1.5.5.7.6.2";
    public static final int NID_id_alg_dh_sig_hmac_sha1 = 325;
    public static final String SN_id_alg_dh_sig_hmac_sha1 = "id-alg-dh-sig-hmac-sha1";
    public static final String OBJ_id_alg_dh_sig_hmac_sha1 = "1.3.6.1.5.5.7.6.3";
    public static final int NID_id_alg_dh_pop = 326;
    public static final String SN_id_alg_dh_pop = "id-alg-dh-pop";
    public static final String OBJ_id_alg_dh_pop = "1.3.6.1.5.5.7.6.4";
    public static final int NID_id_cmc_statusInfo = 327;
    public static final String SN_id_cmc_statusInfo = "id-cmc-statusInfo";
    public static final String OBJ_id_cmc_statusInfo = "1.3.6.1.5.5.7.7.1";
    public static final int NID_id_cmc_identification = 328;
    public static final String SN_id_cmc_identification = "id-cmc-identification";
    public static final String OBJ_id_cmc_identification = "1.3.6.1.5.5.7.7.2";
    public static final int NID_id_cmc_identityProof = 329;
    public static final String SN_id_cmc_identityProof = "id-cmc-identityProof";
    public static final String OBJ_id_cmc_identityProof = "1.3.6.1.5.5.7.7.3";
    public static final int NID_id_cmc_dataReturn = 330;
    public static final String SN_id_cmc_dataReturn = "id-cmc-dataReturn";
    public static final String OBJ_id_cmc_dataReturn = "1.3.6.1.5.5.7.7.4";
    public static final int NID_id_cmc_transactionId = 331;
    public static final String SN_id_cmc_transactionId = "id-cmc-transactionId";
    public static final String OBJ_id_cmc_transactionId = "1.3.6.1.5.5.7.7.5";
    public static final int NID_id_cmc_senderNonce = 332;
    public static final String SN_id_cmc_senderNonce = "id-cmc-senderNonce";
    public static final String OBJ_id_cmc_senderNonce = "1.3.6.1.5.5.7.7.6";
    public static final int NID_id_cmc_recipientNonce = 333;
    public static final String SN_id_cmc_recipientNonce = "id-cmc-recipientNonce";
    public static final String OBJ_id_cmc_recipientNonce = "1.3.6.1.5.5.7.7.7";
    public static final int NID_id_cmc_addExtensions = 334;
    public static final String SN_id_cmc_addExtensions = "id-cmc-addExtensions";
    public static final String OBJ_id_cmc_addExtensions = "1.3.6.1.5.5.7.7.8";
    public static final int NID_id_cmc_encryptedPOP = 335;
    public static final String SN_id_cmc_encryptedPOP = "id-cmc-encryptedPOP";
    public static final String OBJ_id_cmc_encryptedPOP = "1.3.6.1.5.5.7.7.9";
    public static final int NID_id_cmc_decryptedPOP = 336;
    public static final String SN_id_cmc_decryptedPOP = "id-cmc-decryptedPOP";
    public static final String OBJ_id_cmc_decryptedPOP = "1.3.6.1.5.5.7.7.10";
    public static final int NID_id_cmc_lraPOPWitness = 337;
    public static final String SN_id_cmc_lraPOPWitness = "id-cmc-lraPOPWitness";
    public static final String OBJ_id_cmc_lraPOPWitness = "1.3.6.1.5.5.7.7.11";
    public static final int NID_id_cmc_getCert = 338;
    public static final String SN_id_cmc_getCert = "id-cmc-getCert";
    public static final String OBJ_id_cmc_getCert = "1.3.6.1.5.5.7.7.15";
    public static final int NID_id_cmc_getCRL = 339;
    public static final String SN_id_cmc_getCRL = "id-cmc-getCRL";
    public static final String OBJ_id_cmc_getCRL = "1.3.6.1.5.5.7.7.16";
    public static final int NID_id_cmc_revokeRequest = 340;
    public static final String SN_id_cmc_revokeRequest = "id-cmc-revokeRequest";
    public static final String OBJ_id_cmc_revokeRequest = "1.3.6.1.5.5.7.7.17";
    public static final int NID_id_cmc_regInfo = 341;
    public static final String SN_id_cmc_regInfo = "id-cmc-regInfo";
    public static final String OBJ_id_cmc_regInfo = "1.3.6.1.5.5.7.7.18";
    public static final int NID_id_cmc_responseInfo = 342;
    public static final String SN_id_cmc_responseInfo = "id-cmc-responseInfo";
    public static final String OBJ_id_cmc_responseInfo = "1.3.6.1.5.5.7.7.19";
    public static final int NID_id_cmc_queryPending = 343;
    public static final String SN_id_cmc_queryPending = "id-cmc-queryPending";
    public static final String OBJ_id_cmc_queryPending = "1.3.6.1.5.5.7.7.21";
    public static final int NID_id_cmc_popLinkRandom = 344;
    public static final String SN_id_cmc_popLinkRandom = "id-cmc-popLinkRandom";
    public static final String OBJ_id_cmc_popLinkRandom = "1.3.6.1.5.5.7.7.22";
    public static final int NID_id_cmc_popLinkWitness = 345;
    public static final String SN_id_cmc_popLinkWitness = "id-cmc-popLinkWitness";
    public static final String OBJ_id_cmc_popLinkWitness = "1.3.6.1.5.5.7.7.23";
    public static final int NID_id_cmc_confirmCertAcceptance = 346;
    public static final String SN_id_cmc_confirmCertAcceptance = "id-cmc-confirmCertAcceptance";
    public static final String OBJ_id_cmc_confirmCertAcceptance = "1.3.6.1.5.5.7.7.24";
    public static final int NID_id_on_personalData = 347;
    public static final String SN_id_on_personalData = "id-on-personalData";
    public static final String OBJ_id_on_personalData = "1.3.6.1.5.5.7.8.1";
    public static final int NID_id_pda_dateOfBirth = 348;
    public static final String SN_id_pda_dateOfBirth = "id-pda-dateOfBirth";
    public static final String OBJ_id_pda_dateOfBirth = "1.3.6.1.5.5.7.9.1";
    public static final int NID_id_pda_placeOfBirth = 349;
    public static final String SN_id_pda_placeOfBirth = "id-pda-placeOfBirth";
    public static final String OBJ_id_pda_placeOfBirth = "1.3.6.1.5.5.7.9.2";
    public static final int NID_id_pda_gender = 351;
    public static final String SN_id_pda_gender = "id-pda-gender";
    public static final String OBJ_id_pda_gender = "1.3.6.1.5.5.7.9.3";
    public static final int NID_id_pda_countryOfCitizenship = 352;
    public static final String SN_id_pda_countryOfCitizenship = "id-pda-countryOfCitizenship";
    public static final String OBJ_id_pda_countryOfCitizenship = "1.3.6.1.5.5.7.9.4";
    public static final int NID_id_pda_countryOfResidence = 353;
    public static final String SN_id_pda_countryOfResidence = "id-pda-countryOfResidence";
    public static final String OBJ_id_pda_countryOfResidence = "1.3.6.1.5.5.7.9.5";
    public static final int NID_id_aca_authenticationInfo = 354;
    public static final String SN_id_aca_authenticationInfo = "id-aca-authenticationInfo";
    public static final String OBJ_id_aca_authenticationInfo = "1.3.6.1.5.5.7.10.1";
    public static final int NID_id_aca_accessIdentity = 355;
    public static final String SN_id_aca_accessIdentity = "id-aca-accessIdentity";
    public static final String OBJ_id_aca_accessIdentity = "1.3.6.1.5.5.7.10.2";
    public static final int NID_id_aca_chargingIdentity = 356;
    public static final String SN_id_aca_chargingIdentity = "id-aca-chargingIdentity";
    public static final String OBJ_id_aca_chargingIdentity = "1.3.6.1.5.5.7.10.3";
    public static final int NID_id_aca_group = 357;
    public static final String SN_id_aca_group = "id-aca-group";
    public static final String OBJ_id_aca_group = "1.3.6.1.5.5.7.10.4";
    public static final int NID_id_aca_role = 358;
    public static final String SN_id_aca_role = "id-aca-role";
    public static final String OBJ_id_aca_role = "1.3.6.1.5.5.7.10.5";
    public static final int NID_id_qcs_pkixQCSyntax_v1 = 359;
    public static final String SN_id_qcs_pkixQCSyntax_v1 = "id-qcs-pkixQCSyntax-v1";
    public static final String OBJ_id_qcs_pkixQCSyntax_v1 = "1.3.6.1.5.5.7.11.1";
    public static final int NID_id_cct_crs = 360;
    public static final String SN_id_cct_crs = "id-cct-crs";
    public static final String OBJ_id_cct_crs = "1.3.6.1.5.5.7.12.1";
    public static final int NID_id_cct_PKIData = 361;
    public static final String SN_id_cct_PKIData = "id-cct-PKIData";
    public static final String OBJ_id_cct_PKIData = "1.3.6.1.5.5.7.12.2";
    public static final int NID_id_cct_PKIResponse = 362;
    public static final String SN_id_cct_PKIResponse = "id-cct-PKIResponse";
    public static final String OBJ_id_cct_PKIResponse = "1.3.6.1.5.5.7.12.3";
    public static final int NID_ad_timeStamping = 363;
    public static final String SN_ad_timeStamping = "ad_timestamping";
    public static final String LN_ad_timeStamping = "AD Time Stamping";
    public static final String OBJ_ad_timeStamping = "1.3.6.1.5.5.7.48.3";
    public static final int NID_ad_dvcs = 364;
    public static final String SN_ad_dvcs = "AD_DVCS";
    public static final String LN_ad_dvcs = "ad dvcs";
    public static final String OBJ_ad_dvcs = "1.3.6.1.5.5.7.48.4";
    public static final int NID_id_pkix_OCSP_basic = 365;
    public static final String SN_id_pkix_OCSP_basic = "basicOCSPResponse";
    public static final String LN_id_pkix_OCSP_basic = "Basic OCSP Response";
    public static final String OBJ_id_pkix_OCSP_basic = "1.3.6.1.5.5.7.48.1.1";
    public static final int NID_id_pkix_OCSP_Nonce = 366;
    public static final String SN_id_pkix_OCSP_Nonce = "Nonce";
    public static final String LN_id_pkix_OCSP_Nonce = "OCSP Nonce";
    public static final String OBJ_id_pkix_OCSP_Nonce = "1.3.6.1.5.5.7.48.1.2";
    public static final int NID_id_pkix_OCSP_CrlID = 367;
    public static final String SN_id_pkix_OCSP_CrlID = "CrlID";
    public static final String LN_id_pkix_OCSP_CrlID = "OCSP CRL ID";
    public static final String OBJ_id_pkix_OCSP_CrlID = "1.3.6.1.5.5.7.48.1.3";
    public static final int NID_id_pkix_OCSP_acceptableResponses = 368;
    public static final String SN_id_pkix_OCSP_acceptableResponses = "acceptableResponses";
    public static final String LN_id_pkix_OCSP_acceptableResponses = "Acceptable OCSP Responses";
    public static final String OBJ_id_pkix_OCSP_acceptableResponses = "1.3.6.1.5.5.7.48.1.4";
    public static final int NID_id_pkix_OCSP_noCheck = 369;
    public static final String SN_id_pkix_OCSP_noCheck = "noCheck";
    public static final String LN_id_pkix_OCSP_noCheck = "OCSP No Check";
    public static final String OBJ_id_pkix_OCSP_noCheck = "1.3.6.1.5.5.7.48.1.5";
    public static final int NID_id_pkix_OCSP_archiveCutoff = 370;
    public static final String SN_id_pkix_OCSP_archiveCutoff = "archiveCutoff";
    public static final String LN_id_pkix_OCSP_archiveCutoff = "OCSP Archive Cutoff";
    public static final String OBJ_id_pkix_OCSP_archiveCutoff = "1.3.6.1.5.5.7.48.1.6";
    public static final int NID_id_pkix_OCSP_serviceLocator = 371;
    public static final String SN_id_pkix_OCSP_serviceLocator = "serviceLocator";
    public static final String LN_id_pkix_OCSP_serviceLocator = "OCSP Service Locator";
    public static final String OBJ_id_pkix_OCSP_serviceLocator = "1.3.6.1.5.5.7.48.1.7";
    public static final int NID_id_pkix_OCSP_extendedStatus = 372;
    public static final String SN_id_pkix_OCSP_extendedStatus = "extendedStatus";
    public static final String LN_id_pkix_OCSP_extendedStatus = "Extended OCSP Status";
    public static final String OBJ_id_pkix_OCSP_extendedStatus = "1.3.6.1.5.5.7.48.1.8";
    public static final int NID_id_pkix_OCSP_valid = 373;
    public static final String SN_id_pkix_OCSP_valid = "valid";
    public static final String OBJ_id_pkix_OCSP_valid = "1.3.6.1.5.5.7.48.1.9";
    public static final int NID_id_pkix_OCSP_path = 374;
    public static final String SN_id_pkix_OCSP_path = "path";
    public static final String OBJ_id_pkix_OCSP_path = "1.3.6.1.5.5.7.48.1.10";
    public static final int NID_id_pkix_OCSP_trustRoot = 375;
    public static final String SN_id_pkix_OCSP_trustRoot = "trustRoot";
    public static final String LN_id_pkix_OCSP_trustRoot = "Trust Root";
    public static final String OBJ_id_pkix_OCSP_trustRoot = "1.3.6.1.5.5.7.48.1.11";
    public static final int NID_rsaSignature = 377;
    public static final String SN_rsaSignature = "rsaSignature";
    public static final String OBJ_rsaSignature = "1.3.14.3.2.11";
    public static final int NID_Directory = 382;
    public static final String SN_Directory = "directory";
    public static final String LN_Directory = "Directory";
    public static final String OBJ_Directory = "1.3.6.1.1";
    public static final int NID_Management = 383;
    public static final String SN_Management = "mgmt";
    public static final String LN_Management = "Management";
    public static final String OBJ_Management = "1.3.6.1.2";
    public static final int NID_Experimental = 384;
    public static final String SN_Experimental = "experimental";
    public static final String LN_Experimental = "Experimental";
    public static final String OBJ_Experimental = "1.3.6.1.3";
    public static final int NID_Private = 385;
    public static final String SN_Private = "private";
    public static final String LN_Private = "Private";
    public static final String OBJ_Private = "1.3.6.1.4";
    public static final int NID_Security = 386;
    public static final String SN_Security = "security";
    public static final String LN_Security = "Security";
    public static final String OBJ_Security = "1.3.6.1.5";
    public static final int NID_SNMPv2 = 387;
    public static final String SN_SNMPv2 = "snmpv2";
    public static final String LN_SNMPv2 = "SNMPv2";
    public static final String OBJ_SNMPv2 = "1.3.6.1.6";
    public static final int NID_Mail = 388;
    public static final String LN_Mail = "Mail";
    public static final String OBJ_Mail = "1.3.6.1.7";
    public static final int NID_Enterprises = 389;
    public static final String SN_Enterprises = "enterprises";
    public static final String LN_Enterprises = "Enterprises";
    public static final String OBJ_Enterprises = "1.3.6.1.4.1";
    public static final int NID_dcObject = 390;
    public static final String SN_dcObject = "dcobject";
    public static final String LN_dcObject = "dcObject";
    public static final String OBJ_dcObject = "1.3.6.1.4.1.1466.344";
    public static final int NID_itu_t = 645;
    public static final String SN_itu_t = "ITU-T";
    public static final String LN_itu_t = "itu-t";
    public static final String OBJ_itu_t = "0";
    public static final int NID_data = 434;
    public static final String SN_data = "data";
    public static final String OBJ_data = "0.9";
    public static final int NID_pss = 435;
    public static final String SN_pss = "pss";
    public static final String OBJ_pss = "0.9.2342";
    public static final int NID_ucl = 436;
    public static final String SN_ucl = "ucl";
    public static final String OBJ_ucl = "0.9.2342.19200300";
    public static final int NID_pilot = 437;
    public static final String SN_pilot = "pilot";
    public static final String OBJ_pilot = "0.9.2342.19200300.100";
    public static final int NID_pilotAttributeType = 438;
    public static final String LN_pilotAttributeType = "pilotAttributeType";
    public static final String OBJ_pilotAttributeType = "0.9.2342.19200300.100.1";
    public static final int NID_domainComponent = 391;
    public static final String SN_domainComponent = "DC";
    public static final String LN_domainComponent = "domainComponent";
    public static final String OBJ_domainComponent = "0.9.2342.19200300.100.1.25";
    public static final int NID_pilotObjectClass = 440;
    public static final String LN_pilotObjectClass = "pilotObjectClass";
    public static final String OBJ_pilotObjectClass = "0.9.2342.19200300.100.4";
    public static final int NID_Domain = 392;
    public static final String SN_Domain = "domain";
    public static final String LN_Domain = "Domain";
    public static final String OBJ_Domain = "0.9.2342.19200300.100.4.13";
    public static final int NID_joint_iso_ccitt = 393;
    private static final String OBJ_joint_iso_ccitt = "OBJ_joint_iso_itu_t";
    public static final int NID_selected_attribute_types = 394;
    public static final String SN_selected_attribute_types = "selected-attribute-types";
    public static final String LN_selected_attribute_types = "Selected Attribute Types";
    public static final String OBJ_selected_attribute_types = "2.5.1.5";
    public static final int NID_clearance = 395;
    public static final String SN_clearance = "clearance";
    public static final String OBJ_clearance = "2.5.1.5.55";
    public static final int NID_md4WithRSAEncryption = 396;
    public static final String SN_md4WithRSAEncryption = "RSA-MD4";
    public static final String LN_md4WithRSAEncryption = "md4WithRSAEncryption";
    public static final String OBJ_md4WithRSAEncryption = "1.2.840.113549.1.1.3";
    public static final int NID_ac_proxying = 397;
    public static final String SN_ac_proxying = "ac-proxying";
    public static final String OBJ_ac_proxying = "1.3.6.1.5.5.7.1.10";
    public static final int NID_sinfo_access = 398;
    public static final String SN_sinfo_access = "subjectInfoAccess";
    public static final String LN_sinfo_access = "Subject Information Access";
    public static final String OBJ_sinfo_access = "1.3.6.1.5.5.7.1.11";
    public static final int NID_id_aca_encAttrs = 399;
    public static final String SN_id_aca_encAttrs = "id-aca-encAttrs";
    public static final String OBJ_id_aca_encAttrs = "1.3.6.1.5.5.7.10.6";
    public static final int NID_role = 400;
    public static final String SN_role = "role";
    public static final String LN_role = "role";
    public static final String OBJ_role = "2.5.4.72";
    public static final int NID_policy_constraints = 401;
    public static final String SN_policy_constraints = "policyConstraints";
    public static final String LN_policy_constraints = "X509v3 Policy Constraints";
    public static final String OBJ_policy_constraints = "2.5.29.36";
    public static final int NID_target_information = 402;
    public static final String SN_target_information = "targetInformation";
    public static final String LN_target_information = "X509v3 AC Targeting";
    public static final String OBJ_target_information = "2.5.29.55";
    public static final int NID_no_rev_avail = 403;
    public static final String SN_no_rev_avail = "noRevAvail";
    public static final String LN_no_rev_avail = "X509v3 No Revocation Available";
    public static final String OBJ_no_rev_avail = "2.5.29.56";
    public static final int NID_ccitt = 404;
    private static final String OBJ_ccitt = "OBJ_itu_t";
    public static final int NID_X9_62_prime_field = 406;
    public static final String SN_X9_62_prime_field = "prime-field";
    public static final String OBJ_X9_62_prime_field = "1.2.840.10045.1.1";
    public static final int NID_X9_62_characteristic_two_field = 407;
    public static final String SN_X9_62_characteristic_two_field = "characteristic-two-field";
    public static final String OBJ_X9_62_characteristic_two_field = "1.2.840.10045.1.2";
    public static final int NID_X9_62_id_ecPublicKey = 408;
    public static final String SN_X9_62_id_ecPublicKey = "id-ecPublicKey";
    public static final String OBJ_X9_62_id_ecPublicKey = "1.2.840.10045.2.1";
    public static final int NID_X9_62_prime192v1 = 409;
    public static final String SN_X9_62_prime192v1 = "prime192v1";
    public static final String OBJ_X9_62_prime192v1 = "1.2.840.10045.3.1.1";
    public static final int NID_X9_62_prime192v2 = 410;
    public static final String SN_X9_62_prime192v2 = "prime192v2";
    public static final String OBJ_X9_62_prime192v2 = "1.2.840.10045.3.1.2";
    public static final int NID_X9_62_prime192v3 = 411;
    public static final String SN_X9_62_prime192v3 = "prime192v3";
    public static final String OBJ_X9_62_prime192v3 = "1.2.840.10045.3.1.3";
    public static final int NID_X9_62_prime239v1 = 412;
    public static final String SN_X9_62_prime239v1 = "prime239v1";
    public static final String OBJ_X9_62_prime239v1 = "1.2.840.10045.3.1.4";
    public static final int NID_X9_62_prime239v2 = 413;
    public static final String SN_X9_62_prime239v2 = "prime239v2";
    public static final String OBJ_X9_62_prime239v2 = "1.2.840.10045.3.1.5";
    public static final int NID_X9_62_prime239v3 = 414;
    public static final String SN_X9_62_prime239v3 = "prime239v3";
    public static final String OBJ_X9_62_prime239v3 = "1.2.840.10045.3.1.6";
    public static final int NID_X9_62_prime256v1 = 415;
    public static final String SN_X9_62_prime256v1 = "prime256v1";
    public static final String OBJ_X9_62_prime256v1 = "1.2.840.10045.3.1.7";
    public static final int NID_ecdsa_with_SHA1 = 416;
    public static final String SN_ecdsa_with_SHA1 = "ecdsa-with-SHA1";
    public static final String OBJ_ecdsa_with_SHA1 = "1.2.840.10045.4.1";
    public static final ASN1ObjectIdentifier OID_ecdsa_with_SHA1 = new ASN1ObjectIdentifier("1.2.840.10045.4.1");
    public static final int NID_ms_csp_name = 417;
    public static final String SN_ms_csp_name = "CSPName";
    public static final String LN_ms_csp_name = "Microsoft CSP Name";
    public static final String OBJ_ms_csp_name = "1.3.6.1.4.1.311.17.1";
    public static final int NID_aes_128_ecb = 418;
    public static final String SN_aes_128_ecb = "AES-128-ECB";
    public static final String LN_aes_128_ecb = "aes-128-ecb";
    public static final String OBJ_aes_128_ecb = "2.16.840.1.101.3.4.1.1";
    public static final int NID_aes_128_cbc = 419;
    public static final String SN_aes_128_cbc = "AES-128-CBC";
    public static final String LN_aes_128_cbc = "aes-128-cbc";
    public static final String OBJ_aes_128_cbc = "2.16.840.1.101.3.4.1.2";
    public static final int NID_aes_128_ofb128 = 420;
    public static final String SN_aes_128_ofb128 = "AES-128-OFB";
    public static final String LN_aes_128_ofb128 = "aes-128-ofb";
    public static final String OBJ_aes_128_ofb128 = "2.16.840.1.101.3.4.1.3";
    public static final int NID_aes_128_cfb128 = 421;
    public static final String SN_aes_128_cfb128 = "AES-128-CFB";
    public static final String LN_aes_128_cfb128 = "aes-128-cfb";
    public static final String OBJ_aes_128_cfb128 = "2.16.840.1.101.3.4.1.4";
    public static final int NID_aes_192_ecb = 422;
    public static final String SN_aes_192_ecb = "AES-192-ECB";
    public static final String LN_aes_192_ecb = "aes-192-ecb";
    public static final String OBJ_aes_192_ecb = "2.16.840.1.101.3.4.1.21";
    public static final int NID_aes_192_cbc = 423;
    public static final String SN_aes_192_cbc = "AES-192-CBC";
    public static final String LN_aes_192_cbc = "aes-192-cbc";
    public static final String OBJ_aes_192_cbc = "2.16.840.1.101.3.4.1.22";
    public static final int NID_aes_192_ofb128 = 424;
    public static final String SN_aes_192_ofb128 = "AES-192-OFB";
    public static final String LN_aes_192_ofb128 = "aes-192-ofb";
    public static final String OBJ_aes_192_ofb128 = "2.16.840.1.101.3.4.1.23";
    public static final int NID_aes_192_cfb128 = 425;
    public static final String SN_aes_192_cfb128 = "AES-192-CFB";
    public static final String LN_aes_192_cfb128 = "aes-192-cfb";
    public static final String OBJ_aes_192_cfb128 = "2.16.840.1.101.3.4.1.24";
    public static final int NID_aes_256_ecb = 426;
    public static final String SN_aes_256_ecb = "AES-256-ECB";
    public static final String LN_aes_256_ecb = "aes-256-ecb";
    public static final String OBJ_aes_256_ecb = "2.16.840.1.101.3.4.1.41";
    public static final int NID_aes_256_cbc = 427;
    public static final String SN_aes_256_cbc = "AES-256-CBC";
    public static final String LN_aes_256_cbc = "aes-256-cbc";
    public static final String OBJ_aes_256_cbc = "2.16.840.1.101.3.4.1.42";
    public static final int NID_aes_256_ofb128 = 428;
    public static final String SN_aes_256_ofb128 = "AES-256-OFB";
    public static final String LN_aes_256_ofb128 = "aes-256-ofb";
    public static final String OBJ_aes_256_ofb128 = "2.16.840.1.101.3.4.1.43";
    public static final int NID_aes_256_cfb128 = 429;
    public static final String SN_aes_256_cfb128 = "AES-256-CFB";
    public static final String LN_aes_256_cfb128 = "aes-256-cfb";
    public static final String OBJ_aes_256_cfb128 = "2.16.840.1.101.3.4.1.44";
    public static final int NID_hold_instruction_code = 430;
    public static final String SN_hold_instruction_code = "holdInstructionCode";
    public static final String LN_hold_instruction_code = "Hold Instruction Code";
    public static final String OBJ_hold_instruction_code = "2.5.29.23";
    public static final int NID_hold_instruction_none = 431;
    public static final String SN_hold_instruction_none = "holdInstructionNone";
    public static final String LN_hold_instruction_none = "Hold Instruction None";
    public static final String OBJ_hold_instruction_none = "1.2.840.10040.2.1";
    public static final int NID_hold_instruction_call_issuer = 432;
    public static final String SN_hold_instruction_call_issuer = "holdInstructionCallIssuer";
    public static final String LN_hold_instruction_call_issuer = "Hold Instruction Call Issuer";
    public static final String OBJ_hold_instruction_call_issuer = "1.2.840.10040.2.2";
    public static final int NID_hold_instruction_reject = 433;
    public static final String SN_hold_instruction_reject = "holdInstructionReject";
    public static final String LN_hold_instruction_reject = "Hold Instruction Reject";
    public static final String OBJ_hold_instruction_reject = "1.2.840.10040.2.3";
    public static final int NID_pilotAttributeSyntax = 439;
    public static final String LN_pilotAttributeSyntax = "pilotAttributeSyntax";
    public static final String OBJ_pilotAttributeSyntax = "0.9.2342.19200300.100.3";
    public static final int NID_pilotGroups = 441;
    public static final String LN_pilotGroups = "pilotGroups";
    public static final String OBJ_pilotGroups = "0.9.2342.19200300.100.10";
    public static final int NID_iA5StringSyntax = 442;
    public static final String LN_iA5StringSyntax = "iA5StringSyntax";
    public static final String OBJ_iA5StringSyntax = "0.9.2342.19200300.100.3.4";
    public static final int NID_caseIgnoreIA5StringSyntax = 443;
    public static final String LN_caseIgnoreIA5StringSyntax = "caseIgnoreIA5StringSyntax";
    public static final String OBJ_caseIgnoreIA5StringSyntax = "0.9.2342.19200300.100.3.5";
    public static final int NID_pilotObject = 444;
    public static final String LN_pilotObject = "pilotObject";
    public static final String OBJ_pilotObject = "0.9.2342.19200300.100.4.3";
    public static final int NID_pilotPerson = 445;
    public static final String LN_pilotPerson = "pilotPerson";
    public static final String OBJ_pilotPerson = "0.9.2342.19200300.100.4.4";
    public static final int NID_account = 446;
    public static final String SN_account = "account";
    public static final String OBJ_account = "0.9.2342.19200300.100.4.5";
    public static final int NID_document = 447;
    public static final String SN_document = "document";
    public static final String OBJ_document = "0.9.2342.19200300.100.4.6";
    public static final int NID_room = 448;
    public static final String SN_room = "room";
    public static final String OBJ_room = "0.9.2342.19200300.100.4.7";
    public static final int NID_documentSeries = 449;
    public static final String LN_documentSeries = "documentSeries";
    public static final String OBJ_documentSeries = "0.9.2342.19200300.100.4.9";
    public static final int NID_rFC822localPart = 450;
    public static final String LN_rFC822localPart = "rFC822localPart";
    public static final String OBJ_rFC822localPart = "0.9.2342.19200300.100.4.14";
    public static final int NID_dNSDomain = 451;
    public static final String LN_dNSDomain = "dNSDomain";
    public static final String OBJ_dNSDomain = "0.9.2342.19200300.100.4.15";
    public static final int NID_domainRelatedObject = 452;
    public static final String LN_domainRelatedObject = "domainRelatedObject";
    public static final String OBJ_domainRelatedObject = "0.9.2342.19200300.100.4.17";
    public static final int NID_friendlyCountry = 453;
    public static final String LN_friendlyCountry = "friendlyCountry";
    public static final String OBJ_friendlyCountry = "0.9.2342.19200300.100.4.18";
    public static final int NID_simpleSecurityObject = 454;
    public static final String LN_simpleSecurityObject = "simpleSecurityObject";
    public static final String OBJ_simpleSecurityObject = "0.9.2342.19200300.100.4.19";
    public static final int NID_pilotOrganization = 455;
    public static final String LN_pilotOrganization = "pilotOrganization";
    public static final String OBJ_pilotOrganization = "0.9.2342.19200300.100.4.20";
    public static final int NID_pilotDSA = 456;
    public static final String LN_pilotDSA = "pilotDSA";
    public static final String OBJ_pilotDSA = "0.9.2342.19200300.100.4.21";
    public static final int NID_qualityLabelledData = 457;
    public static final String LN_qualityLabelledData = "qualityLabelledData";
    public static final String OBJ_qualityLabelledData = "0.9.2342.19200300.100.4.22";
    public static final int NID_userId = 458;
    public static final String SN_userId = "UID";
    public static final String LN_userId = "userId";
    public static final String OBJ_userId = "0.9.2342.19200300.100.1.1";
    public static final int NID_textEncodedORAddress = 459;
    public static final String LN_textEncodedORAddress = "textEncodedORAddress";
    public static final String OBJ_textEncodedORAddress = "0.9.2342.19200300.100.1.2";
    public static final int NID_rfc822Mailbox = 460;
    public static final String SN_rfc822Mailbox = "mail";
    public static final String LN_rfc822Mailbox = "rfc822Mailbox";
    public static final String OBJ_rfc822Mailbox = "0.9.2342.19200300.100.1.3";
    public static final int NID_info = 461;
    public static final String SN_info = "info";
    public static final String OBJ_info = "0.9.2342.19200300.100.1.4";
    public static final int NID_favouriteDrink = 462;
    public static final String LN_favouriteDrink = "favouriteDrink";
    public static final String OBJ_favouriteDrink = "0.9.2342.19200300.100.1.5";
    public static final int NID_roomNumber = 463;
    public static final String LN_roomNumber = "roomNumber";
    public static final String OBJ_roomNumber = "0.9.2342.19200300.100.1.6";
    public static final int NID_photo = 464;
    public static final String SN_photo = "photo";
    public static final String OBJ_photo = "0.9.2342.19200300.100.1.7";
    public static final int NID_userClass = 465;
    public static final String LN_userClass = "userClass";
    public static final String OBJ_userClass = "0.9.2342.19200300.100.1.8";
    public static final int NID_host = 466;
    public static final String SN_host = "host";
    public static final String OBJ_host = "0.9.2342.19200300.100.1.9";
    public static final int NID_manager = 467;
    public static final String SN_manager = "manager";
    public static final String OBJ_manager = "0.9.2342.19200300.100.1.10";
    public static final int NID_documentIdentifier = 468;
    public static final String LN_documentIdentifier = "documentIdentifier";
    public static final String OBJ_documentIdentifier = "0.9.2342.19200300.100.1.11";
    public static final int NID_documentTitle = 469;
    public static final String LN_documentTitle = "documentTitle";
    public static final String OBJ_documentTitle = "0.9.2342.19200300.100.1.12";
    public static final int NID_documentVersion = 470;
    public static final String LN_documentVersion = "documentVersion";
    public static final String OBJ_documentVersion = "0.9.2342.19200300.100.1.13";
    public static final int NID_documentAuthor = 471;
    public static final String LN_documentAuthor = "documentAuthor";
    public static final String OBJ_documentAuthor = "0.9.2342.19200300.100.1.14";
    public static final int NID_documentLocation = 472;
    public static final String LN_documentLocation = "documentLocation";
    public static final String OBJ_documentLocation = "0.9.2342.19200300.100.1.15";
    public static final int NID_homeTelephoneNumber = 473;
    public static final String LN_homeTelephoneNumber = "homeTelephoneNumber";
    public static final String OBJ_homeTelephoneNumber = "0.9.2342.19200300.100.1.20";
    public static final int NID_secretary = 474;
    public static final String SN_secretary = "secretary";
    public static final String OBJ_secretary = "0.9.2342.19200300.100.1.21";
    public static final int NID_otherMailbox = 475;
    public static final String LN_otherMailbox = "otherMailbox";
    public static final String OBJ_otherMailbox = "0.9.2342.19200300.100.1.22";
    public static final int NID_lastModifiedTime = 476;
    public static final String LN_lastModifiedTime = "lastModifiedTime";
    public static final String OBJ_lastModifiedTime = "0.9.2342.19200300.100.1.23";
    public static final int NID_lastModifiedBy = 477;
    public static final String LN_lastModifiedBy = "lastModifiedBy";
    public static final String OBJ_lastModifiedBy = "0.9.2342.19200300.100.1.24";
    public static final int NID_aRecord = 478;
    public static final String LN_aRecord = "aRecord";
    public static final String OBJ_aRecord = "0.9.2342.19200300.100.1.26";
    public static final int NID_pilotAttributeType27 = 479;
    public static final String LN_pilotAttributeType27 = "pilotAttributeType27";
    public static final String OBJ_pilotAttributeType27 = "0.9.2342.19200300.100.1.27";
    public static final int NID_mXRecord = 480;
    public static final String LN_mXRecord = "mXRecord";
    public static final String OBJ_mXRecord = "0.9.2342.19200300.100.1.28";
    public static final int NID_nSRecord = 481;
    public static final String LN_nSRecord = "nSRecord";
    public static final String OBJ_nSRecord = "0.9.2342.19200300.100.1.29";
    public static final int NID_sOARecord = 482;
    public static final String LN_sOARecord = "sOARecord";
    public static final String OBJ_sOARecord = "0.9.2342.19200300.100.1.30";
    public static final int NID_cNAMERecord = 483;
    public static final String LN_cNAMERecord = "cNAMERecord";
    public static final String OBJ_cNAMERecord = "0.9.2342.19200300.100.1.31";
    public static final int NID_associatedDomain = 484;
    public static final String LN_associatedDomain = "associatedDomain";
    public static final String OBJ_associatedDomain = "0.9.2342.19200300.100.1.37";
    public static final int NID_associatedName = 485;
    public static final String LN_associatedName = "associatedName";
    public static final String OBJ_associatedName = "0.9.2342.19200300.100.1.38";
    public static final int NID_homePostalAddress = 486;
    public static final String LN_homePostalAddress = "homePostalAddress";
    public static final String OBJ_homePostalAddress = "0.9.2342.19200300.100.1.39";
    public static final int NID_personalTitle = 487;
    public static final String LN_personalTitle = "personalTitle";
    public static final String OBJ_personalTitle = "0.9.2342.19200300.100.1.40";
    public static final int NID_mobileTelephoneNumber = 488;
    public static final String LN_mobileTelephoneNumber = "mobileTelephoneNumber";
    public static final String OBJ_mobileTelephoneNumber = "0.9.2342.19200300.100.1.41";
    public static final int NID_pagerTelephoneNumber = 489;
    public static final String LN_pagerTelephoneNumber = "pagerTelephoneNumber";
    public static final String OBJ_pagerTelephoneNumber = "0.9.2342.19200300.100.1.42";
    public static final int NID_friendlyCountryName = 490;
    public static final String LN_friendlyCountryName = "friendlyCountryName";
    public static final String OBJ_friendlyCountryName = "0.9.2342.19200300.100.1.43";
    public static final int NID_organizationalStatus = 491;
    public static final String LN_organizationalStatus = "organizationalStatus";
    public static final String OBJ_organizationalStatus = "0.9.2342.19200300.100.1.45";
    public static final int NID_janetMailbox = 492;
    public static final String LN_janetMailbox = "janetMailbox";
    public static final String OBJ_janetMailbox = "0.9.2342.19200300.100.1.46";
    public static final int NID_mailPreferenceOption = 493;
    public static final String LN_mailPreferenceOption = "mailPreferenceOption";
    public static final String OBJ_mailPreferenceOption = "0.9.2342.19200300.100.1.47";
    public static final int NID_buildingName = 494;
    public static final String LN_buildingName = "buildingName";
    public static final String OBJ_buildingName = "0.9.2342.19200300.100.1.48";
    public static final int NID_dSAQuality = 495;
    public static final String LN_dSAQuality = "dSAQuality";
    public static final String OBJ_dSAQuality = "0.9.2342.19200300.100.1.49";
    public static final int NID_singleLevelQuality = 496;
    public static final String LN_singleLevelQuality = "singleLevelQuality";
    public static final String OBJ_singleLevelQuality = "0.9.2342.19200300.100.1.50";
    public static final int NID_subtreeMinimumQuality = 497;
    public static final String LN_subtreeMinimumQuality = "subtreeMinimumQuality";
    public static final String OBJ_subtreeMinimumQuality = "0.9.2342.19200300.100.1.51";
    public static final int NID_subtreeMaximumQuality = 498;
    public static final String LN_subtreeMaximumQuality = "subtreeMaximumQuality";
    public static final String OBJ_subtreeMaximumQuality = "0.9.2342.19200300.100.1.52";
    public static final int NID_personalSignature = 499;
    public static final String LN_personalSignature = "personalSignature";
    public static final String OBJ_personalSignature = "0.9.2342.19200300.100.1.53";
    public static final int NID_dITRedirect = 500;
    public static final String LN_dITRedirect = "dITRedirect";
    public static final String OBJ_dITRedirect = "0.9.2342.19200300.100.1.54";
    public static final int NID_audio = 501;
    public static final String SN_audio = "audio";
    public static final String OBJ_audio = "0.9.2342.19200300.100.1.55";
    public static final int NID_documentPublisher = 502;
    public static final String LN_documentPublisher = "documentPublisher";
    public static final String OBJ_documentPublisher = "0.9.2342.19200300.100.1.56";
    public static final int NID_x500UniqueIdentifier = 503;
    public static final String LN_x500UniqueIdentifier = "x500UniqueIdentifier";
    public static final String OBJ_x500UniqueIdentifier = "2.5.4.45";
    public static final int NID_mime_mhs = 504;
    public static final String SN_mime_mhs = "mime-mhs";
    public static final String LN_mime_mhs = "MIME MHS";
    public static final String OBJ_mime_mhs = "1.3.6.1.7.1";
    public static final int NID_mime_mhs_headings = 505;
    public static final String SN_mime_mhs_headings = "mime-mhs-headings";
    public static final String LN_mime_mhs_headings = "mime-mhs-headings";
    public static final String OBJ_mime_mhs_headings = "1.3.6.1.7.1.1";
    public static final int NID_mime_mhs_bodies = 506;
    public static final String SN_mime_mhs_bodies = "mime-mhs-bodies";
    public static final String LN_mime_mhs_bodies = "mime-mhs-bodies";
    public static final String OBJ_mime_mhs_bodies = "1.3.6.1.7.1.2";
    public static final int NID_id_hex_partial_message = 507;
    public static final String SN_id_hex_partial_message = "id-hex-partial-message";
    public static final String LN_id_hex_partial_message = "id-hex-partial-message";
    public static final String OBJ_id_hex_partial_message = "1.3.6.1.7.1.1.1";
    public static final int NID_id_hex_multipart_message = 508;
    public static final String SN_id_hex_multipart_message = "id-hex-multipart-message";
    public static final String LN_id_hex_multipart_message = "id-hex-multipart-message";
    public static final String OBJ_id_hex_multipart_message = "1.3.6.1.7.1.1.2";
    public static final int NID_generationQualifier = 509;
    public static final String LN_generationQualifier = "generationQualifier";
    public static final String OBJ_generationQualifier = "2.5.4.44";
    public static final int NID_pseudonym = 510;
    public static final String LN_pseudonym = "pseudonym";
    public static final String OBJ_pseudonym = "2.5.4.65";
    public static final int NID_id_set = 512;
    public static final String SN_id_set = "id-set";
    public static final String LN_id_set = "Secure Electronic Transactions";
    public static final String OBJ_id_set = "2.23.42";
    public static final int NID_set_ctype = 513;
    public static final String SN_set_ctype = "set-ctype";
    public static final String LN_set_ctype = "content types";
    public static final String OBJ_set_ctype = "2.23.42.0";
    public static final int NID_set_msgExt = 514;
    public static final String SN_set_msgExt = "set-msgExt";
    public static final String LN_set_msgExt = "message extensions";
    public static final String OBJ_set_msgExt = "2.23.42.1";
    public static final int NID_set_attr = 515;
    public static final String SN_set_attr = "set-attr";
    public static final String OBJ_set_attr = "2.23.42.3";
    public static final int NID_set_policy = 516;
    public static final String SN_set_policy = "set-policy";
    public static final String OBJ_set_policy = "2.23.42.5";
    public static final int NID_set_certExt = 517;
    public static final String SN_set_certExt = "set-certExt";
    public static final String LN_set_certExt = "certificate extensions";
    public static final String OBJ_set_certExt = "2.23.42.7";
    public static final int NID_set_brand = 518;
    public static final String SN_set_brand = "set-brand";
    public static final String OBJ_set_brand = "2.23.42.8";
    public static final int NID_setct_PANData = 519;
    public static final String SN_setct_PANData = "setct-PANData";
    public static final String OBJ_setct_PANData = "2.23.42.0.0";
    public static final int NID_setct_PANToken = 520;
    public static final String SN_setct_PANToken = "setct-PANToken";
    public static final String OBJ_setct_PANToken = "2.23.42.0.1";
    public static final int NID_setct_PANOnly = 521;
    public static final String SN_setct_PANOnly = "setct-PANOnly";
    public static final String OBJ_setct_PANOnly = "2.23.42.0.2";
    public static final int NID_setct_OIData = 522;
    public static final String SN_setct_OIData = "setct-OIData";
    public static final String OBJ_setct_OIData = "2.23.42.0.3";
    public static final int NID_setct_PI = 523;
    public static final String SN_setct_PI = "setct-PI";
    public static final String OBJ_setct_PI = "2.23.42.0.4";
    public static final int NID_setct_PIData = 524;
    public static final String SN_setct_PIData = "setct-PIData";
    public static final String OBJ_setct_PIData = "2.23.42.0.5";
    public static final int NID_setct_PIDataUnsigned = 525;
    public static final String SN_setct_PIDataUnsigned = "setct-PIDataUnsigned";
    public static final String OBJ_setct_PIDataUnsigned = "2.23.42.0.6";
    public static final int NID_setct_HODInput = 526;
    public static final String SN_setct_HODInput = "setct-HODInput";
    public static final String OBJ_setct_HODInput = "2.23.42.0.7";
    public static final int NID_setct_AuthResBaggage = 527;
    public static final String SN_setct_AuthResBaggage = "setct-AuthResBaggage";
    public static final String OBJ_setct_AuthResBaggage = "2.23.42.0.8";
    public static final int NID_setct_AuthRevReqBaggage = 528;
    public static final String SN_setct_AuthRevReqBaggage = "setct-AuthRevReqBaggage";
    public static final String OBJ_setct_AuthRevReqBaggage = "2.23.42.0.9";
    public static final int NID_setct_AuthRevResBaggage = 529;
    public static final String SN_setct_AuthRevResBaggage = "setct-AuthRevResBaggage";
    public static final String OBJ_setct_AuthRevResBaggage = "2.23.42.0.10";
    public static final int NID_setct_CapTokenSeq = 530;
    public static final String SN_setct_CapTokenSeq = "setct-CapTokenSeq";
    public static final String OBJ_setct_CapTokenSeq = "2.23.42.0.11";
    public static final int NID_setct_PInitResData = 531;
    public static final String SN_setct_PInitResData = "setct-PInitResData";
    public static final String OBJ_setct_PInitResData = "2.23.42.0.12";
    public static final int NID_setct_PI_TBS = 532;
    public static final String SN_setct_PI_TBS = "setct-PI-TBS";
    public static final String OBJ_setct_PI_TBS = "2.23.42.0.13";
    public static final int NID_setct_PResData = 533;
    public static final String SN_setct_PResData = "setct-PResData";
    public static final String OBJ_setct_PResData = "2.23.42.0.14";
    public static final int NID_setct_AuthReqTBS = 534;
    public static final String SN_setct_AuthReqTBS = "setct-AuthReqTBS";
    public static final String OBJ_setct_AuthReqTBS = "2.23.42.0.16";
    public static final int NID_setct_AuthResTBS = 535;
    public static final String SN_setct_AuthResTBS = "setct-AuthResTBS";
    public static final String OBJ_setct_AuthResTBS = "2.23.42.0.17";
    public static final int NID_setct_AuthResTBSX = 536;
    public static final String SN_setct_AuthResTBSX = "setct-AuthResTBSX";
    public static final String OBJ_setct_AuthResTBSX = "2.23.42.0.18";
    public static final int NID_setct_AuthTokenTBS = 537;
    public static final String SN_setct_AuthTokenTBS = "setct-AuthTokenTBS";
    public static final String OBJ_setct_AuthTokenTBS = "2.23.42.0.19";
    public static final int NID_setct_CapTokenData = 538;
    public static final String SN_setct_CapTokenData = "setct-CapTokenData";
    public static final String OBJ_setct_CapTokenData = "2.23.42.0.20";
    public static final int NID_setct_CapTokenTBS = 539;
    public static final String SN_setct_CapTokenTBS = "setct-CapTokenTBS";
    public static final String OBJ_setct_CapTokenTBS = "2.23.42.0.21";
    public static final int NID_setct_AcqCardCodeMsg = 540;
    public static final String SN_setct_AcqCardCodeMsg = "setct-AcqCardCodeMsg";
    public static final String OBJ_setct_AcqCardCodeMsg = "2.23.42.0.22";
    public static final int NID_setct_AuthRevReqTBS = 541;
    public static final String SN_setct_AuthRevReqTBS = "setct-AuthRevReqTBS";
    public static final String OBJ_setct_AuthRevReqTBS = "2.23.42.0.23";
    public static final int NID_setct_AuthRevResData = 542;
    public static final String SN_setct_AuthRevResData = "setct-AuthRevResData";
    public static final String OBJ_setct_AuthRevResData = "2.23.42.0.24";
    public static final int NID_setct_AuthRevResTBS = 543;
    public static final String SN_setct_AuthRevResTBS = "setct-AuthRevResTBS";
    public static final String OBJ_setct_AuthRevResTBS = "2.23.42.0.25";
    public static final int NID_setct_CapReqTBS = 544;
    public static final String SN_setct_CapReqTBS = "setct-CapReqTBS";
    public static final String OBJ_setct_CapReqTBS = "2.23.42.0.26";
    public static final int NID_setct_CapReqTBSX = 545;
    public static final String SN_setct_CapReqTBSX = "setct-CapReqTBSX";
    public static final String OBJ_setct_CapReqTBSX = "2.23.42.0.27";
    public static final int NID_setct_CapResData = 546;
    public static final String SN_setct_CapResData = "setct-CapResData";
    public static final String OBJ_setct_CapResData = "2.23.42.0.28";
    public static final int NID_setct_CapRevReqTBS = 547;
    public static final String SN_setct_CapRevReqTBS = "setct-CapRevReqTBS";
    public static final String OBJ_setct_CapRevReqTBS = "2.23.42.0.29";
    public static final int NID_setct_CapRevReqTBSX = 548;
    public static final String SN_setct_CapRevReqTBSX = "setct-CapRevReqTBSX";
    public static final String OBJ_setct_CapRevReqTBSX = "2.23.42.0.30";
    public static final int NID_setct_CapRevResData = 549;
    public static final String SN_setct_CapRevResData = "setct-CapRevResData";
    public static final String OBJ_setct_CapRevResData = "2.23.42.0.31";
    public static final int NID_setct_CredReqTBS = 550;
    public static final String SN_setct_CredReqTBS = "setct-CredReqTBS";
    public static final String OBJ_setct_CredReqTBS = "2.23.42.0.32";
    public static final int NID_setct_CredReqTBSX = 551;
    public static final String SN_setct_CredReqTBSX = "setct-CredReqTBSX";
    public static final String OBJ_setct_CredReqTBSX = "2.23.42.0.33";
    public static final int NID_setct_CredResData = 552;
    public static final String SN_setct_CredResData = "setct-CredResData";
    public static final String OBJ_setct_CredResData = "2.23.42.0.34";
    public static final int NID_setct_CredRevReqTBS = 553;
    public static final String SN_setct_CredRevReqTBS = "setct-CredRevReqTBS";
    public static final String OBJ_setct_CredRevReqTBS = "2.23.42.0.35";
    public static final int NID_setct_CredRevReqTBSX = 554;
    public static final String SN_setct_CredRevReqTBSX = "setct-CredRevReqTBSX";
    public static final String OBJ_setct_CredRevReqTBSX = "2.23.42.0.36";
    public static final int NID_setct_CredRevResData = 555;
    public static final String SN_setct_CredRevResData = "setct-CredRevResData";
    public static final String OBJ_setct_CredRevResData = "2.23.42.0.37";
    public static final int NID_setct_PCertReqData = 556;
    public static final String SN_setct_PCertReqData = "setct-PCertReqData";
    public static final String OBJ_setct_PCertReqData = "2.23.42.0.38";
    public static final int NID_setct_PCertResTBS = 557;
    public static final String SN_setct_PCertResTBS = "setct-PCertResTBS";
    public static final String OBJ_setct_PCertResTBS = "2.23.42.0.39";
    public static final int NID_setct_BatchAdminReqData = 558;
    public static final String SN_setct_BatchAdminReqData = "setct-BatchAdminReqData";
    public static final String OBJ_setct_BatchAdminReqData = "2.23.42.0.40";
    public static final int NID_setct_BatchAdminResData = 559;
    public static final String SN_setct_BatchAdminResData = "setct-BatchAdminResData";
    public static final String OBJ_setct_BatchAdminResData = "2.23.42.0.41";
    public static final int NID_setct_CardCInitResTBS = 560;
    public static final String SN_setct_CardCInitResTBS = "setct-CardCInitResTBS";
    public static final String OBJ_setct_CardCInitResTBS = "2.23.42.0.42";
    public static final int NID_setct_MeAqCInitResTBS = 561;
    public static final String SN_setct_MeAqCInitResTBS = "setct-MeAqCInitResTBS";
    public static final String OBJ_setct_MeAqCInitResTBS = "2.23.42.0.43";
    public static final int NID_setct_RegFormResTBS = 562;
    public static final String SN_setct_RegFormResTBS = "setct-RegFormResTBS";
    public static final String OBJ_setct_RegFormResTBS = "2.23.42.0.44";
    public static final int NID_setct_CertReqData = 563;
    public static final String SN_setct_CertReqData = "setct-CertReqData";
    public static final String OBJ_setct_CertReqData = "2.23.42.0.45";
    public static final int NID_setct_CertReqTBS = 564;
    public static final String SN_setct_CertReqTBS = "setct-CertReqTBS";
    public static final String OBJ_setct_CertReqTBS = "2.23.42.0.46";
    public static final int NID_setct_CertResData = 565;
    public static final String SN_setct_CertResData = "setct-CertResData";
    public static final String OBJ_setct_CertResData = "2.23.42.0.47";
    public static final int NID_setct_CertInqReqTBS = 566;
    public static final String SN_setct_CertInqReqTBS = "setct-CertInqReqTBS";
    public static final String OBJ_setct_CertInqReqTBS = "2.23.42.0.48";
    public static final int NID_setct_ErrorTBS = 567;
    public static final String SN_setct_ErrorTBS = "setct-ErrorTBS";
    public static final String OBJ_setct_ErrorTBS = "2.23.42.0.49";
    public static final int NID_setct_PIDualSignedTBE = 568;
    public static final String SN_setct_PIDualSignedTBE = "setct-PIDualSignedTBE";
    public static final String OBJ_setct_PIDualSignedTBE = "2.23.42.0.50";
    public static final int NID_setct_PIUnsignedTBE = 569;
    public static final String SN_setct_PIUnsignedTBE = "setct-PIUnsignedTBE";
    public static final String OBJ_setct_PIUnsignedTBE = "2.23.42.0.51";
    public static final int NID_setct_AuthReqTBE = 570;
    public static final String SN_setct_AuthReqTBE = "setct-AuthReqTBE";
    public static final String OBJ_setct_AuthReqTBE = "2.23.42.0.52";
    public static final int NID_setct_AuthResTBE = 571;
    public static final String SN_setct_AuthResTBE = "setct-AuthResTBE";
    public static final String OBJ_setct_AuthResTBE = "2.23.42.0.53";
    public static final int NID_setct_AuthResTBEX = 572;
    public static final String SN_setct_AuthResTBEX = "setct-AuthResTBEX";
    public static final String OBJ_setct_AuthResTBEX = "2.23.42.0.54";
    public static final int NID_setct_AuthTokenTBE = 573;
    public static final String SN_setct_AuthTokenTBE = "setct-AuthTokenTBE";
    public static final String OBJ_setct_AuthTokenTBE = "2.23.42.0.55";
    public static final int NID_setct_CapTokenTBE = 574;
    public static final String SN_setct_CapTokenTBE = "setct-CapTokenTBE";
    public static final String OBJ_setct_CapTokenTBE = "2.23.42.0.56";
    public static final int NID_setct_CapTokenTBEX = 575;
    public static final String SN_setct_CapTokenTBEX = "setct-CapTokenTBEX";
    public static final String OBJ_setct_CapTokenTBEX = "2.23.42.0.57";
    public static final int NID_setct_AcqCardCodeMsgTBE = 576;
    public static final String SN_setct_AcqCardCodeMsgTBE = "setct-AcqCardCodeMsgTBE";
    public static final String OBJ_setct_AcqCardCodeMsgTBE = "2.23.42.0.58";
    public static final int NID_setct_AuthRevReqTBE = 577;
    public static final String SN_setct_AuthRevReqTBE = "setct-AuthRevReqTBE";
    public static final String OBJ_setct_AuthRevReqTBE = "2.23.42.0.59";
    public static final int NID_setct_AuthRevResTBE = 578;
    public static final String SN_setct_AuthRevResTBE = "setct-AuthRevResTBE";
    public static final String OBJ_setct_AuthRevResTBE = "2.23.42.0.60";
    public static final int NID_setct_AuthRevResTBEB = 579;
    public static final String SN_setct_AuthRevResTBEB = "setct-AuthRevResTBEB";
    public static final String OBJ_setct_AuthRevResTBEB = "2.23.42.0.61";
    public static final int NID_setct_CapReqTBE = 580;
    public static final String SN_setct_CapReqTBE = "setct-CapReqTBE";
    public static final String OBJ_setct_CapReqTBE = "2.23.42.0.62";
    public static final int NID_setct_CapReqTBEX = 581;
    public static final String SN_setct_CapReqTBEX = "setct-CapReqTBEX";
    public static final String OBJ_setct_CapReqTBEX = "2.23.42.0.63";
    public static final int NID_setct_CapResTBE = 582;
    public static final String SN_setct_CapResTBE = "setct-CapResTBE";
    public static final String OBJ_setct_CapResTBE = "2.23.42.0.64";
    public static final int NID_setct_CapRevReqTBE = 583;
    public static final String SN_setct_CapRevReqTBE = "setct-CapRevReqTBE";
    public static final String OBJ_setct_CapRevReqTBE = "2.23.42.0.65";
    public static final int NID_setct_CapRevReqTBEX = 584;
    public static final String SN_setct_CapRevReqTBEX = "setct-CapRevReqTBEX";
    public static final String OBJ_setct_CapRevReqTBEX = "2.23.42.0.66";
    public static final int NID_setct_CapRevResTBE = 585;
    public static final String SN_setct_CapRevResTBE = "setct-CapRevResTBE";
    public static final String OBJ_setct_CapRevResTBE = "2.23.42.0.67";
    public static final int NID_setct_CredReqTBE = 586;
    public static final String SN_setct_CredReqTBE = "setct-CredReqTBE";
    public static final String OBJ_setct_CredReqTBE = "2.23.42.0.68";
    public static final int NID_setct_CredReqTBEX = 587;
    public static final String SN_setct_CredReqTBEX = "setct-CredReqTBEX";
    public static final String OBJ_setct_CredReqTBEX = "2.23.42.0.69";
    public static final int NID_setct_CredResTBE = 588;
    public static final String SN_setct_CredResTBE = "setct-CredResTBE";
    public static final String OBJ_setct_CredResTBE = "2.23.42.0.70";
    public static final int NID_setct_CredRevReqTBE = 589;
    public static final String SN_setct_CredRevReqTBE = "setct-CredRevReqTBE";
    public static final String OBJ_setct_CredRevReqTBE = "2.23.42.0.71";
    public static final int NID_setct_CredRevReqTBEX = 590;
    public static final String SN_setct_CredRevReqTBEX = "setct-CredRevReqTBEX";
    public static final String OBJ_setct_CredRevReqTBEX = "2.23.42.0.72";
    public static final int NID_setct_CredRevResTBE = 591;
    public static final String SN_setct_CredRevResTBE = "setct-CredRevResTBE";
    public static final String OBJ_setct_CredRevResTBE = "2.23.42.0.73";
    public static final int NID_setct_BatchAdminReqTBE = 592;
    public static final String SN_setct_BatchAdminReqTBE = "setct-BatchAdminReqTBE";
    public static final String OBJ_setct_BatchAdminReqTBE = "2.23.42.0.74";
    public static final int NID_setct_BatchAdminResTBE = 593;
    public static final String SN_setct_BatchAdminResTBE = "setct-BatchAdminResTBE";
    public static final String OBJ_setct_BatchAdminResTBE = "2.23.42.0.75";
    public static final int NID_setct_RegFormReqTBE = 594;
    public static final String SN_setct_RegFormReqTBE = "setct-RegFormReqTBE";
    public static final String OBJ_setct_RegFormReqTBE = "2.23.42.0.76";
    public static final int NID_setct_CertReqTBE = 595;
    public static final String SN_setct_CertReqTBE = "setct-CertReqTBE";
    public static final String OBJ_setct_CertReqTBE = "2.23.42.0.77";
    public static final int NID_setct_CertReqTBEX = 596;
    public static final String SN_setct_CertReqTBEX = "setct-CertReqTBEX";
    public static final String OBJ_setct_CertReqTBEX = "2.23.42.0.78";
    public static final int NID_setct_CertResTBE = 597;
    public static final String SN_setct_CertResTBE = "setct-CertResTBE";
    public static final String OBJ_setct_CertResTBE = "2.23.42.0.79";
    public static final int NID_setct_CRLNotificationTBS = 598;
    public static final String SN_setct_CRLNotificationTBS = "setct-CRLNotificationTBS";
    public static final String OBJ_setct_CRLNotificationTBS = "2.23.42.0.80";
    public static final int NID_setct_CRLNotificationResTBS = 599;
    public static final String SN_setct_CRLNotificationResTBS = "setct-CRLNotificationResTBS";
    public static final String OBJ_setct_CRLNotificationResTBS = "2.23.42.0.81";
    public static final int NID_setct_BCIDistributionTBS = 600;
    public static final String SN_setct_BCIDistributionTBS = "setct-BCIDistributionTBS";
    public static final String OBJ_setct_BCIDistributionTBS = "2.23.42.0.82";
    public static final int NID_setext_genCrypt = 601;
    public static final String SN_setext_genCrypt = "setext-genCrypt";
    public static final String LN_setext_genCrypt = "generic cryptogram";
    public static final String OBJ_setext_genCrypt = "2.23.42.1.1";
    public static final int NID_setext_miAuth = 602;
    public static final String SN_setext_miAuth = "setext-miAuth";
    public static final String LN_setext_miAuth = "merchant initiated auth";
    public static final String OBJ_setext_miAuth = "2.23.42.1.3";
    public static final int NID_setext_pinSecure = 603;
    public static final String SN_setext_pinSecure = "setext-pinSecure";
    public static final String OBJ_setext_pinSecure = "2.23.42.1.4";
    public static final int NID_setext_pinAny = 604;
    public static final String SN_setext_pinAny = "setext-pinAny";
    public static final String OBJ_setext_pinAny = "2.23.42.1.5";
    public static final int NID_setext_track2 = 605;
    public static final String SN_setext_track2 = "setext-track2";
    public static final String OBJ_setext_track2 = "2.23.42.1.7";
    public static final int NID_setext_cv = 606;
    public static final String SN_setext_cv = "setext-cv";
    public static final String LN_setext_cv = "additional verification";
    public static final String OBJ_setext_cv = "2.23.42.1.8";
    public static final int NID_set_policy_root = 607;
    public static final String SN_set_policy_root = "set-policy-root";
    public static final String OBJ_set_policy_root = "2.23.42.5.0";
    public static final int NID_setCext_hashedRoot = 608;
    public static final String SN_setCext_hashedRoot = "setCext-hashedRoot";
    public static final String OBJ_setCext_hashedRoot = "2.23.42.7.0";
    public static final int NID_setCext_certType = 609;
    public static final String SN_setCext_certType = "setCext-certType";
    public static final String OBJ_setCext_certType = "2.23.42.7.1";
    public static final int NID_setCext_merchData = 610;
    public static final String SN_setCext_merchData = "setCext-merchData";
    public static final String OBJ_setCext_merchData = "2.23.42.7.2";
    public static final int NID_setCext_cCertRequired = 611;
    public static final String SN_setCext_cCertRequired = "setCext-cCertRequired";
    public static final String OBJ_setCext_cCertRequired = "2.23.42.7.3";
    public static final int NID_setCext_tunneling = 612;
    public static final String SN_setCext_tunneling = "setCext-tunneling";
    public static final String OBJ_setCext_tunneling = "2.23.42.7.4";
    public static final int NID_setCext_setExt = 613;
    public static final String SN_setCext_setExt = "setCext-setExt";
    public static final String OBJ_setCext_setExt = "2.23.42.7.5";
    public static final int NID_setCext_setQualf = 614;
    public static final String SN_setCext_setQualf = "setCext-setQualf";
    public static final String OBJ_setCext_setQualf = "2.23.42.7.6";
    public static final int NID_setCext_PGWYcapabilities = 615;
    public static final String SN_setCext_PGWYcapabilities = "setCext-PGWYcapabilities";
    public static final String OBJ_setCext_PGWYcapabilities = "2.23.42.7.7";
    public static final int NID_setCext_TokenIdentifier = 616;
    public static final String SN_setCext_TokenIdentifier = "setCext-TokenIdentifier";
    public static final String OBJ_setCext_TokenIdentifier = "2.23.42.7.8";
    public static final int NID_setCext_Track2Data = 617;
    public static final String SN_setCext_Track2Data = "setCext-Track2Data";
    public static final String OBJ_setCext_Track2Data = "2.23.42.7.9";
    public static final int NID_setCext_TokenType = 618;
    public static final String SN_setCext_TokenType = "setCext-TokenType";
    public static final String OBJ_setCext_TokenType = "2.23.42.7.10";
    public static final int NID_setCext_IssuerCapabilities = 619;
    public static final String SN_setCext_IssuerCapabilities = "setCext-IssuerCapabilities";
    public static final String OBJ_setCext_IssuerCapabilities = "2.23.42.7.11";
    public static final int NID_setAttr_Cert = 620;
    public static final String SN_setAttr_Cert = "setAttr-Cert";
    public static final String OBJ_setAttr_Cert = "2.23.42.3.0";
    public static final int NID_setAttr_PGWYcap = 621;
    public static final String SN_setAttr_PGWYcap = "setAttr-PGWYcap";
    public static final String LN_setAttr_PGWYcap = "payment gateway capabilities";
    public static final String OBJ_setAttr_PGWYcap = "2.23.42.3.1";
    public static final int NID_setAttr_TokenType = 622;
    public static final String SN_setAttr_TokenType = "setAttr-TokenType";
    public static final String OBJ_setAttr_TokenType = "2.23.42.3.2";
    public static final int NID_setAttr_IssCap = 623;
    public static final String SN_setAttr_IssCap = "setAttr-IssCap";
    public static final String LN_setAttr_IssCap = "issuer capabilities";
    public static final String OBJ_setAttr_IssCap = "2.23.42.3.3";
    public static final int NID_set_rootKeyThumb = 624;
    public static final String SN_set_rootKeyThumb = "set-rootKeyThumb";
    public static final String OBJ_set_rootKeyThumb = "2.23.42.3.0.0";
    public static final int NID_set_addPolicy = 625;
    public static final String SN_set_addPolicy = "set-addPolicy";
    public static final String OBJ_set_addPolicy = "2.23.42.3.0.1";
    public static final int NID_setAttr_Token_EMV = 626;
    public static final String SN_setAttr_Token_EMV = "setAttr-Token-EMV";
    public static final String OBJ_setAttr_Token_EMV = "2.23.42.3.2.1";
    public static final int NID_setAttr_Token_B0Prime = 627;
    public static final String SN_setAttr_Token_B0Prime = "setAttr-Token-B0Prime";
    public static final String OBJ_setAttr_Token_B0Prime = "2.23.42.3.2.2";
    public static final int NID_setAttr_IssCap_CVM = 628;
    public static final String SN_setAttr_IssCap_CVM = "setAttr-IssCap-CVM";
    public static final String OBJ_setAttr_IssCap_CVM = "2.23.42.3.3.3";
    public static final int NID_setAttr_IssCap_T2 = 629;
    public static final String SN_setAttr_IssCap_T2 = "setAttr-IssCap-T2";
    public static final String OBJ_setAttr_IssCap_T2 = "2.23.42.3.3.4";
    public static final int NID_setAttr_IssCap_Sig = 630;
    public static final String SN_setAttr_IssCap_Sig = "setAttr-IssCap-Sig";
    public static final String OBJ_setAttr_IssCap_Sig = "2.23.42.3.3.5";
    public static final int NID_setAttr_GenCryptgrm = 631;
    public static final String SN_setAttr_GenCryptgrm = "setAttr-GenCryptgrm";
    public static final String LN_setAttr_GenCryptgrm = "generate cryptogram";
    public static final String OBJ_setAttr_GenCryptgrm = "2.23.42.3.3.3.1";
    public static final int NID_setAttr_T2Enc = 632;
    public static final String SN_setAttr_T2Enc = "setAttr-T2Enc";
    public static final String LN_setAttr_T2Enc = "encrypted track 2";
    public static final String OBJ_setAttr_T2Enc = "2.23.42.3.3.4.1";
    public static final int NID_setAttr_T2cleartxt = 633;
    public static final String SN_setAttr_T2cleartxt = "setAttr-T2cleartxt";
    public static final String LN_setAttr_T2cleartxt = "cleartext track 2";
    public static final String OBJ_setAttr_T2cleartxt = "2.23.42.3.3.4.2";
    public static final int NID_setAttr_TokICCsig = 634;
    public static final String SN_setAttr_TokICCsig = "setAttr-TokICCsig";
    public static final String LN_setAttr_TokICCsig = "ICC or token signature";
    public static final String OBJ_setAttr_TokICCsig = "2.23.42.3.3.5.1";
    public static final int NID_setAttr_SecDevSig = 635;
    public static final String SN_setAttr_SecDevSig = "setAttr-SecDevSig";
    public static final String LN_setAttr_SecDevSig = "secure device signature";
    public static final String OBJ_setAttr_SecDevSig = "2.23.42.3.3.5.2";
    public static final int NID_set_brand_IATA_ATA = 636;
    public static final String SN_set_brand_IATA_ATA = "set-brand-IATA-ATA";
    public static final String OBJ_set_brand_IATA_ATA = "2.23.42.8.1";
    public static final int NID_set_brand_Diners = 637;
    public static final String SN_set_brand_Diners = "set-brand-Diners";
    public static final String OBJ_set_brand_Diners = "2.23.42.8.30";
    public static final int NID_set_brand_AmericanExpress = 638;
    public static final String SN_set_brand_AmericanExpress = "set-brand-AmericanExpress";
    public static final String OBJ_set_brand_AmericanExpress = "2.23.42.8.34";
    public static final int NID_set_brand_JCB = 639;
    public static final String SN_set_brand_JCB = "set-brand-JCB";
    public static final String OBJ_set_brand_JCB = "2.23.42.8.35";
    public static final int NID_set_brand_Visa = 640;
    public static final String SN_set_brand_Visa = "set-brand-Visa";
    public static final String OBJ_set_brand_Visa = "2.23.42.8.4";
    public static final int NID_set_brand_MasterCard = 641;
    public static final String SN_set_brand_MasterCard = "set-brand-MasterCard";
    public static final String OBJ_set_brand_MasterCard = "2.23.42.8.5";
    public static final int NID_set_brand_Novus = 642;
    public static final String SN_set_brand_Novus = "set-brand-Novus";
    public static final String OBJ_set_brand_Novus = "2.23.42.8.6011";
    public static final int NID_des_cdmf = 643;
    public static final String SN_des_cdmf = "DES-CDMF";
    public static final String LN_des_cdmf = "des-cdmf";
    public static final String OBJ_des_cdmf = "1.2.840.113549.3.10";
    public static final int NID_rsaOAEPEncryptionSET = 644;
    public static final String SN_rsaOAEPEncryptionSET = "rsaOAEPEncryptionSET";
    public static final String OBJ_rsaOAEPEncryptionSET = "1.2.840.113549.1.1.6";
    public static final int NID_ms_smartcard_login = 648;
    public static final String SN_ms_smartcard_login = "msSmartcardLogin";
    public static final String LN_ms_smartcard_login = "Microsoft Smartcardlogin";
    public static final String OBJ_ms_smartcard_login = "1.3.6.1.4.1.311.20.2.2";
    public static final int NID_ms_upn = 649;
    public static final String SN_ms_upn = "msUPN";
    public static final String LN_ms_upn = "Microsoft Universal Principal Name";
    public static final String OBJ_ms_upn = "1.3.6.1.4.1.311.20.2.3";
    public static final int NID_aes_128_cfb1 = 650;
    public static final String SN_aes_128_cfb1 = "AES-128-CFB1";
    public static final String LN_aes_128_cfb1 = "aes-128-cfb1";
    public static final int NID_aes_192_cfb1 = 651;
    public static final String SN_aes_192_cfb1 = "AES-192-CFB1";
    public static final String LN_aes_192_cfb1 = "aes-192-cfb1";
    public static final int NID_aes_256_cfb1 = 652;
    public static final String SN_aes_256_cfb1 = "AES-256-CFB1";
    public static final String LN_aes_256_cfb1 = "aes-256-cfb1";
    public static final int NID_aes_128_cfb8 = 653;
    public static final String SN_aes_128_cfb8 = "AES-128-CFB8";
    public static final String LN_aes_128_cfb8 = "aes-128-cfb8";
    public static final int NID_aes_192_cfb8 = 654;
    public static final String SN_aes_192_cfb8 = "AES-192-CFB8";
    public static final String LN_aes_192_cfb8 = "aes-192-cfb8";
    public static final int NID_aes_256_cfb8 = 655;
    public static final String SN_aes_256_cfb8 = "AES-256-CFB8";
    public static final String LN_aes_256_cfb8 = "aes-256-cfb8";
    public static final int NID_des_cfb1 = 656;
    public static final String SN_des_cfb1 = "DES-CFB1";
    public static final String LN_des_cfb1 = "des-cfb1";
    public static final int NID_des_cfb8 = 657;
    public static final String SN_des_cfb8 = "DES-CFB8";
    public static final String LN_des_cfb8 = "des-cfb8";
    public static final int NID_des_ede3_cfb1 = 658;
    public static final String SN_des_ede3_cfb1 = "DES-EDE3-CFB1";
    public static final String LN_des_ede3_cfb1 = "des-ede3-cfb1";
    public static final int NID_des_ede3_cfb8 = 659;
    public static final String SN_des_ede3_cfb8 = "DES-EDE3-CFB8";
    public static final String LN_des_ede3_cfb8 = "des-ede3-cfb8";
    public static final int NID_streetAddress = 660;
    public static final String LN_streetAddress = "streetAddress";
    public static final String OBJ_streetAddress = "2.5.4.9";
    public static final int NID_postalCode = 661;
    public static final String LN_postalCode = "postalCode";
    public static final String OBJ_postalCode = "2.5.4.17";
    public static final int NID_id_ppl = 662;
    public static final String SN_id_ppl = "id-ppl";
    public static final String OBJ_id_ppl = "1.3.6.1.5.5.7.21";
    public static final int NID_proxyCertInfo = 663;
    public static final String SN_proxyCertInfo = "proxyCertInfo";
    public static final String LN_proxyCertInfo = "Proxy Certificate Information";
    public static final String OBJ_proxyCertInfo = "1.3.6.1.5.5.7.1.14";
    public static final int NID_id_ppl_anyLanguage = 664;
    public static final String SN_id_ppl_anyLanguage = "id-ppl-anyLanguage";
    public static final String LN_id_ppl_anyLanguage = "Any language";
    public static final String OBJ_id_ppl_anyLanguage = "1.3.6.1.5.5.7.21.0";
    public static final int NID_id_ppl_inheritAll = 665;
    public static final String SN_id_ppl_inheritAll = "id-ppl-inheritAll";
    public static final String LN_id_ppl_inheritAll = "Inherit all";
    public static final String OBJ_id_ppl_inheritAll = "1.3.6.1.5.5.7.21.1";
    public static final int NID_name_constraints = 666;
    public static final String SN_name_constraints = "nameConstraints";
    public static final String LN_name_constraints = "X509v3 Name Constraints";
    public static final String OBJ_name_constraints = "2.5.29.30";
    public static final int NID_Independent = 667;
    public static final String SN_Independent = "id-ppl-independent";
    public static final String LN_Independent = "Independent";
    public static final String OBJ_Independent = "1.3.6.1.5.5.7.21.2";
    public static final int NID_sha256WithRSAEncryption = 668;
    public static final String SN_sha256WithRSAEncryption = "RSA-SHA256";
    public static final String LN_sha256WithRSAEncryption = "sha256WithRSAEncryption";
    public static final String OBJ_sha256WithRSAEncryption = "1.2.840.113549.1.1.11";
    public static final int NID_sha384WithRSAEncryption = 669;
    public static final String SN_sha384WithRSAEncryption = "RSA-SHA384";
    public static final String LN_sha384WithRSAEncryption = "sha384WithRSAEncryption";
    public static final String OBJ_sha384WithRSAEncryption = "1.2.840.113549.1.1.12";
    public static final int NID_sha512WithRSAEncryption = 670;
    public static final String SN_sha512WithRSAEncryption = "RSA-SHA512";
    public static final String LN_sha512WithRSAEncryption = "sha512WithRSAEncryption";
    public static final String OBJ_sha512WithRSAEncryption = "1.2.840.113549.1.1.13";
    public static final int NID_sha224WithRSAEncryption = 671;
    public static final String SN_sha224WithRSAEncryption = "RSA-SHA224";
    public static final String LN_sha224WithRSAEncryption = "sha224WithRSAEncryption";
    public static final String OBJ_sha224WithRSAEncryption = "1.2.840.113549.1.1.14";
    public static final int NID_sha256 = 672;
    public static final String SN_sha256 = "SHA256";
    public static final String LN_sha256 = "sha256";
    public static final String OBJ_sha256 = "2.16.840.1.101.3.4.2.1";
    public static final int NID_sha384 = 673;
    public static final String SN_sha384 = "SHA384";
    public static final String LN_sha384 = "sha384";
    public static final String OBJ_sha384 = "2.16.840.1.101.3.4.2.2";
    public static final int NID_sha512 = 674;
    public static final String SN_sha512 = "SHA512";
    public static final String LN_sha512 = "sha512";
    public static final String OBJ_sha512 = "2.16.840.1.101.3.4.2.3";
    public static final int NID_sha224 = 675;
    public static final String SN_sha224 = "SHA224";
    public static final String LN_sha224 = "sha224";
    public static final String OBJ_sha224 = "2.16.840.1.101.3.4.2.4";
    public static final int NID_dsa_with_SHA224 = 802;
    public static final String SN_dsa_with_SHA224 = "dsa_with_SHA224";
    public static final String OBJ_dsa_with_SHA224 = "2.16.840.1.101.3.4.3.1";
    public static final String SN_dsa_with_SHA256 = "dsa_with_SHA256";
    public static final int NID_dsa_with_SHA256 = 803;
    public static final String OBJ_dsa_with_SHA256 = "2.16.840.1.101.3.4.3.2";
    public static final int NID_X9_62_id_characteristic_two_basis = 680;
    public static final String SN_X9_62_id_characteristic_two_basis = "id-characteristic-two-basis";
    public static final String OBJ_X9_62_id_characteristic_two_basis = "1.2.840.10045.1.2.3";
    public static final int NID_X9_62_onBasis = 681;
    public static final String SN_X9_62_onBasis = "onBasis";
    public static final String OBJ_X9_62_onBasis = "1.2.840.10045.1.2.3.1";
    public static final int NID_X9_62_tpBasis = 682;
    public static final String SN_X9_62_tpBasis = "tpBasis";
    public static final String OBJ_X9_62_tpBasis = "1.2.840.10045.1.2.3.2";
    public static final int NID_X9_62_ppBasis = 683;
    public static final String SN_X9_62_ppBasis = "ppBasis";
    public static final String OBJ_X9_62_ppBasis = "1.2.840.10045.1.2.3.3";
    public static final int NID_X9_62_c2pnb163v1 = 684;
    public static final String SN_X9_62_c2pnb163v1 = "c2pnb163v1";
    public static final String OBJ_X9_62_c2pnb163v1 = "1.2.840.10045.3.0.1";
    public static final int NID_X9_62_c2pnb163v2 = 685;
    public static final String SN_X9_62_c2pnb163v2 = "c2pnb163v2";
    public static final String OBJ_X9_62_c2pnb163v2 = "1.2.840.10045.3.0.2";
    public static final int NID_X9_62_c2pnb163v3 = 686;
    public static final String SN_X9_62_c2pnb163v3 = "c2pnb163v3";
    public static final String OBJ_X9_62_c2pnb163v3 = "1.2.840.10045.3.0.3";
    public static final int NID_X9_62_c2pnb176v1 = 687;
    public static final String SN_X9_62_c2pnb176v1 = "c2pnb176v1";
    public static final String OBJ_X9_62_c2pnb176v1 = "1.2.840.10045.3.0.4";
    public static final int NID_X9_62_c2tnb191v1 = 688;
    public static final String SN_X9_62_c2tnb191v1 = "c2tnb191v1";
    public static final String OBJ_X9_62_c2tnb191v1 = "1.2.840.10045.3.0.5";
    public static final int NID_X9_62_c2tnb191v2 = 689;
    public static final String SN_X9_62_c2tnb191v2 = "c2tnb191v2";
    public static final String OBJ_X9_62_c2tnb191v2 = "1.2.840.10045.3.0.6";
    public static final int NID_X9_62_c2tnb191v3 = 690;
    public static final String SN_X9_62_c2tnb191v3 = "c2tnb191v3";
    public static final String OBJ_X9_62_c2tnb191v3 = "1.2.840.10045.3.0.7";
    public static final int NID_X9_62_c2onb191v4 = 691;
    public static final String SN_X9_62_c2onb191v4 = "c2onb191v4";
    public static final String OBJ_X9_62_c2onb191v4 = "1.2.840.10045.3.0.8";
    public static final int NID_X9_62_c2onb191v5 = 692;
    public static final String SN_X9_62_c2onb191v5 = "c2onb191v5";
    public static final String OBJ_X9_62_c2onb191v5 = "1.2.840.10045.3.0.9";
    public static final int NID_X9_62_c2pnb208w1 = 693;
    public static final String SN_X9_62_c2pnb208w1 = "c2pnb208w1";
    public static final String OBJ_X9_62_c2pnb208w1 = "1.2.840.10045.3.0.10";
    public static final int NID_X9_62_c2tnb239v1 = 694;
    public static final String SN_X9_62_c2tnb239v1 = "c2tnb239v1";
    public static final String OBJ_X9_62_c2tnb239v1 = "1.2.840.10045.3.0.11";
    public static final int NID_X9_62_c2tnb239v2 = 695;
    public static final String SN_X9_62_c2tnb239v2 = "c2tnb239v2";
    public static final String OBJ_X9_62_c2tnb239v2 = "1.2.840.10045.3.0.12";
    public static final int NID_X9_62_c2tnb239v3 = 696;
    public static final String SN_X9_62_c2tnb239v3 = "c2tnb239v3";
    public static final String OBJ_X9_62_c2tnb239v3 = "1.2.840.10045.3.0.13";
    public static final int NID_X9_62_c2onb239v4 = 697;
    public static final String SN_X9_62_c2onb239v4 = "c2onb239v4";
    public static final String OBJ_X9_62_c2onb239v4 = "1.2.840.10045.3.0.14";
    public static final int NID_X9_62_c2onb239v5 = 698;
    public static final String SN_X9_62_c2onb239v5 = "c2onb239v5";
    public static final String OBJ_X9_62_c2onb239v5 = "1.2.840.10045.3.0.15";
    public static final int NID_X9_62_c2pnb272w1 = 699;
    public static final String SN_X9_62_c2pnb272w1 = "c2pnb272w1";
    public static final String OBJ_X9_62_c2pnb272w1 = "1.2.840.10045.3.0.16";
    public static final int NID_X9_62_c2pnb304w1 = 700;
    public static final String SN_X9_62_c2pnb304w1 = "c2pnb304w1";
    public static final String OBJ_X9_62_c2pnb304w1 = "1.2.840.10045.3.0.17";
    public static final int NID_X9_62_c2tnb359v1 = 701;
    public static final String SN_X9_62_c2tnb359v1 = "c2tnb359v1";
    public static final String OBJ_X9_62_c2tnb359v1 = "1.2.840.10045.3.0.18";
    public static final int NID_X9_62_c2pnb368w1 = 702;
    public static final String SN_X9_62_c2pnb368w1 = "c2pnb368w1";
    public static final String OBJ_X9_62_c2pnb368w1 = "1.2.840.10045.3.0.19";
    public static final int NID_X9_62_c2tnb431r1 = 703;
    public static final String SN_X9_62_c2tnb431r1 = "c2tnb431r1";
    public static final String OBJ_X9_62_c2tnb431r1 = "1.2.840.10045.3.0.20";
    public static final int NID_secp112r1 = 704;
    public static final String SN_secp112r1 = "secp112r1";
    public static final String OBJ_secp112r1 = "1.3.132.0.6";
    public static final int NID_secp112r2 = 705;
    public static final String SN_secp112r2 = "secp112r2";
    public static final String OBJ_secp112r2 = "1.3.132.0.7";
    public static final int NID_secp128r1 = 706;
    public static final String SN_secp128r1 = "secp128r1";
    public static final String OBJ_secp128r1 = "1.3.132.0.28";
    public static final int NID_secp128r2 = 707;
    public static final String SN_secp128r2 = "secp128r2";
    public static final String OBJ_secp128r2 = "1.3.132.0.29";
    public static final int NID_secp160k1 = 708;
    public static final String SN_secp160k1 = "secp160k1";
    public static final String OBJ_secp160k1 = "1.3.132.0.9";
    public static final int NID_secp160r1 = 709;
    public static final String SN_secp160r1 = "secp160r1";
    public static final String OBJ_secp160r1 = "1.3.132.0.8";
    public static final int NID_secp160r2 = 710;
    public static final String SN_secp160r2 = "secp160r2";
    public static final String OBJ_secp160r2 = "1.3.132.0.30";
    public static final int NID_secp192k1 = 711;
    public static final String SN_secp192k1 = "secp192k1";
    public static final String OBJ_secp192k1 = "1.3.132.0.31";
    public static final int NID_secp224k1 = 712;
    public static final String SN_secp224k1 = "secp224k1";
    public static final String OBJ_secp224k1 = "1.3.132.0.32";
    public static final int NID_secp224r1 = 713;
    public static final String SN_secp224r1 = "secp224r1";
    public static final String OBJ_secp224r1 = "1.3.132.0.33";
    public static final int NID_secp256k1 = 714;
    public static final String SN_secp256k1 = "secp256k1";
    public static final String OBJ_secp256k1 = "1.3.132.0.10";
    public static final int NID_secp384r1 = 715;
    public static final String SN_secp384r1 = "secp384r1";
    public static final String OBJ_secp384r1 = "1.3.132.0.34";
    public static final int NID_secp521r1 = 716;
    public static final String SN_secp521r1 = "secp521r1";
    public static final String OBJ_secp521r1 = "1.3.132.0.35";
    public static final int NID_sect113r1 = 717;
    public static final String SN_sect113r1 = "sect113r1";
    public static final String OBJ_sect113r1 = "1.3.132.0.4";
    public static final int NID_sect113r2 = 718;
    public static final String SN_sect113r2 = "sect113r2";
    public static final String OBJ_sect113r2 = "1.3.132.0.5";
    public static final int NID_sect131r1 = 719;
    public static final String SN_sect131r1 = "sect131r1";
    public static final String OBJ_sect131r1 = "1.3.132.0.22";
    public static final int NID_sect131r2 = 720;
    public static final String SN_sect131r2 = "sect131r2";
    public static final String OBJ_sect131r2 = "1.3.132.0.23";
    public static final int NID_sect163k1 = 721;
    public static final String SN_sect163k1 = "sect163k1";
    public static final String OBJ_sect163k1 = "1.3.132.0.1";
    public static final int NID_sect163r1 = 722;
    public static final String SN_sect163r1 = "sect163r1";
    public static final String OBJ_sect163r1 = "1.3.132.0.2";
    public static final int NID_sect163r2 = 723;
    public static final String SN_sect163r2 = "sect163r2";
    public static final String OBJ_sect163r2 = "1.3.132.0.15";
    public static final int NID_sect193r1 = 724;
    public static final String SN_sect193r1 = "sect193r1";
    public static final String OBJ_sect193r1 = "1.3.132.0.24";
    public static final int NID_sect193r2 = 725;
    public static final String SN_sect193r2 = "sect193r2";
    public static final String OBJ_sect193r2 = "1.3.132.0.25";
    public static final int NID_sect233k1 = 726;
    public static final String SN_sect233k1 = "sect233k1";
    public static final String OBJ_sect233k1 = "1.3.132.0.26";
    public static final int NID_sect233r1 = 727;
    public static final String SN_sect233r1 = "sect233r1";
    public static final String OBJ_sect233r1 = "1.3.132.0.27";
    public static final int NID_sect239k1 = 728;
    public static final String SN_sect239k1 = "sect239k1";
    public static final String OBJ_sect239k1 = "1.3.132.0.3";
    public static final int NID_sect283k1 = 729;
    public static final String SN_sect283k1 = "sect283k1";
    public static final String OBJ_sect283k1 = "1.3.132.0.16";
    public static final int NID_sect283r1 = 730;
    public static final String SN_sect283r1 = "sect283r1";
    public static final String OBJ_sect283r1 = "1.3.132.0.17";
    public static final int NID_sect409k1 = 731;
    public static final String SN_sect409k1 = "sect409k1";
    public static final String OBJ_sect409k1 = "1.3.132.0.36";
    public static final int NID_sect409r1 = 732;
    public static final String SN_sect409r1 = "sect409r1";
    public static final String OBJ_sect409r1 = "1.3.132.0.37";
    public static final int NID_sect571k1 = 733;
    public static final String SN_sect571k1 = "sect571k1";
    public static final String OBJ_sect571k1 = "1.3.132.0.38";
    public static final int NID_sect571r1 = 734;
    public static final String SN_sect571r1 = "sect571r1";
    public static final String OBJ_sect571r1 = "1.3.132.0.39";
    public static final int NID_wap_wsg_idm_ecid_wtls1 = 735;
    public static final String SN_wap_wsg_idm_ecid_wtls1 = "wap-wsg-idm-ecid-wtls1";
    public static final String OBJ_wap_wsg_idm_ecid_wtls1 = "2.23.43.13.4.1";
    public static final int NID_wap_wsg_idm_ecid_wtls3 = 736;
    public static final String SN_wap_wsg_idm_ecid_wtls3 = "wap-wsg-idm-ecid-wtls3";
    public static final String OBJ_wap_wsg_idm_ecid_wtls3 = "2.23.43.13.4.3";
    public static final int NID_wap_wsg_idm_ecid_wtls4 = 737;
    public static final String SN_wap_wsg_idm_ecid_wtls4 = "wap-wsg-idm-ecid-wtls4";
    public static final String OBJ_wap_wsg_idm_ecid_wtls4 = "2.23.43.13.4.4";
    public static final int NID_wap_wsg_idm_ecid_wtls5 = 738;
    public static final String SN_wap_wsg_idm_ecid_wtls5 = "wap-wsg-idm-ecid-wtls5";
    public static final String OBJ_wap_wsg_idm_ecid_wtls5 = "2.23.43.13.4.5";
    public static final int NID_wap_wsg_idm_ecid_wtls6 = 739;
    public static final String SN_wap_wsg_idm_ecid_wtls6 = "wap-wsg-idm-ecid-wtls6";
    public static final String OBJ_wap_wsg_idm_ecid_wtls6 = "2.23.43.13.4.6";
    public static final int NID_wap_wsg_idm_ecid_wtls7 = 740;
    public static final String SN_wap_wsg_idm_ecid_wtls7 = "wap-wsg-idm-ecid-wtls7";
    public static final String OBJ_wap_wsg_idm_ecid_wtls7 = "2.23.43.13.4.7";
    public static final int NID_wap_wsg_idm_ecid_wtls8 = 741;
    public static final String SN_wap_wsg_idm_ecid_wtls8 = "wap-wsg-idm-ecid-wtls8";
    public static final String OBJ_wap_wsg_idm_ecid_wtls8 = "2.23.43.13.4.8";
    public static final int NID_wap_wsg_idm_ecid_wtls9 = 742;
    public static final String SN_wap_wsg_idm_ecid_wtls9 = "wap-wsg-idm-ecid-wtls9";
    public static final String OBJ_wap_wsg_idm_ecid_wtls9 = "2.23.43.13.4.9";
    public static final int NID_wap_wsg_idm_ecid_wtls10 = 743;
    public static final String SN_wap_wsg_idm_ecid_wtls10 = "wap-wsg-idm-ecid-wtls10";
    public static final String OBJ_wap_wsg_idm_ecid_wtls10 = "2.23.43.13.4.10";
    public static final int NID_wap_wsg_idm_ecid_wtls11 = 744;
    public static final String SN_wap_wsg_idm_ecid_wtls11 = "wap-wsg-idm-ecid-wtls11";
    public static final String OBJ_wap_wsg_idm_ecid_wtls11 = "2.23.43.13.4.11";
    public static final int NID_wap_wsg_idm_ecid_wtls12 = 745;
    public static final String SN_wap_wsg_idm_ecid_wtls12 = "wap-wsg-idm-ecid-wtls12";
    public static final String OBJ_wap_wsg_idm_ecid_wtls12 = "2.23.43.13.4.12";
    public static final int NID_any_policy = 746;
    public static final String SN_any_policy = "anyPolicy";
    public static final String LN_any_policy = "X509v3 Any Policy";
    public static final String OBJ_any_policy = "2.5.29.32.0";
    public static final int NID_policy_mappings = 747;
    public static final String SN_policy_mappings = "policyMappings";
    public static final String LN_policy_mappings = "X509v3 Policy Mappings";
    public static final String OBJ_policy_mappings = "2.5.29.33";
    public static final int NID_inhibit_any_policy = 748;
    public static final String SN_inhibit_any_policy = "inhibitAnyPolicy";
    public static final String LN_inhibit_any_policy = "X509v3 Inhibit Any Policy";
    public static final String OBJ_inhibit_any_policy = "2.5.29.54";
    public static final int NID_ipsec3 = 749;
    public static final String SN_ipsec3 = "Oakley-EC2N-3";
    public static final String LN_ipsec3 = "ipsec3";
    public static final int NID_ipsec4 = 750;
    public static final String SN_ipsec4 = "Oakley-EC2N-4";
    public static final String LN_ipsec4 = "ipsec4";

    static Integer obj2nid(String oid) {
        return ASN1Registry.obj2nid(new ASN1ObjectIdentifier(oid));
    }

    public static Integer obj2nid(ASN1ObjectIdentifier oid) {
        return OID_TO_NID.get(oid);
    }

    static String ln2oid(String ln) {
        ASN1ObjectIdentifier oid = ASN1Registry.sym2oid(ln);
        return oid == null ? null : oid.getId();
    }

    public static String o2a(String oid) {
        return ASN1Registry.o2a(new ASN1ObjectIdentifier(oid));
    }

    public static String o2a(ASN1ObjectIdentifier obj) {
        Integer nid = ASN1Registry.obj2nid(obj);
        String name = NID_TO_LN.get(nid);
        if (name == null) {
            name = NID_TO_SN.get(nid);
        }
        return name;
    }

    public static ASN1ObjectIdentifier sym2oid(String name) {
        return SYM_TO_OID.get(name.toLowerCase());
    }

    static int sym2nid(String name) {
        return OID_TO_NID.get(SYM_TO_OID.get(name.toLowerCase()));
    }

    static String nid2ln(int nid) {
        return NID_TO_LN.get(nid);
    }

    public static ASN1ObjectIdentifier nid2obj(int nid) {
        return NID_TO_OID.get(nid);
    }

    static String nid2ln(Integer nid) {
        return NID_TO_LN.get(nid);
    }

    private static ASN1ObjectIdentifier addObject(int nid, String sn, String ln, String oid) {
        ASN1ObjectIdentifier objectId = new ASN1ObjectIdentifier(oid);
        ASN1Registry.addObject((Integer)nid, sn, ln, objectId);
        return objectId;
    }

    private static void addObject(Integer nid, String sn, String ln, ASN1ObjectIdentifier oid) {
        if (sn != null) {
            SYM_TO_OID.put(sn.toLowerCase(), oid);
        }
        if (ln != null) {
            SYM_TO_OID.put(ln.toLowerCase(), oid);
        }
        OID_TO_SYM.put(oid, sn == null ? ln : sn);
        OID_TO_NID.put(oid, nid);
        NID_TO_OID.put(nid, oid);
        NID_TO_SN.put(nid, sn);
        NID_TO_LN.put(nid, ln);
    }

    private static void initObjects() {
        ASN1Registry.addObject(1, SN_rsadsi, LN_rsadsi, OBJ_rsadsi);
        ASN1Registry.addObject(2, SN_pkcs, LN_pkcs, OBJ_pkcs);
        ASN1Registry.addObject(3, SN_md2, LN_md2, OBJ_md2);
        ASN1Registry.addObject(4, SN_md5, LN_md5, OBJ_md5);
        ASN1Registry.addObject(5, SN_rc4, LN_rc4, OBJ_rc4);
        ASN1Registry.addObject((Integer)6, null, LN_rsaEncryption, OID_rsaEncryption);
        ASN1Registry.addObject(7, SN_md2WithRSAEncryption, LN_md2WithRSAEncryption, OBJ_md2WithRSAEncryption);
        ASN1Registry.addObject(8, SN_md5WithRSAEncryption, LN_md5WithRSAEncryption, OBJ_md5WithRSAEncryption);
        ASN1Registry.addObject(9, SN_pbeWithMD2AndDES_CBC, LN_pbeWithMD2AndDES_CBC, OBJ_pbeWithMD2AndDES_CBC);
        ASN1Registry.addObject(10, SN_pbeWithMD5AndDES_CBC, LN_pbeWithMD5AndDES_CBC, OBJ_pbeWithMD5AndDES_CBC);
        ASN1Registry.addObject(11, SN_X500, LN_X500, OBJ_X500);
        ASN1Registry.addObject(12, SN_X509, null, OBJ_X509);
        ASN1Registry.addObject(13, SN_commonName, LN_commonName, OBJ_commonName);
        ASN1Registry.addObject(14, SN_countryName, LN_countryName, OBJ_countryName);
        ASN1Registry.addObject(15, SN_localityName, LN_localityName, OBJ_localityName);
        ASN1Registry.addObject(16, SN_stateOrProvinceName, LN_stateOrProvinceName, OBJ_stateOrProvinceName);
        ASN1Registry.addObject(17, SN_organizationName, LN_organizationName, OBJ_organizationName);
        ASN1Registry.addObject(18, SN_organizationalUnitName, LN_organizationalUnitName, OBJ_organizationalUnitName);
        ASN1Registry.addObject(19, SN_rsa, LN_rsa, OBJ_rsa);
        ASN1Registry.addObject(20, SN_pkcs7, null, OBJ_pkcs7);
        ASN1Registry.addObject((Integer)21, null, LN_pkcs7_data, OID_pkcs7_data);
        ASN1Registry.addObject(22, null, LN_pkcs7_signed, OBJ_pkcs7_signed);
        ASN1Registry.addObject(23, null, LN_pkcs7_enveloped, OBJ_pkcs7_enveloped);
        ASN1Registry.addObject(24, null, LN_pkcs7_signedAndEnveloped, OBJ_pkcs7_signedAndEnveloped);
        ASN1Registry.addObject(25, null, LN_pkcs7_digest, OBJ_pkcs7_digest);
        ASN1Registry.addObject(26, null, LN_pkcs7_encrypted, OBJ_pkcs7_encrypted);
        ASN1Registry.addObject(27, SN_pkcs3, null, OBJ_pkcs3);
        ASN1Registry.addObject(28, null, LN_dhKeyAgreement, OBJ_dhKeyAgreement);
        ASN1Registry.addObject(29, SN_des_ecb, LN_des_ecb, OBJ_des_ecb);
        ASN1Registry.addObject(30, SN_des_cfb64, LN_des_cfb64, OBJ_des_cfb64);
        ASN1Registry.addObject((Integer)31, SN_des_cbc, LN_des_cbc, OID_des_cbc);
        ASN1Registry.addObject(32, SN_des_ede_ecb, LN_des_ede_ecb, OBJ_des_ede_ecb);
        ASN1Registry.addObject(34, SN_idea_cbc, LN_idea_cbc, OBJ_idea_cbc);
        ASN1Registry.addObject((Integer)37, SN_rc2_cbc, LN_rc2_cbc, OID_rc2_cbc);
        ASN1Registry.addObject(41, SN_sha, LN_sha, OBJ_sha);
        ASN1Registry.addObject(42, SN_shaWithRSAEncryption, LN_shaWithRSAEncryption, OBJ_shaWithRSAEncryption);
        ASN1Registry.addObject((Integer)44, SN_des_ede3_cbc, LN_des_ede3_cbc, OID_des_ede3_cbc);
        ASN1Registry.addObject(45, SN_des_ofb64, LN_des_ofb64, OBJ_des_ofb64);
        ASN1Registry.addObject(47, SN_pkcs9, null, OBJ_pkcs9);
        ASN1Registry.addObject(48, null, LN_pkcs9_emailAddress, OBJ_pkcs9_emailAddress);
        ASN1Registry.addObject(49, null, LN_pkcs9_unstructuredName, OBJ_pkcs9_unstructuredName);
        ASN1Registry.addObject(50, null, LN_pkcs9_contentType, OBJ_pkcs9_contentType);
        ASN1Registry.addObject(51, null, LN_pkcs9_messageDigest, OBJ_pkcs9_messageDigest);
        ASN1Registry.addObject(52, null, LN_pkcs9_signingTime, OBJ_pkcs9_signingTime);
        ASN1Registry.addObject(53, null, LN_pkcs9_countersignature, OBJ_pkcs9_countersignature);
        ASN1Registry.addObject(54, null, LN_pkcs9_challengePassword, OBJ_pkcs9_challengePassword);
        ASN1Registry.addObject(55, null, LN_pkcs9_unstructuredAddress, OBJ_pkcs9_unstructuredAddress);
        ASN1Registry.addObject(56, null, LN_pkcs9_extCertAttributes, OBJ_pkcs9_extCertAttributes);
        ASN1Registry.addObject(57, SN_netscape, LN_netscape, OBJ_netscape);
        ASN1Registry.addObject(58, SN_netscape_cert_extension, LN_netscape_cert_extension, OBJ_netscape_cert_extension);
        ASN1Registry.addObject(59, SN_netscape_data_type, LN_netscape_data_type, OBJ_netscape_data_type);
        ASN1Registry.addObject((Integer)64, SN_sha1, LN_sha1, OID_sha1);
        ASN1Registry.addObject(65, SN_sha1WithRSAEncryption, LN_sha1WithRSAEncryption, OBJ_sha1WithRSAEncryption);
        ASN1Registry.addObject(66, SN_dsaWithSHA, LN_dsaWithSHA, OBJ_dsaWithSHA);
        ASN1Registry.addObject(67, SN_dsa_2, LN_dsa_2, OBJ_dsa_2);
        ASN1Registry.addObject(68, SN_pbeWithSHA1AndRC2_CBC, LN_pbeWithSHA1AndRC2_CBC, OBJ_pbeWithSHA1AndRC2_CBC);
        ASN1Registry.addObject(69, null, LN_id_pbkdf2, OBJ_id_pbkdf2);
        ASN1Registry.addObject(70, SN_dsaWithSHA1_2, LN_dsaWithSHA1_2, OBJ_dsaWithSHA1_2);
        ASN1Registry.addObject(71, SN_netscape_cert_type, LN_netscape_cert_type, OBJ_netscape_cert_type);
        ASN1Registry.addObject(72, SN_netscape_base_url, LN_netscape_base_url, OBJ_netscape_base_url);
        ASN1Registry.addObject(73, SN_netscape_revocation_url, LN_netscape_revocation_url, OBJ_netscape_revocation_url);
        ASN1Registry.addObject(74, SN_netscape_ca_revocation_url, LN_netscape_ca_revocation_url, OBJ_netscape_ca_revocation_url);
        ASN1Registry.addObject(75, SN_netscape_renewal_url, LN_netscape_renewal_url, OBJ_netscape_renewal_url);
        ASN1Registry.addObject(76, SN_netscape_ca_policy_url, LN_netscape_ca_policy_url, OBJ_netscape_ca_policy_url);
        ASN1Registry.addObject(77, SN_netscape_ssl_server_name, LN_netscape_ssl_server_name, OBJ_netscape_ssl_server_name);
        ASN1Registry.addObject(78, SN_netscape_comment, LN_netscape_comment, OBJ_netscape_comment);
        ASN1Registry.addObject(79, SN_netscape_cert_sequence, LN_netscape_cert_sequence, OBJ_netscape_cert_sequence);
        ASN1Registry.addObject(81, SN_id_ce, null, OBJ_id_ce);
        ASN1Registry.addObject(82, SN_subject_key_identifier, LN_subject_key_identifier, OBJ_subject_key_identifier);
        ASN1Registry.addObject(83, SN_key_usage, LN_key_usage, OBJ_key_usage);
        ASN1Registry.addObject(84, SN_private_key_usage_period, LN_private_key_usage_period, OBJ_private_key_usage_period);
        ASN1Registry.addObject(85, SN_subject_alt_name, LN_subject_alt_name, OBJ_subject_alt_name);
        ASN1Registry.addObject(86, SN_issuer_alt_name, LN_issuer_alt_name, OBJ_issuer_alt_name);
        ASN1Registry.addObject(87, SN_basic_constraints, LN_basic_constraints, OBJ_basic_constraints);
        ASN1Registry.addObject(88, SN_crl_number, LN_crl_number, OBJ_crl_number);
        ASN1Registry.addObject(89, SN_certificate_policies, LN_certificate_policies, OBJ_certificate_policies);
        ASN1Registry.addObject(90, SN_authority_key_identifier, LN_authority_key_identifier, OBJ_authority_key_identifier);
        ASN1Registry.addObject(91, SN_bf_cbc, LN_bf_cbc, OBJ_bf_cbc);
        ASN1Registry.addObject(95, SN_mdc2, LN_mdc2, OBJ_mdc2);
        ASN1Registry.addObject(96, SN_mdc2WithRSA, LN_mdc2WithRSA, OBJ_mdc2WithRSA);
        ASN1Registry.addObject(98, SN_rc2_40_cbc, LN_rc2_40_cbc, "1.2.840.113549.3.2");
        ASN1Registry.addObject(99, SN_givenName, LN_givenName, OBJ_givenName);
        ASN1Registry.addObject(100, SN_surname, LN_surname, OBJ_surname);
        ASN1Registry.addObject(101, null, LN_initials, OBJ_initials);
        ASN1Registry.addObject(103, SN_crl_distribution_points, LN_crl_distribution_points, OBJ_crl_distribution_points);
        ASN1Registry.addObject(104, SN_md5WithRSA, LN_md5WithRSA, OBJ_md5WithRSA);
        ASN1Registry.addObject(105, null, LN_serialNumber, OBJ_serialNumber);
        ASN1Registry.addObject(106, null, LN_title, OBJ_title);
        ASN1Registry.addObject(107, null, LN_description, OBJ_description);
        ASN1Registry.addObject(108, SN_cast5_cbc, LN_cast5_cbc, OBJ_cast5_cbc);
        ASN1Registry.addObject(112, null, LN_pbeWithMD5AndCast5_CBC, OBJ_pbeWithMD5AndCast5_CBC);
        ASN1Registry.addObject(113, SN_dsaWithSHA1, LN_dsaWithSHA1, OBJ_dsaWithSHA1);
        ASN1Registry.addObject(115, SN_sha1WithRSA, LN_sha1WithRSA, OBJ_sha1WithRSA);
        ASN1Registry.addObject((Integer)116, SN_dsa, LN_dsa, OID_dsa);
        ASN1Registry.addObject(117, SN_ripemd160, LN_ripemd160, OBJ_ripemd160);
        ASN1Registry.addObject(119, SN_ripemd160WithRSA, LN_ripemd160WithRSA, OBJ_ripemd160WithRSA);
        ASN1Registry.addObject(120, SN_rc5_cbc, LN_rc5_cbc, OBJ_rc5_cbc);
        ASN1Registry.addObject(124, SN_rle_compression, LN_rle_compression, OBJ_rle_compression);
        ASN1Registry.addObject(125, SN_zlib_compression, LN_zlib_compression, OBJ_zlib_compression);
        ASN1Registry.addObject(126, SN_ext_key_usage, LN_ext_key_usage, OBJ_ext_key_usage);
        ASN1Registry.addObject(127, SN_id_pkix, null, OBJ_id_pkix);
        ASN1Registry.addObject(128, SN_id_kp, null, OBJ_id_kp);
        ASN1Registry.addObject(129, SN_server_auth, LN_server_auth, OBJ_server_auth);
        ASN1Registry.addObject(130, SN_client_auth, LN_client_auth, OBJ_client_auth);
        ASN1Registry.addObject(131, SN_code_sign, LN_code_sign, OBJ_code_sign);
        ASN1Registry.addObject(132, SN_email_protect, LN_email_protect, OBJ_email_protect);
        ASN1Registry.addObject(133, SN_time_stamp, LN_time_stamp, OBJ_time_stamp);
        ASN1Registry.addObject(134, SN_ms_code_ind, LN_ms_code_ind, OBJ_ms_code_ind);
        ASN1Registry.addObject(135, SN_ms_code_com, LN_ms_code_com, OBJ_ms_code_com);
        ASN1Registry.addObject(136, SN_ms_ctl_sign, LN_ms_ctl_sign, OBJ_ms_ctl_sign);
        ASN1Registry.addObject(137, SN_ms_sgc, LN_ms_sgc, OBJ_ms_sgc);
        ASN1Registry.addObject(138, SN_ms_efs, LN_ms_efs, OBJ_ms_efs);
        ASN1Registry.addObject(139, SN_ns_sgc, LN_ns_sgc, OBJ_ns_sgc);
        ASN1Registry.addObject(140, SN_delta_crl, LN_delta_crl, OBJ_delta_crl);
        ASN1Registry.addObject(141, SN_crl_reason, LN_crl_reason, OBJ_crl_reason);
        ASN1Registry.addObject(142, SN_invalidity_date, LN_invalidity_date, OBJ_invalidity_date);
        ASN1Registry.addObject(143, SN_sxnet, LN_sxnet, OBJ_sxnet);
        ASN1Registry.addObject(144, SN_pbe_WithSHA1And128BitRC4, LN_pbe_WithSHA1And128BitRC4, OBJ_pbe_WithSHA1And128BitRC4);
        ASN1Registry.addObject(145, SN_pbe_WithSHA1And40BitRC4, LN_pbe_WithSHA1And40BitRC4, OBJ_pbe_WithSHA1And40BitRC4);
        ASN1Registry.addObject(146, SN_pbe_WithSHA1And3_Key_TripleDES_CBC, LN_pbe_WithSHA1And3_Key_TripleDES_CBC, OBJ_pbe_WithSHA1And3_Key_TripleDES_CBC);
        ASN1Registry.addObject(147, SN_pbe_WithSHA1And2_Key_TripleDES_CBC, LN_pbe_WithSHA1And2_Key_TripleDES_CBC, OBJ_pbe_WithSHA1And2_Key_TripleDES_CBC);
        ASN1Registry.addObject(148, SN_pbe_WithSHA1And128BitRC2_CBC, LN_pbe_WithSHA1And128BitRC2_CBC, OBJ_pbe_WithSHA1And128BitRC2_CBC);
        ASN1Registry.addObject(149, SN_pbe_WithSHA1And40BitRC2_CBC, LN_pbe_WithSHA1And40BitRC2_CBC, OBJ_pbe_WithSHA1And40BitRC2_CBC);
        ASN1Registry.addObject(150, null, LN_keyBag, OBJ_keyBag);
        ASN1Registry.addObject(151, null, LN_pkcs8ShroudedKeyBag, OBJ_pkcs8ShroudedKeyBag);
        ASN1Registry.addObject(152, null, LN_certBag, OBJ_certBag);
        ASN1Registry.addObject(153, null, LN_crlBag, OBJ_crlBag);
        ASN1Registry.addObject(154, null, LN_secretBag, OBJ_secretBag);
        ASN1Registry.addObject(155, null, LN_safeContentsBag, OBJ_safeContentsBag);
        ASN1Registry.addObject(156, null, LN_friendlyName, OBJ_friendlyName);
        ASN1Registry.addObject(157, null, LN_localKeyID, OBJ_localKeyID);
        ASN1Registry.addObject(158, null, LN_x509Certificate, OBJ_x509Certificate);
        ASN1Registry.addObject(159, null, LN_sdsiCertificate, OBJ_sdsiCertificate);
        ASN1Registry.addObject(160, null, LN_x509Crl, OBJ_x509Crl);
        ASN1Registry.addObject(161, null, LN_pbes2, OBJ_pbes2);
        ASN1Registry.addObject(162, null, LN_pbmac1, OBJ_pbmac1);
        ASN1Registry.addObject(163, null, LN_hmacWithSHA1, OBJ_hmacWithSHA1);
        ASN1Registry.addObject(164, SN_id_qt_cps, LN_id_qt_cps, OBJ_id_qt_cps);
        ASN1Registry.addObject(165, SN_id_qt_unotice, LN_id_qt_unotice, OBJ_id_qt_unotice);
        ASN1Registry.addObject(167, SN_SMIMECapabilities, LN_SMIMECapabilities, OBJ_SMIMECapabilities);
        ASN1Registry.addObject(168, SN_pbeWithMD2AndRC2_CBC, LN_pbeWithMD2AndRC2_CBC, OBJ_pbeWithMD2AndRC2_CBC);
        ASN1Registry.addObject(169, SN_pbeWithMD5AndRC2_CBC, LN_pbeWithMD5AndRC2_CBC, OBJ_pbeWithMD5AndRC2_CBC);
        ASN1Registry.addObject(170, SN_pbeWithSHA1AndDES_CBC, LN_pbeWithSHA1AndDES_CBC, OBJ_pbeWithSHA1AndDES_CBC);
        ASN1Registry.addObject(171, SN_ms_ext_req, LN_ms_ext_req, OBJ_ms_ext_req);
        ASN1Registry.addObject(172, SN_ext_req, LN_ext_req, OBJ_ext_req);
        ASN1Registry.addObject(173, "name", "name", OBJ_name);
        ASN1Registry.addObject(174, "dnQualifier", "dnQualifier", OBJ_dnQualifier);
        ASN1Registry.addObject(175, SN_id_pe, null, OBJ_id_pe);
        ASN1Registry.addObject(176, SN_id_ad, null, OBJ_id_ad);
        ASN1Registry.addObject(177, SN_info_access, LN_info_access, OBJ_info_access);
        ASN1Registry.addObject(178, "OCSP", "OCSP", "1.3.6.1.5.5.7.48.1");
        ASN1Registry.addObject(179, SN_ad_ca_issuers, LN_ad_ca_issuers, OBJ_ad_ca_issuers);
        ASN1Registry.addObject(180, SN_OCSP_sign, LN_OCSP_sign, OBJ_OCSP_sign);
        ASN1Registry.addObject(182, SN_member_body, LN_member_body, OBJ_member_body);
        ASN1Registry.addObject(183, SN_ISO_US, LN_ISO_US, OBJ_ISO_US);
        ASN1Registry.addObject(184, SN_X9_57, LN_X9_57, OBJ_X9_57);
        ASN1Registry.addObject(185, SN_X9cm, LN_X9cm, OBJ_X9cm);
        ASN1Registry.addObject(186, SN_pkcs1, null, OBJ_pkcs1);
        ASN1Registry.addObject(187, SN_pkcs5, null, OBJ_pkcs5);
        ASN1Registry.addObject(188, SN_SMIME, LN_SMIME, OBJ_SMIME);
        ASN1Registry.addObject(189, SN_id_smime_mod, null, OBJ_id_smime_mod);
        ASN1Registry.addObject(190, SN_id_smime_ct, null, OBJ_id_smime_ct);
        ASN1Registry.addObject(191, SN_id_smime_aa, null, OBJ_id_smime_aa);
        ASN1Registry.addObject(192, SN_id_smime_alg, null, OBJ_id_smime_alg);
        ASN1Registry.addObject(193, SN_id_smime_cd, null, OBJ_id_smime_cd);
        ASN1Registry.addObject(194, SN_id_smime_spq, null, OBJ_id_smime_spq);
        ASN1Registry.addObject(195, SN_id_smime_cti, null, OBJ_id_smime_cti);
        ASN1Registry.addObject(196, SN_id_smime_mod_cms, null, OBJ_id_smime_mod_cms);
        ASN1Registry.addObject(197, SN_id_smime_mod_ess, null, OBJ_id_smime_mod_ess);
        ASN1Registry.addObject(198, SN_id_smime_mod_oid, null, OBJ_id_smime_mod_oid);
        ASN1Registry.addObject(199, SN_id_smime_mod_msg_v3, null, OBJ_id_smime_mod_msg_v3);
        ASN1Registry.addObject(200, SN_id_smime_mod_ets_eSignature_88, null, OBJ_id_smime_mod_ets_eSignature_88);
        ASN1Registry.addObject(201, SN_id_smime_mod_ets_eSignature_97, null, OBJ_id_smime_mod_ets_eSignature_97);
        ASN1Registry.addObject(202, SN_id_smime_mod_ets_eSigPolicy_88, null, OBJ_id_smime_mod_ets_eSigPolicy_88);
        ASN1Registry.addObject(203, SN_id_smime_mod_ets_eSigPolicy_97, null, OBJ_id_smime_mod_ets_eSigPolicy_97);
        ASN1Registry.addObject(204, SN_id_smime_ct_receipt, null, OBJ_id_smime_ct_receipt);
        ASN1Registry.addObject(205, SN_id_smime_ct_authData, null, OBJ_id_smime_ct_authData);
        ASN1Registry.addObject(206, SN_id_smime_ct_publishCert, null, OBJ_id_smime_ct_publishCert);
        ASN1Registry.addObject(207, SN_id_smime_ct_TSTInfo, null, OBJ_id_smime_ct_TSTInfo);
        ASN1Registry.addObject(208, SN_id_smime_ct_TDTInfo, null, OBJ_id_smime_ct_TDTInfo);
        ASN1Registry.addObject(209, SN_id_smime_ct_contentInfo, null, OBJ_id_smime_ct_contentInfo);
        ASN1Registry.addObject(210, SN_id_smime_ct_DVCSRequestData, null, OBJ_id_smime_ct_DVCSRequestData);
        ASN1Registry.addObject(211, SN_id_smime_ct_DVCSResponseData, null, OBJ_id_smime_ct_DVCSResponseData);
        ASN1Registry.addObject(212, SN_id_smime_aa_receiptRequest, null, OBJ_id_smime_aa_receiptRequest);
        ASN1Registry.addObject(213, SN_id_smime_aa_securityLabel, null, OBJ_id_smime_aa_securityLabel);
        ASN1Registry.addObject(214, SN_id_smime_aa_mlExpandHistory, null, OBJ_id_smime_aa_mlExpandHistory);
        ASN1Registry.addObject(215, SN_id_smime_aa_contentHint, null, OBJ_id_smime_aa_contentHint);
        ASN1Registry.addObject(216, SN_id_smime_aa_msgSigDigest, null, OBJ_id_smime_aa_msgSigDigest);
        ASN1Registry.addObject(217, SN_id_smime_aa_encapContentType, null, OBJ_id_smime_aa_encapContentType);
        ASN1Registry.addObject(218, SN_id_smime_aa_contentIdentifier, null, OBJ_id_smime_aa_contentIdentifier);
        ASN1Registry.addObject(219, SN_id_smime_aa_macValue, null, OBJ_id_smime_aa_macValue);
        ASN1Registry.addObject(220, SN_id_smime_aa_equivalentLabels, null, OBJ_id_smime_aa_equivalentLabels);
        ASN1Registry.addObject(221, SN_id_smime_aa_contentReference, null, OBJ_id_smime_aa_contentReference);
        ASN1Registry.addObject(222, SN_id_smime_aa_encrypKeyPref, null, OBJ_id_smime_aa_encrypKeyPref);
        ASN1Registry.addObject(223, SN_id_smime_aa_signingCertificate, null, OBJ_id_smime_aa_signingCertificate);
        ASN1Registry.addObject(224, SN_id_smime_aa_smimeEncryptCerts, null, OBJ_id_smime_aa_smimeEncryptCerts);
        ASN1Registry.addObject(225, SN_id_smime_aa_timeStampToken, null, OBJ_id_smime_aa_timeStampToken);
        ASN1Registry.addObject(226, SN_id_smime_aa_ets_sigPolicyId, null, OBJ_id_smime_aa_ets_sigPolicyId);
        ASN1Registry.addObject(227, SN_id_smime_aa_ets_commitmentType, null, OBJ_id_smime_aa_ets_commitmentType);
        ASN1Registry.addObject(228, SN_id_smime_aa_ets_signerLocation, null, OBJ_id_smime_aa_ets_signerLocation);
        ASN1Registry.addObject(229, SN_id_smime_aa_ets_signerAttr, null, OBJ_id_smime_aa_ets_signerAttr);
        ASN1Registry.addObject(230, SN_id_smime_aa_ets_otherSigCert, null, OBJ_id_smime_aa_ets_otherSigCert);
        ASN1Registry.addObject(231, SN_id_smime_aa_ets_contentTimestamp, null, OBJ_id_smime_aa_ets_contentTimestamp);
        ASN1Registry.addObject(232, SN_id_smime_aa_ets_CertificateRefs, null, OBJ_id_smime_aa_ets_CertificateRefs);
        ASN1Registry.addObject(233, SN_id_smime_aa_ets_RevocationRefs, null, OBJ_id_smime_aa_ets_RevocationRefs);
        ASN1Registry.addObject(234, SN_id_smime_aa_ets_certValues, null, OBJ_id_smime_aa_ets_certValues);
        ASN1Registry.addObject(235, SN_id_smime_aa_ets_revocationValues, null, OBJ_id_smime_aa_ets_revocationValues);
        ASN1Registry.addObject(236, SN_id_smime_aa_ets_escTimeStamp, null, OBJ_id_smime_aa_ets_escTimeStamp);
        ASN1Registry.addObject(237, SN_id_smime_aa_ets_certCRLTimestamp, null, OBJ_id_smime_aa_ets_certCRLTimestamp);
        ASN1Registry.addObject(238, SN_id_smime_aa_ets_archiveTimeStamp, null, OBJ_id_smime_aa_ets_archiveTimeStamp);
        ASN1Registry.addObject(239, SN_id_smime_aa_signatureType, null, OBJ_id_smime_aa_signatureType);
        ASN1Registry.addObject(240, SN_id_smime_aa_dvcs_dvc, null, OBJ_id_smime_aa_dvcs_dvc);
        ASN1Registry.addObject(241, SN_id_smime_alg_ESDHwith3DES, null, OBJ_id_smime_alg_ESDHwith3DES);
        ASN1Registry.addObject(242, SN_id_smime_alg_ESDHwithRC2, null, OBJ_id_smime_alg_ESDHwithRC2);
        ASN1Registry.addObject(243, SN_id_smime_alg_3DESwrap, null, OBJ_id_smime_alg_3DESwrap);
        ASN1Registry.addObject(244, SN_id_smime_alg_RC2wrap, null, OBJ_id_smime_alg_RC2wrap);
        ASN1Registry.addObject(245, SN_id_smime_alg_ESDH, null, OBJ_id_smime_alg_ESDH);
        ASN1Registry.addObject(246, SN_id_smime_alg_CMS3DESwrap, null, OBJ_id_smime_alg_CMS3DESwrap);
        ASN1Registry.addObject(247, SN_id_smime_alg_CMSRC2wrap, null, OBJ_id_smime_alg_CMSRC2wrap);
        ASN1Registry.addObject(248, SN_id_smime_cd_ldap, null, OBJ_id_smime_cd_ldap);
        ASN1Registry.addObject(249, SN_id_smime_spq_ets_sqt_uri, null, OBJ_id_smime_spq_ets_sqt_uri);
        ASN1Registry.addObject(250, SN_id_smime_spq_ets_sqt_unotice, null, OBJ_id_smime_spq_ets_sqt_unotice);
        ASN1Registry.addObject(251, SN_id_smime_cti_ets_proofOfOrigin, null, OBJ_id_smime_cti_ets_proofOfOrigin);
        ASN1Registry.addObject(252, SN_id_smime_cti_ets_proofOfReceipt, null, OBJ_id_smime_cti_ets_proofOfReceipt);
        ASN1Registry.addObject(253, SN_id_smime_cti_ets_proofOfDelivery, null, OBJ_id_smime_cti_ets_proofOfDelivery);
        ASN1Registry.addObject(254, SN_id_smime_cti_ets_proofOfSender, null, OBJ_id_smime_cti_ets_proofOfSender);
        ASN1Registry.addObject(255, SN_id_smime_cti_ets_proofOfApproval, null, OBJ_id_smime_cti_ets_proofOfApproval);
        ASN1Registry.addObject(256, SN_id_smime_cti_ets_proofOfCreation, null, OBJ_id_smime_cti_ets_proofOfCreation);
        ASN1Registry.addObject(257, SN_md4, LN_md4, OBJ_md4);
        ASN1Registry.addObject(258, SN_id_pkix_mod, null, OBJ_id_pkix_mod);
        ASN1Registry.addObject(259, SN_id_qt, null, OBJ_id_qt);
        ASN1Registry.addObject(260, SN_id_it, null, OBJ_id_it);
        ASN1Registry.addObject(261, SN_id_pkip, null, OBJ_id_pkip);
        ASN1Registry.addObject(262, SN_id_alg, null, OBJ_id_alg);
        ASN1Registry.addObject(263, SN_id_cmc, null, OBJ_id_cmc);
        ASN1Registry.addObject(264, SN_id_on, null, OBJ_id_on);
        ASN1Registry.addObject(265, SN_id_pda, null, OBJ_id_pda);
        ASN1Registry.addObject(266, SN_id_aca, null, OBJ_id_aca);
        ASN1Registry.addObject(267, SN_id_qcs, null, OBJ_id_qcs);
        ASN1Registry.addObject(268, SN_id_cct, null, OBJ_id_cct);
        ASN1Registry.addObject(269, SN_id_pkix1_explicit_88, null, OBJ_id_pkix1_explicit_88);
        ASN1Registry.addObject(270, SN_id_pkix1_implicit_88, null, OBJ_id_pkix1_implicit_88);
        ASN1Registry.addObject(271, SN_id_pkix1_explicit_93, null, OBJ_id_pkix1_explicit_93);
        ASN1Registry.addObject(272, SN_id_pkix1_implicit_93, null, OBJ_id_pkix1_implicit_93);
        ASN1Registry.addObject(273, SN_id_mod_crmf, null, OBJ_id_mod_crmf);
        ASN1Registry.addObject(274, SN_id_mod_cmc, null, OBJ_id_mod_cmc);
        ASN1Registry.addObject(275, SN_id_mod_kea_profile_88, null, OBJ_id_mod_kea_profile_88);
        ASN1Registry.addObject(276, SN_id_mod_kea_profile_93, null, OBJ_id_mod_kea_profile_93);
        ASN1Registry.addObject(277, SN_id_mod_cmp, null, OBJ_id_mod_cmp);
        ASN1Registry.addObject(278, SN_id_mod_qualified_cert_88, null, OBJ_id_mod_qualified_cert_88);
        ASN1Registry.addObject(279, SN_id_mod_qualified_cert_93, null, OBJ_id_mod_qualified_cert_93);
        ASN1Registry.addObject(280, SN_id_mod_attribute_cert, null, OBJ_id_mod_attribute_cert);
        ASN1Registry.addObject(281, SN_id_mod_timestamp_protocol, null, OBJ_id_mod_timestamp_protocol);
        ASN1Registry.addObject(282, SN_id_mod_ocsp, null, OBJ_id_mod_ocsp);
        ASN1Registry.addObject(283, SN_id_mod_dvcs, null, OBJ_id_mod_dvcs);
        ASN1Registry.addObject(284, SN_id_mod_cmp2000, null, OBJ_id_mod_cmp2000);
        ASN1Registry.addObject(285, SN_biometricInfo, LN_biometricInfo, OBJ_biometricInfo);
        ASN1Registry.addObject(286, SN_qcStatements, null, OBJ_qcStatements);
        ASN1Registry.addObject(287, SN_ac_auditEntity, null, OBJ_ac_auditEntity);
        ASN1Registry.addObject(288, SN_ac_targeting, null, OBJ_ac_targeting);
        ASN1Registry.addObject(289, SN_aaControls, null, OBJ_aaControls);
        ASN1Registry.addObject(290, SN_sbgp_ipAddrBlock, null, OBJ_sbgp_ipAddrBlock);
        ASN1Registry.addObject(291, SN_sbgp_autonomousSysNum, null, OBJ_sbgp_autonomousSysNum);
        ASN1Registry.addObject(292, SN_sbgp_routerIdentifier, null, OBJ_sbgp_routerIdentifier);
        ASN1Registry.addObject(293, SN_textNotice, null, OBJ_textNotice);
        ASN1Registry.addObject(294, SN_ipsecEndSystem, LN_ipsecEndSystem, OBJ_ipsecEndSystem);
        ASN1Registry.addObject(295, SN_ipsecTunnel, LN_ipsecTunnel, OBJ_ipsecTunnel);
        ASN1Registry.addObject(296, SN_ipsecUser, LN_ipsecUser, OBJ_ipsecUser);
        ASN1Registry.addObject(297, SN_dvcs, LN_dvcs, OBJ_dvcs);
        ASN1Registry.addObject(298, SN_id_it_caProtEncCert, null, OBJ_id_it_caProtEncCert);
        ASN1Registry.addObject(299, SN_id_it_signKeyPairTypes, null, OBJ_id_it_signKeyPairTypes);
        ASN1Registry.addObject(300, SN_id_it_encKeyPairTypes, null, OBJ_id_it_encKeyPairTypes);
        ASN1Registry.addObject(301, SN_id_it_preferredSymmAlg, null, OBJ_id_it_preferredSymmAlg);
        ASN1Registry.addObject(302, SN_id_it_caKeyUpdateInfo, null, OBJ_id_it_caKeyUpdateInfo);
        ASN1Registry.addObject(303, SN_id_it_currentCRL, null, OBJ_id_it_currentCRL);
        ASN1Registry.addObject(304, SN_id_it_unsupportedOIDs, null, OBJ_id_it_unsupportedOIDs);
        ASN1Registry.addObject(305, SN_id_it_subscriptionRequest, null, OBJ_id_it_subscriptionRequest);
        ASN1Registry.addObject(306, SN_id_it_subscriptionResponse, null, OBJ_id_it_subscriptionResponse);
        ASN1Registry.addObject(307, SN_id_it_keyPairParamReq, null, OBJ_id_it_keyPairParamReq);
        ASN1Registry.addObject(308, SN_id_it_keyPairParamRep, null, OBJ_id_it_keyPairParamRep);
        ASN1Registry.addObject(309, SN_id_it_revPassphrase, null, OBJ_id_it_revPassphrase);
        ASN1Registry.addObject(310, SN_id_it_implicitConfirm, null, OBJ_id_it_implicitConfirm);
        ASN1Registry.addObject(311, SN_id_it_confirmWaitTime, null, OBJ_id_it_confirmWaitTime);
        ASN1Registry.addObject(312, SN_id_it_origPKIMessage, null, OBJ_id_it_origPKIMessage);
        ASN1Registry.addObject(313, SN_id_regCtrl, null, OBJ_id_regCtrl);
        ASN1Registry.addObject(314, SN_id_regInfo, null, OBJ_id_regInfo);
        ASN1Registry.addObject(315, SN_id_regCtrl_regToken, null, OBJ_id_regCtrl_regToken);
        ASN1Registry.addObject(316, SN_id_regCtrl_authenticator, null, OBJ_id_regCtrl_authenticator);
        ASN1Registry.addObject(317, SN_id_regCtrl_pkiPublicationInfo, null, OBJ_id_regCtrl_pkiPublicationInfo);
        ASN1Registry.addObject(318, SN_id_regCtrl_pkiArchiveOptions, null, OBJ_id_regCtrl_pkiArchiveOptions);
        ASN1Registry.addObject(319, SN_id_regCtrl_oldCertID, null, OBJ_id_regCtrl_oldCertID);
        ASN1Registry.addObject(320, SN_id_regCtrl_protocolEncrKey, null, OBJ_id_regCtrl_protocolEncrKey);
        ASN1Registry.addObject(321, SN_id_regInfo_utf8Pairs, null, OBJ_id_regInfo_utf8Pairs);
        ASN1Registry.addObject(322, SN_id_regInfo_certReq, null, OBJ_id_regInfo_certReq);
        ASN1Registry.addObject(323, SN_id_alg_des40, null, OBJ_id_alg_des40);
        ASN1Registry.addObject(324, SN_id_alg_noSignature, null, OBJ_id_alg_noSignature);
        ASN1Registry.addObject(325, SN_id_alg_dh_sig_hmac_sha1, null, OBJ_id_alg_dh_sig_hmac_sha1);
        ASN1Registry.addObject(326, SN_id_alg_dh_pop, null, OBJ_id_alg_dh_pop);
        ASN1Registry.addObject(327, SN_id_cmc_statusInfo, null, OBJ_id_cmc_statusInfo);
        ASN1Registry.addObject(328, SN_id_cmc_identification, null, OBJ_id_cmc_identification);
        ASN1Registry.addObject(329, SN_id_cmc_identityProof, null, OBJ_id_cmc_identityProof);
        ASN1Registry.addObject(330, SN_id_cmc_dataReturn, null, OBJ_id_cmc_dataReturn);
        ASN1Registry.addObject(331, SN_id_cmc_transactionId, null, OBJ_id_cmc_transactionId);
        ASN1Registry.addObject(332, SN_id_cmc_senderNonce, null, OBJ_id_cmc_senderNonce);
        ASN1Registry.addObject(333, SN_id_cmc_recipientNonce, null, OBJ_id_cmc_recipientNonce);
        ASN1Registry.addObject(334, SN_id_cmc_addExtensions, null, OBJ_id_cmc_addExtensions);
        ASN1Registry.addObject(335, SN_id_cmc_encryptedPOP, null, OBJ_id_cmc_encryptedPOP);
        ASN1Registry.addObject(336, SN_id_cmc_decryptedPOP, null, OBJ_id_cmc_decryptedPOP);
        ASN1Registry.addObject(337, SN_id_cmc_lraPOPWitness, null, OBJ_id_cmc_lraPOPWitness);
        ASN1Registry.addObject(338, SN_id_cmc_getCert, null, OBJ_id_cmc_getCert);
        ASN1Registry.addObject(339, SN_id_cmc_getCRL, null, OBJ_id_cmc_getCRL);
        ASN1Registry.addObject(340, SN_id_cmc_revokeRequest, null, OBJ_id_cmc_revokeRequest);
        ASN1Registry.addObject(341, SN_id_cmc_regInfo, null, OBJ_id_cmc_regInfo);
        ASN1Registry.addObject(342, SN_id_cmc_responseInfo, null, OBJ_id_cmc_responseInfo);
        ASN1Registry.addObject(343, SN_id_cmc_queryPending, null, OBJ_id_cmc_queryPending);
        ASN1Registry.addObject(344, SN_id_cmc_popLinkRandom, null, OBJ_id_cmc_popLinkRandom);
        ASN1Registry.addObject(345, SN_id_cmc_popLinkWitness, null, OBJ_id_cmc_popLinkWitness);
        ASN1Registry.addObject(346, SN_id_cmc_confirmCertAcceptance, null, OBJ_id_cmc_confirmCertAcceptance);
        ASN1Registry.addObject(347, SN_id_on_personalData, null, OBJ_id_on_personalData);
        ASN1Registry.addObject(348, SN_id_pda_dateOfBirth, null, OBJ_id_pda_dateOfBirth);
        ASN1Registry.addObject(349, SN_id_pda_placeOfBirth, null, OBJ_id_pda_placeOfBirth);
        ASN1Registry.addObject(351, SN_id_pda_gender, null, OBJ_id_pda_gender);
        ASN1Registry.addObject(352, SN_id_pda_countryOfCitizenship, null, OBJ_id_pda_countryOfCitizenship);
        ASN1Registry.addObject(353, SN_id_pda_countryOfResidence, null, OBJ_id_pda_countryOfResidence);
        ASN1Registry.addObject(354, SN_id_aca_authenticationInfo, null, OBJ_id_aca_authenticationInfo);
        ASN1Registry.addObject(355, SN_id_aca_accessIdentity, null, OBJ_id_aca_accessIdentity);
        ASN1Registry.addObject(356, SN_id_aca_chargingIdentity, null, OBJ_id_aca_chargingIdentity);
        ASN1Registry.addObject(357, SN_id_aca_group, null, OBJ_id_aca_group);
        ASN1Registry.addObject(358, SN_id_aca_role, null, OBJ_id_aca_role);
        ASN1Registry.addObject(359, SN_id_qcs_pkixQCSyntax_v1, null, OBJ_id_qcs_pkixQCSyntax_v1);
        ASN1Registry.addObject(360, SN_id_cct_crs, null, OBJ_id_cct_crs);
        ASN1Registry.addObject(361, SN_id_cct_PKIData, null, OBJ_id_cct_PKIData);
        ASN1Registry.addObject(362, SN_id_cct_PKIResponse, null, OBJ_id_cct_PKIResponse);
        ASN1Registry.addObject(363, SN_ad_timeStamping, LN_ad_timeStamping, OBJ_ad_timeStamping);
        ASN1Registry.addObject(364, SN_ad_dvcs, LN_ad_dvcs, OBJ_ad_dvcs);
        ASN1Registry.addObject(365, SN_id_pkix_OCSP_basic, LN_id_pkix_OCSP_basic, OBJ_id_pkix_OCSP_basic);
        ASN1Registry.addObject(366, SN_id_pkix_OCSP_Nonce, LN_id_pkix_OCSP_Nonce, OBJ_id_pkix_OCSP_Nonce);
        ASN1Registry.addObject(367, SN_id_pkix_OCSP_CrlID, LN_id_pkix_OCSP_CrlID, OBJ_id_pkix_OCSP_CrlID);
        ASN1Registry.addObject(368, SN_id_pkix_OCSP_acceptableResponses, LN_id_pkix_OCSP_acceptableResponses, OBJ_id_pkix_OCSP_acceptableResponses);
        ASN1Registry.addObject(369, SN_id_pkix_OCSP_noCheck, LN_id_pkix_OCSP_noCheck, OBJ_id_pkix_OCSP_noCheck);
        ASN1Registry.addObject(370, SN_id_pkix_OCSP_archiveCutoff, LN_id_pkix_OCSP_archiveCutoff, OBJ_id_pkix_OCSP_archiveCutoff);
        ASN1Registry.addObject(371, SN_id_pkix_OCSP_serviceLocator, LN_id_pkix_OCSP_serviceLocator, OBJ_id_pkix_OCSP_serviceLocator);
        ASN1Registry.addObject(372, SN_id_pkix_OCSP_extendedStatus, LN_id_pkix_OCSP_extendedStatus, OBJ_id_pkix_OCSP_extendedStatus);
        ASN1Registry.addObject(373, SN_id_pkix_OCSP_valid, null, OBJ_id_pkix_OCSP_valid);
        ASN1Registry.addObject(374, SN_id_pkix_OCSP_path, null, OBJ_id_pkix_OCSP_path);
        ASN1Registry.addObject(375, SN_id_pkix_OCSP_trustRoot, LN_id_pkix_OCSP_trustRoot, OBJ_id_pkix_OCSP_trustRoot);
        ASN1Registry.addObject(376, "algorithm", "algorithm", OBJ_algorithm);
        ASN1Registry.addObject(377, SN_rsaSignature, null, OBJ_rsaSignature);
        ASN1Registry.addObject(378, SN_X500algorithms, LN_X500algorithms, OBJ_X500algorithms);
        ASN1Registry.addObject(379, SN_org, LN_org, "1.3");
        ASN1Registry.addObject(380, SN_dod, LN_dod, OBJ_dod);
        ASN1Registry.addObject(381, SN_iana, LN_iana, "1.3.6.1");
        ASN1Registry.addObject(382, SN_Directory, LN_Directory, OBJ_Directory);
        ASN1Registry.addObject(383, SN_Management, LN_Management, OBJ_Management);
        ASN1Registry.addObject(384, SN_Experimental, LN_Experimental, OBJ_Experimental);
        ASN1Registry.addObject(385, SN_Private, LN_Private, OBJ_Private);
        ASN1Registry.addObject(386, SN_Security, LN_Security, OBJ_Security);
        ASN1Registry.addObject(387, SN_SNMPv2, LN_SNMPv2, OBJ_SNMPv2);
        ASN1Registry.addObject(388, null, LN_Mail, OBJ_Mail);
        ASN1Registry.addObject(389, SN_Enterprises, LN_Enterprises, OBJ_Enterprises);
        ASN1Registry.addObject(390, SN_dcObject, LN_dcObject, OBJ_dcObject);
        ASN1Registry.addObject(391, SN_domainComponent, LN_domainComponent, OBJ_domainComponent);
        ASN1Registry.addObject(392, SN_Domain, LN_Domain, OBJ_Domain);
        ASN1Registry.addObject(394, SN_selected_attribute_types, LN_selected_attribute_types, OBJ_selected_attribute_types);
        ASN1Registry.addObject(395, SN_clearance, null, OBJ_clearance);
        ASN1Registry.addObject(396, SN_md4WithRSAEncryption, LN_md4WithRSAEncryption, OBJ_md4WithRSAEncryption);
        ASN1Registry.addObject(397, SN_ac_proxying, null, OBJ_ac_proxying);
        ASN1Registry.addObject(398, SN_sinfo_access, LN_sinfo_access, OBJ_sinfo_access);
        ASN1Registry.addObject(399, SN_id_aca_encAttrs, null, OBJ_id_aca_encAttrs);
        ASN1Registry.addObject(400, "role", "role", OBJ_role);
        ASN1Registry.addObject(401, SN_policy_constraints, LN_policy_constraints, OBJ_policy_constraints);
        ASN1Registry.addObject(402, SN_target_information, LN_target_information, OBJ_target_information);
        ASN1Registry.addObject(403, SN_no_rev_avail, LN_no_rev_avail, OBJ_no_rev_avail);
        ASN1Registry.addObject(405, SN_ansi_X9_62, LN_ansi_X9_62, OBJ_ansi_X9_62);
        ASN1Registry.addObject(406, SN_X9_62_prime_field, null, OBJ_X9_62_prime_field);
        ASN1Registry.addObject(407, SN_X9_62_characteristic_two_field, null, OBJ_X9_62_characteristic_two_field);
        ASN1Registry.addObject(408, SN_X9_62_id_ecPublicKey, null, OBJ_X9_62_id_ecPublicKey);
        ASN1Registry.addObject(409, SN_X9_62_prime192v1, null, OBJ_X9_62_prime192v1);
        ASN1Registry.addObject(410, SN_X9_62_prime192v2, null, OBJ_X9_62_prime192v2);
        ASN1Registry.addObject(411, SN_X9_62_prime192v3, null, OBJ_X9_62_prime192v3);
        ASN1Registry.addObject(412, SN_X9_62_prime239v1, null, OBJ_X9_62_prime239v1);
        ASN1Registry.addObject(413, SN_X9_62_prime239v2, null, OBJ_X9_62_prime239v2);
        ASN1Registry.addObject(414, SN_X9_62_prime239v3, null, OBJ_X9_62_prime239v3);
        ASN1Registry.addObject(415, SN_X9_62_prime256v1, null, OBJ_X9_62_prime256v1);
        ASN1Registry.addObject((Integer)416, SN_ecdsa_with_SHA1, null, OID_ecdsa_with_SHA1);
        ASN1Registry.addObject(417, SN_ms_csp_name, LN_ms_csp_name, OBJ_ms_csp_name);
        ASN1Registry.addObject(418, SN_aes_128_ecb, LN_aes_128_ecb, OBJ_aes_128_ecb);
        ASN1Registry.addObject(419, SN_aes_128_cbc, LN_aes_128_cbc, OBJ_aes_128_cbc);
        ASN1Registry.addObject(420, SN_aes_128_ofb128, LN_aes_128_ofb128, OBJ_aes_128_ofb128);
        ASN1Registry.addObject(421, SN_aes_128_cfb128, LN_aes_128_cfb128, OBJ_aes_128_cfb128);
        ASN1Registry.addObject(422, SN_aes_192_ecb, LN_aes_192_ecb, OBJ_aes_192_ecb);
        ASN1Registry.addObject(423, SN_aes_192_cbc, LN_aes_192_cbc, OBJ_aes_192_cbc);
        ASN1Registry.addObject(424, SN_aes_192_ofb128, LN_aes_192_ofb128, OBJ_aes_192_ofb128);
        ASN1Registry.addObject(425, SN_aes_192_cfb128, LN_aes_192_cfb128, OBJ_aes_192_cfb128);
        ASN1Registry.addObject(426, SN_aes_256_ecb, LN_aes_256_ecb, OBJ_aes_256_ecb);
        ASN1Registry.addObject(427, SN_aes_256_cbc, LN_aes_256_cbc, OBJ_aes_256_cbc);
        ASN1Registry.addObject(428, SN_aes_256_ofb128, LN_aes_256_ofb128, OBJ_aes_256_ofb128);
        ASN1Registry.addObject(429, SN_aes_256_cfb128, LN_aes_256_cfb128, OBJ_aes_256_cfb128);
        ASN1Registry.addObject(430, SN_hold_instruction_code, LN_hold_instruction_code, OBJ_hold_instruction_code);
        ASN1Registry.addObject(431, SN_hold_instruction_none, LN_hold_instruction_none, OBJ_hold_instruction_none);
        ASN1Registry.addObject(432, SN_hold_instruction_call_issuer, LN_hold_instruction_call_issuer, OBJ_hold_instruction_call_issuer);
        ASN1Registry.addObject(433, SN_hold_instruction_reject, LN_hold_instruction_reject, OBJ_hold_instruction_reject);
        ASN1Registry.addObject(434, SN_data, null, OBJ_data);
        ASN1Registry.addObject(435, SN_pss, null, OBJ_pss);
        ASN1Registry.addObject(436, SN_ucl, null, OBJ_ucl);
        ASN1Registry.addObject(437, SN_pilot, null, OBJ_pilot);
        ASN1Registry.addObject(438, null, LN_pilotAttributeType, OBJ_pilotAttributeType);
        ASN1Registry.addObject(439, null, LN_pilotAttributeSyntax, OBJ_pilotAttributeSyntax);
        ASN1Registry.addObject(440, null, LN_pilotObjectClass, OBJ_pilotObjectClass);
        ASN1Registry.addObject(441, null, LN_pilotGroups, OBJ_pilotGroups);
        ASN1Registry.addObject(442, null, LN_iA5StringSyntax, OBJ_iA5StringSyntax);
        ASN1Registry.addObject(443, null, LN_caseIgnoreIA5StringSyntax, OBJ_caseIgnoreIA5StringSyntax);
        ASN1Registry.addObject(444, null, LN_pilotObject, OBJ_pilotObject);
        ASN1Registry.addObject(445, null, LN_pilotPerson, OBJ_pilotPerson);
        ASN1Registry.addObject(446, SN_account, null, OBJ_account);
        ASN1Registry.addObject(447, SN_document, null, OBJ_document);
        ASN1Registry.addObject(448, SN_room, null, OBJ_room);
        ASN1Registry.addObject(449, null, LN_documentSeries, OBJ_documentSeries);
        ASN1Registry.addObject(450, null, LN_rFC822localPart, OBJ_rFC822localPart);
        ASN1Registry.addObject(451, null, LN_dNSDomain, OBJ_dNSDomain);
        ASN1Registry.addObject(452, null, LN_domainRelatedObject, OBJ_domainRelatedObject);
        ASN1Registry.addObject(453, null, LN_friendlyCountry, OBJ_friendlyCountry);
        ASN1Registry.addObject(454, null, LN_simpleSecurityObject, OBJ_simpleSecurityObject);
        ASN1Registry.addObject(455, null, LN_pilotOrganization, OBJ_pilotOrganization);
        ASN1Registry.addObject(456, null, LN_pilotDSA, OBJ_pilotDSA);
        ASN1Registry.addObject(457, null, LN_qualityLabelledData, OBJ_qualityLabelledData);
        ASN1Registry.addObject(458, SN_userId, LN_userId, OBJ_userId);
        ASN1Registry.addObject(459, null, LN_textEncodedORAddress, OBJ_textEncodedORAddress);
        ASN1Registry.addObject(460, SN_rfc822Mailbox, LN_rfc822Mailbox, OBJ_rfc822Mailbox);
        ASN1Registry.addObject(461, SN_info, null, OBJ_info);
        ASN1Registry.addObject(462, null, LN_favouriteDrink, OBJ_favouriteDrink);
        ASN1Registry.addObject(463, null, LN_roomNumber, OBJ_roomNumber);
        ASN1Registry.addObject(464, SN_photo, null, OBJ_photo);
        ASN1Registry.addObject(465, null, LN_userClass, OBJ_userClass);
        ASN1Registry.addObject(466, SN_host, null, OBJ_host);
        ASN1Registry.addObject(467, SN_manager, null, OBJ_manager);
        ASN1Registry.addObject(468, null, LN_documentIdentifier, OBJ_documentIdentifier);
        ASN1Registry.addObject(469, null, LN_documentTitle, OBJ_documentTitle);
        ASN1Registry.addObject(470, null, LN_documentVersion, OBJ_documentVersion);
        ASN1Registry.addObject(471, null, LN_documentAuthor, OBJ_documentAuthor);
        ASN1Registry.addObject(472, null, LN_documentLocation, OBJ_documentLocation);
        ASN1Registry.addObject(473, null, LN_homeTelephoneNumber, OBJ_homeTelephoneNumber);
        ASN1Registry.addObject(474, SN_secretary, null, OBJ_secretary);
        ASN1Registry.addObject(475, null, LN_otherMailbox, OBJ_otherMailbox);
        ASN1Registry.addObject(476, null, LN_lastModifiedTime, OBJ_lastModifiedTime);
        ASN1Registry.addObject(477, null, LN_lastModifiedBy, OBJ_lastModifiedBy);
        ASN1Registry.addObject(478, null, LN_aRecord, OBJ_aRecord);
        ASN1Registry.addObject(479, null, LN_pilotAttributeType27, OBJ_pilotAttributeType27);
        ASN1Registry.addObject(480, null, LN_mXRecord, OBJ_mXRecord);
        ASN1Registry.addObject(481, null, LN_nSRecord, OBJ_nSRecord);
        ASN1Registry.addObject(482, null, LN_sOARecord, OBJ_sOARecord);
        ASN1Registry.addObject(483, null, LN_cNAMERecord, OBJ_cNAMERecord);
        ASN1Registry.addObject(484, null, LN_associatedDomain, OBJ_associatedDomain);
        ASN1Registry.addObject(485, null, LN_associatedName, OBJ_associatedName);
        ASN1Registry.addObject(486, null, LN_homePostalAddress, OBJ_homePostalAddress);
        ASN1Registry.addObject(487, null, LN_personalTitle, OBJ_personalTitle);
        ASN1Registry.addObject(488, null, LN_mobileTelephoneNumber, OBJ_mobileTelephoneNumber);
        ASN1Registry.addObject(489, null, LN_pagerTelephoneNumber, OBJ_pagerTelephoneNumber);
        ASN1Registry.addObject(490, null, LN_friendlyCountryName, OBJ_friendlyCountryName);
        ASN1Registry.addObject(491, null, LN_organizationalStatus, OBJ_organizationalStatus);
        ASN1Registry.addObject(492, null, LN_janetMailbox, OBJ_janetMailbox);
        ASN1Registry.addObject(493, null, LN_mailPreferenceOption, OBJ_mailPreferenceOption);
        ASN1Registry.addObject(494, null, LN_buildingName, OBJ_buildingName);
        ASN1Registry.addObject(495, null, LN_dSAQuality, OBJ_dSAQuality);
        ASN1Registry.addObject(496, null, LN_singleLevelQuality, OBJ_singleLevelQuality);
        ASN1Registry.addObject(497, null, LN_subtreeMinimumQuality, OBJ_subtreeMinimumQuality);
        ASN1Registry.addObject(498, null, LN_subtreeMaximumQuality, OBJ_subtreeMaximumQuality);
        ASN1Registry.addObject(499, null, LN_personalSignature, OBJ_personalSignature);
        ASN1Registry.addObject(500, null, LN_dITRedirect, OBJ_dITRedirect);
        ASN1Registry.addObject(501, SN_audio, null, OBJ_audio);
        ASN1Registry.addObject(502, null, LN_documentPublisher, OBJ_documentPublisher);
        ASN1Registry.addObject(503, null, LN_x500UniqueIdentifier, OBJ_x500UniqueIdentifier);
        ASN1Registry.addObject(504, SN_mime_mhs, LN_mime_mhs, OBJ_mime_mhs);
        ASN1Registry.addObject(505, "mime-mhs-headings", "mime-mhs-headings", OBJ_mime_mhs_headings);
        ASN1Registry.addObject(506, "mime-mhs-bodies", "mime-mhs-bodies", OBJ_mime_mhs_bodies);
        ASN1Registry.addObject(507, "id-hex-partial-message", "id-hex-partial-message", OBJ_id_hex_partial_message);
        ASN1Registry.addObject(508, "id-hex-multipart-message", "id-hex-multipart-message", OBJ_id_hex_multipart_message);
        ASN1Registry.addObject(509, null, LN_generationQualifier, OBJ_generationQualifier);
        ASN1Registry.addObject(510, null, LN_pseudonym, OBJ_pseudonym);
        ASN1Registry.addObject(512, SN_id_set, LN_id_set, OBJ_id_set);
        ASN1Registry.addObject(513, SN_set_ctype, LN_set_ctype, OBJ_set_ctype);
        ASN1Registry.addObject(514, SN_set_msgExt, LN_set_msgExt, OBJ_set_msgExt);
        ASN1Registry.addObject(515, SN_set_attr, null, OBJ_set_attr);
        ASN1Registry.addObject(516, SN_set_policy, null, OBJ_set_policy);
        ASN1Registry.addObject(517, SN_set_certExt, LN_set_certExt, OBJ_set_certExt);
        ASN1Registry.addObject(518, SN_set_brand, null, OBJ_set_brand);
        ASN1Registry.addObject(519, SN_setct_PANData, null, OBJ_setct_PANData);
        ASN1Registry.addObject(520, SN_setct_PANToken, null, OBJ_setct_PANToken);
        ASN1Registry.addObject(521, SN_setct_PANOnly, null, OBJ_setct_PANOnly);
        ASN1Registry.addObject(522, SN_setct_OIData, null, OBJ_setct_OIData);
        ASN1Registry.addObject(523, SN_setct_PI, null, OBJ_setct_PI);
        ASN1Registry.addObject(524, SN_setct_PIData, null, OBJ_setct_PIData);
        ASN1Registry.addObject(525, SN_setct_PIDataUnsigned, null, OBJ_setct_PIDataUnsigned);
        ASN1Registry.addObject(526, SN_setct_HODInput, null, OBJ_setct_HODInput);
        ASN1Registry.addObject(527, SN_setct_AuthResBaggage, null, OBJ_setct_AuthResBaggage);
        ASN1Registry.addObject(528, SN_setct_AuthRevReqBaggage, null, OBJ_setct_AuthRevReqBaggage);
        ASN1Registry.addObject(529, SN_setct_AuthRevResBaggage, null, OBJ_setct_AuthRevResBaggage);
        ASN1Registry.addObject(530, SN_setct_CapTokenSeq, null, OBJ_setct_CapTokenSeq);
        ASN1Registry.addObject(531, SN_setct_PInitResData, null, OBJ_setct_PInitResData);
        ASN1Registry.addObject(532, SN_setct_PI_TBS, null, OBJ_setct_PI_TBS);
        ASN1Registry.addObject(533, SN_setct_PResData, null, OBJ_setct_PResData);
        ASN1Registry.addObject(534, SN_setct_AuthReqTBS, null, OBJ_setct_AuthReqTBS);
        ASN1Registry.addObject(535, SN_setct_AuthResTBS, null, OBJ_setct_AuthResTBS);
        ASN1Registry.addObject(536, SN_setct_AuthResTBSX, null, OBJ_setct_AuthResTBSX);
        ASN1Registry.addObject(537, SN_setct_AuthTokenTBS, null, OBJ_setct_AuthTokenTBS);
        ASN1Registry.addObject(538, SN_setct_CapTokenData, null, OBJ_setct_CapTokenData);
        ASN1Registry.addObject(539, SN_setct_CapTokenTBS, null, OBJ_setct_CapTokenTBS);
        ASN1Registry.addObject(540, SN_setct_AcqCardCodeMsg, null, OBJ_setct_AcqCardCodeMsg);
        ASN1Registry.addObject(541, SN_setct_AuthRevReqTBS, null, OBJ_setct_AuthRevReqTBS);
        ASN1Registry.addObject(542, SN_setct_AuthRevResData, null, OBJ_setct_AuthRevResData);
        ASN1Registry.addObject(543, SN_setct_AuthRevResTBS, null, OBJ_setct_AuthRevResTBS);
        ASN1Registry.addObject(544, SN_setct_CapReqTBS, null, OBJ_setct_CapReqTBS);
        ASN1Registry.addObject(545, SN_setct_CapReqTBSX, null, OBJ_setct_CapReqTBSX);
        ASN1Registry.addObject(546, SN_setct_CapResData, null, OBJ_setct_CapResData);
        ASN1Registry.addObject(547, SN_setct_CapRevReqTBS, null, OBJ_setct_CapRevReqTBS);
        ASN1Registry.addObject(548, SN_setct_CapRevReqTBSX, null, OBJ_setct_CapRevReqTBSX);
        ASN1Registry.addObject(549, SN_setct_CapRevResData, null, OBJ_setct_CapRevResData);
        ASN1Registry.addObject(550, SN_setct_CredReqTBS, null, OBJ_setct_CredReqTBS);
        ASN1Registry.addObject(551, SN_setct_CredReqTBSX, null, OBJ_setct_CredReqTBSX);
        ASN1Registry.addObject(552, SN_setct_CredResData, null, OBJ_setct_CredResData);
        ASN1Registry.addObject(553, SN_setct_CredRevReqTBS, null, OBJ_setct_CredRevReqTBS);
        ASN1Registry.addObject(554, SN_setct_CredRevReqTBSX, null, OBJ_setct_CredRevReqTBSX);
        ASN1Registry.addObject(555, SN_setct_CredRevResData, null, OBJ_setct_CredRevResData);
        ASN1Registry.addObject(556, SN_setct_PCertReqData, null, OBJ_setct_PCertReqData);
        ASN1Registry.addObject(557, SN_setct_PCertResTBS, null, OBJ_setct_PCertResTBS);
        ASN1Registry.addObject(558, SN_setct_BatchAdminReqData, null, OBJ_setct_BatchAdminReqData);
        ASN1Registry.addObject(559, SN_setct_BatchAdminResData, null, OBJ_setct_BatchAdminResData);
        ASN1Registry.addObject(560, SN_setct_CardCInitResTBS, null, OBJ_setct_CardCInitResTBS);
        ASN1Registry.addObject(561, SN_setct_MeAqCInitResTBS, null, OBJ_setct_MeAqCInitResTBS);
        ASN1Registry.addObject(562, SN_setct_RegFormResTBS, null, OBJ_setct_RegFormResTBS);
        ASN1Registry.addObject(563, SN_setct_CertReqData, null, OBJ_setct_CertReqData);
        ASN1Registry.addObject(564, SN_setct_CertReqTBS, null, OBJ_setct_CertReqTBS);
        ASN1Registry.addObject(565, SN_setct_CertResData, null, OBJ_setct_CertResData);
        ASN1Registry.addObject(566, SN_setct_CertInqReqTBS, null, OBJ_setct_CertInqReqTBS);
        ASN1Registry.addObject(567, SN_setct_ErrorTBS, null, OBJ_setct_ErrorTBS);
        ASN1Registry.addObject(568, SN_setct_PIDualSignedTBE, null, OBJ_setct_PIDualSignedTBE);
        ASN1Registry.addObject(569, SN_setct_PIUnsignedTBE, null, OBJ_setct_PIUnsignedTBE);
        ASN1Registry.addObject(570, SN_setct_AuthReqTBE, null, OBJ_setct_AuthReqTBE);
        ASN1Registry.addObject(571, SN_setct_AuthResTBE, null, OBJ_setct_AuthResTBE);
        ASN1Registry.addObject(572, SN_setct_AuthResTBEX, null, OBJ_setct_AuthResTBEX);
        ASN1Registry.addObject(573, SN_setct_AuthTokenTBE, null, OBJ_setct_AuthTokenTBE);
        ASN1Registry.addObject(574, SN_setct_CapTokenTBE, null, OBJ_setct_CapTokenTBE);
        ASN1Registry.addObject(575, SN_setct_CapTokenTBEX, null, OBJ_setct_CapTokenTBEX);
        ASN1Registry.addObject(576, SN_setct_AcqCardCodeMsgTBE, null, OBJ_setct_AcqCardCodeMsgTBE);
        ASN1Registry.addObject(577, SN_setct_AuthRevReqTBE, null, OBJ_setct_AuthRevReqTBE);
        ASN1Registry.addObject(578, SN_setct_AuthRevResTBE, null, OBJ_setct_AuthRevResTBE);
        ASN1Registry.addObject(579, SN_setct_AuthRevResTBEB, null, OBJ_setct_AuthRevResTBEB);
        ASN1Registry.addObject(580, SN_setct_CapReqTBE, null, OBJ_setct_CapReqTBE);
        ASN1Registry.addObject(581, SN_setct_CapReqTBEX, null, OBJ_setct_CapReqTBEX);
        ASN1Registry.addObject(582, SN_setct_CapResTBE, null, OBJ_setct_CapResTBE);
        ASN1Registry.addObject(583, SN_setct_CapRevReqTBE, null, OBJ_setct_CapRevReqTBE);
        ASN1Registry.addObject(584, SN_setct_CapRevReqTBEX, null, OBJ_setct_CapRevReqTBEX);
        ASN1Registry.addObject(585, SN_setct_CapRevResTBE, null, OBJ_setct_CapRevResTBE);
        ASN1Registry.addObject(586, SN_setct_CredReqTBE, null, OBJ_setct_CredReqTBE);
        ASN1Registry.addObject(587, SN_setct_CredReqTBEX, null, OBJ_setct_CredReqTBEX);
        ASN1Registry.addObject(588, SN_setct_CredResTBE, null, OBJ_setct_CredResTBE);
        ASN1Registry.addObject(589, SN_setct_CredRevReqTBE, null, OBJ_setct_CredRevReqTBE);
        ASN1Registry.addObject(590, SN_setct_CredRevReqTBEX, null, OBJ_setct_CredRevReqTBEX);
        ASN1Registry.addObject(591, SN_setct_CredRevResTBE, null, OBJ_setct_CredRevResTBE);
        ASN1Registry.addObject(592, SN_setct_BatchAdminReqTBE, null, OBJ_setct_BatchAdminReqTBE);
        ASN1Registry.addObject(593, SN_setct_BatchAdminResTBE, null, OBJ_setct_BatchAdminResTBE);
        ASN1Registry.addObject(594, SN_setct_RegFormReqTBE, null, OBJ_setct_RegFormReqTBE);
        ASN1Registry.addObject(595, SN_setct_CertReqTBE, null, OBJ_setct_CertReqTBE);
        ASN1Registry.addObject(596, SN_setct_CertReqTBEX, null, OBJ_setct_CertReqTBEX);
        ASN1Registry.addObject(597, SN_setct_CertResTBE, null, OBJ_setct_CertResTBE);
        ASN1Registry.addObject(598, SN_setct_CRLNotificationTBS, null, OBJ_setct_CRLNotificationTBS);
        ASN1Registry.addObject(599, SN_setct_CRLNotificationResTBS, null, OBJ_setct_CRLNotificationResTBS);
        ASN1Registry.addObject(600, SN_setct_BCIDistributionTBS, null, OBJ_setct_BCIDistributionTBS);
        ASN1Registry.addObject(601, SN_setext_genCrypt, LN_setext_genCrypt, OBJ_setext_genCrypt);
        ASN1Registry.addObject(602, SN_setext_miAuth, LN_setext_miAuth, OBJ_setext_miAuth);
        ASN1Registry.addObject(603, SN_setext_pinSecure, null, OBJ_setext_pinSecure);
        ASN1Registry.addObject(604, SN_setext_pinAny, null, OBJ_setext_pinAny);
        ASN1Registry.addObject(605, SN_setext_track2, null, OBJ_setext_track2);
        ASN1Registry.addObject(606, SN_setext_cv, LN_setext_cv, OBJ_setext_cv);
        ASN1Registry.addObject(607, SN_set_policy_root, null, OBJ_set_policy_root);
        ASN1Registry.addObject(608, SN_setCext_hashedRoot, null, OBJ_setCext_hashedRoot);
        ASN1Registry.addObject(609, SN_setCext_certType, null, OBJ_setCext_certType);
        ASN1Registry.addObject(610, SN_setCext_merchData, null, OBJ_setCext_merchData);
        ASN1Registry.addObject(611, SN_setCext_cCertRequired, null, OBJ_setCext_cCertRequired);
        ASN1Registry.addObject(612, SN_setCext_tunneling, null, OBJ_setCext_tunneling);
        ASN1Registry.addObject(613, SN_setCext_setExt, null, OBJ_setCext_setExt);
        ASN1Registry.addObject(614, SN_setCext_setQualf, null, OBJ_setCext_setQualf);
        ASN1Registry.addObject(615, SN_setCext_PGWYcapabilities, null, OBJ_setCext_PGWYcapabilities);
        ASN1Registry.addObject(616, SN_setCext_TokenIdentifier, null, OBJ_setCext_TokenIdentifier);
        ASN1Registry.addObject(617, SN_setCext_Track2Data, null, OBJ_setCext_Track2Data);
        ASN1Registry.addObject(618, SN_setCext_TokenType, null, OBJ_setCext_TokenType);
        ASN1Registry.addObject(619, SN_setCext_IssuerCapabilities, null, OBJ_setCext_IssuerCapabilities);
        ASN1Registry.addObject(620, SN_setAttr_Cert, null, OBJ_setAttr_Cert);
        ASN1Registry.addObject(621, SN_setAttr_PGWYcap, LN_setAttr_PGWYcap, OBJ_setAttr_PGWYcap);
        ASN1Registry.addObject(622, SN_setAttr_TokenType, null, OBJ_setAttr_TokenType);
        ASN1Registry.addObject(623, SN_setAttr_IssCap, LN_setAttr_IssCap, OBJ_setAttr_IssCap);
        ASN1Registry.addObject(624, SN_set_rootKeyThumb, null, OBJ_set_rootKeyThumb);
        ASN1Registry.addObject(625, SN_set_addPolicy, null, OBJ_set_addPolicy);
        ASN1Registry.addObject(626, SN_setAttr_Token_EMV, null, OBJ_setAttr_Token_EMV);
        ASN1Registry.addObject(627, SN_setAttr_Token_B0Prime, null, OBJ_setAttr_Token_B0Prime);
        ASN1Registry.addObject(628, SN_setAttr_IssCap_CVM, null, OBJ_setAttr_IssCap_CVM);
        ASN1Registry.addObject(629, SN_setAttr_IssCap_T2, null, OBJ_setAttr_IssCap_T2);
        ASN1Registry.addObject(630, SN_setAttr_IssCap_Sig, null, OBJ_setAttr_IssCap_Sig);
        ASN1Registry.addObject(631, SN_setAttr_GenCryptgrm, LN_setAttr_GenCryptgrm, OBJ_setAttr_GenCryptgrm);
        ASN1Registry.addObject(632, SN_setAttr_T2Enc, LN_setAttr_T2Enc, OBJ_setAttr_T2Enc);
        ASN1Registry.addObject(633, SN_setAttr_T2cleartxt, LN_setAttr_T2cleartxt, OBJ_setAttr_T2cleartxt);
        ASN1Registry.addObject(634, SN_setAttr_TokICCsig, LN_setAttr_TokICCsig, OBJ_setAttr_TokICCsig);
        ASN1Registry.addObject(635, SN_setAttr_SecDevSig, LN_setAttr_SecDevSig, OBJ_setAttr_SecDevSig);
        ASN1Registry.addObject(636, SN_set_brand_IATA_ATA, null, OBJ_set_brand_IATA_ATA);
        ASN1Registry.addObject(637, SN_set_brand_Diners, null, OBJ_set_brand_Diners);
        ASN1Registry.addObject(638, SN_set_brand_AmericanExpress, null, OBJ_set_brand_AmericanExpress);
        ASN1Registry.addObject(639, SN_set_brand_JCB, null, OBJ_set_brand_JCB);
        ASN1Registry.addObject(640, SN_set_brand_Visa, null, OBJ_set_brand_Visa);
        ASN1Registry.addObject(641, SN_set_brand_MasterCard, null, OBJ_set_brand_MasterCard);
        ASN1Registry.addObject(642, SN_set_brand_Novus, null, OBJ_set_brand_Novus);
        ASN1Registry.addObject(643, SN_des_cdmf, LN_des_cdmf, OBJ_des_cdmf);
        ASN1Registry.addObject(644, SN_rsaOAEPEncryptionSET, null, OBJ_rsaOAEPEncryptionSET);
        ASN1Registry.addObject(647, SN_international_organizations, LN_international_organizations, OBJ_international_organizations);
        ASN1Registry.addObject(648, SN_ms_smartcard_login, LN_ms_smartcard_login, OBJ_ms_smartcard_login);
        ASN1Registry.addObject(649, SN_ms_upn, LN_ms_upn, OBJ_ms_upn);
        ASN1Registry.addObject(660, null, LN_streetAddress, OBJ_streetAddress);
        ASN1Registry.addObject(661, null, LN_postalCode, OBJ_postalCode);
        ASN1Registry.addObject(662, SN_id_ppl, null, OBJ_id_ppl);
        ASN1Registry.addObject(663, SN_proxyCertInfo, LN_proxyCertInfo, OBJ_proxyCertInfo);
        ASN1Registry.addObject(664, SN_id_ppl_anyLanguage, LN_id_ppl_anyLanguage, OBJ_id_ppl_anyLanguage);
        ASN1Registry.addObject(665, SN_id_ppl_inheritAll, LN_id_ppl_inheritAll, OBJ_id_ppl_inheritAll);
        ASN1Registry.addObject(666, SN_name_constraints, LN_name_constraints, OBJ_name_constraints);
        ASN1Registry.addObject(667, SN_Independent, LN_Independent, OBJ_Independent);
        ASN1Registry.addObject(668, SN_sha256WithRSAEncryption, LN_sha256WithRSAEncryption, OBJ_sha256WithRSAEncryption);
        ASN1Registry.addObject(669, SN_sha384WithRSAEncryption, LN_sha384WithRSAEncryption, OBJ_sha384WithRSAEncryption);
        ASN1Registry.addObject(670, SN_sha512WithRSAEncryption, LN_sha512WithRSAEncryption, OBJ_sha512WithRSAEncryption);
        ASN1Registry.addObject(671, SN_sha224WithRSAEncryption, LN_sha224WithRSAEncryption, OBJ_sha224WithRSAEncryption);
        ASN1Registry.addObject(672, SN_sha256, LN_sha256, OBJ_sha256);
        ASN1Registry.addObject(673, SN_sha384, LN_sha384, OBJ_sha384);
        ASN1Registry.addObject(674, SN_sha512, LN_sha512, OBJ_sha512);
        ASN1Registry.addObject(675, SN_sha224, LN_sha224, OBJ_sha224);
        ASN1Registry.addObject(676, SN_identified_organization, null, "1.3");
        ASN1Registry.addObject(677, SN_certicom_arc, null, OBJ_certicom_arc);
        ASN1Registry.addObject(678, SN_wap, null, OBJ_wap);
        ASN1Registry.addObject(679, SN_wap_wsg, null, OBJ_wap_wsg);
        ASN1Registry.addObject(680, SN_X9_62_id_characteristic_two_basis, null, OBJ_X9_62_id_characteristic_two_basis);
        ASN1Registry.addObject(681, SN_X9_62_onBasis, null, OBJ_X9_62_onBasis);
        ASN1Registry.addObject(682, SN_X9_62_tpBasis, null, OBJ_X9_62_tpBasis);
        ASN1Registry.addObject(683, SN_X9_62_ppBasis, null, OBJ_X9_62_ppBasis);
        ASN1Registry.addObject(684, SN_X9_62_c2pnb163v1, null, OBJ_X9_62_c2pnb163v1);
        ASN1Registry.addObject(685, SN_X9_62_c2pnb163v2, null, OBJ_X9_62_c2pnb163v2);
        ASN1Registry.addObject(686, SN_X9_62_c2pnb163v3, null, OBJ_X9_62_c2pnb163v3);
        ASN1Registry.addObject(687, SN_X9_62_c2pnb176v1, null, OBJ_X9_62_c2pnb176v1);
        ASN1Registry.addObject(688, SN_X9_62_c2tnb191v1, null, OBJ_X9_62_c2tnb191v1);
        ASN1Registry.addObject(689, SN_X9_62_c2tnb191v2, null, OBJ_X9_62_c2tnb191v2);
        ASN1Registry.addObject(690, SN_X9_62_c2tnb191v3, null, OBJ_X9_62_c2tnb191v3);
        ASN1Registry.addObject(691, SN_X9_62_c2onb191v4, null, OBJ_X9_62_c2onb191v4);
        ASN1Registry.addObject(692, SN_X9_62_c2onb191v5, null, OBJ_X9_62_c2onb191v5);
        ASN1Registry.addObject(693, SN_X9_62_c2pnb208w1, null, OBJ_X9_62_c2pnb208w1);
        ASN1Registry.addObject(694, SN_X9_62_c2tnb239v1, null, OBJ_X9_62_c2tnb239v1);
        ASN1Registry.addObject(695, SN_X9_62_c2tnb239v2, null, OBJ_X9_62_c2tnb239v2);
        ASN1Registry.addObject(696, SN_X9_62_c2tnb239v3, null, OBJ_X9_62_c2tnb239v3);
        ASN1Registry.addObject(697, SN_X9_62_c2onb239v4, null, OBJ_X9_62_c2onb239v4);
        ASN1Registry.addObject(698, SN_X9_62_c2onb239v5, null, OBJ_X9_62_c2onb239v5);
        ASN1Registry.addObject(699, SN_X9_62_c2pnb272w1, null, OBJ_X9_62_c2pnb272w1);
        ASN1Registry.addObject(700, SN_X9_62_c2pnb304w1, null, OBJ_X9_62_c2pnb304w1);
        ASN1Registry.addObject(701, SN_X9_62_c2tnb359v1, null, OBJ_X9_62_c2tnb359v1);
        ASN1Registry.addObject(702, SN_X9_62_c2pnb368w1, null, OBJ_X9_62_c2pnb368w1);
        ASN1Registry.addObject(703, SN_X9_62_c2tnb431r1, null, OBJ_X9_62_c2tnb431r1);
        ASN1Registry.addObject(704, SN_secp112r1, null, OBJ_secp112r1);
        ASN1Registry.addObject(705, SN_secp112r2, null, OBJ_secp112r2);
        ASN1Registry.addObject(706, SN_secp128r1, null, OBJ_secp128r1);
        ASN1Registry.addObject(707, SN_secp128r2, null, OBJ_secp128r2);
        ASN1Registry.addObject(708, SN_secp160k1, null, OBJ_secp160k1);
        ASN1Registry.addObject(709, SN_secp160r1, null, OBJ_secp160r1);
        ASN1Registry.addObject(710, SN_secp160r2, null, OBJ_secp160r2);
        ASN1Registry.addObject(711, SN_secp192k1, null, OBJ_secp192k1);
        ASN1Registry.addObject(712, SN_secp224k1, null, OBJ_secp224k1);
        ASN1Registry.addObject(713, SN_secp224r1, null, OBJ_secp224r1);
        ASN1Registry.addObject(714, SN_secp256k1, null, OBJ_secp256k1);
        ASN1Registry.addObject(715, SN_secp384r1, null, OBJ_secp384r1);
        ASN1Registry.addObject(716, SN_secp521r1, null, OBJ_secp521r1);
        ASN1Registry.addObject(717, SN_sect113r1, null, OBJ_sect113r1);
        ASN1Registry.addObject(718, SN_sect113r2, null, OBJ_sect113r2);
        ASN1Registry.addObject(719, SN_sect131r1, null, OBJ_sect131r1);
        ASN1Registry.addObject(720, SN_sect131r2, null, OBJ_sect131r2);
        ASN1Registry.addObject(721, SN_sect163k1, null, OBJ_sect163k1);
        ASN1Registry.addObject(722, SN_sect163r1, null, OBJ_sect163r1);
        ASN1Registry.addObject(723, SN_sect163r2, null, OBJ_sect163r2);
        ASN1Registry.addObject(724, SN_sect193r1, null, OBJ_sect193r1);
        ASN1Registry.addObject(725, SN_sect193r2, null, OBJ_sect193r2);
        ASN1Registry.addObject(726, SN_sect233k1, null, OBJ_sect233k1);
        ASN1Registry.addObject(727, SN_sect233r1, null, OBJ_sect233r1);
        ASN1Registry.addObject(728, SN_sect239k1, null, OBJ_sect239k1);
        ASN1Registry.addObject(729, SN_sect283k1, null, OBJ_sect283k1);
        ASN1Registry.addObject(730, SN_sect283r1, null, OBJ_sect283r1);
        ASN1Registry.addObject(731, SN_sect409k1, null, OBJ_sect409k1);
        ASN1Registry.addObject(732, SN_sect409r1, null, OBJ_sect409r1);
        ASN1Registry.addObject(733, SN_sect571k1, null, OBJ_sect571k1);
        ASN1Registry.addObject(734, SN_sect571r1, null, OBJ_sect571r1);
        ASN1Registry.addObject(735, SN_wap_wsg_idm_ecid_wtls1, null, OBJ_wap_wsg_idm_ecid_wtls1);
        ASN1Registry.addObject(736, SN_wap_wsg_idm_ecid_wtls3, null, OBJ_wap_wsg_idm_ecid_wtls3);
        ASN1Registry.addObject(737, SN_wap_wsg_idm_ecid_wtls4, null, OBJ_wap_wsg_idm_ecid_wtls4);
        ASN1Registry.addObject(738, SN_wap_wsg_idm_ecid_wtls5, null, OBJ_wap_wsg_idm_ecid_wtls5);
        ASN1Registry.addObject(739, SN_wap_wsg_idm_ecid_wtls6, null, OBJ_wap_wsg_idm_ecid_wtls6);
        ASN1Registry.addObject(740, SN_wap_wsg_idm_ecid_wtls7, null, OBJ_wap_wsg_idm_ecid_wtls7);
        ASN1Registry.addObject(741, SN_wap_wsg_idm_ecid_wtls8, null, OBJ_wap_wsg_idm_ecid_wtls8);
        ASN1Registry.addObject(742, SN_wap_wsg_idm_ecid_wtls9, null, OBJ_wap_wsg_idm_ecid_wtls9);
        ASN1Registry.addObject(743, SN_wap_wsg_idm_ecid_wtls10, null, OBJ_wap_wsg_idm_ecid_wtls10);
        ASN1Registry.addObject(744, SN_wap_wsg_idm_ecid_wtls11, null, OBJ_wap_wsg_idm_ecid_wtls11);
        ASN1Registry.addObject(745, SN_wap_wsg_idm_ecid_wtls12, null, OBJ_wap_wsg_idm_ecid_wtls12);
        ASN1Registry.addObject(746, SN_any_policy, LN_any_policy, OBJ_any_policy);
        ASN1Registry.addObject(747, SN_policy_mappings, LN_policy_mappings, OBJ_policy_mappings);
        ASN1Registry.addObject(748, SN_inhibit_any_policy, LN_inhibit_any_policy, OBJ_inhibit_any_policy);
        ASN1Registry.addObject(802, SN_dsa_with_SHA224, null, OBJ_dsa_with_SHA224);
        ASN1Registry.addObject(803, SN_dsa_with_SHA256, null, OBJ_dsa_with_SHA256);
    }

    static {
        ASN1Registry.initObjects();
    }
}

