/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Utils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509StoreContext
extends RubyObject {
    private static ObjectAllocator X509STORECTX_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509StoreContext(runtime, klass);
        }
    };
    private final StoreContext storeContext;

    public static void createX509StoreContext(Ruby runtime, RubyModule mX509) {
        RubyClass cX509StoreContext = mX509.defineClassUnder("StoreContext", runtime.getObject(), X509STORECTX_ALLOCATOR);
        cX509StoreContext.defineAnnotatedMethods(X509StoreContext.class);
    }

    public X509StoreContext(Ruby runtime, RubyClass type) {
        super(runtime, type);
        this.storeContext = new StoreContext();
    }

    X509StoreContext(Ruby runtime, RubyClass type, StoreContext storeContext) {
        super(runtime, type);
        this.storeContext = storeContext;
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(ThreadContext context, IRubyObject[] args, Block block) {
        IRubyObject chain;
        IRubyObject cert = chain = context.runtime.getNil();
        IRubyObject store = args[0];
        if (Arity.checkArgumentCount((Ruby)context.runtime, (IRubyObject[])args, (int)1, (int)3) > 1) {
            cert = args[1];
        }
        if (args.length > 2) {
            chain = args[2];
        }
        Store x509Store = ((X509Store)store).getStore();
        X509AuxCertificate x509Cert = cert.isNil() ? null : ((X509Cert)cert).getAuxCert();
        ArrayList<X509AuxCertificate> x509Certs = new ArrayList<X509AuxCertificate>();
        if (!chain.isNil()) {
            for (IRubyObject obj : ((RubyArray)chain).toJavaArray()) {
                x509Certs.add(((X509Cert)obj).getAuxCert());
            }
        }
        if (this.storeContext.init(x509Store, x509Cert, x509Certs) != 1) {
            throw X509StoreContext.newStoreError(context.runtime, null);
        }
        IRubyObject time = store.getInstanceVariables().getInstanceVariable("@time");
        if (!time.isNil()) {
            this.set_time(time);
        }
        IRubyObject vc = store.getInstanceVariables().getInstanceVariable("@verify_callback");
        this.setInstanceVariable("@verify_callback", vc);
        this.setInstanceVariable("@cert", cert);
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(ThreadContext context) {
        Ruby runtime = context.runtime;
        this.storeContext.setExtraData(1, this.getInstanceVariable("@verify_callback"));
        try {
            int result = this.storeContext.verifyCertificate();
            return result != 0 ? runtime.getTrue() : runtime.getFalse();
        }
        catch (Exception e) {
            if (OpenSSLReal.isDebug(context.runtime)) {
                e.printStackTrace(context.runtime.getOut());
            }
            throw X509StoreContext.newStoreError(runtime, e.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject chain(ThreadContext context) {
        Ruby runtime = context.runtime;
        List<X509AuxCertificate> chain = this.storeContext.getChain();
        if (chain == null) {
            return runtime.getNil();
        }
        RubyArray result = runtime.newArray(chain.size());
        RubyClass _Certificate = X509StoreContext._Certificate(runtime);
        try {
            for (X509AuxCertificate x509 : chain) {
                RubyString encoded = RubyString.newString((Ruby)runtime, (byte[])x509.getEncoded());
                result.append(_Certificate.callMethod(context, "new", (IRubyObject)encoded));
            }
        }
        catch (CertificateEncodingException e) {
            throw X509StoreContext.newStoreError(runtime, e.getMessage());
        }
        return result;
    }

    @JRubyMethod
    public IRubyObject error(ThreadContext context) {
        return context.runtime.newFixnum(this.storeContext.getError());
    }

    @JRubyMethod(name={"error="})
    public IRubyObject set_error(IRubyObject error) {
        this.storeContext.setError(RubyNumeric.fix2int((IRubyObject)error));
        return error;
    }

    @JRubyMethod
    public IRubyObject error_string(ThreadContext context) {
        int err = this.storeContext.getError();
        return context.runtime.newString(X509Utils.verifyCertificateErrorString(err));
    }

    @JRubyMethod
    public IRubyObject error_depth(ThreadContext context) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: StoreContext#error_depth");
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject current_cert(ThreadContext context) {
        Ruby runtime = context.runtime;
        X509AuxCertificate x509 = this.storeContext.getCurrentCertificate();
        try {
            RubyClass _Certificate = X509StoreContext._Certificate(runtime);
            return _Certificate.callMethod(context, "new", (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])x509.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            throw X509StoreContext.newStoreError(runtime, e.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject current_crl(ThreadContext context) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: StoreContext#current_crl");
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject cleanup(ThreadContext context) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: StoreContext#cleanup");
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"flags="})
    public IRubyObject set_flags(ThreadContext context, IRubyObject arg) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: StoreContext#set_flags");
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"purpose="})
    public IRubyObject set_purpose(ThreadContext context, IRubyObject arg) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: StoreContext#set_purpose");
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"trust="})
    public IRubyObject set_trust(ThreadContext context, IRubyObject arg) {
        OpenSSLReal.warn(context, "WARNING: unimplemented method called: StoreContext#set_trust");
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"time="})
    public IRubyObject set_time(IRubyObject arg) {
        this.storeContext.setTime(0L, ((RubyTime)arg).getJavaDate());
        return arg;
    }

    private static RaiseException newStoreError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("StoreError"), message);
    }

    private static RubyClass _Certificate(Ruby runtime) {
        return X509._X509(runtime).getClass("Certificate");
    }
}

