/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.SSLSocket;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.builtin.IRubyObject;

public class SSL {
    public static final int VERIFY_NONE = 0;
    public static final int VERIFY_PEER = 1;
    public static final int VERIFY_FAIL_IF_NO_PEER_CERT = 2;
    public static final int VERIFY_CLIENT_ONCE = 4;
    public static final long OP_ALL = 4095L;
    public static final long OP_NO_TICKET = 16384L;
    public static final long OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = 65536L;
    public static final long OP_SINGLE_ECDH_USE = 524288L;
    public static final long OP_SINGLE_DH_USE = 0x100000L;
    public static final long OP_EPHEMERAL_RSA = 0x200000L;
    public static final long OP_CIPHER_SERVER_PREFERENCE = 0x400000L;
    public static final long OP_TLS_ROLLBACK_BUG = 0x800000L;
    public static final long OP_NO_SSLv2 = 0x1000000L;
    public static final long OP_NO_SSLv3 = 0x2000000L;
    public static final long OP_NO_TLSv1 = 0x4000000L;
    public static final long OP_PKCS1_CHECK_1 = 0x8000000L;
    public static final long OP_PKCS1_CHECK_2 = 0x10000000L;
    public static final long OP_NETSCAPE_CA_DN_BUG = 0x20000000L;
    public static final long OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG = 0x40000000L;

    public static void createSSL(Ruby runtime, RubyModule ossl) {
        IRubyObject _WaitWritable;
        RubyModule _SSL = ossl.defineModuleUnder("SSL");
        RubyClass _OpenSSLError = ossl.getClass("OpenSSLError");
        RubyClass _SSLError = _SSL.defineClassUnder("SSLError", _OpenSSLError, _OpenSSLError.getAllocator());
        IRubyObject _WaitReadable = runtime.getIO().getConstantAt("WaitReadable");
        if (_WaitReadable != null) {
            _SSL.defineClassUnder("SSLErrorWaitReadable", _SSLError, _OpenSSLError.getAllocator()).include(new IRubyObject[]{_WaitReadable});
        }
        if ((_WaitWritable = runtime.getIO().getConstantAt("WaitWritable")) != null) {
            _SSL.defineClassUnder("SSLErrorWaitWritable", _SSLError, _OpenSSLError.getAllocator()).include(new IRubyObject[]{_WaitWritable});
        }
        SSLContext.createSSLContext(runtime, _SSL);
        SSLSocket.createSSLSocket(runtime, _SSL);
        _SSL.setConstant("VERIFY_NONE", (IRubyObject)runtime.newFixnum(0));
        _SSL.setConstant("VERIFY_PEER", (IRubyObject)runtime.newFixnum(1));
        _SSL.setConstant("VERIFY_FAIL_IF_NO_PEER_CERT", (IRubyObject)runtime.newFixnum(2));
        _SSL.setConstant("VERIFY_CLIENT_ONCE", (IRubyObject)runtime.newFixnum(4));
        _SSL.setConstant("OP_ALL", (IRubyObject)runtime.newFixnum(4095L));
        _SSL.setConstant("OP_NO_TICKET", (IRubyObject)runtime.newFixnum(16384L));
        _SSL.setConstant("OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION", (IRubyObject)runtime.newFixnum(65536L));
        _SSL.setConstant("OP_SINGLE_ECDH_USE", (IRubyObject)runtime.newFixnum(524288L));
        _SSL.setConstant("OP_SINGLE_DH_USE", (IRubyObject)runtime.newFixnum(0x100000L));
        _SSL.setConstant("OP_EPHEMERAL_RSA", (IRubyObject)runtime.newFixnum(0x200000L));
        _SSL.setConstant("OP_CIPHER_SERVER_PREFERENCE", (IRubyObject)runtime.newFixnum(0x400000L));
        _SSL.setConstant("OP_TLS_ROLLBACK_BUG", (IRubyObject)runtime.newFixnum(0x800000L));
        _SSL.setConstant("OP_NO_SSLv2", (IRubyObject)runtime.newFixnum(0x1000000L));
        _SSL.setConstant("OP_NO_SSLv3", (IRubyObject)runtime.newFixnum(0x2000000L));
        _SSL.setConstant("OP_NO_TLSv1", (IRubyObject)runtime.newFixnum(0x4000000L));
        _SSL.setConstant("OP_PKCS1_CHECK_1", (IRubyObject)runtime.newFixnum(0x8000000L));
        _SSL.setConstant("OP_PKCS1_CHECK_2", (IRubyObject)runtime.newFixnum(0x10000000L));
        _SSL.setConstant("OP_NETSCAPE_CA_DN_BUG", (IRubyObject)runtime.newFixnum(0x20000000L));
        _SSL.setConstant("OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG", (IRubyObject)runtime.newFixnum(0x40000000L));
    }

    @Deprecated
    public static RaiseException newSSLError(Ruby runtime, Throwable t) {
        throw Utils.newError(runtime, "OpenSSL::SSL::SSLError", t.getMessage());
    }

    public static RaiseException newSSLError(Ruby runtime, Exception exception) {
        return Utils.newError(runtime, SSL._SSL(runtime).getClass("SSLError"), exception);
    }

    public static RaiseException newSSLError(Ruby runtime, String message) {
        return Utils.newError(runtime, SSL._SSL(runtime).getClass("SSLError"), message, false);
    }

    public static RaiseException newSSLErrorWaitReadable(Ruby runtime, String message) {
        return SSL.newCustomSSLError(runtime, "SSLErrorWaitReadable", message);
    }

    public static RaiseException newSSLErrorWaitWritable(Ruby runtime, String message) {
        return SSL.newCustomSSLError(runtime, "SSLErrorWaitWritable", message);
    }

    private static RaiseException newCustomSSLError(Ruby runtime, String name, String message) {
        RubyClass errorClass = SSL._SSL(runtime).getClass(name);
        if (errorClass == null) {
            errorClass = SSL._SSL(runtime).getClass("SSLError");
        }
        return Utils.newError(runtime, errorClass, message, false);
    }

    static RubyModule _SSL(Ruby runtime) {
        return (RubyModule)runtime.getModule("OpenSSL").getConstant("SSL");
    }
}

