/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringReader;
import java.security.MessageDigest;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.ext.openssl.BouncyCastlePEMHandler;
import org.jruby.ext.openssl.DefaultPEMHandler;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PEMHandler;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class OpenSSLImpl {
    private OpenSSLImpl() {
    }

    @Deprecated
    public static IRubyObject to_der_if_possible(IRubyObject obj) {
        if (!obj.respondsTo("to_der")) {
            return obj;
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), "to_der");
    }

    static IRubyObject to_der_if_possible(ThreadContext context, IRubyObject obj) {
        if (!obj.respondsTo("to_der")) {
            return obj;
        }
        return obj.callMethod(context, "to_der");
    }

    @Deprecated
    static byte[] readX509PEM(IRubyObject arg) {
        return OpenSSLImpl.readX509PEM(arg.getRuntime().getCurrentContext(), arg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] readX509PEM(ThreadContext context, IRubyObject arg) {
        RubyString str;
        if ((arg = OpenSSLImpl.to_der_if_possible(context, arg)) instanceof RubyIO) {
            IRubyObject result = ((RubyIO)arg).read(context);
            if (!(result instanceof RubyString)) throw context.runtime.newArgumentError("IO stream `" + arg.inspect() + "' contained no data");
            str = (RubyString)result;
        } else {
            str = arg.asString();
        }
        StringReader in = new StringReader(str.getUnicodeValue());
        try {
            byte[] bytes = PEMInputOutput.readX509PEM(in);
            if (bytes == null) return str.getBytes();
            return bytes;
        }
        catch (IOException e) {
            // empty catch block
        }
        return str.getBytes();
    }

    @Deprecated
    public static PEMHandler getPEMHandler() {
        try {
            return new BouncyCastlePEMHandler();
        }
        catch (Exception e) {
            if (OpenSSLReal.isDebug()) {
                e.printStackTrace(System.out);
            }
            return new DefaultPEMHandler();
        }
    }

    static KeyAndIv EVP_BytesToKey(int key_len, int iv_len, MessageDigest md, byte[] salt, byte[] data, int count) {
        byte[] key = new byte[key_len];
        byte[] iv = new byte[iv_len];
        if (data == null) {
            return new KeyAndIvImpl(key, iv);
        }
        int key_ix = 0;
        int iv_ix = 0;
        byte[] md_buf = null;
        int nkey = key_len;
        int niv = iv_len;
        int addmd = 0;
        do {
            int i;
            md.reset();
            if (addmd++ > 0) {
                md.update(md_buf);
            }
            md.update(data);
            if (null != salt) {
                md.update(salt, 0, 8);
            }
            md_buf = md.digest();
            for (i = 1; i < count; ++i) {
                md.reset();
                md.update(md_buf);
                md_buf = md.digest();
            }
            if (nkey > 0) {
                for (i = 0; nkey != 0 && i != md_buf.length; --nkey, ++i) {
                    key[key_ix++] = md_buf[i];
                }
            }
            if (niv <= 0 || i == md_buf.length) continue;
            while (niv != 0 && i != md_buf.length) {
                iv[iv_ix++] = md_buf[i];
                --niv;
                ++i;
            }
        } while (nkey != 0 || niv != 0);
        return new KeyAndIvImpl(key, iv);
    }

    private static class KeyAndIvImpl
    implements KeyAndIv {
        private final byte[] key;
        private final byte[] iv;

        public KeyAndIvImpl(byte[] key, byte[] iv) {
            this.key = key;
            this.iv = iv;
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }

        @Override
        public byte[] getIv() {
            return this.iv;
        }
    }

    static interface KeyAndIv {
        public byte[] getKey();

        public byte[] getIv();
    }
}

