/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.provider.jdk;

import java.security.NoSuchAlgorithmException;
import org.jruby.ext.krypt.provider.Digest;
import org.jruby.ext.krypt.provider.KryptProvider;
import org.jruby.ext.krypt.provider.jdk.Algorithms;
import org.jruby.ext.krypt.provider.jdk.digest.JdkDigest;

public class KryptJdkProvider
implements KryptProvider {
    private static final String NAME = "jdk";

    protected KryptJdkProvider() {
    }

    public String getName() {
        return NAME;
    }

    public void cleanUp() {
    }

    public Digest newDigestByName(String name) {
        try {
            return new JdkDigest(Algorithms.getJavaAlgorithm(name));
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    public Digest newDigestByOid(String oid) {
        try {
            return new JdkDigest(Algorithms.getJavaAlgorithmForOid(oid));
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }
}

