/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.encoding;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.encoding.CharsetTranscoder;
import org.jruby.util.encoding.RubyCoderResult;
import org.jruby.util.io.EncodingUtils;

public abstract class Transcoder {
    protected final Ruby runtime;
    public final Encoding outEncoding;
    public final Encoding inEncoding;
    public RubyCoderResult lastResult;
    private RaiseException lastError;
    public static final Set<Charset> UNICODE_CHARSETS;

    public Transcoder(ThreadContext context, Encoding outEncoding, Encoding inEncoding) {
        this.runtime = context.runtime;
        this.outEncoding = outEncoding;
        this.inEncoding = inEncoding;
    }

    public static Transcoder open(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags, IRubyObject replacement2) {
        Transcoder transcoder = Transcoder.open0(context, sourceEncoding, destinationEncoding, ecflags, replacement2);
        if (transcoder == null) {
            return null;
        }
        return transcoder;
    }

    public static Transcoder open0(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags, IRubyObject replacement2) {
        EncodingDB.Entry dest;
        EncodingDB.Entry src;
        Encoding senc = null;
        if (sourceEncoding.length > 0 && (src = context.runtime.getEncodingService().findEncodingOrAliasEntry(new ByteList(sourceEncoding, false))) != null) {
            senc = src.getEncoding();
        }
        Encoding denc = null;
        if (destinationEncoding.length > 0 && (dest = context.runtime.getEncodingService().findEncodingOrAliasEntry(new ByteList(destinationEncoding, false))) != null) {
            denc = dest.getEncoding();
        }
        if (sourceEncoding.length == 0 && destinationEncoding.length == 0) {
            denc = ASCIIEncoding.INSTANCE;
            senc = denc;
        } else if (CharsetTranscoder.transcodeCharsetFor(context.runtime, sourceEncoding, senc, false) == null || CharsetTranscoder.transcodeCharsetFor(context.runtime, destinationEncoding, denc, false) == null) {
            return null;
        }
        return new CharsetTranscoder(context, denc, senc, ecflags, replacement2);
    }

    public static ByteList strConvEncOpts(ThreadContext context, ByteList value2, Encoding fromEncoding, Encoding toEncoding, int ecflags, IRubyObject ecopts) {
        if (toEncoding == null) {
            return value2;
        }
        if (fromEncoding == null) {
            fromEncoding = value2.getEncoding();
        }
        if (fromEncoding == toEncoding) {
            return value2;
        }
        if (toEncoding.isAsciiCompatible() && StringSupport.codeRangeScan(value2.getEncoding(), value2) == 32 || toEncoding == ASCIIEncoding.INSTANCE) {
            if (value2.getEncoding() != toEncoding) {
                value2 = value2.shallowDup();
                value2.setEncoding(toEncoding);
            }
            return value2;
        }
        Transcoder ec = EncodingUtils.econvOpenOpts(context, fromEncoding.getName(), toEncoding.getName(), ecflags, ecopts);
        if (ec == null) {
            return value2;
        }
        ByteList ret = ec.convert(context, value2, false);
        ret.setEncoding(toEncoding);
        return ret;
    }

    public static ByteList strConvEnc(ThreadContext context, ByteList value2, Encoding fromEncoding, Encoding toEncoding) {
        return Transcoder.strConvEncOpts(context, value2, fromEncoding, toEncoding, 0, context.nil);
    }

    public static ByteList transcode(ThreadContext context, ByteList value2, Encoding fromEncoding, Encoding toEncoding, IRubyObject opts, boolean is7BitASCII) {
        if (toEncoding == null) {
            return value2;
        }
        if (fromEncoding == null) {
            fromEncoding = value2.getEncoding();
        }
        if (fromEncoding == toEncoding) {
            return value2;
        }
        return new CharsetTranscoder(context, toEncoding, fromEncoding, CharsetTranscoder.processCodingErrorActions(context, opts)).transcode(context, value2, is7BitASCII);
    }

    public abstract RubyCoderResult transcode(ThreadContext var1, ByteList var2, ByteList var3);

    public abstract ByteList transcode(ThreadContext var1, ByteList var2);

    public abstract ByteList transcode(ThreadContext var1, ByteList var2, boolean var3);

    public abstract ByteList convert(ThreadContext var1, ByteList var2, boolean var3);

    public abstract ByteList econvStrConvert(ThreadContext var1, ByteList var2, boolean var3);

    public abstract RubyCoderResult primitiveConvert(ThreadContext var1, ByteList var2, ByteList var3, int var4, int var5, Encoding var6, boolean var7, int var8);

    public abstract ByteList finish(Encoding var1);

    public RubyCoderResult getLastResult() {
        return this.lastResult;
    }

    public RaiseException getLastError() {
        this.createLastError();
        return this.lastError;
    }

    private void createLastError() {
        if (this.lastResult != null && this.lastResult.isError()) {
            RubyString errorBytes = this.runtime.newString(new ByteList(this.lastResult.errorBytes, ASCIIEncoding.INSTANCE, true));
            errorBytes.setEncoding(ASCIIEncoding.INSTANCE);
            if (this.lastResult.isInvalid()) {
                this.lastError = this.runtime.newInvalidByteSequenceError("\"" + errorBytes.inspect19().toString() + "\" on " + this.lastResult.inEncoding);
                this.lastError.getException().dataWrapStruct(this.lastResult);
            } else if (this.lastResult.isUndefined()) {
                this.lastError = this.runtime.newUndefinedConversionError("\"" + errorBytes.inspect19().toString() + "\" from " + this.lastResult.inEncoding + " to " + this.lastResult.outEncoding);
                this.lastError.getException().dataWrapStruct(this.lastResult);
            }
        }
    }

    static {
        HashSet<Charset> charsets = new HashSet<Charset>();
        charsets.add(Charset.forName("UTF-8"));
        charsets.add(Charset.forName("UTF-16"));
        charsets.add(Charset.forName("UTF-16BE"));
        charsets.add(Charset.forName("UTF-16LE"));
        charsets.add(Charset.forName("UTF-32"));
        charsets.add(Charset.forName("UTF-32BE"));
        charsets.add(Charset.forName("UTF-32LE"));
        UNICODE_CHARSETS = Collections.unmodifiableSet(charsets);
    }
}

