/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.digest;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.krypt.Errors;
import org.jruby.ext.krypt.Hex;
import org.jruby.ext.krypt.provider.Digest;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyNativeDigest
extends RubyObject {
    private static RubyClass cNativeDigest;
    private Digest digest;

    public RubyNativeDigest(Ruby runtime, Digest digest) {
        super(runtime, cNativeDigest);
        this.digest = digest;
    }

    @JRubyMethod
    public IRubyObject reset(ThreadContext ctx) {
        this.digest.reset();
        return this;
    }

    @JRubyMethod(name={"update", "<<"})
    public IRubyObject update(ThreadContext ctx, IRubyObject data) {
        try {
            byte[] bytes = data.asString().getBytes();
            this.digest.update(bytes, 0, bytes.length);
            return this;
        }
        catch (Exception ex) {
            throw Errors.newDigestError(ctx.getRuntime(), "Error while updating digest: " + ex.getMessage());
        }
    }

    @JRubyMethod(optional=1)
    public IRubyObject digest(ThreadContext ctx, IRubyObject[] args) {
        Ruby runtime = ctx.getRuntime();
        if (args.length == 0) {
            return this.digestFinalize(runtime);
        }
        return this.digestData(runtime, args[0]);
    }

    @JRubyMethod(optional=1)
    public IRubyObject hexdigest(ThreadContext ctx, IRubyObject[] args) {
        IRubyObject result = this.digest(ctx, args);
        byte[] encoded = Hex.encode(result.asString().getBytes());
        return RubyString.newUsAsciiStringNoCopy((Ruby)ctx.getRuntime(), (ByteList)new ByteList(encoded, false));
    }

    @JRubyMethod
    public IRubyObject name(ThreadContext ctx) {
        return ctx.getRuntime().newString(this.digest.getName());
    }

    @JRubyMethod
    public IRubyObject digest_length(ThreadContext ctx) {
        return RubyNumeric.int2fix((Ruby)ctx.getRuntime(), (long)this.digest.getDigestLength());
    }

    @JRubyMethod
    public IRubyObject block_length(ThreadContext ctx) {
        return RubyNumeric.int2fix((Ruby)ctx.getRuntime(), (long)this.digest.getBlockLength());
    }

    private IRubyObject digestFinalize(Ruby runtime) {
        try {
            byte[] result = this.digest.digest();
            return runtime.newString(new ByteList(result, false));
        }
        catch (Exception ex) {
            throw Errors.newDigestError(runtime, "Error while finalizing digest: " + ex.getMessage());
        }
    }

    private IRubyObject digestData(Ruby runtime, IRubyObject rbdata) {
        try {
            byte[] data = rbdata.asString().getBytes();
            byte[] result = this.digest.digest(data);
            return runtime.newString(new ByteList(result, false));
        }
        catch (Exception ex) {
            throw Errors.newDigestError(runtime, "Error while computing digest: " + ex.getMessage());
        }
    }

    public static void createDigest(Ruby runtime, RubyModule krypt) {
        RubyModule mDigest = (RubyModule)krypt.getConstant("Digest");
        cNativeDigest = mDigest.defineClassUnder("NativeDigest", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        cNativeDigest.defineAnnotatedMethods(RubyNativeDigest.class);
    }
}

