/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1;

import impl.krypt.asn1.Tag;

public class Length {
    private boolean isInfiniteLength;
    private int length;
    private byte[] encoding;

    public Length(boolean isInfiniteLength) {
        this(0, isInfiniteLength, null);
    }

    public Length(int length, boolean isInfiniteLength, byte[] encoding) {
        this.isInfiniteLength = isInfiniteLength;
        this.length = length;
        this.encoding = encoding;
    }

    public byte[] getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.computeEncoding();
        }
        return this.encoding;
    }

    public boolean isInfiniteLength() {
        return this.isInfiniteLength;
    }

    public void setInfiniteLength(boolean isInfiniteLength) {
        if (isInfiniteLength == this.isInfiniteLength) {
            return;
        }
        this.isInfiniteLength = isInfiniteLength;
        this.encoding = null;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (length == this.length) {
            return;
        }
        this.length = length;
        this.encoding = null;
    }

    public void invalidateEncoding() {
        this.encoding = null;
        this.length = 0;
    }

    public boolean hasBeenComputed() {
        return this.encoding != null;
    }

    private byte[] computeEncoding() {
        if (this.isInfiniteLength) {
            return new byte[]{-128};
        }
        if (this.length <= 127) {
            return new byte[]{(byte)(this.length & 0xFF)};
        }
        return this.computeComplexLength();
    }

    private byte[] computeComplexLength() {
        int numShifts = Tag.determineNumberOfShifts(this.length, 8);
        int tmp = this.length;
        byte[] out = new byte[numShifts + 1];
        out[0] = (byte)(numShifts & 0xFF);
        out[0] = (byte)(out[0] | 0xFFFFFF80);
        for (int i = numShifts; i > 0; --i) {
            out[i] = (byte)(tmp & 0xFF);
            tmp >>= 8;
        }
        return out;
    }
}

