/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public class WikiReader {
    private final String baseurl;

    public WikiReader(String string) {
        this.baseurl = string;
    }

    public WikiReader() {
        this.baseurl = Main.pref.get("help.baseurl", Main.getJOSMWebsite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(String string) throws IOException {
        URL uRL = new URL(string);
        BufferedReader bufferedReader = Utils.openURLReader(uRL);
        try {
            if (string.startsWith(this.baseurl) && !string.endsWith("?format=txt")) {
                String string2 = this.readFromTrac(bufferedReader, uRL);
                return string2;
            }
            String string3 = this.readNormal(bufferedReader);
            return string3;
        }
        finally {
            Utils.close(bufferedReader);
        }
    }

    public String readLang(String string) throws IOException {
        String string2 = "";
        String string3 = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.DEFAULTNOTENGLISH);
        if (string3 != null) {
            string2 = this.readLang(new URL(this.baseurl + "/wiki/" + string3 + string));
        }
        if (string2.isEmpty() && (string3 = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.BASELANGUAGE)) != null) {
            string2 = this.readLang(new URL(this.baseurl + "/wiki/" + string3 + string));
        }
        if (string2.isEmpty() && (string3 = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.ENGLISH)) != null) {
            string2 = this.readLang(new URL(this.baseurl + "/wiki/" + string3 + string));
        }
        if (string2.isEmpty()) {
            throw new IOException(string + " does not exist");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLang(URL uRL) throws IOException {
        BufferedReader bufferedReader;
        try {
            bufferedReader = Utils.openURLReader(uRL);
        }
        catch (IOException iOException) {
            Main.addNetworkError(uRL, Utils.getRootCause(iOException));
            throw iOException;
        }
        try {
            String string = this.readFromTrac(bufferedReader, uRL);
            return string;
        }
        finally {
            Utils.close(bufferedReader);
        }
    }

    private String readNormal(BufferedReader bufferedReader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null) {
            if (!string.contains("[[TranslatedPages]]")) {
                stringBuilder.append(string.replaceAll(" />", ">")).append("\n");
            }
            string = bufferedReader.readLine();
        }
        return "<html>" + stringBuilder + "</html>";
    }

    protected String readFromTrac(BufferedReader bufferedReader, URL uRL) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        String string2 = "";
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            string2 = string2 + string3;
            if (string3.contains("<div id=\"searchable\">")) {
                bl = true;
            } else if (string3.contains("<div class=\"wiki-toc trac-nav\"")) {
                bl2 = true;
            } else if (string3.contains("<div class=\"wikipage searchable\">")) {
                bl = true;
            } else if (string3.contains("<div class=\"buttons\">")) {
                bl = false;
            } else if (string3.contains("<h3>Attachments</h3>")) {
                bl = false;
            } else if (string3.contains("<div id=\"attachments\">")) {
                bl = false;
            } else if (string3.contains("<div class=\"trac-modifiedby\">")) {
                bl3 = true;
            }
            if (bl && !bl2 && !bl3) {
                string = string + string3.replaceAll("<img ", "<img border=\"0\" ").replaceAll("<span class=\"icon\">.</span>", "").replaceAll("href=\"/", "href=\"" + this.baseurl + "/").replaceAll(" />", ">") + "\n";
            } else if (bl2 && string3.contains("</div>")) {
                bl2 = false;
            }
            if (string3.contains("</div>")) {
                bl3 = false;
            }
            string3 = bufferedReader.readLine();
        }
        if (string.indexOf("      Describe ") >= 0 || string.indexOf(" does not exist. You can create it here.</p>") >= 0) {
            return "";
        }
        if (string.isEmpty()) {
            string = string2;
        }
        return "<html><base href=\"" + uRL.toExternalForm() + "\"> " + string + "</html>";
    }
}

