/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import javax.swing.JApplet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;

public final class OpenBrowser {
    private OpenBrowser() {
    }

    private static void displayUrlFallback(URI uRI) throws IOException {
        if (Main.platform == null) {
            throw new IllegalStateException(I18n.tr("Failed to open URL. There is currently no platform set. Please set a platform first.", new Object[0]));
        }
        Main.platform.openUrl(uRI.toString());
    }

    public static String displayUrl(URI uRI) {
        CheckParameterUtil.ensureParameterNotNull(uRI, "uri");
        if (Main.applet) {
            try {
                JApplet jApplet = (JApplet)Main.parent;
                jApplet.getAppletContext().showDocument(uRI.toURL());
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                return malformedURLException.getMessage();
            }
        }
        Main.info(I18n.tr("Opening URL: {0}", uRI));
        if (Desktop.isDesktopSupported()) {
            try {
                if (Main.platform instanceof PlatformHookWindows) {
                    Desktop.getDesktop().browse(uRI);
                }
                if (Main.platform instanceof PlatformHookUnixoid) {
                    Main.platform.openUrl(uRI.toString());
                }
                try {
                    Desktop.getDesktop().browse(uRI);
                }
                catch (IOException iOException) {
                    Main.warn("Desktop class failed. Platform dependent fall back for open url in browser.");
                    OpenBrowser.displayUrlFallback(uRI);
                }
            }
            catch (Exception exception) {
                Main.warn(exception);
                return exception.getMessage();
            }
        } else {
            try {
                Main.warn("Desktop class is not supported. Platform dependent fall back for open url in browser.");
                OpenBrowser.displayUrlFallback(uRI);
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
        return null;
    }

    public static String displayUrl(String string) {
        try {
            return OpenBrowser.displayUrl(new URI(string));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }
}

