/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImageProvider {
    protected Collection<String> dirs;
    protected String id;
    protected String subdir;
    protected String name;
    protected File archive;
    protected String inArchiveDir;
    protected int width = -1;
    protected int height = -1;
    protected int maxWidth = -1;
    protected int maxHeight = -1;
    protected boolean optional;
    protected boolean suppressWarnings;
    protected Collection<ClassLoader> additionalClassLoaders;
    private static SVGUniverse svgUniverse;
    private static final Map<String, ImageResource> cache;
    private static final Map<Image, Map<Long, ImageResource>> ROTATE_CACHE;
    private static final ExecutorService IMAGE_FETCHER;
    private static final Pattern dataUrlPattern;
    static final double DEGREE_90 = 1.5707963267948966;

    public ImageProvider(String string, String string2) {
        this.subdir = string;
        this.name = string2;
    }

    public ImageProvider(String string) {
        this.name = string;
    }

    public ImageProvider setDirs(Collection<String> collection) {
        this.dirs = collection;
        return this;
    }

    public ImageProvider setId(String string) {
        this.id = string;
        return this;
    }

    public ImageProvider setArchive(File file) {
        this.archive = file;
        return this;
    }

    public ImageProvider setInArchiveDir(String string) {
        this.inArchiveDir = string;
        return this;
    }

    public ImageProvider setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
        return this;
    }

    public ImageProvider setWidth(int n) {
        this.width = n;
        return this;
    }

    public ImageProvider setHeight(int n) {
        this.height = n;
        return this;
    }

    public ImageProvider setMaxSize(Dimension dimension) {
        this.maxWidth = dimension.width;
        this.maxHeight = dimension.height;
        return this;
    }

    public ImageProvider setMaxSize(int n) {
        return this.setMaxSize(new Dimension(n, n));
    }

    public ImageProvider setMaxWidth(int n) {
        this.maxWidth = n;
        return this;
    }

    public ImageProvider setMaxHeight(int n) {
        this.maxHeight = n;
        return this;
    }

    public ImageProvider setOptional(boolean bl) {
        this.optional = bl;
        return this;
    }

    public ImageProvider setSuppressWarnings(boolean bl) {
        this.suppressWarnings = bl;
        return this;
    }

    public ImageProvider setAdditionalClassLoaders(Collection<ClassLoader> collection) {
        this.additionalClassLoaders = collection;
        return this;
    }

    public ImageIcon get() {
        ImageResource imageResource = this.getIfAvailableImpl(this.additionalClassLoaders);
        if (imageResource == null) {
            if (!this.optional) {
                String string = this.name.indexOf(46) != -1 ? "" : ".???";
                throw new RuntimeException(I18n.tr("Fatal: failed to locate image ''{0}''. This is a serious configuration problem. JOSM will stop working.", this.name + string));
            }
            if (!this.suppressWarnings) {
                Main.error(I18n.tr("Failed to locate image ''{0}''", this.name));
            }
            return null;
        }
        if (this.maxWidth != -1 || this.maxHeight != -1) {
            return imageResource.getImageIconBounded(new Dimension(this.maxWidth, this.maxHeight));
        }
        return imageResource.getImageIcon(new Dimension(this.width, this.height));
    }

    public void getInBackground(final ImageCallback imageCallback) {
        if (this.name.startsWith("http://") || this.name.startsWith("wiki://")) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ImageIcon imageIcon = ImageProvider.this.get();
                    imageCallback.finished(imageIcon);
                }
            };
            IMAGE_FETCHER.submit(runnable);
        } else {
            ImageIcon imageIcon = this.get();
            imageCallback.finished(imageIcon);
        }
    }

    public static ImageIcon get(String string, String string2) {
        return new ImageProvider(string, string2).get();
    }

    public static ImageIcon get(String string) {
        return new ImageProvider(string).get();
    }

    public static ImageIcon getIfAvailable(String string, String string2) {
        return new ImageProvider(string, string2).setOptional(true).get();
    }

    public static ImageIcon getIfAvailable(String string) {
        return new ImageProvider(string).setOptional(true).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageResource getIfAvailableImpl(Collection<ClassLoader> collection) {
        Map<String, ImageResource> map = cache;
        synchronized (map) {
            ImageType imageType;
            if (this.name == null) {
                return null;
            }
            if (this.name.startsWith("data:")) {
                String string = this.name;
                ImageResource imageResource = cache.get(string);
                if (imageResource != null) {
                    return imageResource;
                }
                imageResource = ImageProvider.getIfAvailableDataUrl(string);
                if (imageResource != null) {
                    cache.put(string, imageResource);
                }
                return imageResource;
            }
            ImageType imageType2 = imageType = this.name.toLowerCase().endsWith(".svg") ? ImageType.SVG : ImageType.OTHER;
            if (this.name.startsWith("http://") || this.name.startsWith("https://")) {
                String string = this.name;
                ImageResource imageResource = cache.get(string);
                if (imageResource != null) {
                    return imageResource;
                }
                imageResource = ImageProvider.getIfAvailableHttp(string, imageType);
                if (imageResource != null) {
                    cache.put(string, imageResource);
                }
                return imageResource;
            }
            if (this.name.startsWith("wiki://")) {
                ImageResource imageResource = cache.get(this.name);
                if (imageResource != null) {
                    return imageResource;
                }
                imageResource = ImageProvider.getIfAvailableWiki(this.name, imageType);
                if (imageResource != null) {
                    cache.put(this.name, imageResource);
                }
                return imageResource;
            }
            if (this.subdir == null) {
                this.subdir = "";
            } else if (!this.subdir.isEmpty()) {
                this.subdir = this.subdir + "/";
            }
            String[] stringArray = this.name.indexOf(46) != -1 ? new String[]{""} : new String[]{".png", ".svg"};
            Integer[] integerArray = new Integer[]{0, 1};
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray[i];
                block8: for (String string : stringArray) {
                    ImageResource imageResource;
                    String string2;
                    if (".svg".equals(string)) {
                        imageType = ImageType.SVG;
                    } else if (".png".equals(string)) {
                        imageType = ImageType.OTHER;
                    }
                    String string3 = string2 = this.subdir + this.name + string;
                    if (this.dirs != null && !this.dirs.isEmpty()) {
                        string3 = "id:" + this.id + ":" + string2;
                        if (this.archive != null) {
                            string3 = string3 + ":" + this.archive.getName();
                        }
                    }
                    if ((imageResource = cache.get(string3)) != null) {
                        return imageResource;
                    }
                    switch (n2) {
                        case 0: {
                            if (this.archive == null || (imageResource = ImageProvider.getIfAvailableZip(string2, this.archive, this.inArchiveDir, imageType)) == null) continue block8;
                            cache.put(string3, imageResource);
                            return imageResource;
                        }
                        case 1: {
                            URL uRL = ImageProvider.getImageUrl(string2, this.dirs, collection);
                            if (uRL == null || (imageResource = ImageProvider.getIfAvailableLocalURL(uRL, imageType)) == null) continue block8;
                            cache.put(string3, imageResource);
                            return imageResource;
                        }
                    }
                }
            }
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private static ImageResource getIfAvailableHttp(String var0, ImageType var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ImageResource getIfAvailableDataUrl(String string) {
        try {
            Matcher matcher = dataUrlPattern.matcher(string);
            if (matcher.matches()) {
                byte[] byArray;
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                String string4 = matcher.group(3);
                if (";base64".equals(string3)) {
                    byArray = Base64.decodeBase64(string4);
                } else {
                    try {
                        byArray = URLDecoder.decode(string4, "utf-8").getBytes();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Main.warn("Unable to decode URL data part: " + illegalArgumentException.getMessage() + " (" + string4 + ")");
                        return null;
                    }
                }
                if (string2 != null && string2.contains("image/svg+xml")) {
                    String string5 = new String(byArray);
                    URI uRI = ImageProvider.getSvgUniverse().loadSVG(new StringReader(string5), URLEncoder.encode(string5, "UTF-8"));
                    SVGDiagram sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                    if (sVGDiagram == null) {
                        Main.warn("Unable to process svg: " + string5);
                        return null;
                    }
                    return new ImageResource(sVGDiagram);
                }
                try {
                    return new ImageResource(ImageIO.read(new ByteArrayInputStream(byArray)));
                }
                catch (IOException iOException) {
                    Main.warn("IOException while reading image: " + iOException.getMessage());
                }
            }
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static ImageResource getIfAvailableWiki(String string, ImageType imageType) {
        List<String> list = Arrays.asList("http://wiki.openstreetmap.org/w/images/", "http://upload.wikimedia.org/wikipedia/commons/", "http://wiki.openstreetmap.org/wiki/File:");
        Collection<String> collection = Main.pref.getCollection("image-provider.wiki.urls", list);
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        ImageResource imageResource = null;
        for (String string3 : collection) {
            String string4;
            if (string3.endsWith(":")) {
                string4 = ImageProvider.getImgUrlFromWikiInfoPage(string3, string2);
                if (string4 == null) {
                    continue;
                }
            } else {
                String string5 = Utils.md5Hex(string2);
                string4 = string3 + string5.substring(0, 1) + "/" + string5.substring(0, 2) + "/" + string2;
            }
            if ((imageResource = ImageProvider.getIfAvailableHttp(string4, imageType)) == null) continue;
            break;
        }
        return imageResource;
    }

    /*
     * Exception decompiling
     */
    private static ImageResource getIfAvailableZip(String var0, File var1_1, String var2_2, ImageType var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ImageResource getIfAvailableLocalURL(URL uRL, ImageType imageType) {
        switch (imageType) {
            case SVG: {
                URI uRI = ImageProvider.getSvgUniverse().loadSVG(uRL);
                SVGDiagram sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                return sVGDiagram == null ? null : new ImageResource(sVGDiagram);
            }
            case OTHER: {
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ImageIO.read(uRL);
                }
                catch (IOException iOException) {
                    Main.warn(iOException);
                }
                return bufferedImage == null ? null : new ImageResource(bufferedImage);
            }
        }
        throw new AssertionError();
    }

    private static URL getImageUrl(String string, String string2, Collection<ClassLoader> collection) {
        if (string != null && string.startsWith("resource://")) {
            String string3 = string.substring("resource://".length());
            ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(PluginHandler.getResourceClassLoaders());
            if (collection != null) {
                arrayList.addAll(collection);
            }
            for (ClassLoader classLoader : arrayList) {
                URL uRL = classLoader.getResource(string3 + string2);
                if (uRL == null) continue;
                return uRL;
            }
        } else {
            File file = new File(string, string2);
            if ((string != null || file.isAbsolute()) && file.exists()) {
                return Utils.fileToURL(file);
            }
        }
        return null;
    }

    private static URL getImageUrl(String string, Collection<String> collection, Collection<ClassLoader> collection2) {
        URL uRL = null;
        if (collection != null) {
            for (String object : collection) {
                try {
                    uRL = ImageProvider.getImageUrl(object, string, collection2);
                    if (uRL == null) continue;
                    return uRL;
                }
                catch (SecurityException securityException) {
                    Main.warn(I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", object, securityException.toString()));
                }
            }
        }
        String string2 = Main.pref.getPreferencesDir() + "images";
        try {
            uRL = ImageProvider.getImageUrl(string2, string, collection2);
            if (uRL != null) {
                return uRL;
            }
        }
        catch (SecurityException securityException) {
            Main.warn(I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", string2, securityException.toString()));
        }
        uRL = ImageProvider.getImageUrl(null, string, collection2);
        if (uRL != null) {
            return uRL;
        }
        uRL = ImageProvider.getImageUrl("resource://images/", string, collection2);
        if (uRL != null) {
            return uRL;
        }
        for (String string3 : Main.pref.getAllPossiblePreferenceDirs()) {
            uRL = ImageProvider.getImageUrl(string3 + "images", string, collection2);
            if (uRL != null) {
                return uRL;
            }
            uRL = ImageProvider.getImageUrl(string3, string, collection2);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    private static String getImgUrlFromWikiInfoPage(String string, final String string2) {
        class SAXReturnException
        extends SAXException {
            private String result;

            public SAXReturnException(String string) {
                this.result = string;
            }

            public String getResult() {
                return this.result;
            }
        }
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(new DefaultHandler(){

                @Override
                public void startElement(String string, String string22, String string3, Attributes attributes) throws SAXException {
                    String string4;
                    if (string22.equalsIgnoreCase("img") && (string4 = attributes.getValue("src")).endsWith(string2)) {
                        throw new SAXReturnException(string4);
                    }
                }
            });
            xMLReader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            xMLReader.parse(new InputSource(new MirroredInputStream(string + string2, new File(Main.pref.getPreferencesDir(), "images").toString())));
        }
        catch (SAXReturnException sAXReturnException) {
            return sAXReturnException.getResult();
        }
        catch (Exception exception) {
            Main.warn("Parsing " + string + string2 + " failed:\n" + exception);
            return null;
        }
        Main.warn("Parsing " + string + string2 + " failed: Unexpected content.");
        return null;
    }

    public static Cursor getCursor(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.get("cursor", string);
        if (string2 != null) {
            imageIcon = ImageProvider.overlay(imageIcon, ImageProvider.get("cursor/modifier/" + string2), OverlayPosition.SOUTHEAST);
        }
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), string.equals("crosshair") ? new Point(10, 10) : new Point(3, 2), "Cursor");
        return cursor;
    }

    public static ImageIcon overlay(Icon icon, Icon icon2, OverlayPosition overlayPosition) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = icon2.getIconWidth();
        int n4 = icon2.getIconHeight();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        int n5 = 0;
        int n6 = 0;
        switch (overlayPosition) {
            case NORTHWEST: {
                n5 = 0;
                n6 = 0;
                break;
            }
            case NORTHEAST: {
                n5 = n - n3;
                n6 = 0;
                break;
            }
            case SOUTHWEST: {
                n5 = 0;
                n6 = n2 - n4;
                break;
            }
            case SOUTHEAST: {
                n5 = n - n3;
                n6 = n2 - n4;
            }
        }
        icon2.paintIcon(null, graphics2D, n5, n6);
        return new ImageIcon(bufferedImage);
    }

    public static Image createRotatedImage(Image image, double d) {
        return ImageProvider.createRotatedImage(image, d, ImageResource.DEFAULT_DIMENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image createRotatedImage(Image image, double d, Dimension dimension) {
        CheckParameterUtil.ensureParameterNotNull(image, "img");
        Long l = Math.round(d % 360.0);
        if (d != 0.0 && l == 0L) {
            l = 360L;
        }
        ImageResource imageResource = null;
        Map<Image, Map<Long, ImageResource>> map = ROTATE_CACHE;
        synchronized (map) {
            Map<Long, ImageResource> map2 = ROTATE_CACHE.get(image);
            if (map2 == null) {
                map2 = new HashMap<Long, ImageResource>();
                ROTATE_CACHE.put(image, map2);
            }
            if ((imageResource = map2.get(l)) == null) {
                int n;
                int n2;
                double d2 = l % 90L;
                if ((double)l.longValue() != 0.0 && d2 == 0.0) {
                    d2 = 90.0;
                }
                double d3 = Math.toRadians(d2);
                new ImageIcon(image);
                int n3 = image.getWidth(null);
                int n4 = image.getHeight(null);
                if (l >= 0L && l <= 90L || l > 180L && l <= 270L) {
                    n2 = (int)((double)n3 * Math.sin(1.5707963267948966 - d3) + (double)n4 * Math.sin(d3));
                    n = (int)((double)n3 * Math.sin(d3) + (double)n4 * Math.sin(1.5707963267948966 - d3));
                } else {
                    n2 = (int)((double)n4 * Math.sin(1.5707963267948966 - d3) + (double)n3 * Math.sin(d3));
                    n = (int)((double)n4 * Math.sin(d3) + (double)n3 * Math.sin(1.5707963267948966 - d3));
                }
                BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
                imageResource = new ImageResource(bufferedImage);
                map2.put(l, imageResource);
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                int n5 = n3 / 2;
                int n6 = n4 / 2;
                graphics2D.translate(n2 / 2, n / 2);
                graphics2D.rotate(Math.toRadians(l.longValue()));
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.drawImage(image, -n5, -n6, null);
                graphics2D.dispose();
                new ImageIcon(bufferedImage);
            }
            return imageResource.getImageIcon(dimension).getImage();
        }
    }

    public static Image createBoundedImage(Image image, int n) {
        return new ImageResource(image).getImageIconBounded(new Dimension(n, n)).getImage();
    }

    public static ImageIcon get(OsmPrimitiveType osmPrimitiveType) {
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        return ImageProvider.get("data", osmPrimitiveType.getAPIName());
    }

    public static BufferedImage createImageFromSvg(SVGDiagram sVGDiagram, Dimension dimension) {
        float f = sVGDiagram.getWidth();
        float f2 = sVGDiagram.getHeight();
        int n = Math.round(f);
        int n2 = Math.round(f2);
        Double d = null;
        Double d2 = null;
        if (dimension.width != -1) {
            n = dimension.width;
            d = (double)n / (double)f;
            if (dimension.height == -1) {
                d2 = d;
                n2 = (int)Math.round((double)f2 * d2);
            } else {
                n2 = dimension.height;
                d2 = (double)n2 / (double)f2;
            }
        } else if (dimension.height != -1) {
            n2 = dimension.height;
            d = d2 = Double.valueOf((double)n2 / (double)f2);
            n = (int)Math.round((double)f * d);
        }
        if (n == 0 || n2 == 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, n, n2);
        if (d != null && d2 != null) {
            graphics2D.scale(d, d2);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            sVGDiagram.render(graphics2D);
        }
        catch (SVGException sVGException) {
            return null;
        }
        return bufferedImage;
    }

    private static SVGUniverse getSvgUniverse() {
        if (svgUniverse == null) {
            svgUniverse = new SVGUniverse();
        }
        return svgUniverse;
    }

    static {
        cache = new HashMap<String, ImageResource>();
        ROTATE_CACHE = new HashMap<Image, Map<Long, ImageResource>>();
        IMAGE_FETCHER = Executors.newSingleThreadExecutor();
        dataUrlPattern = Pattern.compile("^data:([a-zA-Z]+/[a-zA-Z+]+)?(;base64)?,(.+)$");
    }

    public static interface ImageCallback {
        public void finished(ImageIcon var1);
    }

    public static enum ImageType {
        SVG,
        OTHER;

    }

    public static enum OverlayPosition {
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

