/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ReadLocalPluginInformationTask
extends PleaseWaitRunnable {
    private Map<String, PluginInformation> availablePlugins = new HashMap<String, PluginInformation>();
    private boolean canceled;

    public ReadLocalPluginInformationTask() {
        super(I18n.tr("Reading local plugin information..", new Object[0]), false);
    }

    public ReadLocalPluginInformationTask(ProgressMonitor progressMonitor) {
        super(I18n.tr("Reading local plugin information..", new Object[0]), progressMonitor, false);
    }

    @Override
    protected void cancel() {
        this.canceled = true;
    }

    @Override
    protected void finish() {
    }

    protected void processJarFile(File file, String string) throws PluginException {
        PluginInformation pluginInformation = new PluginInformation(file, string);
        if (!this.availablePlugins.containsKey(pluginInformation.getName())) {
            pluginInformation.updateLocalInfo(pluginInformation);
            this.availablePlugins.put(pluginInformation.getName(), pluginInformation);
        } else {
            PluginInformation pluginInformation2 = this.availablePlugins.get(pluginInformation.getName());
            pluginInformation2.updateFromJar(pluginInformation);
        }
    }

    private File[] listFiles(File file, final String string) {
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string2.matches(string);
            }
        });
    }

    protected void scanSiteCacheFiles(ProgressMonitor progressMonitor, File file) {
        File[] fileArray = this.listFiles(file, "^([0-9]+-)?site.*\\.txt$");
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        progressMonitor.subTask(I18n.tr("Processing plugin site cache files...", new Object[0]));
        progressMonitor.setTicksCount(fileArray.length);
        for (File file2 : fileArray) {
            String string = file2.getName();
            progressMonitor.setCustomText(I18n.tr("Processing file ''{0}''", string));
            try {
                this.processLocalPluginInformationFile(file2);
            }
            catch (PluginListParseException pluginListParseException) {
                Main.warn(I18n.tr("Failed to scan file ''{0}'' for plugin information. Skipping.", string));
                Main.error(pluginListParseException);
            }
            progressMonitor.worked(1);
        }
    }

    protected void scanIconCacheFiles(ProgressMonitor progressMonitor, File file) {
        File[] fileArray = this.listFiles(file, "^([0-9]+-)?site.*plugin-icons\\.zip$");
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        progressMonitor.subTask(I18n.tr("Processing plugin site cache icon files...", new Object[0]));
        progressMonitor.setTicksCount(fileArray.length);
        for (File file2 : fileArray) {
            String string = file2.getName();
            progressMonitor.setCustomText(I18n.tr("Processing file ''{0}''", string));
            for (PluginInformation pluginInformation : this.availablePlugins.values()) {
                if (pluginInformation.icon != null || pluginInformation.iconPath == null) continue;
                pluginInformation.icon = new ImageProvider(pluginInformation.name + ".jar/" + pluginInformation.iconPath).setArchive(file2).setMaxWidth(24).setMaxHeight(24).setOptional(true).get();
            }
            progressMonitor.worked(1);
        }
    }

    protected void scanPluginFiles(ProgressMonitor progressMonitor, File file) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".jar") || string.endsWith(".jar.new");
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        progressMonitor.subTask(I18n.tr("Processing plugin files...", new Object[0]));
        progressMonitor.setTicksCount(fileArray.length);
        for (File file2 : fileArray) {
            String string = file2.getName();
            progressMonitor.setCustomText(I18n.tr("Processing file ''{0}''", string));
            try {
                String string2;
                if (string.endsWith(".jar")) {
                    string2 = string.substring(0, string.length() - 4);
                    this.processJarFile(file2, string2);
                } else if (string.endsWith(".jar.new")) {
                    string2 = string.substring(0, string.length() - 8);
                    this.processJarFile(file2, string2);
                }
            }
            catch (PluginException pluginException) {
                Main.warn("PluginException: " + pluginException.getMessage());
                Main.warn(I18n.tr("Failed to scan file ''{0}'' for plugin information. Skipping.", string));
            }
            progressMonitor.worked(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanLocalPluginRepository(ProgressMonitor progressMonitor, File file) {
        if (file == null) {
            return;
        }
        try {
            progressMonitor.beginTask("");
            this.scanSiteCacheFiles(progressMonitor, file);
            this.scanIconCacheFiles(progressMonitor, file);
            this.scanPluginFiles(progressMonitor, file);
        }
        finally {
            progressMonitor.setCustomText("");
            progressMonitor.finishTask();
        }
    }

    protected void processLocalPluginInformationFile(File file) throws PluginListParseException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            List<PluginInformation> list = new PluginListParser().parse(fileInputStream);
            for (PluginInformation pluginInformation : list) {
                this.availablePlugins.put(pluginInformation.name, pluginInformation);
            }
        }
        catch (IOException iOException) {
            try {
                throw new PluginListParseException(iOException);
            }
            catch (Throwable throwable) {
                Utils.close(fileInputStream);
                throw throwable;
            }
        }
        Utils.close(fileInputStream);
    }

    protected void analyseInProcessPlugins() {
        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
            PluginInformation pluginInformation = pluginProxy.getPluginInformation();
            if (this.canceled) {
                return;
            }
            if (!this.availablePlugins.containsKey(pluginInformation.name)) {
                this.availablePlugins.put(pluginInformation.name, pluginInformation);
                continue;
            }
            this.availablePlugins.get((Object)pluginInformation.name).localversion = pluginInformation.localversion;
        }
    }

    protected void filterOldPlugins() {
        for (PluginHandler.DeprecatedPlugin deprecatedPlugin : PluginHandler.DEPRECATED_PLUGINS) {
            if (this.canceled) {
                return;
            }
            if (!this.availablePlugins.containsKey(deprecatedPlugin.name)) continue;
            this.availablePlugins.remove(deprecatedPlugin.name);
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        Collection<String> collection = PluginInformation.getPluginLocations();
        this.getProgressMonitor().setTicksCount(collection.size() + 2);
        if (this.canceled) {
            return;
        }
        for (String string : collection) {
            this.scanLocalPluginRepository(this.getProgressMonitor().createSubTaskMonitor(1, false), new File(string));
            this.getProgressMonitor().worked(1);
            if (!this.canceled) continue;
            return;
        }
        this.analyseInProcessPlugins();
        this.getProgressMonitor().worked(1);
        if (this.canceled) {
            return;
        }
        this.filterOldPlugins();
        this.getProgressMonitor().worked(1);
    }

    public List<PluginInformation> getAvailablePlugins() {
        return new ArrayList<PluginInformation>(this.availablePlugins.values());
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

