/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PluginListParser {
    protected static PluginInformation createInfo(String string, String string2, String string3) throws PluginListParseException {
        try {
            return new PluginInformation(new ByteArrayInputStream(string3.getBytes(Utils.UTF_8)), string.substring(0, string.length() - 4), string2);
        }
        catch (PluginException pluginException) {
            throw new PluginListParseException(I18n.tr("Failed to create plugin information from manifest for plugin ''{0}''", string), pluginException);
        }
    }

    public List<PluginInformation> parse(InputStream inputStream) throws PluginListParseException {
        LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Utils.UTF_8));
            String string = null;
            String string2 = null;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                if (string3.startsWith("\t")) {
                    string3 = string3.substring(1);
                    while (string3.length() > 70) {
                        stringBuilder.append(string3.substring(0, 70)).append("\n");
                        string3 = " " + string3.substring(70);
                    }
                    stringBuilder.append(string3).append("\n");
                } else {
                    PluginListParser.addPluginInformation(linkedList, string, string2, stringBuilder.toString());
                    String[] stringArray = string3.split(";");
                    if (stringArray.length != 2) {
                        throw new IOException(I18n.tr("Illegal entry in plugin list.", new Object[0]));
                    }
                    string = stringArray[0];
                    string2 = stringArray[1];
                    stringBuilder = new StringBuilder();
                }
                string3 = bufferedReader.readLine();
            }
            PluginListParser.addPluginInformation(linkedList, string, string2, stringBuilder.toString());
            return linkedList;
        }
        catch (IOException iOException) {
            throw new PluginListParseException(iOException);
        }
    }

    private static void addPluginInformation(List<PluginInformation> list, String string, String string2, String string3) {
        try {
            PluginInformation pluginInformation;
            if (string != null && (pluginInformation = PluginListParser.createInfo(string, string2, string3)) != null) {
                for (PluginProxy pluginProxy : PluginHandler.pluginList) {
                    if (!pluginProxy.getPluginInformation().name.equals(pluginInformation.getName())) continue;
                    pluginInformation.localversion = pluginProxy.getPluginInformation().localversion;
                }
                list.add(pluginInformation);
            }
        }
        catch (PluginListParseException pluginListParseException) {
            Main.error(pluginListParseException);
        }
    }
}

