/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginPreferenceFactory;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.plugins.ReadRemotePluginInformationTask;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class PluginHandler {
    public static final Collection<DeprecatedPlugin> DEPRECATED_PLUGINS;
    public static final String[] UNMAINTAINED_PLUGINS;
    public static final int DEFAULT_TIME_BASED_UPDATE_INTERVAL = 30;
    public static final Collection<PluginProxy> pluginList;
    private static final List<ClassLoader> sources;
    private static PluginDownloadTask pluginDownloadTask;

    private PluginHandler() {
    }

    public static Collection<ClassLoader> getResourceClassLoaders() {
        return Collections.unmodifiableCollection(sources);
    }

    private static void filterDeprecatedPlugins(Component component, Collection<String> collection) {
        TreeSet<DeprecatedPlugin> treeSet = new TreeSet<DeprecatedPlugin>();
        for (DeprecatedPlugin object : DEPRECATED_PLUGINS) {
            if (!collection.contains(object.name)) continue;
            collection.remove(object.name);
            Main.pref.removeFromCollection("plugins", object.name);
            treeSet.add(object);
            object.migrate();
        }
        if (treeSet.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(I18n.trn("The following plugin is no longer necessary and has been deactivated:", "The following plugins are no longer necessary and have been deactivated:", treeSet.size(), new Object[0]));
        stringBuilder.append("<ul>");
        for (DeprecatedPlugin deprecatedPlugin : treeSet) {
            stringBuilder.append("<li>").append(deprecatedPlugin.name);
            if (deprecatedPlugin.reason != null) {
                stringBuilder.append(" (").append(deprecatedPlugin.reason).append(")");
            }
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append("</html>");
        JOptionPane.showMessageDialog(component, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2);
    }

    private static void filterUnmaintainedPlugins(Component component, Collection<String> collection) {
        for (String string : UNMAINTAINED_PLUGINS) {
            if (!collection.contains(string)) continue;
            String string2 = I18n.tr("<html>Loading of the plugin \"{0}\" was requested.<br>This plugin is no longer developed and very likely will produce errors.<br>It should be disabled.<br>Delete from preferences?</html>", string);
            if (!PluginHandler.confirmDisablePlugin(component, string2, string)) continue;
            Main.pref.removeFromCollection("plugins", string);
            collection.remove(string);
        }
    }

    public static boolean checkAndConfirmPluginUpdate(Component component) {
        String string = null;
        String string2 = null;
        int n = Version.getInstance().getVersion();
        if (Main.pref.getInteger("pluginmanager.version", 0) < n) {
            string = "<html>" + I18n.tr("You updated your JOSM software.<br>To prevent problems the plugins should be updated as well.<br><br>Update plugins now?", new Object[0]) + "</html>";
            string2 = "pluginmanager.version-based-update.policy";
        } else {
            long l = System.currentTimeMillis();
            long l2 = Main.pref.getLong("pluginmanager.lastupdate", 0L);
            Integer n2 = Main.pref.getInteger("pluginmanager.time-based-update.interval", 30);
            long l3 = (l - l2) / 86400000L;
            if (l2 <= 0L || n2 <= 0) {
                Main.pref.put("pluginmanager.lastupdate", Long.toString(l));
            } else if (l3 > (long)n2.intValue()) {
                string = "<html>" + I18n.tr("Last plugin update more than {0} days ago.", l3) + "</html>";
                string2 = "pluginmanager.time-based-update.policy";
            }
        }
        if (string == null) {
            return false;
        }
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugins", new Object[0]), ImageProvider.get("dialogs", "refresh"), I18n.tr("Click to update the activated plugins", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Skip update", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to skip updating the activated plugins", new Object[0]), null)};
        UpdatePluginsMessagePanel updatePluginsMessagePanel = new UpdatePluginsMessagePanel();
        updatePluginsMessagePanel.setMessage(string);
        updatePluginsMessagePanel.initDontShowAgain(string2);
        String string3 = Main.pref.get(string2, "ask");
        string3 = string3.trim().toLowerCase();
        if (string3.equals("never")) {
            if ("pluginmanager.version-based-update.policy".equals(string2)) {
                Main.info(I18n.tr("Skipping plugin update after JOSM upgrade. Automatic update at startup is disabled.", new Object[0]));
            } else if ("pluginmanager.time-based-update.policy".equals(string2)) {
                Main.info(I18n.tr("Skipping plugin update after elapsed update interval. Automatic update at startup is disabled.", new Object[0]));
            }
            return false;
        }
        if (string3.equals("always")) {
            if ("pluginmanager.version-based-update.policy".equals(string2)) {
                Main.info(I18n.tr("Running plugin update after JOSM upgrade. Automatic update at startup is enabled.", new Object[0]));
            } else if ("pluginmanager.time-based-update.policy".equals(string2)) {
                Main.info(I18n.tr("Running plugin update after elapsed update interval. Automatic update at startup is disabled.", new Object[0]));
            }
            return true;
        }
        if (!string3.equals("ask")) {
            Main.warn(I18n.tr("Unexpected value ''{0}'' for preference ''{1}''. Assuming value ''ask''.", string3, string2));
        }
        int n3 = HelpAwareOptionPane.showOptionDialog(component, updatePluginsMessagePanel, I18n.tr("Update plugins", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Preferences/Plugins#AutomaticUpdate"));
        if (updatePluginsMessagePanel.isRememberDecision()) {
            switch (n3) {
                case 0: {
                    Main.pref.put(string2, "always");
                    break;
                }
                case -1: 
                case 1: {
                    Main.pref.put(string2, "never");
                }
            }
        } else {
            Main.pref.put(string2, "ask");
        }
        return n3 == 0;
    }

    private static void alertMissingRequiredPlugin(Component component, String string, Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(I18n.trn("Plugin {0} requires a plugin which was not found. The missing plugin is:", "Plugin {0} requires {1} plugins which were not found. The missing plugins are:", set.size(), string, set.size()));
        stringBuilder.append(Utils.joinAsHtmlUnorderedList(set));
        stringBuilder.append("</html>");
        JOptionPane.showMessageDialog(component, stringBuilder.toString(), I18n.tr("Error", new Object[0]), 0);
    }

    private static void alertJOSMUpdateRequired(Component component, String string, int n) {
        HelpAwareOptionPane.showOptionDialog(component, I18n.tr("<html>Plugin {0} requires JOSM version {1}. The current JOSM version is {2}.<br>You have to update JOSM in order to use this plugin.</html>", string, Integer.toString(n), Version.getInstance().getVersionString()), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Plugin/Loading#JOSMUpdateRequired"));
    }

    public static boolean checkLoadPreconditions(Component component, Collection<PluginInformation> collection, PluginInformation pluginInformation) {
        int n = Version.getInstance().getVersion();
        if (pluginInformation.localmainversion > n && n != 0) {
            PluginHandler.alertJOSMUpdateRequired(component, pluginInformation.name, pluginInformation.localmainversion);
            return false;
        }
        HashSet<PluginInformation> hashSet = new HashSet<PluginInformation>(collection);
        for (PluginProxy pluginProxy : pluginList) {
            hashSet.add(pluginProxy.getPluginInformation());
        }
        return PluginHandler.checkRequiredPluginsPreconditions(component, hashSet, pluginInformation, true);
    }

    public static boolean checkRequiredPluginsPreconditions(Component component, Collection<PluginInformation> collection, PluginInformation pluginInformation, boolean bl) {
        String string;
        String string2 = string = bl ? pluginInformation.localrequires : pluginInformation.requires;
        if (string != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (PluginInformation object2 : collection) {
                hashSet.add(object2.name);
            }
            HashSet hashSet2 = new HashSet();
            List<String> list = bl ? pluginInformation.getLocalRequiredPlugins() : pluginInformation.getRequiredPlugins();
            for (String string3 : list) {
                if (hashSet.contains(string3)) continue;
                hashSet2.add(string3);
            }
            if (!hashSet2.isEmpty()) {
                PluginHandler.alertMissingRequiredPlugin(component, pluginInformation.name, hashSet2);
                return false;
            }
        }
        return true;
    }

    public static ClassLoader createClassLoader(Collection<PluginInformation> collection) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        File file = Main.pref.getPluginsDirectory();
        HashSet<PluginInformation> hashSet = new HashSet<PluginInformation>(collection);
        for (PluginProxy object : pluginList) {
            hashSet.add(object.getPluginInformation());
        }
        for (PluginInformation pluginInformation : hashSet) {
            if (pluginInformation.libraries == null) continue;
            linkedList.addAll(pluginInformation.libraries);
            File file2 = new File(file, pluginInformation.name + ".jar");
            I18n.addTexts(file2);
            URL uRL = Utils.fileToURL(file2);
            linkedList.add(uRL);
        }
        final Iterator<PluginProxy> iterator = linkedList.toArray(new URL[linkedList.size()]);
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(iterator, Main.class.getClassLoader());
            }
        });
    }

    public static void loadPlugin(Component component, PluginInformation pluginInformation, ClassLoader classLoader) {
        String string = I18n.tr("Could not load plugin {0}. Delete from preferences?", pluginInformation.name);
        try {
            Class<?> clazz = pluginInformation.loadClass(classLoader);
            if (clazz != null) {
                Main.info(I18n.tr("loading plugin ''{0}'' (version {1})", pluginInformation.name, pluginInformation.localversion));
                PluginProxy pluginProxy = pluginInformation.load(clazz);
                pluginList.add(pluginProxy);
                Main.addMapFrameListener(pluginProxy);
            }
            string = null;
        }
        catch (PluginException pluginException) {
            Main.error(pluginException);
            if (pluginException.getCause() instanceof ClassNotFoundException) {
                string = I18n.tr("<html>Could not load plugin {0} because the plugin<br>main class ''{1}'' was not found.<br>Delete from preferences?</html>", pluginInformation.name, pluginInformation.className);
            }
        }
        catch (Throwable throwable) {
            Main.error(throwable);
        }
        if (string != null && PluginHandler.confirmDisablePlugin(component, string, pluginInformation.name)) {
            Main.pref.removeFromCollection("plugins", pluginInformation.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugins(Component component, Collection<PluginInformation> collection, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Loading plugins ...", new Object[0]));
            progressMonitor.subTask(I18n.tr("Checking plugin preconditions...", new Object[0]));
            LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
            for (PluginInformation object : collection) {
                if (!PluginHandler.checkLoadPreconditions(component, collection, object)) continue;
                linkedList.add(object);
            }
            Collections.sort(linkedList, new Comparator<PluginInformation>(){

                @Override
                public int compare(PluginInformation pluginInformation, PluginInformation pluginInformation2) {
                    if (pluginInformation.stage < pluginInformation2.stage) {
                        return -1;
                    }
                    if (pluginInformation.stage == pluginInformation2.stage) {
                        return 0;
                    }
                    return 1;
                }
            });
            if (linkedList.isEmpty()) {
                return;
            }
            ClassLoader classLoader = PluginHandler.createClassLoader(linkedList);
            sources.add(0, classLoader);
            progressMonitor.setTicksCount(linkedList.size());
            for (PluginInformation pluginInformation : linkedList) {
                progressMonitor.setExtraText(I18n.tr("Loading plugin ''{0}''...", pluginInformation.name));
                PluginHandler.loadPlugin(component, pluginInformation, classLoader);
                progressMonitor.worked(1);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public static void loadEarlyPlugins(Component component, Collection<PluginInformation> collection, ProgressMonitor progressMonitor) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(collection.size());
        for (PluginInformation pluginInformation : collection) {
            if (!pluginInformation.early) continue;
            arrayList.add(pluginInformation);
        }
        PluginHandler.loadPlugins(component, arrayList, progressMonitor);
    }

    public static void loadLatePlugins(Component component, Collection<PluginInformation> collection, ProgressMonitor progressMonitor) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(collection.size());
        for (PluginInformation pluginInformation : collection) {
            if (pluginInformation.early) continue;
            arrayList.add(pluginInformation);
        }
        PluginHandler.loadPlugins(component, arrayList, progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Map<String, PluginInformation> loadLocallyAvailablePluginInformation(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            ReadLocalPluginInformationTask readLocalPluginInformationTask = new ReadLocalPluginInformationTask(progressMonitor);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<?> future = executorService.submit(readLocalPluginInformationTask);
            try {
                future.get();
            }
            catch (ExecutionException executionException) {
                Main.error(executionException);
                Map<String, PluginInformation> map = null;
                progressMonitor.finishTask();
                return map;
            }
            catch (InterruptedException interruptedException) {
                Main.warn("InterruptedException in " + PluginHandler.class.getSimpleName() + " while loading locally available plugin information");
                Map<String, PluginInformation> map = null;
                progressMonitor.finishTask();
                return map;
            }
            HashMap<String, PluginInformation> hashMap = new HashMap<String, PluginInformation>();
            for (PluginInformation pluginInformation : readLocalPluginInformationTask.getAvailablePlugins()) {
                hashMap.put(pluginInformation.name, pluginInformation);
            }
            HashMap<String, PluginInformation> hashMap2 = hashMap;
            return hashMap2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static void alertMissingPluginInformation(Component component, Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(I18n.trn("JOSM could not find information about the following plugin:", "JOSM could not find information about the following plugins:", collection.size(), new Object[0]));
        stringBuilder.append(Utils.joinAsHtmlUnorderedList(collection));
        stringBuilder.append(I18n.trn("The plugin is not going to be loaded.", "The plugins are not going to be loaded.", collection.size(), new Object[0]));
        stringBuilder.append("</html>");
        HelpAwareOptionPane.showOptionDialog(component, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Plugin/Loading#MissingPluginInfos"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginInformation> buildListOfPluginsToLoad(Component component, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Determine plugins to load...", new Object[0]));
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Main.pref.getCollection("plugins", new LinkedList<String>()));
            if (System.getProperty("josm.plugins") != null) {
                hashSet.addAll(Arrays.asList(System.getProperty("josm.plugins").split(",")));
            }
            progressMonitor.subTask(I18n.tr("Removing deprecated plugins...", new Object[0]));
            PluginHandler.filterDeprecatedPlugins(component, hashSet);
            progressMonitor.subTask(I18n.tr("Removing unmaintained plugins...", new Object[0]));
            PluginHandler.filterUnmaintainedPlugins(component, hashSet);
            Map<String, PluginInformation> map = PluginHandler.loadLocallyAvailablePluginInformation(progressMonitor.createSubTaskMonitor(1, false));
            LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
            Object object = hashSet.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (!map.containsKey(string)) continue;
                linkedList.add(map.get(string));
                object.remove();
            }
            if (!hashSet.isEmpty()) {
                PluginHandler.alertMissingPluginInformation(component, hashSet);
            }
            object = linkedList;
            return object;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static void alertFailedPluginUpdate(Component component, Collection<PluginInformation> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(I18n.trn("Updating the following plugin has failed:", "Updating the following plugins has failed:", collection.size(), new Object[0]));
        stringBuilder.append("<ul>");
        for (PluginInformation pluginInformation : collection) {
            stringBuilder.append("<li>").append(pluginInformation.name).append("</li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append(I18n.trn("Please open the Preference Dialog after JOSM has started and try to update it manually.", "Please open the Preference Dialog after JOSM has started and try to update them manually.", collection.size(), new Object[0]));
        stringBuilder.append("</html>");
        HelpAwareOptionPane.showOptionDialog(component, stringBuilder.toString(), I18n.tr("Plugin update failed", new Object[0]), 0, HelpUtil.ht("/Plugin/Loading#FailedPluginUpdated"));
    }

    private static Set<PluginInformation> findRequiredPluginsToDownload(Collection<PluginInformation> collection, List<PluginInformation> list, Set<PluginInformation> set) {
        HashSet<PluginInformation> hashSet = new HashSet<PluginInformation>();
        for (PluginInformation pluginInformation : collection) {
            for (String string : pluginInformation.getRequiredPlugins()) {
                try {
                    PluginInformation pluginInformation2 = PluginInformation.findPlugin(string);
                    if (pluginInformation2 != null) continue;
                    PluginInformation pluginInformation3 = null;
                    for (PluginInformation pluginInformation4 : list) {
                        if (!pluginInformation4.getName().equals(string)) continue;
                        pluginInformation3 = pluginInformation4;
                        break;
                    }
                    if (pluginInformation3 == null || set.contains(pluginInformation3)) continue;
                    hashSet.add(pluginInformation3);
                }
                catch (PluginException pluginException) {
                    Main.warn(I18n.tr("Failed to find plugin {0}", string));
                    Main.error(pluginException);
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Collection<PluginInformation> updatePlugins(Component component, Collection<PluginInformation> collection, ProgressMonitor progressMonitor, boolean bl) throws IllegalArgumentException {
        List<PluginInformation> list;
        block20: {
            list = null;
            pluginDownloadTask = null;
            if (progressMonitor == null) {
                progressMonitor = NullProgressMonitor.INSTANCE;
            }
            try {
                List<PluginInformation> list2;
                HashSet<PluginInformation> hashSet;
                Object object;
                progressMonitor.beginTask("");
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                ReadRemotePluginInformationTask readRemotePluginInformationTask = new ReadRemotePluginInformationTask(progressMonitor.createSubTaskMonitor(1, false), Main.pref.getPluginSites(), bl);
                Future<?> future = executorService.submit(readRemotePluginInformationTask);
                List<PluginInformation> list3 = null;
                try {
                    future.get();
                    list3 = readRemotePluginInformationTask.getAvailablePlugins();
                    list = PluginHandler.buildListOfPluginsToLoad(component, progressMonitor.createSubTaskMonitor(1, false));
                    if (collection != null && !collection.isEmpty()) {
                        object = list.iterator();
                        while (object.hasNext()) {
                            hashSet = (PluginInformation)object.next();
                            boolean bl2 = false;
                            for (PluginInformation pluginInformation : collection) {
                                if (!((PluginInformation)((Object)hashSet)).name.equals(pluginInformation.name)) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            object.remove();
                        }
                    }
                }
                catch (ExecutionException executionException) {
                    Main.warn(I18n.tr("Failed to download plugin information list", new Object[0]) + ": ExecutionException");
                    Main.error(executionException);
                }
                catch (InterruptedException interruptedException) {
                    Main.warn(I18n.tr("Failed to download plugin information list", new Object[0]) + ": InterruptedException");
                }
                object = new ArrayList();
                for (PluginInformation pluginInformation : list) {
                    if (!pluginInformation.isUpdateRequired()) continue;
                    object.add(pluginInformation);
                }
                if (object.isEmpty()) break block20;
                hashSet = new HashSet<PluginInformation>((Collection<PluginInformation>)object);
                if (list3 != null) {
                    Set<PluginInformation> set = PluginHandler.findRequiredPluginsToDownload((Collection<PluginInformation>)object, list3, hashSet);
                    hashSet.addAll(set);
                    while (!set.isEmpty()) {
                        list.addAll(set);
                        set = PluginHandler.findRequiredPluginsToDownload(set, list3, hashSet);
                        hashSet.addAll(set);
                    }
                }
                pluginDownloadTask = new PluginDownloadTask(progressMonitor.createSubTaskMonitor(1, false), hashSet, I18n.tr("Update plugins", new Object[0]));
                future = executorService.submit(pluginDownloadTask);
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                    Main.error(executionException);
                    PluginHandler.alertFailedPluginUpdate(component, (Collection<PluginInformation>)object);
                    list2 = list;
                    progressMonitor.finishTask();
                    return list2;
                }
                catch (InterruptedException interruptedException) {
                    Main.warn("InterruptedException in " + PluginHandler.class.getSimpleName() + " while updating plugins");
                    PluginHandler.alertFailedPluginUpdate(component, (Collection<PluginInformation>)object);
                    list2 = list;
                    progressMonitor.finishTask();
                    return list2;
                }
                PluginHandler.refreshLocalUpdatedPluginInfo(pluginDownloadTask.getDownloadedPlugins());
                if (!pluginDownloadTask.getFailedPlugins().isEmpty()) {
                    PluginHandler.alertFailedPluginUpdate(component, pluginDownloadTask.getFailedPlugins());
                    List<PluginInformation> list4 = list;
                    return list4;
                }
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                progressMonitor.finishTask();
            }
        }
        if (collection == null) {
            Main.pref.putInteger("pluginmanager.version", Version.getInstance().getVersion());
            Main.pref.put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        }
        return list;
    }

    public static boolean confirmDisablePlugin(Component component, String string, String string2) {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin", new Object[0]), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to delete the plugin ''{0}''", string2), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", string2), null)};
        int n = HelpAwareOptionPane.showOptionDialog(component, string, I18n.tr("Disable plugin", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], null);
        return n == 0;
    }

    public static Object getPlugin(String string) {
        for (PluginProxy pluginProxy : pluginList) {
            if (!pluginProxy.getPluginInformation().name.equals(string)) continue;
            return pluginProxy.plugin;
        }
        return null;
    }

    public static void addDownloadSelection(List<DownloadSelection> list) {
        for (PluginProxy pluginProxy : pluginList) {
            pluginProxy.addDownloadSelection(list);
        }
    }

    public static void getPreferenceSetting(Collection<PreferenceSettingFactory> collection) {
        for (PluginProxy pluginProxy : pluginList) {
            collection.add(new PluginPreferenceFactory(pluginProxy));
        }
    }

    public static void installDownloadedPlugins(boolean bl) {
        File[] fileArray;
        File file = Main.pref.getPluginsDirectory();
        if (!(file.exists() && file.isDirectory() && file.canWrite())) {
            return;
        }
        for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".jar.new");
            }
        })) {
            String string = file2.getPath();
            File file3 = new File(string.substring(0, string.length() - 4));
            String string2 = file2.getName().substring(0, file2.getName().length() - 8);
            if (file3.exists() && !file3.delete() && bl) {
                Main.warn(I18n.tr("Failed to delete outdated plugin ''{0}''.", file3.toString()));
                Main.warn(I18n.tr("Failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", string2));
                continue;
            }
            try {
                new JarFile(file2).close();
            }
            catch (Exception exception) {
                if (!bl) continue;
                Main.warn(I18n.tr("Failed to install plugin ''{0}'' from temporary download file ''{1}''. {2}", file3.toString(), file2.toString(), exception.getLocalizedMessage()));
                continue;
            }
            if (file2.renameTo(file3) || !bl) continue;
            Main.warn(I18n.tr("Failed to install plugin ''{0}'' from temporary download file ''{1}''. Renaming failed.", file3.toString(), file2.toString()));
            Main.warn(I18n.tr("Failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", string2));
        }
    }

    public static boolean isValidJar(File file) {
        if (file != null && file.exists() && file.canRead()) {
            try {
                new JarFile(file).close();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static File findUpdatedJar(String string) {
        File file = Main.pref.getPluginsDirectory();
        File file2 = new File(file, string + ".jar.new");
        if (!PluginHandler.isValidJar(file2) && !PluginHandler.isValidJar(file2 = new File(file, string + ".jar"))) {
            return null;
        }
        return file2;
    }

    public static void refreshLocalUpdatedPluginInfo(Collection<PluginInformation> collection) {
        if (collection == null) {
            return;
        }
        for (PluginInformation pluginInformation : collection) {
            File file = PluginHandler.findUpdatedJar(pluginInformation.name);
            if (file == null) continue;
            try {
                pluginInformation.updateFromJar(new PluginInformation(file, pluginInformation.name));
            }
            catch (PluginException pluginException) {
                Main.error(pluginException);
            }
        }
    }

    private static int askUpdateDisableKeepPluginAfterException(PluginProxy pluginProxy) {
        final HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugin", new Object[0]), ImageProvider.get("dialogs", "refresh"), I18n.tr("Click to update the plugin ''{0}''", pluginProxy.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin", new Object[0]), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to disable the plugin ''{0}''", pluginProxy.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", pluginProxy.getPluginInformation().name), null)};
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(I18n.tr("An unexpected exception occurred that may have come from the ''{0}'' plugin.", pluginProxy.getPluginInformation().name));
        stringBuilder.append("<br>");
        if (pluginProxy.getPluginInformation().author != null) {
            stringBuilder.append(I18n.tr("According to the information within the plugin, the author is {0}.", pluginProxy.getPluginInformation().author));
            stringBuilder.append("<br>");
        }
        stringBuilder.append(I18n.tr("Try updating to the newest version of this plugin before reporting a bug.", new Object[0]));
        stringBuilder.append("</html>");
        try {
            FutureTask<Integer> futureTask = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return HelpAwareOptionPane.showOptionDialog(Main.parent, stringBuilder.toString(), I18n.tr("Update plugins", new Object[0]), 3, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/ErrorMessages#ErrorInPlugin"));
                }
            });
            GuiHelper.runInEDT(futureTask);
            return futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            Main.warn(interruptedException);
        }
        catch (ExecutionException executionException) {
            Main.warn(executionException);
        }
        return -1;
    }

    private static PluginProxy getPluginCausingException(Throwable throwable) {
        PluginProxy pluginProxy = null;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        for (PluginProxy pluginProxy2 : pluginList) {
            String string = pluginProxy2.getPluginInformation().className;
            string = string.substring(0, string.lastIndexOf(46));
            for (int i = 0; i < n; ++i) {
                if (!stackTraceElementArray[i].getClassName().startsWith(string)) continue;
                n = i;
                pluginProxy = pluginProxy2;
            }
        }
        return pluginProxy;
    }

    public static PluginDownloadTask updateOrdisablePluginAfterException(Throwable throwable) {
        PluginProxy pluginProxy = null;
        if (throwable instanceof PluginException) {
            pluginProxy = ((PluginException)throwable).plugin;
        }
        if (pluginProxy == null) {
            pluginProxy = PluginHandler.getPluginCausingException(throwable);
        }
        if (pluginProxy == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(Main.pref.getCollection("plugins", Collections.<String>emptySet()));
        PluginInformation pluginInformation = pluginProxy.getPluginInformation();
        if (!hashSet.contains(pluginInformation.name)) {
            return null;
        }
        switch (PluginHandler.askUpdateDisableKeepPluginAfterException(pluginProxy)) {
            case 0: {
                PluginHandler.updatePlugins(Main.parent, Collections.singleton(pluginInformation), null, true);
                return pluginDownloadTask;
            }
            case 1: {
                hashSet.remove(pluginProxy.getPluginInformation().name);
                Main.pref.putCollection("plugins", hashSet);
                GuiHelper.runInEDTAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin has been removed from the configuration. Please restart JOSM to unload the plugin.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    }
                });
                return null;
            }
        }
        return null;
    }

    public static String getBugReportText() {
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection("plugins", new LinkedList<String>()));
        for (PluginProxy object : pluginList) {
            PluginInformation pluginInformation = object.getPluginInformation();
            linkedList.remove(pluginInformation.name);
            linkedList.add(pluginInformation.name + " (" + (pluginInformation.localversion != null && !pluginInformation.localversion.isEmpty() ? pluginInformation.localversion : "unknown") + ")");
        }
        Collections.sort(linkedList);
        for (String string : linkedList) {
            stringBuilder.append("Plugin: ").append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    public static JPanel getInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (PluginProxy pluginProxy : pluginList) {
            final PluginInformation pluginInformation = pluginProxy.getPluginInformation();
            String string = pluginInformation.name + (pluginInformation.version != null && !pluginInformation.version.isEmpty() ? " Version: " + pluginInformation.version : "");
            jPanel.add((Component)new JLabel(string), GBC.std());
            jPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            jPanel.add((Component)new JButton(new AbstractAction(I18n.tr("Information", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map.Entry<String, String> entry : pluginInformation.attr.entrySet()) {
                        stringBuilder.append(entry.getKey());
                        stringBuilder.append(": ");
                        stringBuilder.append(entry.getValue());
                        stringBuilder.append("\n");
                    }
                    JosmTextArea josmTextArea = new JosmTextArea(10, 40);
                    josmTextArea.setEditable(false);
                    josmTextArea.setText(stringBuilder.toString());
                    josmTextArea.setCaretPosition(0);
                    JOptionPane.showMessageDialog(Main.parent, new JScrollPane(josmTextArea), I18n.tr("Plugin information", new Object[0]), 1);
                }
            }), GBC.eol());
            JosmTextArea josmTextArea = new JosmTextArea(pluginInformation.description == null ? I18n.tr("no description available", new Object[0]) : pluginInformation.description);
            josmTextArea.setEditable(false);
            josmTextArea.setFont(new JLabel().getFont().deriveFont(2));
            josmTextArea.setLineWrap(true);
            josmTextArea.setWrapStyleWord(true);
            josmTextArea.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            josmTextArea.setBackground(UIManager.getColor("Panel.background"));
            josmTextArea.setCaretPosition(0);
            jPanel.add((Component)josmTextArea, GBC.eop().fill(2));
        }
        return jPanel;
    }

    static {
        String string = I18n.tr("integrated into main program", new Object[0]);
        DEPRECATED_PLUGINS = Arrays.asList(new DeprecatedPlugin("mappaint", string), new DeprecatedPlugin("unglueplugin", string), new DeprecatedPlugin("lang-de", string), new DeprecatedPlugin("lang-en_GB", string), new DeprecatedPlugin("lang-fr", string), new DeprecatedPlugin("lang-it", string), new DeprecatedPlugin("lang-pl", string), new DeprecatedPlugin("lang-ro", string), new DeprecatedPlugin("lang-ru", string), new DeprecatedPlugin("ewmsplugin", string), new DeprecatedPlugin("ywms", string), new DeprecatedPlugin("tways-0.2", string), new DeprecatedPlugin("geotagged", string), new DeprecatedPlugin("landsat", I18n.tr("replaced by new {0} plugin", "lakewalker")), new DeprecatedPlugin("namefinder", string), new DeprecatedPlugin("waypoints", string), new DeprecatedPlugin("slippy_map_chooser", string), new DeprecatedPlugin("tcx-support", I18n.tr("replaced by new {0} plugin", "dataimport")), new DeprecatedPlugin("usertools", string), new DeprecatedPlugin("AgPifoJ", string), new DeprecatedPlugin("utilsplugin", string), new DeprecatedPlugin("ghost", string), new DeprecatedPlugin("validator", string), new DeprecatedPlugin("multipoly", string), new DeprecatedPlugin("multipoly-convert", string), new DeprecatedPlugin("remotecontrol", string), new DeprecatedPlugin("imagery", string), new DeprecatedPlugin("slippymap", string), new DeprecatedPlugin("wmsplugin", string), new DeprecatedPlugin("ParallelWay", string), new DeprecatedPlugin("dumbutils", I18n.tr("replaced by new {0} plugin", "utilsplugin2")), new DeprecatedPlugin("ImproveWayAccuracy", string), new DeprecatedPlugin("Curves", I18n.tr("replaced by new {0} plugin", "utilsplugin2")), new DeprecatedPlugin("epsg31287", I18n.tr("replaced by new {0} plugin", "proj4j")), new DeprecatedPlugin("licensechange", I18n.tr("no longer required", new Object[0])), new DeprecatedPlugin("restart", string), new DeprecatedPlugin("wayselector", string));
        UNMAINTAINED_PLUGINS = new String[]{"gpsbabelgui", "Intersect_way"};
        pluginList = new LinkedList<PluginProxy>();
        sources = new LinkedList<ClassLoader>();
        try {
            sources.add(ClassLoader.getSystemClassLoader());
            sources.add(MainApplication.class.getClassLoader());
        }
        catch (SecurityException securityException) {
            sources.add(ImageProvider.class.getClassLoader());
        }
        pluginDownloadTask = null;
    }

    private static class UpdatePluginsMessagePanel
    extends JPanel {
        private JMultilineLabel lblMessage;
        private JCheckBox cbDontShowAgain;

        protected final void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.lblMessage = new JMultilineLabel("");
            this.add((Component)this.lblMessage, gridBagConstraints);
            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(0));
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            this.cbDontShowAgain = new JCheckBox(I18n.tr("Do not ask again and remember my decision (go to Preferences->Plugins to change it later)", new Object[0]));
            this.add((Component)this.cbDontShowAgain, gridBagConstraints);
            this.cbDontShowAgain.setFont(this.cbDontShowAgain.getFont().deriveFont(0));
        }

        public UpdatePluginsMessagePanel() {
            this.build();
        }

        public void setMessage(String string) {
            this.lblMessage.setText(string);
        }

        public void initDontShowAgain(String string) {
            String string2 = Main.pref.get(string, "ask");
            this.cbDontShowAgain.setSelected(!(string2 = string2.trim().toLowerCase()).equals("ask"));
        }

        public boolean isRememberDecision() {
            return this.cbDontShowAgain.isSelected();
        }
    }

    public static class DeprecatedPlugin
    implements Comparable<DeprecatedPlugin> {
        public final String name;
        public final String reason;
        private final Runnable migration;

        public DeprecatedPlugin(String string) {
            this(string, null, null);
        }

        public DeprecatedPlugin(String string, String string2) {
            this(string, string2, null);
        }

        public DeprecatedPlugin(String string, String string2, Runnable runnable) {
            this.name = string;
            this.reason = string2;
            this.migration = runnable;
        }

        public void migrate() {
            if (this.migration != null) {
                this.migration.run();
            }
        }

        @Override
        public int compareTo(DeprecatedPlugin deprecatedPlugin) {
            return this.name.compareTo(deprecatedPlugin.name);
        }
    }
}

