/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class RemoteControlHttpsServer
extends Thread {
    private ServerSocket server;
    private static RemoteControlHttpsServer instance;
    private boolean initOK = false;
    private SSLContext sslContext;
    private static final String KEYSTORE_PATH = "/data/josm.keystore";
    private static final String KEYSTORE_PASSWORD = "josm_ssl";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        block15: {
            if (!this.initOK) {
                try {
                    Object object;
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    char[] cArray = KEYSTORE_PASSWORD.toCharArray();
                    InputStream inputStream = RemoteControlHttpsServer.class.getResourceAsStream(KEYSTORE_PATH);
                    if (inputStream == null) {
                        Main.error(I18n.tr("Unable to find JOSM keystore at {0}. Remote control will not be available on HTTPS.", KEYSTORE_PATH));
                        break block15;
                    }
                    try {
                        keyStore.load(inputStream, cArray);
                    }
                    finally {
                        Utils.close(inputStream);
                    }
                    if (Main.isDebugEnabled()) {
                        object = keyStore.aliases();
                        while (object.hasMoreElements()) {
                            Main.debug("Alias in keystore: " + (String)object.nextElement());
                        }
                    }
                    object = KeyManagerFactory.getInstance("SunX509");
                    ((KeyManagerFactory)object).init(keyStore, cArray);
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                    trustManagerFactory.init(keyStore);
                    this.sslContext = SSLContext.getInstance("TLS");
                    this.sslContext.init(((KeyManagerFactory)object).getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                    if (Main.isDebugEnabled()) {
                        Main.debug("SSL Context protocol: " + this.sslContext.getProtocol());
                        Main.debug("SSL Context provider: " + this.sslContext.getProvider());
                    }
                    this.initOK = true;
                }
                catch (KeyStoreException keyStoreException) {
                    Main.error(keyStoreException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    Main.error(noSuchAlgorithmException);
                }
                catch (CertificateException certificateException) {
                    Main.error(certificateException);
                }
                catch (IOException iOException) {
                    Main.error(iOException);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    Main.error(unrecoverableKeyException);
                }
                catch (KeyManagementException keyManagementException) {
                    Main.error(keyManagementException);
                }
            }
        }
    }

    public static void restartRemoteControlHttpsServer() {
        int n = Main.pref.getInteger("remote.control.https.port", 8112);
        try {
            RemoteControlHttpsServer.stopRemoteControlHttpsServer();
            instance = new RemoteControlHttpsServer(n);
            if (RemoteControlHttpsServer.instance.initOK) {
                instance.start();
            }
        }
        catch (BindException bindException) {
            Main.warn(I18n.marktr("Cannot start remotecontrol https server on port {0}: {1}"), Integer.toString(n), bindException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Main.error(noSuchAlgorithmException);
        }
    }

    public static void stopRemoteControlHttpsServer() {
        if (instance != null) {
            try {
                instance.stopServer();
                instance = null;
            }
            catch (IOException iOException) {
                Main.error(iOException);
            }
        }
    }

    public RemoteControlHttpsServer(int n) throws IOException, NoSuchAlgorithmException {
        super("RemoteControl HTTPS Server");
        this.setDaemon(true);
        this.initialize();
        SSLServerSocketFactory sSLServerSocketFactory = this.sslContext.getServerSocketFactory();
        if (Main.isDebugEnabled()) {
            Main.debug("SSL factory - Supported Cipher suites: " + Arrays.toString(sSLServerSocketFactory.getSupportedCipherSuites()));
        }
        this.server = sSLServerSocketFactory.createServerSocket(n, 1, InetAddress.getByName(Main.pref.get("remote.control.host", "localhost")));
        if (Main.isDebugEnabled() && this.server instanceof SSLServerSocket) {
            SSLServerSocket sSLServerSocket = (SSLServerSocket)this.server;
            Main.debug("SSL server - Enabled Cipher suites: " + Arrays.toString(sSLServerSocket.getEnabledCipherSuites()));
            Main.debug("SSL server - Enabled Protocols: " + Arrays.toString(sSLServerSocket.getEnabledProtocols()));
            Main.debug("SSL server - Enable Session Creation: " + sSLServerSocket.getEnableSessionCreation());
            Main.debug("SSL server - Need Client Auth: " + sSLServerSocket.getNeedClientAuth());
            Main.debug("SSL server - Want Client Auth: " + sSLServerSocket.getWantClientAuth());
            Main.debug("SSL server - Use Client Mode: " + sSLServerSocket.getUseClientMode());
        }
    }

    @Override
    public void run() {
        Main.info(I18n.marktr("RemoteControl::Accepting secure connections on port {0}"), Integer.toString(this.server.getLocalPort()));
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    if (Main.isDebugEnabled() && socket instanceof SSLSocket) {
                        SSLSocket sSLSocket = (SSLSocket)socket;
                        Main.debug("SSL socket - Enabled Cipher suites: " + Arrays.toString(sSLSocket.getEnabledCipherSuites()));
                        Main.debug("SSL socket - Enabled Protocols: " + Arrays.toString(sSLSocket.getEnabledProtocols()));
                        Main.debug("SSL socket - Enable Session Creation: " + sSLSocket.getEnableSessionCreation());
                        Main.debug("SSL socket - Need Client Auth: " + sSLSocket.getNeedClientAuth());
                        Main.debug("SSL socket - Want Client Auth: " + sSLSocket.getWantClientAuth());
                        Main.debug("SSL socket - Use Client Mode: " + sSLSocket.getUseClientMode());
                        Main.debug("SSL socket - Session: " + sSLSocket.getSession());
                    }
                    RequestProcessor.processRequest(socket);
                }
            }
            catch (SocketException socketException) {
                if (this.server.isClosed()) continue;
                Main.error(socketException);
                continue;
            }
            catch (IOException iOException) {
                Main.error(iOException);
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        this.server.close();
        Main.info(I18n.marktr("RemoteControl::Server (https) stopped."));
    }
}

