/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangesetContentParser;
import org.openstreetmap.josm.io.OsmChangesetParser;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlParsingException;

public class OsmServerChangesetReader
extends OsmServerReader {
    public OsmServerChangesetReader() {
        this.setDoAuthenticate(false);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Changeset> queryChangesets(ChangesetQuery changesetQuery, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changesetQuery, "query");
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Reading changesets...", new Object[0]));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("changesets?").append(changesetQuery.getQueryString());
            InputStream inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) {
                List<Changeset> list = null;
                return list;
            }
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading changesets ...", new Object[0]));
            List<Changeset> list = OsmChangesetParser.parse(inputStream, progressMonitor.createSubTaskMonitor(1, true));
            return list;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (IllegalDataException illegalDataException) {
            throw new OsmTransferException(illegalDataException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public Changeset readChangeset(long l, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", l));
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Reading changeset {0} ...", l));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("changeset/").append(l);
            InputStream inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) {
                Changeset changeset = null;
                return changeset;
            }
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading changeset {0} ...", l));
            List<Changeset> list = OsmChangesetParser.parse(inputStream, progressMonitor.createSubTaskMonitor(1, true));
            if (list == null || list.isEmpty()) {
                Changeset changeset = null;
                return changeset;
            }
            Changeset changeset = list.get(0);
            return changeset;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (IllegalDataException illegalDataException) {
            throw new OsmTransferException(illegalDataException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public List<Changeset> readChangesets(Collection<Integer> collection, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (collection == null) {
            return Collections.emptyList();
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.trn("Downloading {0} changeset ...", "Downloading {0} changesets ...", collection.size(), collection.size()));
            progressMonitor.setTicksCount(collection.size());
            ArrayList<Changeset> arrayList = new ArrayList<Changeset>();
            int n = 0;
            Object object = collection.iterator();
            while (object.hasNext()) {
                List<Changeset> list;
                int n2 = object.next();
                if (n2 <= 0) continue;
                ++n;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("changeset/").append(n2);
                InputStream inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
                if (inputStream == null) {
                    list = null;
                    return list;
                }
                progressMonitor.indeterminateSubTask(I18n.tr("({0}/{1}) Downloading changeset {2} ...", n, collection.size(), n2));
                list = OsmChangesetParser.parse(inputStream, progressMonitor.createSubTaskMonitor(1, true));
                if (list == null || list.isEmpty()) continue;
                arrayList.addAll(list);
                progressMonitor.worked(1);
            }
            object = arrayList;
            return object;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (IllegalDataException illegalDataException) {
            throw new OsmTransferException(illegalDataException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public ChangesetDataSet downloadChangeset(int n, ProgressMonitor progressMonitor) throws IllegalArgumentException, OsmTransferException {
        if (n <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value of type integer > 0 for parameter ''{0}'', got {1}", "id", n));
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Downloading changeset content", new Object[0]));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("changeset/").append(n).append("/download");
            InputStream inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) {
                ChangesetDataSet changesetDataSet = null;
                return changesetDataSet;
            }
            progressMonitor.setCustomText(I18n.tr("Downloading content for changeset {0} ...", n));
            OsmChangesetContentParser osmChangesetContentParser = new OsmChangesetContentParser(inputStream);
            ChangesetDataSet changesetDataSet = osmChangesetContentParser.parse(progressMonitor.createSubTaskMonitor(1, true));
            return changesetDataSet;
        }
        catch (XmlParsingException xmlParsingException) {
            throw new OsmTransferException(xmlParsingException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

