/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmServerBackreferenceReader
extends OsmServerReader {
    private long id;
    private OsmPrimitiveType primitiveType;
    private boolean readFull;

    public OsmServerBackreferenceReader(OsmPrimitive osmPrimitive) throws IllegalArgumentException {
        CheckParameterUtil.ensureValidPrimitiveId(osmPrimitive, "primitive");
        this.id = osmPrimitive.getId();
        this.primitiveType = OsmPrimitiveType.from(osmPrimitive);
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(long l, OsmPrimitiveType osmPrimitiveType) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        this.id = l;
        this.primitiveType = osmPrimitiveType;
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(OsmPrimitive osmPrimitive, boolean bl) {
        this(osmPrimitive);
        this.readFull = bl;
    }

    public OsmServerBackreferenceReader(long l, OsmPrimitiveType osmPrimitiveType, boolean bl) throws IllegalArgumentException {
        this(l, osmPrimitiveType);
        this.readFull = bl;
    }

    public boolean isReadFull() {
        return this.readFull;
    }

    public void setReadFull(boolean bl) {
        this.readFull = bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataSet getReferringWays(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet dataSet;
        InputStream inputStream;
        block10: {
            DataSet dataSet2;
            block9: {
                inputStream = null;
                progressMonitor.beginTask(null, 2);
                progressMonitor.indeterminateSubTask(I18n.tr("Downloading from OSM Server...", new Object[0]));
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/ways");
                inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
                if (inputStream == null) {
                    dataSet2 = null;
                    progressMonitor.finishTask();
                    break block9;
                }
                progressMonitor.subTask(I18n.tr("Downloading referring ways ...", new Object[0]));
                dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, true));
                progressMonitor.finishTask();
                break block10;
            }
            Utils.close(inputStream);
            this.activeConnection = null;
            return dataSet2;
        }
        Utils.close(inputStream);
        this.activeConnection = null;
        return dataSet;
        catch (Exception exception) {
            if (!this.cancel) throw new OsmTransferException(exception);
            DataSet dataSet3 = null;
            return dataSet3;
        }
        finally {
            progressMonitor.finishTask();
            Utils.close(inputStream);
            this.activeConnection = null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataSet getReferringRelations(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet dataSet;
        InputStream inputStream;
        block10: {
            DataSet dataSet2;
            block9: {
                inputStream = null;
                progressMonitor.beginTask(null, 2);
                progressMonitor.subTask(I18n.tr("Contacting OSM Server...", new Object[0]));
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/relations");
                inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
                if (inputStream == null) {
                    dataSet2 = null;
                    progressMonitor.finishTask();
                    break block9;
                }
                progressMonitor.subTask(I18n.tr("Downloading referring relations ...", new Object[0]));
                dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, true));
                progressMonitor.finishTask();
                break block10;
            }
            Utils.close(inputStream);
            this.activeConnection = null;
            return dataSet2;
        }
        Utils.close(inputStream);
        this.activeConnection = null;
        return dataSet;
        catch (Exception exception) {
            if (!this.cancel) throw new OsmTransferException(exception);
            DataSet dataSet3 = null;
            return dataSet3;
        }
        finally {
            progressMonitor.finishTask();
            Utils.close(inputStream);
            this.activeConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet readIncompletePrimitives(DataSet dataSet, ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(null, 2);
        try {
            ArrayList<Relation> arrayList;
            Object object;
            Object object2;
            ArrayList<Way> arrayList2 = new ArrayList<Way>(dataSet.getWays());
            if (this.isReadFull() || this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                for (Way object3 : arrayList2) {
                    if (object3.isNew() || !object3.hasIncompleteNodes()) continue;
                    OsmServerObjectReader osmServerObjectReader = new OsmServerObjectReader(object3.getId(), OsmPrimitiveType.from(object3), true);
                    object2 = osmServerObjectReader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    object = new DataSetMerger(dataSet, (DataSet)object2);
                    ((DataSetMerger)object).merge();
                }
            }
            if (this.isReadFull()) {
                arrayList = new ArrayList<Relation>(dataSet.getRelations());
                for (Relation relation : arrayList) {
                    if (relation.isNew() || !relation.hasIncompleteMembers()) continue;
                    object2 = new OsmServerObjectReader(relation.getId(), OsmPrimitiveType.from(relation), true);
                    object = ((OsmServerObjectReader)object2).parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    DataSetMerger dataSetMerger = new DataSetMerger(dataSet, (DataSet)object);
                    dataSetMerger.merge();
                }
            }
            arrayList = dataSet;
            return arrayList;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            DataSetMerger dataSetMerger;
            DataSet dataSet;
            progressMonitor.beginTask(null, 3);
            DataSet dataSet2 = new DataSet();
            if (this.primitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                dataSet = this.getReferringWays(progressMonitor.createSubTaskMonitor(1, false));
                dataSetMerger = new DataSetMerger(dataSet2, dataSet);
                dataSetMerger.merge();
                dataSet2 = dataSetMerger.getTargetDataSet();
            }
            dataSet = this.getReferringRelations(progressMonitor.createSubTaskMonitor(1, false));
            dataSetMerger = new DataSetMerger(dataSet2, dataSet);
            dataSetMerger.merge();
            dataSet2 = dataSetMerger.getTargetDataSet();
            this.readIncompletePrimitives(dataSet2, progressMonitor.createSubTaskMonitor(1, false));
            if (dataSet2 != null) {
                dataSet2.deleteInvisible();
            }
            DataSet dataSet3 = dataSet2;
            return dataSet3;
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

