/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class PopupMenuLauncher
extends MouseAdapter {
    protected JPopupMenu menu;
    private final boolean checkEnabled;

    public PopupMenuLauncher() {
        this(null);
    }

    public PopupMenuLauncher(JPopupMenu jPopupMenu) {
        this(jPopupMenu, false);
    }

    public PopupMenuLauncher(JPopupMenu jPopupMenu, boolean bl) {
        this.menu = jPopupMenu;
        this.checkEnabled = bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.processEvent(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.processEvent(mouseEvent);
    }

    private void processEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && (!this.checkEnabled || mouseEvent.getComponent().isEnabled())) {
            this.launch(mouseEvent);
        }
    }

    public void launch(MouseEvent mouseEvent) {
        Component component;
        if (mouseEvent != null && this.checkSelection(component = mouseEvent.getComponent(), mouseEvent.getPoint())) {
            this.checkFocusAndShowMenu(component, mouseEvent);
        }
    }

    protected boolean checkSelection(Component component, Point point) {
        if (component instanceof JList) {
            return this.checkListSelection((JList)component, point) > -1;
        }
        if (component instanceof JTable) {
            return this.checkTableSelection((JTable)component, point) > -1;
        }
        if (component instanceof JTree) {
            return this.checkTreeSelection((JTree)component, point) != null;
        }
        return true;
    }

    protected void checkFocusAndShowMenu(final Component component, final MouseEvent mouseEvent) {
        if (component != null && component.isFocusable() && !component.hasFocus() && component.requestFocusInWindow()) {
            component.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    PopupMenuLauncher.this.showMenu(mouseEvent);
                    component.removeFocusListener(this);
                }
            });
        } else {
            this.showMenu(mouseEvent);
        }
    }

    protected void showMenu(MouseEvent mouseEvent) {
        if (this.menu != null && mouseEvent != null) {
            this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected int checkListSelection(JList jList, Point point) {
        int n = jList.locationToIndex(point);
        if (n >= 0 && n < jList.getModel().getSize() && jList.getSelectedIndices().length < 2 && !jList.isSelectedIndex(n)) {
            jList.setSelectedIndex(n);
        }
        return n;
    }

    protected int checkTableSelection(JTable jTable, Point point) {
        int n = jTable.rowAtPoint(point);
        if (n >= 0 && n < jTable.getRowCount() && jTable.getSelectedRowCount() < 2 && jTable.getSelectedRow() != n) {
            jTable.getSelectionModel().setSelectionInterval(n, n);
        }
        return n;
    }

    protected TreePath checkTreeSelection(JTree jTree, Point point) {
        TreePath treePath = jTree.getPathForLocation(point.x, point.y);
        if (treePath != null && jTree.getSelectionCount() < 2 && !jTree.isPathSelected(treePath)) {
            jTree.setSelectionPath(treePath);
        }
        return treePath;
    }

    protected static boolean isDoubleClick(MouseEvent mouseEvent) {
        return mouseEvent != null && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2;
    }

    public final JPopupMenu getMenu() {
        return this.menu;
    }
}

