/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;

public class TaggingPresetSelector
extends JPanel
implements SelectionChangedListener {
    private static final int CLASSIFICATION_IN_FAVORITES = 300;
    private static final int CLASSIFICATION_NAME_MATCH = 300;
    private static final int CLASSIFICATION_GROUP_MATCH = 200;
    private static final int CLASSIFICATION_TAGS_MATCH = 100;
    private static final BooleanProperty SEARCH_IN_TAGS = new BooleanProperty("taggingpreset.dialog.search-in-tags", true);
    private static final BooleanProperty ONLY_APPLICABLE = new BooleanProperty("taggingpreset.dialog.only-applicable-to-selection", true);
    private JosmTextField edSearchText;
    private JList lsResult;
    private JCheckBox ckOnlyApplicable;
    private JCheckBox ckSearchInTags;
    private final EnumSet<TaggingPresetType> typesInSelection = EnumSet.noneOf(TaggingPresetType.class);
    private boolean typesInSelectionDirty = true;
    private final List<PresetClassification> classifications = new ArrayList<PresetClassification>();
    private ResultListModel lsResultModel = new ResultListModel();
    private ActionListener dblClickListener;
    private ActionListener clickListener;

    public TaggingPresetSelector(boolean bl, boolean bl2) {
        super(new BorderLayout());
        if (TaggingPresetPreference.taggingPresets != null) {
            this.loadPresets(TaggingPresetPreference.taggingPresets);
        }
        this.edSearchText = new JosmTextField();
        this.edSearchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TaggingPresetSelector.this.filterPresets();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TaggingPresetSelector.this.filterPresets();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TaggingPresetSelector.this.filterPresets();
            }
        });
        this.edSearchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 40: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResult.getSelectedIndex() + 1);
                        break;
                    }
                    case 38: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResult.getSelectedIndex() - 1);
                        break;
                    }
                    case 34: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResult.getSelectedIndex() + 10);
                        break;
                    }
                    case 33: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResult.getSelectedIndex() - 10);
                        break;
                    }
                    case 36: {
                        TaggingPresetSelector.this.selectPreset(0);
                        break;
                    }
                    case 35: {
                        TaggingPresetSelector.this.selectPreset(TaggingPresetSelector.this.lsResultModel.getSize());
                    }
                }
            }
        });
        this.add((Component)this.edSearchText, "North");
        this.lsResult = new JList();
        this.lsResult.setModel(this.lsResultModel);
        this.lsResult.setCellRenderer(new ResultListCellRenderer());
        this.lsResult.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    if (TaggingPresetSelector.this.dblClickListener != null) {
                        TaggingPresetSelector.this.dblClickListener.actionPerformed(null);
                    }
                } else if (TaggingPresetSelector.this.clickListener != null) {
                    TaggingPresetSelector.this.clickListener.actionPerformed(null);
                }
            }
        });
        this.add((Component)new JScrollPane(this.lsResult), "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (bl) {
            this.ckOnlyApplicable = new JCheckBox();
            this.ckOnlyApplicable.setText(I18n.tr("Show only applicable to selection", new Object[0]));
            jPanel.add(this.ckOnlyApplicable);
            this.ckOnlyApplicable.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    TaggingPresetSelector.this.filterPresets();
                }
            });
        }
        if (bl2) {
            this.ckSearchInTags = new JCheckBox();
            this.ckSearchInTags.setText(I18n.tr("Search in tags", new Object[0]));
            this.ckSearchInTags.setSelected(SEARCH_IN_TAGS.get());
            this.ckSearchInTags.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    TaggingPresetSelector.this.filterPresets();
                }
            });
            jPanel.add(this.ckSearchInTags);
        }
        this.add((Component)jPanel, "South");
        this.setPreferredSize(new Dimension(400, 300));
        this.filterPresets();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new AbstractAction(I18n.tr("Add toolbar button", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TaggingPresetSelector.this.getSelectedPreset().getToolbarString();
                Main.toolbar.addCustomButton(string, -1, false);
            }
        });
        this.lsResult.addMouseListener(new PopupMenuLauncher(jPopupMenu));
    }

    private void selectPreset(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.lsResultModel.getSize() - 1) {
            n = this.lsResultModel.getSize() - 1;
        }
        this.lsResult.setSelectedIndex(n);
        this.lsResult.ensureIndexIsVisible(n);
    }

    private void filterPresets() {
        String[] stringArray;
        String[] stringArray2;
        String string = this.edSearchText.getText().toLowerCase();
        if (string.contains("/")) {
            stringArray2 = string.substring(0, string.lastIndexOf(47)).split("[\\s/]");
            stringArray = string.substring(string.indexOf(47) + 1).split("\\s");
        } else {
            stringArray2 = null;
            stringArray = string.split("\\s");
        }
        boolean bl = this.ckOnlyApplicable != null && this.ckOnlyApplicable.isSelected();
        boolean bl2 = this.ckSearchInTags != null && this.ckSearchInTags.isSelected();
        ArrayList<PresetClassification> arrayList = new ArrayList<PresetClassification>();
        for (PresetClassification presetClassification : this.classifications) {
            int n;
            TaggingPreset taggingPreset = presetClassification.preset;
            presetClassification.classification = 0;
            if (bl && taggingPreset.types != null) {
                n = 0;
                for (TaggingPresetType taggingPresetType : taggingPreset.types) {
                    if (!this.getTypesInSelection().contains((Object)taggingPresetType)) continue;
                    n = 1;
                    break;
                }
                if (n == 0) continue;
            }
            if (stringArray2 != null && presetClassification.isMatchingGroup(stringArray2) == 0) continue;
            n = presetClassification.isMatchingName(stringArray);
            if (n == 0) {
                int n2;
                int n3;
                if (stringArray2 == null && (n3 = presetClassification.isMatchingGroup(stringArray)) > 0) {
                    presetClassification.classification = 200 + n3;
                }
                if (presetClassification.classification == 0 && bl2 && (n2 = presetClassification.isMatchingTags(stringArray)) > 0) {
                    presetClassification.classification = 100 + n2;
                }
            } else {
                presetClassification.classification = 300 + n;
            }
            if (presetClassification.classification <= 0) continue;
            presetClassification.classification += presetClassification.favoriteIndex;
            arrayList.add(presetClassification);
        }
        Collections.sort(arrayList);
        this.lsResultModel.setPresets(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumSet<TaggingPresetType> getTypesInSelection() {
        if (this.typesInSelectionDirty) {
            EnumSet<TaggingPresetType> enumSet = this.typesInSelection;
            synchronized (enumSet) {
                this.typesInSelectionDirty = false;
                this.typesInSelection.clear();
                if (Main.main == null || Main.main.getCurrentDataSet() == null) {
                    return this.typesInSelection;
                }
                for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().getSelected()) {
                    if (osmPrimitive instanceof Node) {
                        this.typesInSelection.add(TaggingPresetType.NODE);
                        continue;
                    }
                    if (osmPrimitive instanceof Way) {
                        this.typesInSelection.add(TaggingPresetType.WAY);
                        if (!((Way)osmPrimitive).isClosed()) continue;
                        this.typesInSelection.add(TaggingPresetType.CLOSEDWAY);
                        continue;
                    }
                    if (!(osmPrimitive instanceof Relation)) continue;
                    this.typesInSelection.add(TaggingPresetType.RELATION);
                }
            }
        }
        return this.typesInSelection;
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.typesInSelectionDirty = true;
    }

    public void init() {
        if (this.ckOnlyApplicable != null) {
            this.ckOnlyApplicable.setEnabled(!this.getTypesInSelection().isEmpty());
            this.ckOnlyApplicable.setSelected(!this.getTypesInSelection().isEmpty() && ONLY_APPLICABLE.get() != false);
        }
        this.edSearchText.setText("");
        this.filterPresets();
    }

    public void init(Collection<TaggingPreset> collection) {
        this.classifications.clear();
        this.loadPresets(collection);
        this.init();
    }

    public void clearSelection() {
        this.lsResult.getSelectionModel().clearSelection();
    }

    public void savePreferences() {
        if (this.ckSearchInTags != null) {
            SEARCH_IN_TAGS.put(this.ckSearchInTags.isSelected());
        }
        if (this.ckOnlyApplicable != null && this.ckOnlyApplicable.isEnabled()) {
            ONLY_APPLICABLE.put(this.ckOnlyApplicable.isSelected());
        }
    }

    public TaggingPreset getSelectedPreset() {
        List<PresetClassification> list = this.lsResultModel.getPresets();
        if (list.isEmpty()) {
            return null;
        }
        int n = this.lsResult.getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        TaggingPreset taggingPreset = list.get((int)n).preset;
        for (PresetClassification presetClassification : this.classifications) {
            if (presetClassification.preset == taggingPreset) {
                presetClassification.favoriteIndex = 300;
                continue;
            }
            if (presetClassification.favoriteIndex <= 0) continue;
            --presetClassification.favoriteIndex;
        }
        return taggingPreset;
    }

    private void loadPresets(Collection<TaggingPreset> collection) {
        for (TaggingPreset taggingPreset : collection) {
            if (taggingPreset instanceof TaggingPresetSeparator || taggingPreset instanceof TaggingPresetMenu) continue;
            this.classifications.add(new PresetClassification(taggingPreset));
        }
    }

    public void setSelectedPreset(TaggingPreset taggingPreset) {
        this.lsResult.setSelectedValue(taggingPreset, true);
    }

    public int getItemCount() {
        return this.lsResultModel.getSize();
    }

    public void setDblClickListener(ActionListener actionListener) {
        this.dblClickListener = actionListener;
    }

    public void setClickListener(ActionListener actionListener) {
        this.clickListener = actionListener;
    }

    public void addSelectionListener(final ActionListener actionListener) {
        this.lsResult.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    actionListener.actionPerformed(null);
                }
            }
        });
    }

    private static class PresetClassification
    implements Comparable<PresetClassification> {
        public final TaggingPreset preset;
        public int classification;
        public int favoriteIndex;
        private final Collection<String> groups = new HashSet<String>();
        private final Collection<String> names = new HashSet<String>();
        private final Collection<String> tags = new HashSet<String>();

        PresetClassification(TaggingPreset taggingPreset) {
            this.preset = taggingPreset;
            TaggingPresetMenu taggingPresetMenu = taggingPreset.group;
            while (taggingPresetMenu != null) {
                Collections.addAll(this.groups, taggingPresetMenu.getLocaleName().toLowerCase().split("\\s"));
                taggingPresetMenu = taggingPresetMenu.group;
            }
            Collections.addAll(this.names, taggingPreset.getLocaleName().toLowerCase().split("\\s"));
            for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                if (taggingPresetItem instanceof TaggingPresetItems.KeyedItem) {
                    this.tags.add(((TaggingPresetItems.KeyedItem)taggingPresetItem).key);
                    if (taggingPresetItem instanceof TaggingPresetItems.ComboMultiSelect) {
                        TaggingPresetItems.ComboMultiSelect comboMultiSelect = (TaggingPresetItems.ComboMultiSelect)taggingPresetItem;
                        if (Boolean.parseBoolean(comboMultiSelect.values_searchable)) {
                            this.tags.addAll(comboMultiSelect.getDisplayValues());
                        }
                    }
                    if (!(taggingPresetItem instanceof TaggingPresetItems.Key) || ((TaggingPresetItems.Key)taggingPresetItem).value == null) continue;
                    this.tags.add(((TaggingPresetItems.Key)taggingPresetItem).value);
                    continue;
                }
                if (!(taggingPresetItem instanceof TaggingPresetItems.Roles)) continue;
                for (TaggingPresetItems.Role role : ((TaggingPresetItems.Roles)taggingPresetItem).roles) {
                    this.tags.add(role.key);
                }
            }
        }

        private int isMatching(Collection<String> collection, String[] stringArray) {
            int n = 0;
            for (String string : stringArray) {
                boolean bl = false;
                boolean bl2 = false;
                for (String string2 : collection) {
                    int n2 = string2.toLowerCase().indexOf(string);
                    if (n2 == 0) {
                        bl2 = true;
                        break;
                    }
                    if (n2 <= 0) continue;
                    bl = true;
                }
                if (bl2) {
                    n += 2;
                    continue;
                }
                if (bl) {
                    ++n;
                    continue;
                }
                return 0;
            }
            return n;
        }

        int isMatchingGroup(String[] stringArray) {
            return this.isMatching(this.groups, stringArray);
        }

        int isMatchingName(String[] stringArray) {
            return this.isMatching(this.names, stringArray);
        }

        int isMatchingTags(String[] stringArray) {
            return this.isMatching(this.tags, stringArray);
        }

        @Override
        public int compareTo(PresetClassification presetClassification) {
            int n = presetClassification.classification - this.classification;
            if (n == 0) {
                return this.preset.getName().compareTo(presetClassification.preset.getName());
            }
            return n;
        }

        public String toString() {
            return this.classification + " " + this.preset.toString();
        }
    }

    private static class ResultListModel
    extends AbstractListModel {
        private List<PresetClassification> presets = new ArrayList<PresetClassification>();

        private ResultListModel() {
        }

        public void setPresets(List<PresetClassification> list) {
            this.presets = list;
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }

        public List<PresetClassification> getPresets() {
            return this.presets;
        }

        @Override
        public Object getElementAt(int n) {
            return this.presets.get((int)n).preset;
        }

        @Override
        public int getSize() {
            return this.presets.size();
        }
    }

    private static class ResultListCellRenderer
    extends DefaultListCellRenderer {
        private ResultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            TaggingPreset taggingPreset = (TaggingPreset)object;
            jLabel.setText(taggingPreset.getName());
            jLabel.setIcon((Icon)taggingPreset.getValue("SmallIcon"));
            return jLabel;
        }
    }
}

