/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PresetTextComparator;

public class TaggingPresetMenu
extends TaggingPreset {
    public JMenu menu = null;

    @Override
    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("Optional tooltip text", this.group != null ? I18n.tr("Preset group {1} / {0}", this.getLocaleName(), this.group.getName()) : I18n.tr("Preset group {0}", this.getLocaleName()));
        this.putValue("toolbar", "tagginggroup_" + this.getRawName());
    }

    private Component copyMenuComponent(Component component) {
        if (component instanceof JMenu) {
            JMenu jMenu = (JMenu)component;
            JMenu jMenu2 = new JMenu(jMenu.getAction());
            for (Component component2 : jMenu.getMenuComponents()) {
                jMenu2.add(this.copyMenuComponent(component2));
            }
            jMenu2.setText(jMenu.getText());
            return jMenu2;
        }
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            JMenuItem jMenuItem2 = new JMenuItem(jMenuItem.getAction());
            jMenuItem2.setText(jMenuItem.getText());
            return jMenuItem2;
        }
        if (component instanceof JSeparator) {
            return new JSeparator();
        }
        return component;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.menu != null && object instanceof Component) {
            JPopupMenu jPopupMenu = new JPopupMenu(this.getName());
            for (Component component : this.menu.getMenuComponents()) {
                jPopupMenu.add(this.copyMenuComponent(component));
            }
            Point point = MouseInfo.getPointerInfo().getLocation();
            jPopupMenu.show(Main.parent, point.x - Main.parent.getX(), point.y - Main.parent.getY());
        }
    }

    public void sortMenu() {
        TaggingPresetMenu.sortMenu(this.menu);
    }

    public static void sortMenu(JMenu jMenu) {
        Component[] componentArray = jMenu.getMenuComponents();
        PresetTextComparator presetTextComparator = new PresetTextComparator();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            int n2;
            int n3;
            Component component = componentArray[i];
            if (component instanceof JMenu) {
                TaggingPresetMenu.sortMenu((JMenu)component);
            }
            if (component instanceof JMenuItem) {
                arrayList.add((JMenuItem)component);
                if (i != componentArray.length - 1) continue;
                Collections.sort(arrayList, presetTextComparator);
                n3 = 0;
                for (JMenuItem jMenuItem : arrayList) {
                    n2 = n == 0 ? n3 : n3 + n + 1;
                    jMenu.add((Component)jMenuItem, n2);
                    ++n3;
                }
                arrayList = new ArrayList();
                n = 0;
                continue;
            }
            if (!(component instanceof JSeparator)) continue;
            Collections.sort(arrayList, presetTextComparator);
            n3 = 0;
            for (JMenuItem jMenuItem : arrayList) {
                n2 = n == 0 ? n3 : n3 + n + 1;
                jMenu.add((Component)jMenuItem, n2);
                ++n3;
            }
            arrayList = new ArrayList();
            n = i;
        }
    }
}

