/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.BoxTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class MapImage {
    private static final int MAX_SIZE = 48;
    private BufferedImage img;
    public int alpha = 255;
    public String name;
    public StyleSource source;
    public int width = -1;
    public int height = -1;
    private boolean temporary;
    private Image disabledImgCache;

    public MapImage(String string, StyleSource styleSource) {
        this.name = string;
        this.source = styleSource;
    }

    public Image getDisabled() {
        if (this.disabledImgCache != null) {
            return this.disabledImgCache;
        }
        if (this.img == null) {
            this.getImage();
        }
        this.disabledImgCache = GuiHelper.getDisabledImage(this.img);
        return this.disabledImgCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        if (this.img != null) {
            return this.img;
        }
        this.temporary = false;
        new ImageProvider(this.name).setDirs(MapPaintStyles.getIconSourceDirs(this.source)).setId("mappaint." + this.source.getPrefName()).setArchive(this.source.zipIcons).setInArchiveDir(this.source.getZipEntryDirName()).setWidth(this.width).setHeight(this.height).setOptional(true).getInBackground(new ImageProvider.ImageCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(ImageIcon imageIcon) {
                MapImage mapImage = MapImage.this;
                synchronized (mapImage) {
                    if (imageIcon == null) {
                        ImageIcon imageIcon2 = MapPaintStyles.getNoIcon_Icon(MapImage.this.source);
                        MapImage.this.img = imageIcon2 == null ? null : (BufferedImage)imageIcon2.getImage();
                    } else {
                        MapImage.this.img = (BufferedImage)imageIcon.getImage();
                    }
                    if (MapImage.this.temporary) {
                        MapImage.this.disabledImgCache = null;
                        Main.map.mapView.preferenceChanged(null);
                        Main.map.mapView.repaint();
                    }
                    MapImage.this.temporary = false;
                }
            }
        });
        MapImage mapImage = this;
        synchronized (mapImage) {
            if (this.img == null) {
                this.img = (BufferedImage)ImageProvider.get("clock").getImage();
                this.temporary = true;
            }
        }
        return this.img;
    }

    public int getWidth() {
        return this.getImage().getWidth(null);
    }

    public int getHeight() {
        return this.getImage().getHeight(null);
    }

    public float getAlphaFloat() {
        return Utils.color_int2float(this.alpha).floatValue();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public BoxTextElemStyle.BoxProvider getBoxProvider() {
        return new MapImageBoxProvider();
    }

    public Image getDisplayedNodeIcon(boolean bl) {
        Image image;
        Image image2 = image = bl ? this.getDisabled() : this.getImage();
        if (this.mustRescale(image)) {
            return ImageProvider.createBoundedImage(image, 16);
        }
        return image;
    }

    private boolean mustRescale(Image image) {
        return this.width == -1 && image.getWidth(null) > 48 && this.height == -1 && image.getHeight(null) > 48;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapImage mapImage = (MapImage)object;
        return this.alpha == mapImage.alpha && Utils.equal(this.name, mapImage.name) && Utils.equal(this.source, mapImage.source) && this.width == mapImage.width && this.height == mapImage.height;
    }

    public int hashCode() {
        int n = 7;
        n = 67 * n + this.alpha;
        n = 67 * n + this.name.hashCode();
        n = 67 * n + this.source.hashCode();
        n = 67 * n + this.width;
        n = 67 * n + this.height;
        return n;
    }

    public String toString() {
        return this.name;
    }

    protected class MapImageBoxProvider
    implements BoxTextElemStyle.BoxProvider {
        protected MapImageBoxProvider() {
        }

        @Override
        public BoxTextElemStyle.BoxProviderResult get() {
            return new BoxTextElemStyle.BoxProviderResult(this.box(), MapImage.this.temporary);
        }

        private Rectangle box() {
            int n = MapImage.this.getWidth();
            int n2 = MapImage.this.getHeight();
            if (MapImage.this.mustRescale(MapImage.this.getImage())) {
                n = 16;
                n2 = 16;
            }
            return new Rectangle(-n / 2, -n2 / 2, n, n2);
        }

        private MapImage getParent() {
            return MapImage.this;
        }

        public int hashCode() {
            return MapImage.this.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof BoxTextElemStyle.BoxProvider)) {
                return false;
            }
            if (object instanceof MapImageBoxProvider) {
                MapImageBoxProvider mapImageBoxProvider = (MapImageBoxProvider)object;
                return MapImage.this.equals(mapImageBoxProvider.getParent());
            }
            if (MapImage.this.temporary) {
                return false;
            }
            BoxTextElemStyle.BoxProvider boxProvider = (BoxTextElemStyle.BoxProvider)object;
            BoxTextElemStyle.BoxProviderResult boxProviderResult = boxProvider.get();
            if (boxProviderResult.isTemporary()) {
                return false;
            }
            return this.box().equals(boxProviderResult.getBox());
        }
    }
}

