/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.CustomizeColor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.gpx.ChooseTrackVisibilityAction;
import org.openstreetmap.josm.gui.layer.gpx.ConvertToDataLayerAction;
import org.openstreetmap.josm.gui.layer.gpx.CustomizeDrawingAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadWmsAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.ImportAudioAction;
import org.openstreetmap.josm.gui.layer.gpx.ImportImagesAction;
import org.openstreetmap.josm.gui.layer.gpx.MarkersFromNamedPointsAction;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class GpxLayer
extends Layer {
    public GpxData data;
    protected static final double PHI;
    private boolean computeCacheInSync;
    private int computeCacheMaxLineLengthUsed;
    private Color computeCacheColorUsed;
    private boolean computeCacheColorDynamic;
    private colorModes computeCacheColored;
    private int computeCacheColorTracksTune;
    private boolean isLocalFile;
    public boolean[] trackVisibility = new boolean[0];
    private final List<GpxTrack> lastTracks = new ArrayList<GpxTrack>();
    private int lastUpdateCount;
    private static final Color[] colors;
    private final Color[] hdopColors;
    private final int hdopAlpha = Main.pref.getInteger("hdop.color.alpha", -1);
    private static final Color[] colors_cyclic;
    private static final int ll0 = 9;
    private static final int sl4 = 5;
    private static final int sl9 = 3;
    private static final int[][] dir;

    public GpxLayer(GpxData gpxData) {
        super((String)gpxData.attr.get("name"));
        if (this.hdopAlpha >= 0) {
            this.hdopColors = new Color[256];
            for (int i = 0; i < this.hdopColors.length; ++i) {
                this.hdopColors[i] = new Color(colors[i].getRGB() & 0xFFFFFF | (this.hdopAlpha & 0xFF) << 24, true);
            }
        } else {
            this.hdopColors = colors;
        }
        this.data = gpxData;
        this.computeCacheInSync = false;
        this.ensureTrackVisibilityLength();
    }

    public GpxLayer(GpxData gpxData, String string) {
        this(gpxData);
        this.setName(string);
    }

    public GpxLayer(GpxData gpxData, String string, boolean bl) {
        this(gpxData);
        this.setName(string);
        this.isLocalFile = bl;
    }

    public static Date[] getMinMaxTimeForTrack(GpxTrack gpxTrack) {
        WayPoint wayPoint = null;
        WayPoint wayPoint2 = null;
        for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
            for (WayPoint wayPoint3 : gpxTrackSegment.getWayPoints()) {
                if (wayPoint2 == null) {
                    wayPoint2 = wayPoint = wayPoint3;
                    continue;
                }
                if (wayPoint3.compareTo(wayPoint) < 0) {
                    wayPoint = wayPoint3;
                    continue;
                }
                wayPoint2 = wayPoint3;
            }
        }
        if (wayPoint == null || wayPoint2 == null) {
            return null;
        }
        return new Date[]{wayPoint.getTime(), wayPoint2.getTime()};
    }

    public Date[] getMinMaxTimeForAllTracks() {
        double d = 1.0E100;
        double d2 = -1.0E100;
        double d3 = (double)System.currentTimeMillis() / 1000.0;
        for (GpxTrack gpxTrack : this.data.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    double d4 = wayPoint.time;
                    if (!(d4 > 0.0) || !(d4 <= d3)) continue;
                    if (d4 > d2) {
                        d2 = d4;
                    }
                    if (!(d4 < d)) continue;
                    d = d4;
                }
            }
        }
        if (d == 1.0E100 || d2 == -1.0E100) {
            return null;
        }
        return new Date[]{new Date((long)(d * 1000.0)), new Date((long)(d2 * 1000.0))};
    }

    public static String getTimespanForTrack(GpxTrack gpxTrack) {
        Date[] dateArray = GpxLayer.getMinMaxTimeForTrack(gpxTrack);
        String string = "";
        if (dateArray != null) {
            DateFormat dateFormat;
            String string2;
            DateFormat dateFormat2 = DateFormat.getDateInstance(3);
            String string3 = dateFormat2.format(dateArray[0]);
            if (string3.equals(string2 = dateFormat2.format(dateArray[1]))) {
                dateFormat = DateFormat.getTimeInstance(3);
                string = string + string3 + " ";
                string = string + dateFormat.format(dateArray[0]) + " - " + dateFormat.format(dateArray[1]);
            } else {
                dateFormat = DateFormat.getDateTimeInstance(3, 3);
                string = string + dateFormat.format(dateArray[0]) + " - " + dateFormat.format(dateArray[1]);
            }
            int n = (int)(dateArray[1].getTime() - dateArray[0].getTime()) / 1000;
            string = string + String.format(" (%d:%02d)", n / 3600, n % 3600 / 60);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "gpx_small");
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.data.attr.containsKey("name")) {
            stringBuilder.append(I18n.tr("Name: {0}", this.data.attr.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            stringBuilder.append(I18n.tr("Description: {0}", this.data.attr.get("meta.desc"))).append("<br>");
        }
        if (!this.data.tracks.isEmpty()) {
            stringBuilder.append("<table><thead align='center'><tr><td colspan='5'>" + I18n.trn("{0} track", "{0} tracks", this.data.tracks.size(), this.data.tracks.size()) + "</td></tr><tr align='center'><td>" + I18n.tr("Name", new Object[0]) + "</td><td>" + I18n.tr("Description", new Object[0]) + "</td><td>" + I18n.tr("Timespan", new Object[0]) + "</td><td>" + I18n.tr("Length", new Object[0]) + "</td><td>" + I18n.tr("URL", new Object[0]) + "</td></tr></thead>");
            for (GpxTrack gpxTrack : this.data.tracks) {
                stringBuilder.append("<tr><td>");
                if (gpxTrack.getAttributes().containsKey("name")) {
                    stringBuilder.append(gpxTrack.getAttributes().get("name"));
                }
                stringBuilder.append("</td><td>");
                if (gpxTrack.getAttributes().containsKey("desc")) {
                    stringBuilder.append(" ").append(gpxTrack.getAttributes().get("desc"));
                }
                stringBuilder.append("</td><td>");
                stringBuilder.append(GpxLayer.getTimespanForTrack(gpxTrack));
                stringBuilder.append("</td><td>");
                stringBuilder.append(NavigatableComponent.getSystemOfMeasurement().getDistText(gpxTrack.length()));
                stringBuilder.append("</td><td>");
                if (gpxTrack.getAttributes().containsKey("url")) {
                    stringBuilder.append(gpxTrack.getAttributes().get("url"));
                }
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("</table><br><br>");
        }
        stringBuilder.append(I18n.tr("Length: {0}", NavigatableComponent.getSystemOfMeasurement().getDistText(this.data.length()))).append("<br>");
        stringBuilder.append(I18n.trn("{0} route, ", "{0} routes, ", this.data.routes.size(), this.data.routes.size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.waypoints.size(), this.data.waypoints.size())).append("<br>");
        final JScrollPane jScrollPane = new JScrollPane(new HtmlPanel(stringBuilder.toString()));
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width + 20, 370));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        return jScrollPane;
    }

    @Override
    public boolean isInfoResizable() {
        return true;
    }

    @Override
    public Color getColor(boolean bl) {
        Color color = Main.pref.getColor(I18n.marktr("gps point"), "layer " + this.getName(), Color.gray);
        return bl || this.getColorMode() == colorModes.none ? color : null;
    }

    public colorModes getColorMode() {
        try {
            int n = Main.pref.getInteger("draw.rawgps.colors", "layer " + this.getName(), 0);
            return colorModes.values()[n];
        }
        catch (Exception exception) {
            Main.warn(exception);
            return colorModes.none;
        }
    }

    public static Color getGenericColor() {
        return Main.pref.getColor(I18n.marktr("gps point"), Color.gray);
    }

    @Override
    public Action[] getMenuEntries() {
        if (Main.applet) {
            return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new CustomizeColor(this), new CustomizeDrawingAction(this), new ConvertToDataLayerAction(this), Layer.SeparatorLayerAction.INSTANCE, new ChooseTrackVisibilityAction(this), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
        }
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this), new CustomizeColor(this), new CustomizeDrawingAction(this), new ImportImagesAction(this), new ImportAudioAction(this), new MarkersFromNamedPointsAction(this), new ConvertToDataLayerAction(this), new DownloadAlongTrackAction(this.data), new DownloadWmsAlongTrackAction(this.data), Layer.SeparatorLayerAction.INSTANCE, new ChooseTrackVisibilityAction(this), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    public boolean isLocalFile() {
        return this.isLocalFile;
    }

    @Override
    public String getToolTipText() {
        StringBuilder stringBuilder = new StringBuilder().append("<html>");
        if (this.data.attr.containsKey("name")) {
            stringBuilder.append(I18n.tr("Name: {0}", this.data.attr.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            stringBuilder.append(I18n.tr("Description: {0}", this.data.attr.get("meta.desc"))).append("<br>");
        }
        stringBuilder.append(I18n.trn("{0} track, ", "{0} tracks, ", this.data.tracks.size(), this.data.tracks.size()));
        stringBuilder.append(I18n.trn("{0} route, ", "{0} routes, ", this.data.routes.size(), this.data.routes.size()));
        stringBuilder.append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.waypoints.size(), this.data.waypoints.size())).append("<br>");
        stringBuilder.append(I18n.tr("Length: {0}", NavigatableComponent.getSystemOfMeasurement().getDistText(this.data.length())));
        stringBuilder.append("<br>");
        return stringBuilder.append("</html>").toString();
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof GpxLayer;
    }

    private int sumUpdateCount() {
        int n = 0;
        for (GpxTrack gpxTrack : this.data.tracks) {
            n += gpxTrack.getUpdateCount();
        }
        return n;
    }

    @Override
    public boolean isChanged() {
        if (((Object)this.data.tracks).equals(this.lastTracks)) {
            return this.sumUpdateCount() != this.lastUpdateCount;
        }
        return true;
    }

    public void filterTracksByDate(Date date, Date date2, boolean bl) {
        int n = 0;
        long l = date.getTime();
        long l2 = date2.getTime();
        for (GpxTrack gpxTrack : this.data.tracks) {
            Date[] dateArray = GpxLayer.getMinMaxTimeForTrack(gpxTrack);
            if (dateArray == null) continue;
            long l3 = dateArray[1].getTime();
            this.trackVisibility[n] = l3 == 0L && bl || l <= l3 && l3 <= l2;
            ++n;
        }
    }

    @Override
    public void mergeFrom(Layer layer) {
        this.data.mergeFrom(((GpxLayer)layer).data);
        this.computeCacheInSync = false;
    }

    private static float w(float f) {
        if ((double)f < 0.5) {
            return 1.0f - 2.0f * f * f;
        }
        return 2.0f * (1.0f - f) * (1.0f - f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Object object;
        Object object2;
        Object object522;
        boolean bl;
        int n;
        this.lastUpdateCount = this.sumUpdateCount();
        this.lastTracks.clear();
        this.lastTracks.addAll(this.data.tracks);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.gpx.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        Color color = this.getColor(true);
        String string = "layer " + this.getName();
        boolean bl2 = Main.pref.getBoolean("draw.rawgps.lines.force", string, false);
        boolean bl3 = Main.pref.getBoolean("draw.rawgps.direction", string, false);
        int n2 = Main.pref.getInteger("draw.rawgps.linewidth", string, 0);
        if (!this.data.fromServer) {
            n = Main.pref.getInteger("draw.rawgps.max-line-length.local", string, -1);
            bl = Main.pref.getBoolean("draw.rawgps.lines.local", string, true);
        } else {
            n = Main.pref.getInteger("draw.rawgps.max-line-length", string, 200);
            bl = Main.pref.getBoolean("draw.rawgps.lines", string, true);
        }
        boolean bl4 = Main.pref.getBoolean("draw.rawgps.large", string, false);
        int n3 = Main.pref.getInteger("draw.rawgps.large.size", string, 3);
        boolean bl5 = Main.pref.getBoolean("draw.rawgps.hdopcircle", string, false);
        colorModes colorModes2 = this.getColorMode();
        boolean bl6 = Main.pref.getBoolean("draw.rawgps.alternatedirection", string, false);
        int n4 = Main.pref.getInteger("draw.rawgps.min-arrow-distance", string, 40);
        int n5 = Main.pref.getInteger("draw.rawgps.colorTracksTune", string, 45);
        boolean bl7 = Main.pref.getBoolean("draw.rawgps.colors.dynamic", string, false);
        int n6 = Main.pref.getInteger("hdop.factor", 25);
        Stroke stroke = graphics2D.getStroke();
        if (n2 != 0) {
            graphics2D.setStroke(new BasicStroke(n2, 1, 1));
            n3 += n2;
        }
        if (this.computeCacheMaxLineLengthUsed != n || !color.equals(this.computeCacheColorUsed) || this.computeCacheColored != colorModes2 || this.computeCacheColorTracksTune != n5 || this.computeCacheColorDynamic != bl7) {
            this.computeCacheMaxLineLengthUsed = n;
            this.computeCacheInSync = false;
            this.computeCacheColorUsed = color;
            this.computeCacheColored = colorModes2;
            this.computeCacheColorTracksTune = n5;
            this.computeCacheColorDynamic = bl7;
        }
        if (!this.computeCacheInSync) {
            double d = 1.0E10;
            double d2 = -1.0E10;
            object522 = null;
            if (bl7) {
                double d3;
                Object object3;
                if (colorModes2 == colorModes.velocity) {
                    for (Collection<WayPoint> collection : this.data.getLinesIterable(null)) {
                        if (!bl2) {
                            object522 = null;
                        }
                        for (WayPoint wayPoint : collection) {
                            object3 = wayPoint.getCoor();
                            if (Double.isNaN(((LatLon)object3).lat()) || Double.isNaN(((LatLon)object3).lon())) continue;
                            if (object522 != null && wayPoint.time > ((WayPoint)object522).time) {
                                d3 = ((LatLon)object3).greatCircleDistance(((WayPoint)object522).getCoor()) / (wayPoint.time - ((WayPoint)object522).time);
                                if (d3 > d2) {
                                    d2 = d3;
                                }
                                if (d3 < d) {
                                    d = d3;
                                }
                            }
                            object522 = wayPoint;
                        }
                    }
                } else if (colorModes2 == colorModes.dilution) {
                    for (Collection<WayPoint> collection : this.data.getLinesIterable(null)) {
                        for (WayPoint wayPoint : collection) {
                            object3 = wayPoint.attr.get("hdop");
                            if (object3 == null) continue;
                            d3 = ((Float)object3).doubleValue();
                            if (d3 > d2) {
                                d2 = d3;
                            }
                            if (!(d3 < d)) continue;
                            d = d3;
                        }
                    }
                }
                object522 = null;
            }
            double latLon = (double)System.currentTimeMillis() / 1000.0;
            if (colorModes2 == colorModes.time) {
                object2 = this.getMinMaxTimeForAllTracks();
                if (object2 != null) {
                    d = (double)object2[0].getTime() / 1000.0;
                    d2 = (double)((Date)object2[1]).getTime() / 1000.0;
                } else {
                    d = 0.0;
                    d2 = latLon;
                }
            }
            for (Collection collection : this.data.getLinesIterable(null)) {
                if (!bl2) {
                    object522 = null;
                }
                for (WayPoint wayPoint : collection) {
                    int n7;
                    LatLon latLon2 = wayPoint.getCoor();
                    if (Double.isNaN(latLon2.lat()) || Double.isNaN(latLon2.lon())) continue;
                    wayPoint.customColoring = color;
                    if (wayPoint.attr.get("hdop") != null) {
                        if (colorModes2 == colorModes.dilution) {
                            float f = ((Float)wayPoint.attr.get("hdop")).floatValue();
                            int n8 = (int)Math.round(bl7 ? ((double)f - d) * 255.0 / (d2 - d) : (double)(f <= 0.0f ? 0.0f : f * (float)n6));
                            n7 = 255 - (n8 > 255 ? 255 : n8);
                            wayPoint.customColoring = colors[n7];
                            wayPoint.customColoringTransparent = this.hdopColors[n7];
                        } else {
                            wayPoint.customColoringTransparent = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.hdopAlpha & 0xFF);
                        }
                    }
                    if (object522 != null) {
                        double d4 = latLon2.greatCircleDistance(((WayPoint)object522).getCoor());
                        n7 = 0;
                        switch (colorModes2) {
                            case velocity: {
                                double d5 = wayPoint.time - ((WayPoint)object522).time;
                                if (d5 > 0.0) {
                                    float f = (float)(d4 / d5);
                                    int n9 = (int)Math.round(bl7 ? ((double)f - d) * 255.0 / (d2 - d) : (double)(f <= 0.0f ? 0.0f : f / (float)n5 * 255.0f));
                                    int n10 = Math.max(0, Math.min(n9, 255));
                                    wayPoint.customColoring = n10 == 255 ? color : colors[n10];
                                    break;
                                }
                                wayPoint.customColoring = color;
                                break;
                            }
                            case direction: {
                                double d6 = ((WayPoint)object522).getCoor().heading(wayPoint.getCoor()) / (Math.PI * 2) * 256.0;
                                if (d6 != d6 || d6 < 0.0 || d6 >= 256.0) {
                                    wayPoint.customColoring = colors_cyclic[0];
                                    break;
                                }
                                wayPoint.customColoring = colors_cyclic[(int)d6];
                                break;
                            }
                            case time: {
                                double d7 = wayPoint.time;
                                if (d7 > 0.0 && d7 <= latLon && d2 - d > 1000.0) {
                                    int n11 = (int)Math.round((d7 - d) * 255.0 / (d2 - d));
                                    wayPoint.customColoring = colors[n11];
                                    break;
                                }
                                wayPoint.customColoring = color;
                            }
                        }
                        if (n7 == 0 && (n == -1 || d4 <= (double)n)) {
                            wayPoint.drawLine = true;
                            wayPoint.dir = (int)((WayPoint)object522).getCoor().heading(wayPoint.getCoor());
                        } else {
                            wayPoint.drawLine = false;
                        }
                    } else {
                        wayPoint.drawLine = false;
                    }
                    object522 = wayPoint;
                }
            }
            this.computeCacheInSync = true;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        WayPoint wayPoint = null;
        this.ensureTrackVisibilityLength();
        for (Collection<WayPoint> collection : this.data.getLinesIterable(this.trackVisibility)) {
            for (WayPoint wayPoint3 : collection) {
                Bounds bounds2 = new Bounds(wayPoint3.getCoor());
                if (wayPoint3.drawLine) {
                    bounds2.extend(wayPoint.getCoor());
                }
                if (bounds2.intersects(bounds)) {
                    if (wayPoint != null && (linkedList.isEmpty() || linkedList.getLast() != wayPoint)) {
                        if (wayPoint.drawLine) {
                            object2 = new WayPoint(wayPoint);
                            ((WayPoint)object2).drawLine = false;
                            linkedList.add(object2);
                        } else {
                            linkedList.add(wayPoint);
                        }
                    }
                    linkedList.add(wayPoint3);
                }
                wayPoint = wayPoint3;
            }
        }
        if (linkedList.isEmpty()) {
            return;
        }
        if (bl) {
            object = null;
            for (Object object522 : linkedList) {
                LatLon wayPoint4 = ((WayPoint)object522).getCoor();
                if (Double.isNaN(wayPoint4.lat()) || Double.isNaN(wayPoint4.lon())) continue;
                Point point = mapView.getPoint(((WayPoint)object522).getEastNorth());
                if (((WayPoint)object522).drawLine && object != null && (((Point)object).x != point.x || ((Point)object).y != point.y)) {
                    graphics2D.setColor(((WayPoint)object522).customColoring);
                    graphics2D.drawLine(((Point)object).x, ((Point)object).y, point.x, point.y);
                }
                object = point;
            }
        }
        if (bl && bl3 && !bl6) {
            object = null;
            Object var24_81 = null;
            for (WayPoint latLon : linkedList) {
                void var24_82;
                LatLon latLon3 = latLon.getCoor();
                if (Double.isNaN(latLon3.lat()) || Double.isNaN(latLon3.lon()) || !latLon.drawLine) continue;
                object2 = mapView.getPoint(latLon.getEastNorth());
                if (object != null && (var24_82 == null || ((Point)object2).x < var24_82.x - n4 || ((Point)object2).x > var24_82.x + n4 || ((Point)object2).y < var24_82.y - n4 || ((Point)object2).y > var24_82.y + n4)) {
                    graphics2D.setColor(latLon.customColoring);
                    double d = Math.atan2(((Point)object2).y - ((Point)object).y, ((Point)object2).x - ((Point)object).x) + Math.PI;
                    graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, (int)((double)((Point)object2).x + 10.0 * Math.cos(d - PHI)), (int)((double)((Point)object2).y + 10.0 * Math.sin(d - PHI)));
                    graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, (int)((double)((Point)object2).x + 10.0 * Math.cos(d + PHI)), (int)((double)((Point)object2).y + 10.0 * Math.sin(d + PHI)));
                    Object object4 = object2;
                }
                object = object2;
            }
        }
        if (bl && bl3 && bl6) {
            object = null;
            Object var24_85 = null;
            for (WayPoint point : linkedList) {
                void var24_86;
                LatLon latLon = point.getCoor();
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon()) || !point.drawLine) continue;
                object2 = mapView.getPoint(point.getEastNorth());
                if (object != null && (var24_86 == null || ((Point)object2).x < var24_86.x - n4 || ((Point)object2).x > var24_86.x + n4 || ((Point)object2).y < var24_86.y - n4 || ((Point)object2).y > var24_86.y + n4)) {
                    graphics2D.setColor(point.customColoring);
                    graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)object2).x + dir[point.dir][0], ((Point)object2).y + dir[point.dir][1]);
                    graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)object2).x + dir[point.dir][2], ((Point)object2).y + dir[point.dir][3]);
                    Object object5 = object2;
                }
                object = object2;
            }
        }
        if (bl4 || bl5) {
            int n12 = n3 / 2;
            graphics2D.setColor(color);
            for (Object object522 : linkedList) {
                LatLon point = ((WayPoint)object522).getCoor();
                if (Double.isNaN(point.lat()) || Double.isNaN(point.lon())) continue;
                Point point2 = mapView.getPoint(((WayPoint)object522).getEastNorth());
                graphics2D.setColor(((WayPoint)object522).customColoringTransparent);
                if (bl5 && ((WayPoint)object522).attr.get("hdop") != null) {
                    float f = ((Float)((WayPoint)object522).attr.get("hdop")).floatValue();
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    int n13 = mapView.getPoint((LatLon)new LatLon((double)((WayPoint)object522).getCoor().lat(), (double)(((WayPoint)object522).getCoor().lon() + (double)(12.0f * f * 360.0f / 4.0E7f)))).x - point2.x;
                    graphics2D.drawArc(point2.x - n13 / 2, point2.y - n13 / 2, n13, n13, 0, 360);
                }
                if (!bl4) continue;
                graphics2D.fillRect(point2.x - n12, point2.y - n12, n3, n3);
            }
        }
        if (!bl4 && bl) {
            graphics2D.setColor(color);
            for (WayPoint wayPoint2 : linkedList) {
                object522 = wayPoint2.getCoor();
                if (Double.isNaN(((LatLon)object522).lat()) || Double.isNaN(((LatLon)object522).lon()) || wayPoint2.drawLine) continue;
                Point point = mapView.getPoint(wayPoint2.getEastNorth());
                graphics2D.drawRect(point.x, point.y, 0, 0);
            }
        }
        if (!bl4 && !bl) {
            graphics2D.setColor(color);
            for (WayPoint wayPoint3 : linkedList) {
                object522 = wayPoint3.getCoor();
                if (Double.isNaN(((LatLon)object522).lat()) || Double.isNaN(((LatLon)object522).lon())) continue;
                Point point = mapView.getPoint(wayPoint3.getEastNorth());
                graphics2D.setColor(wayPoint3.customColoring);
                graphics2D.drawRect(point.x, point.y, 0, 0);
            }
        }
        if (n2 != 0) {
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        boundingXYVisitor.visit(this.data.recalculateBounds());
    }

    @Override
    public File getAssociatedFile() {
        return this.data.storageFile;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.data.storageFile = file;
    }

    private final void ensureTrackVisibilityLength() {
        int n = this.data.tracks.size();
        if (n == this.trackVisibility.length) {
            return;
        }
        int n2 = Math.min(n, this.trackVisibility.length);
        this.trackVisibility = Arrays.copyOf(this.trackVisibility, n);
        for (int i = n2; i < n; ++i) {
            this.trackVisibility[i] = true;
        }
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        if (projection2 == null) {
            return;
        }
        if (this.data.waypoints != null) {
            for (WayPoint iWithAttributes : this.data.waypoints) {
                iWithAttributes.invalidateEastNorthCache();
            }
        }
        if (this.data.tracks != null) {
            for (GpxTrack gpxTrack : this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                        wayPoint.invalidateEastNorthCache();
                    }
                }
            }
        }
        if (this.data.routes != null) {
            for (GpxRoute gpxRoute : this.data.routes) {
                if (gpxRoute.routePoints == null) continue;
                for (WayPoint wayPoint : gpxRoute.routePoints) {
                    wayPoint.invalidateEastNorthCache();
                }
            }
        }
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean checkSaveConditions() {
        return this.data != null;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file", new Object[0]), GpxImporter.FILE_FILTER);
    }

    static {
        int n;
        PHI = Math.toRadians(15.0);
        colors = new Color[256];
        for (n = 0; n < colors.length; ++n) {
            GpxLayer.colors[n] = Color.getHSBColor((float)n / 300.0f, 1.0f, 1.0f);
        }
        colors_cyclic = new Color[256];
        for (n = 0; n < colors_cyclic.length; ++n) {
            int[] nArray = new int[]{0, 59, 127, 244, 360};
            int[] nArray2 = new int[]{100, 84, 99, 100};
            int[] nArray3 = new int[]{90, 93, 74, 83};
            float f = 4.0f - (float)n / 256.0f * 4.0f;
            int n2 = (int)f;
            f -= (float)n2;
            n2 = Utils.mod(n2 + 1, 4);
            float f2 = (float)nArray[n2] * GpxLayer.w(f) + (float)nArray[n2 + 1] * (1.0f - GpxLayer.w(f));
            float f3 = (float)nArray2[n2] * GpxLayer.w(f) + (float)nArray2[Utils.mod(n2 + 1, 4)] * (1.0f - GpxLayer.w(f));
            float f4 = (float)nArray3[n2] * GpxLayer.w(f) + (float)nArray3[Utils.mod(n2 + 1, 4)] * (1.0f - GpxLayer.w(f));
            GpxLayer.colors_cyclic[n] = Color.getHSBColor(f2 / 360.0f, f3 / 100.0f, f4 / 100.0f);
        }
        dir = new int[][]{{5, 9, 9, 5}, {-3, 9, 3, 9}, {-9, 5, -5, 9}, {-9, -3, -9, 3}, {-5, -9, -9, -5}, {3, -9, -3, -9}, {9, -5, 5, -9}, {9, 3, 9, -3}, {5, 9, 9, 5}, {-3, 9, 3, 9}, {-9, 5, -5, 9}, {-9, -3, -9, 3}};
    }

    static enum colorModes {
        none,
        velocity,
        dilution,
        direction,
        time;

    }
}

