/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.io.SaveLayerTask;
import org.openstreetmap.josm.gui.io.SaveLayersModel;
import org.openstreetmap.josm.gui.io.SaveLayersTable;
import org.openstreetmap.josm.gui.io.UploadAndSaveProgressRenderer;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadLayerTask;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class SaveLayersDialog
extends JDialog
implements TableModelListener {
    private SaveLayersModel model;
    private UserAction action = UserAction.CANCEL;
    private UploadAndSaveProgressRenderer pnlUploadLayers;
    private SaveAndProceedAction saveAndProceedAction;
    private DiscardAndProceedAction discardAndProceedAction;
    private CancelAction cancelAction;
    private SaveAndUploadTask saveAndUploadTask;
    private JButton saveAndProceedActionButton = null;

    protected void build() {
        WindowGeometry windowGeometry = WindowGeometry.centerOnScreen(new Dimension(650, 300));
        windowGeometry.applySafe(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.model = new SaveLayersModel();
        SaveLayersTable saveLayersTable = new SaveLayersTable(this.model);
        JScrollPane jScrollPane = new JScrollPane(saveLayersTable);
        this.model.addPropertyChangeListener(saveLayersTable);
        saveLayersTable.getModel().addTableModelListener(this);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowClosingAdapter());
        this.setDefaultCloseOperation(2);
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        this.saveAndProceedAction = new SaveAndProceedAction();
        this.model.addPropertyChangeListener(this.saveAndProceedAction);
        this.saveAndProceedActionButton = new JButton(this.saveAndProceedAction);
        jPanel.add(this.saveAndProceedActionButton);
        this.discardAndProceedAction = new DiscardAndProceedAction();
        this.model.addPropertyChangeListener(this.discardAndProceedAction);
        jPanel.add(new JButton(this.discardAndProceedAction));
        this.cancelAction = new CancelAction();
        jPanel.add(new JButton(this.cancelAction));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.pnlUploadLayers = new UploadAndSaveProgressRenderer();
        jPanel2.add((Component)this.pnlUploadLayers, "Center");
        this.model.addPropertyChangeListener(this.pnlUploadLayers);
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    public void prepareForSavingAndUpdatingLayersBeforeExit() {
        this.setTitle(I18n.tr("Unsaved changes - Save/Upload before exiting?", new Object[0]));
        this.saveAndProceedAction.initForSaveAndExit();
        this.discardAndProceedAction.initForDiscardAndExit();
    }

    public void prepareForSavingAndUpdatingLayersBeforeDelete() {
        this.setTitle(I18n.tr("Unsaved changes - Save/Upload before deleting?", new Object[0]));
        this.saveAndProceedAction.initForSaveAndDelete();
        this.discardAndProceedAction.initForDiscardAndDelete();
    }

    public SaveLayersDialog(Component component) {
        super((Window)JOptionPane.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public UserAction getUserAction() {
        return this.action;
    }

    public SaveLayersModel getModel() {
        return this.model;
    }

    protected void launchSafeAndUploadTask() {
        SwingRenderingProgressMonitor swingRenderingProgressMonitor = new SwingRenderingProgressMonitor(this.pnlUploadLayers);
        swingRenderingProgressMonitor.beginTask(I18n.tr("Uploading and saving modified layers ...", new Object[0]));
        this.saveAndUploadTask = new SaveAndUploadTask(this.model, swingRenderingProgressMonitor);
        new Thread(this.saveAndUploadTask).start();
    }

    protected void cancelSafeAndUploadTask() {
        if (this.saveAndUploadTask != null) {
            this.saveAndUploadTask.cancel();
        }
        this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
    }

    protected void warnLayersWithConflictsAndUploadRequest(List<SaveLayerInfo> list) {
        String string = I18n.trn("<html>{0} layer has unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layer with conflicts:</html>", "<html>{0} layers have unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layers with conflicts:</html>", list.size(), list.size());
        JOptionPane.showConfirmDialog(Main.parent, new LayerListWarningMessagePanel(string, list), I18n.tr("Unsaved data and conflicts", new Object[0]), -1, 2);
    }

    protected void warnLayersWithoutFilesAndSaveRequest(List<SaveLayerInfo> list) {
        String string = I18n.trn("<html>{0} layer needs saving but has no associated file.<br>Either select a file for this layer or discard the changes.<br>Layer without a file:</html>", "<html>{0} layers need saving but have no associated file.<br>Either select a file for each of them or discard the changes.<br>Layers without a file:</html>", list.size(), list.size());
        JOptionPane.showConfirmDialog(Main.parent, new LayerListWarningMessagePanel(string, list), I18n.tr("Unsaved data and missing associated file", new Object[0]), -1, 2);
    }

    protected void warnLayersWithIllegalFilesAndSaveRequest(List<SaveLayerInfo> list) {
        String string = I18n.trn("<html>{0} layer needs saving but has an associated file<br>which cannot be written.<br>Either select another file for this layer or discard the changes.<br>Layer with a non-writable file:</html>", "<html>{0} layers need saving but have associated files<br>which cannot be written.<br>Either select another file for each of them or discard the changes.<br>Layers with non-writable files:</html>", list.size(), list.size());
        JOptionPane.showConfirmDialog(Main.parent, new LayerListWarningMessagePanel(string, list), I18n.tr("Unsaved data non-writable files", new Object[0]), -1, 2);
    }

    protected boolean confirmSaveLayerInfosOK() {
        List<SaveLayerInfo> list = this.model.getLayersWithConflictsAndUploadRequest();
        if (!list.isEmpty()) {
            this.warnLayersWithConflictsAndUploadRequest(list);
            return false;
        }
        list = this.model.getLayersWithoutFilesAndSaveRequest();
        if (!list.isEmpty()) {
            this.warnLayersWithoutFilesAndSaveRequest(list);
            return false;
        }
        list = this.model.getLayersWithIllegalFilesAndSaveRequest();
        if (!list.isEmpty()) {
            this.warnLayersWithIllegalFilesAndSaveRequest(list);
            return false;
        }
        return true;
    }

    protected void setUserAction(UserAction userAction) {
        this.action = userAction;
    }

    public void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl;
        boolean bl2 = bl = this.model.getLayersToSave().isEmpty() && this.model.getLayersToUpload().isEmpty();
        if (this.saveAndProceedActionButton != null) {
            this.saveAndProceedActionButton.setEnabled(!bl);
        }
        this.saveAndProceedAction.redrawIcon();
    }

    protected class SaveAndUploadTask
    implements Runnable {
        private SaveLayersModel model;
        private ProgressMonitor monitor;
        private ExecutorService worker;
        private boolean canceled;
        private Future<?> currentFuture;
        private AbstractIOTask currentTask;

        public SaveAndUploadTask(SaveLayersModel saveLayersModel, ProgressMonitor progressMonitor) {
            this.model = saveLayersModel;
            this.monitor = progressMonitor;
            this.worker = Executors.newSingleThreadExecutor();
        }

        protected void uploadLayers(List<SaveLayerInfo> list) {
            for (SaveLayerInfo saveLayerInfo : list) {
                if (this.canceled) {
                    this.model.setUploadState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                    continue;
                }
                this.monitor.subTask(I18n.tr("Preparing layer ''{0}'' for upload ...", saveLayerInfo.getName()));
                if (!new UploadAction().checkPreUploadConditions(saveLayerInfo.getLayer())) {
                    this.model.setUploadState(saveLayerInfo.getLayer(), UploadOrSaveState.FAILED);
                    continue;
                }
                UploadDialog uploadDialog = UploadDialog.getUploadDialog();
                uploadDialog.setUploadedPrimitives(new APIDataSet(saveLayerInfo.getLayer().data));
                uploadDialog.setVisible(true);
                if (uploadDialog.isCanceled()) {
                    this.model.setUploadState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                    continue;
                }
                uploadDialog.rememberUserInput();
                this.currentTask = new UploadLayerTask(UploadDialog.getUploadDialog().getUploadStrategySpecification(), saveLayerInfo.getLayer(), this.monitor, UploadDialog.getUploadDialog().getChangeset());
                this.currentFuture = this.worker.submit(this.currentTask);
                try {
                    this.currentFuture.get();
                }
                catch (CancellationException cancellationException) {
                    this.model.setUploadState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                }
                catch (Exception exception) {
                    Main.error(exception);
                    this.model.setUploadState(saveLayerInfo.getLayer(), UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(exception);
                }
                if (this.currentTask.isCanceled()) {
                    this.model.setUploadState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                } else if (this.currentTask.isFailed()) {
                    Main.error(this.currentTask.getLastException());
                    ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    this.model.setUploadState(saveLayerInfo.getLayer(), UploadOrSaveState.FAILED);
                } else {
                    this.model.setUploadState(saveLayerInfo.getLayer(), UploadOrSaveState.OK);
                }
                this.currentTask = null;
                this.currentFuture = null;
            }
        }

        protected void saveLayers(List<SaveLayerInfo> list) {
            for (SaveLayerInfo saveLayerInfo : list) {
                if (this.canceled) {
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                    continue;
                }
                this.currentTask = new SaveLayerTask(saveLayerInfo, this.monitor);
                this.currentFuture = this.worker.submit(this.currentTask);
                try {
                    this.currentFuture.get();
                }
                catch (CancellationException cancellationException) {
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                }
                catch (Exception exception) {
                    Main.error(exception);
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(exception);
                }
                if (this.currentTask.isCanceled()) {
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.CANCELED);
                } else if (this.currentTask.isFailed()) {
                    if (this.currentTask.getLastException() != null) {
                        Main.error(this.currentTask.getLastException());
                        ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    }
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.FAILED);
                } else {
                    this.model.setSaveState(saveLayerInfo.getLayer(), UploadOrSaveState.OK);
                }
                this.currentTask = null;
                this.currentFuture = null;
            }
        }

        protected void warnBecauseOfUnsavedData() {
            int n = this.model.getNumCancel() + this.model.getNumFailed();
            if (n == 0) {
                return;
            }
            String string = I18n.trn("<html>An upload and/or save operation of one layer with modifications<br>was canceled or has failed.</html>", "<html>Upload and/or save operations of {0} layers with modifications<br>were canceled or have failed.</html>", n, n);
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Incomplete upload and/or save", new Object[0]), 2);
        }

        @Override
        public void run() {
            List<SaveLayerInfo> list;
            this.model.setMode(SaveLayersModel.Mode.UPLOADING_AND_SAVING);
            List<SaveLayerInfo> list2 = this.model.getLayersToUpload();
            if (!list2.isEmpty()) {
                this.uploadLayers(list2);
            }
            if (!(list = this.model.getLayersToSave()).isEmpty()) {
                this.saveLayers(list);
            }
            this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
            if (this.model.hasUnsavedData()) {
                this.warnBecauseOfUnsavedData();
                this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
                if (this.canceled) {
                    SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
                    SaveLayersDialog.this.closeDialog();
                }
            } else {
                SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
                SaveLayersDialog.this.closeDialog();
            }
        }

        public void cancel() {
            if (this.currentTask != null) {
                this.currentTask.cancel();
            }
            this.canceled = true;
        }
    }

    final class SaveAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        private static final int is = 24;
        private static final String BASE_ICON = "BASE_ICON";
        private final Image save = ImageProvider.get("save").getImage();
        private final Image upld = ImageProvider.get("upload").getImage();
        private final Image saveDis = new BufferedImage(24, 24, 6);
        private final Image upldDis = new BufferedImage(24, 24, 6);

        public SaveAndProceedAction() {
            new JLabel(ImageProvider.get("save")).getDisabledIcon().paintIcon(new JPanel(), this.saveDis.getGraphics(), 0, 0);
            new JLabel(ImageProvider.get("upload")).getDisabledIcon().paintIcon(new JPanel(), this.upldDis.getGraphics(), 0, 0);
            this.initForSaveAndExit();
        }

        public void initForSaveAndExit() {
            this.putValue("Name", I18n.tr("Perform actions before exiting", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Exit JOSM with saving. Unsaved changes are uploaded and/or saved.", new Object[0]));
            this.putValue(BASE_ICON, ImageProvider.get("exit"));
            this.redrawIcon();
        }

        public void initForSaveAndDelete() {
            this.putValue("Name", I18n.tr("Perform actions before deleting", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Save/Upload layers before deleting. Unsaved changes are not lost.", new Object[0]));
            this.putValue(BASE_ICON, ImageProvider.get("dialogs", "delete"));
            this.redrawIcon();
        }

        public void redrawIcon() {
            try {
                Image image = ((ImageIcon)this.getValue(BASE_ICON)).getImage();
                BufferedImage bufferedImage = new BufferedImage(72, 24, 6);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(SaveLayersDialog.this.model.getLayersToUpload().isEmpty() ? this.upldDis : this.upld, 0, 0, 24, 24, null);
                graphics2D.drawImage(SaveLayersDialog.this.model.getLayersToSave().isEmpty() ? this.saveDis : this.save, 24, 0, 24, 24, null);
                graphics2D.drawImage(image, 48, 0, 24, 24, null);
                this.putValue("SmallIcon", new ImageIcon(bufferedImage));
            }
            catch (Exception exception) {
                this.putValue("SmallIcon", this.getValue(BASE_ICON));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SaveLayersDialog.this.confirmSaveLayerInfosOK()) {
                return;
            }
            SaveLayersDialog.this.launchSafeAndUploadTask();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)propertyChangeEvent.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class DiscardAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        public DiscardAndProceedAction() {
            this.initForDiscardAndExit();
        }

        public void initForDiscardAndExit() {
            this.putValue("Name", I18n.tr("Exit now!", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Exit JOSM without saving. Unsaved changes are lost.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("exit"));
        }

        public void initForDiscardAndDelete() {
            this.putValue("Name", I18n.tr("Delete now!", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Delete layers without saving. Unsaved changes are lost.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
            SaveLayersDialog.this.closeDialog();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)propertyChangeEvent.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Close this dialog and resume editing in JOSM", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            SaveLayersDialog.this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
            SaveLayersDialog.this.getRootPane().getActionMap().put("ESCAPE", this);
        }

        protected void cancelWhenInEditingModel() {
            SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
            SaveLayersDialog.this.closeDialog();
        }

        protected void cancelWhenInSaveAndUploadingMode() {
            SaveLayersDialog.this.cancelSafeAndUploadTask();
        }

        public void cancel() {
            switch (SaveLayersDialog.this.model.getMode()) {
                case EDITING_DATA: {
                    this.cancelWhenInEditingModel();
                    break;
                }
                case UPLOADING_AND_SAVING: {
                    SaveLayersDialog.this.cancelSafeAndUploadTask();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
        }
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            SaveLayersDialog.this.cancelAction.cancel();
        }
    }

    private static class LayerListWarningMessagePanel
    extends JPanel {
        private JLabel lblMessage;
        private JList lstLayers;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.lblMessage = new JLabel();
            this.add((Component)this.lblMessage, gridBagConstraints);
            this.lblMessage.setHorizontalAlignment(2);
            this.lstLayers = new JList();
            this.lstLayers.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    SaveLayerInfo saveLayerInfo = (SaveLayerInfo)object;
                    this.setIcon(saveLayerInfo.getLayer().getIcon());
                    this.setText(saveLayerInfo.getName());
                    return this;
                }
            });
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.lstLayers, gridBagConstraints);
        }

        public LayerListWarningMessagePanel(String string, List<SaveLayerInfo> list) {
            this.build();
            this.lblMessage.setText(string);
            this.lstLayers.setListData(list.toArray());
        }
    }

    public static enum UserAction {
        PROCEED,
        CANCEL;

    }
}

