/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.tools.I18n;

public class RelationChecker
extends Test {
    protected static final int ROLE_UNKNOWN = 1701;
    protected static final int ROLE_EMPTY = 1702;
    protected static final int WRONG_TYPE = 1703;
    protected static final int HIGH_COUNT = 1704;
    protected static final int LOW_COUNT = 1705;
    protected static final int ROLE_MISSING = 1706;
    protected static final int RELATION_UNKNOWN = 1707;
    protected static final int RELATION_EMPTY = 1708;
    public static final String ROLE_VERIF_PROBLEM_MSG = I18n.tr("Role verification problem", new Object[0]);
    private static Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("This plugin checks for errors in relations.", new Object[0]));
    }

    @Override
    public void initialize() {
        this.initializePresets();
    }

    public void initializePresets() {
        Collection<TaggingPreset> collection = TaggingPresetPreference.taggingPresets;
        if (collection != null) {
            block0: for (TaggingPreset taggingPreset : collection) {
                for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                    if (!(taggingPresetItem instanceof TaggingPresetItems.Roles)) continue;
                    relationpresets.add(taggingPreset);
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(Relation relation) {
        Object object;
        Object object2;
        LinkedList<TaggingPresetItems.Role> linkedList = new LinkedList<TaggingPresetItems.Role>();
        for (TaggingPreset linkedList2 : relationpresets) {
            void var6_11;
            boolean relationMember = true;
            Object var6_12 = null;
            object2 = linkedList2.data.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object instanceof TaggingPresetItems.Key) {
                    TaggingPresetItems.Key key = (TaggingPresetItems.Key)object;
                    if (key.value.equals(relation.get(key.key))) continue;
                    relationMember = false;
                    break;
                }
                if (!(object instanceof TaggingPresetItems.Roles)) continue;
                TaggingPresetItems.Roles roles = (TaggingPresetItems.Roles)object;
            }
            if (!relationMember || var6_11 == null) continue;
            linkedList.addAll(var6_11.roles);
        }
        if (linkedList.isEmpty() && relation.hasTag("type", "route") && relation.hasTag("route", "train", "subway", "monorail", "tram", "bus", "trolleybus", "aerialway", "ferry")) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Route scheme (public_transport or legacy) is unspecified. Add {0}", "public_transport:version"), 1707, relation));
        } else if (linkedList.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Relation type is unknown", new Object[0]), 1707, relation));
        } else {
            HashMap hashMap = new HashMap();
            for (RelationMember relationMember : relation.getMembers()) {
                void var6_17;
                String string = "";
                if (relationMember.hasRole()) {
                    String string2 = relationMember.getRole();
                }
                if ((object2 = (RoleInfo)hashMap.get(var6_17)) == null) {
                    object2 = new RoleInfo();
                }
                ((RoleInfo)object2).total++;
                if (relationMember.isRelation()) {
                    ((RoleInfo)object2).relations.add(relationMember.getRelation());
                } else if (relationMember.isWay()) {
                    ((RoleInfo)object2).ways.add(relationMember.getWay());
                    if (!relationMember.getWay().isClosed()) {
                        ((RoleInfo)object2).openways.add(relationMember.getWay());
                    }
                } else if (relationMember.isNode()) {
                    ((RoleInfo)object2).nodes.add(relationMember.getNode());
                }
                hashMap.put(var6_17, object2);
            }
            if (hashMap.isEmpty()) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Relation is empty", new Object[0]), 1708, relation));
            } else {
                LinkedList<String> linkedList2 = new LinkedList<String>();
                for (TaggingPresetItems.Role role : linkedList) {
                    Object object3;
                    HashSet<OsmPrimitive> hashSet;
                    long l;
                    long l2;
                    linkedList2.add(role.key);
                    object2 = role.key;
                    if ("".equals(object2)) {
                        object2 = I18n.tr("<empty>", new Object[0]);
                    }
                    if ((l2 = (object = (RoleInfo)hashMap.get(role.key)) == null ? 0L : (long)((RoleInfo)object).total) != (l = role.getValidCount(l2))) {
                        if (l2 == 0L) {
                            hashSet = I18n.marktr("Role {0} missing");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(hashSet, new Object[]{object2}), MessageFormat.format(hashSet, new Object[]{object2}), 1706, relation));
                        } else if (l > l2) {
                            hashSet = I18n.marktr("Number of {0} roles too low ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(hashSet, new Object[]{object2, l2}), MessageFormat.format(hashSet, new Object[]{object2, l2}), 1705, relation));
                        } else {
                            hashSet = I18n.marktr("Number of {0} roles too high ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr(hashSet, new Object[]{object2, l2}), MessageFormat.format(hashSet, new Object[]{object2, l2}), 1704, relation));
                        }
                    }
                    if (object == null) continue;
                    if (role.types != null) {
                        hashSet = new HashSet();
                        if (!role.types.contains((Object)TaggingPresetType.WAY)) {
                            hashSet.addAll(role.types.contains((Object)TaggingPresetType.CLOSEDWAY) ? ((RoleInfo)object).openways : ((RoleInfo)object).ways);
                        }
                        if (!role.types.contains((Object)TaggingPresetType.NODE)) {
                            hashSet.addAll(((RoleInfo)object).nodes);
                        }
                        if (!role.types.contains((Object)TaggingPresetType.RELATION)) {
                            hashSet.addAll(((RoleInfo)object).relations);
                        }
                        if (!hashSet.isEmpty()) {
                            object3 = I18n.marktr("Member for role {0} of wrong type");
                            LinkedList<Relation> linkedList3 = new LinkedList<Relation>(hashSet);
                            linkedList3.addFirst(relation);
                            this.errors.add(new TestError(this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr((String)object3, object2), MessageFormat.format((String)object3, object2), 1703, linkedList3, hashSet));
                        }
                    }
                    if (role.memberExpression == null) continue;
                    hashSet = new HashSet<OsmPrimitive>();
                    for (Collection collection : Arrays.asList(((RoleInfo)object).nodes, ((RoleInfo)object).ways, ((RoleInfo)object).relations)) {
                        for (OsmPrimitive osmPrimitive : collection) {
                            if (!osmPrimitive.isUsable() || role.memberExpression.match(osmPrimitive)) continue;
                            hashSet.add(osmPrimitive);
                        }
                    }
                    if (hashSet.isEmpty()) continue;
                    object3 = I18n.marktr("Member for role ''{0}'' does not match ''{1}''");
                    LinkedList<Relation> linkedList4 = new LinkedList<Relation>(hashSet);
                    linkedList4.addFirst(relation);
                    this.errors.add(new TestError(this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr((String)object3, object2, role.memberExpression), MessageFormat.format((String)object3, object2, role.memberExpression), 1703, linkedList4, hashSet));
                }
                for (String string : hashMap.keySet()) {
                    if (linkedList2.contains(string)) continue;
                    if (string.length() > 0) {
                        object2 = I18n.marktr("Role {0} unknown");
                        this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr((String)object2, string), MessageFormat.format((String)object2, string), 1701, relation));
                        continue;
                    }
                    object2 = I18n.marktr("Empty role found");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, ROLE_VERIF_PROBLEM_MSG, I18n.tr((String)object2, new Object[0]), (String)object2, 1702, relation));
                }
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            return new DeleteCommand(testError.getPrimitives());
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        return testError.getCode() == 1708 && !collection.isEmpty() && collection.iterator().next().isNew();
    }

    private static class RoleInfo {
        private int total = 0;
        private Collection<Node> nodes = new LinkedList<Node>();
        private Collection<Way> ways = new LinkedList<Way>();
        private Collection<Way> openways = new LinkedList<Way>();
        private Collection<Relation> relations = new LinkedList<Relation>();

        private RoleInfo() {
        }
    }
}

