/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.validation.FixableTestError;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSTagChecker
extends Test.TagTest {
    public static final String ENTRIES_PREF_KEY = "validator." + MapCSSTagChecker.class.getName() + ".entries";
    final List<TagCheck> checks = new ArrayList<TagCheck>();

    public MapCSSTagChecker() {
        super(I18n.tr("Tag checker (MapCSS based)", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    public Collection<TestError> getErrorsForPrimitive(OsmPrimitive osmPrimitive, boolean bl) {
        ArrayList<TestError> arrayList = new ArrayList<TestError>();
        Environment environment = new Environment(osmPrimitive, new MultiCascade(), "default", null);
        for (TagCheck tagCheck : this.checks) {
            Selector selector;
            if (Severity.OTHER.equals((Object)tagCheck.getSeverity()) && !bl || (selector = tagCheck.whichSelectorMatchesEnvironment(environment)) == null) continue;
            tagCheck.rule.execute(environment);
            TestError testError = tagCheck.getErrorForPrimitive(osmPrimitive, selector, environment);
            if (testError == null) continue;
            testError.setTester(new MapCSSTagCheckerAndRule(tagCheck.rule));
            arrayList.add(testError);
        }
        return arrayList;
    }

    @Override
    public void check(OsmPrimitive osmPrimitive) {
        this.errors.addAll(this.getErrorsForPrimitive(osmPrimitive, ValidatorPreference.PREF_OTHER.get()));
    }

    public void addMapCSS(Reader reader) throws ParseException {
        this.checks.addAll(TagCheck.readMapCSS(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initialize() throws Exception {
        this.checks.clear();
        for (String string : new ValidatorTagCheckerRulesPreference.RulePrefHelper().getActiveUrls()) {
            try {
                if (string.startsWith("resource:")) {
                    Main.debug(I18n.tr("Adding {0} to tag checker", string));
                } else {
                    Main.info(I18n.tr("Adding {0} to tag checker", string));
                }
                MirroredInputStream mirroredInputStream = new MirroredInputStream(string);
                try {
                    this.addMapCSS(new BufferedReader(UTFInputStreamReader.create(mirroredInputStream)));
                }
                finally {
                    Utils.close(mirroredInputStream);
                }
            }
            catch (IOException iOException) {
                Main.warn(I18n.tr("Failed to add {0} to tag checker", string));
                Main.warn(iOException, false);
            }
            catch (Exception exception) {
                Main.warn(I18n.tr("Failed to add {0} to tag checker", string));
                Main.warn(exception);
            }
        }
    }

    static class MapCSSTagCheckerAndRule
    extends MapCSSTagChecker {
        public final MapCSSRule rule;

        MapCSSTagCheckerAndRule(MapCSSRule mapCSSRule) {
            this.rule = mapCSSRule;
        }

        public boolean equals(Object object) {
            return super.equals(object) || object instanceof TagCheck && this.rule.equals(((TagCheck)object).rule) || object instanceof MapCSSRule && this.rule.equals(object);
        }
    }

    static class TagCheck
    implements Predicate<OsmPrimitive> {
        protected final MapCSSRule rule;
        protected final List<PrimitiveToTag> change = new ArrayList<PrimitiveToTag>();
        protected final Map<String, String> keyChange = new LinkedHashMap<String, String>();
        protected final List<String> alternatives = new ArrayList<String>();
        protected final Map<Instruction.AssignmentInstruction, Severity> errors = new HashMap<Instruction.AssignmentInstruction, Severity>();
        protected final Map<String, Boolean> assertions = new HashMap<String, Boolean>();

        TagCheck(MapCSSRule mapCSSRule) {
            this.rule = mapCSSRule;
        }

        static TagCheck ofMapCSSRule(MapCSSRule mapCSSRule) {
            TagCheck tagCheck = new TagCheck(mapCSSRule);
            boolean bl = false;
            for (Instruction instruction : mapCSSRule.declaration) {
                String[] stringArray;
                String string;
                if (!(instruction instanceof Instruction.AssignmentInstruction)) continue;
                Instruction.AssignmentInstruction assignmentInstruction = (Instruction.AssignmentInstruction)instruction;
                if (assignmentInstruction.isSetInstruction) {
                    bl = true;
                    continue;
                }
                String string2 = assignmentInstruction.val instanceof Expression ? (String)((Expression)assignmentInstruction.val).evaluate(new Environment()) : (string = assignmentInstruction.val instanceof String ? (String)assignmentInstruction.val : null);
                if (assignmentInstruction.key.startsWith("throw")) {
                    stringArray = Severity.valueOf(assignmentInstruction.key.substring("throw".length()).toUpperCase());
                    tagCheck.errors.put(assignmentInstruction, (Severity)stringArray);
                    continue;
                }
                if ("fixAdd".equals(assignmentInstruction.key)) {
                    stringArray = PrimitiveToTag.ofMapCSSObject(assignmentInstruction.val, false);
                    tagCheck.change.add((PrimitiveToTag)stringArray);
                    continue;
                }
                if ("fixRemove".equals(assignmentInstruction.key)) {
                    CheckParameterUtil.ensureThat(!(assignmentInstruction.val instanceof String) || !string.contains("="), "Unexpected '='. Please only specify the key to remove!");
                    stringArray = PrimitiveToTag.ofMapCSSObject(assignmentInstruction.val, true);
                    tagCheck.change.add((PrimitiveToTag)stringArray);
                    continue;
                }
                if ("fixChangeKey".equals(assignmentInstruction.key) && string != null) {
                    CheckParameterUtil.ensureThat(string.contains("=>"), "Separate old from new key by '=>'!");
                    stringArray = string.split("=>", 2);
                    tagCheck.keyChange.put(Tag.removeWhiteSpaces(stringArray[0]), Tag.removeWhiteSpaces(stringArray[1]));
                    continue;
                }
                if ("suggestAlternative".equals(assignmentInstruction.key) && string != null) {
                    tagCheck.alternatives.add(string);
                    continue;
                }
                if ("assertMatch".equals(assignmentInstruction.key) && string != null) {
                    tagCheck.assertions.put(string, true);
                    continue;
                }
                if ("assertNoMatch".equals(assignmentInstruction.key) && string != null) {
                    tagCheck.assertions.put(string, false);
                    continue;
                }
                throw new RuntimeException("Cannot add instruction " + assignmentInstruction.key + ": " + assignmentInstruction.val + "!");
            }
            if (tagCheck.errors.isEmpty() && !bl) {
                throw new RuntimeException("No throwError/throwWarning/throwOther given! You should specify a validation error message for " + mapCSSRule.selectors);
            }
            if (tagCheck.errors.size() > 1) {
                throw new RuntimeException("More than one throwError/throwWarning/throwOther given! You should specify a single validation error message for " + mapCSSRule.selectors);
            }
            return tagCheck;
        }

        static List<TagCheck> readMapCSS(Reader reader) throws ParseException {
            CheckParameterUtil.ensureParameterNotNull(reader, "css");
            return TagCheck.readMapCSS(new MapCSSParser(reader));
        }

        static List<TagCheck> readMapCSS(MapCSSParser mapCSSParser) throws ParseException {
            CheckParameterUtil.ensureParameterNotNull(mapCSSParser, "css");
            MapCSSStyleSource mapCSSStyleSource = new MapCSSStyleSource("");
            mapCSSParser.sheet(mapCSSStyleSource);
            assert (mapCSSStyleSource.getErrors().isEmpty());
            TagCheck.removeMetaRules(mapCSSStyleSource);
            return new ArrayList<TagCheck>(Utils.transform(mapCSSStyleSource.rules, new Utils.Function<MapCSSRule, TagCheck>(){

                @Override
                public TagCheck apply(MapCSSRule mapCSSRule) {
                    return TagCheck.ofMapCSSRule(mapCSSRule);
                }
            }));
        }

        private static void removeMetaRules(MapCSSStyleSource mapCSSStyleSource) {
            Iterator<MapCSSRule> iterator = mapCSSStyleSource.rules.iterator();
            while (iterator.hasNext()) {
                Selector selector;
                MapCSSRule mapCSSRule = iterator.next();
                if (mapCSSRule.selectors.size() != 1 || !((selector = mapCSSRule.selectors.get(0)) instanceof Selector.GeneralSelector)) continue;
                Selector.GeneralSelector generalSelector = (Selector.GeneralSelector)selector;
                if (!"meta".equals(generalSelector.base) || !generalSelector.getConditions().isEmpty()) continue;
                iterator.remove();
            }
        }

        @Override
        public boolean evaluate(OsmPrimitive osmPrimitive) {
            return this.matchesPrimitive(osmPrimitive);
        }

        @Deprecated
        boolean matchesPrimitive(OsmPrimitive osmPrimitive) {
            return this.whichSelectorMatchesPrimitive(osmPrimitive) != null;
        }

        Selector whichSelectorMatchesPrimitive(OsmPrimitive osmPrimitive) {
            return this.whichSelectorMatchesEnvironment(new Environment().withPrimitive(osmPrimitive));
        }

        Selector whichSelectorMatchesEnvironment(Environment environment) {
            for (Selector selector : this.rule.selectors) {
                environment.clearSelectorMatchingInformation();
                if (!selector.matches(environment)) continue;
                return selector;
            }
            return null;
        }

        static String determineArgument(Selector.GeneralSelector generalSelector, int n, String string) {
            try {
                Tag tag;
                Condition condition = generalSelector.getConditions().get(n);
                Tag tag2 = condition instanceof Condition.KeyCondition ? ((Condition.KeyCondition)condition).asTag() : (tag = condition instanceof Condition.KeyValueCondition ? ((Condition.KeyValueCondition)condition).asTag() : null);
                if (tag == null) {
                    return null;
                }
                if ("key".equals(string)) {
                    return tag.getKey();
                }
                if ("value".equals(string)) {
                    return tag.getValue();
                }
                if ("tag".equals(string)) {
                    return tag.toString();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Main.debug(indexOutOfBoundsException.getMessage());
            }
            return null;
        }

        static String insertArguments(Selector selector, String string) {
            if (string != null && selector instanceof Selector.ChildOrParentSelector) {
                return TagCheck.insertArguments(((Selector.ChildOrParentSelector)selector).right, string);
            }
            if (string == null || !(selector instanceof Selector.GeneralSelector)) {
                return string;
            }
            Matcher matcher = Pattern.compile("\\{(\\d+)\\.(key|value|tag)\\}").matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string2 = TagCheck.determineArgument((Selector.GeneralSelector)selector, Integer.parseInt(matcher.group(1)), matcher.group(2));
                try {
                    matcher.appendReplacement(stringBuffer, String.valueOf(string2));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Main.error(I18n.tr("Unable to replace argument {0} in {1}: {2}", string2, stringBuffer, indexOutOfBoundsException.getMessage()));
                }
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        Command fixPrimitive(OsmPrimitive osmPrimitive) {
            String string;
            Object object;
            if (this.change.isEmpty() && this.keyChange.isEmpty()) {
                return null;
            }
            Selector selector = this.whichSelectorMatchesPrimitive(osmPrimitive);
            LinkedList<Command> linkedList = new LinkedList<Command>();
            for (PrimitiveToTag object2 : this.change) {
                object = (Tag)object2.apply(osmPrimitive);
                string = TagCheck.insertArguments(selector, ((Tag)object).getKey());
                String string2 = TagCheck.insertArguments(selector, ((Tag)object).getValue());
                linkedList.add(new ChangePropertyCommand(osmPrimitive, string, string2));
            }
            for (Map.Entry entry : this.keyChange.entrySet()) {
                object = TagCheck.insertArguments(selector, (String)entry.getKey());
                string = TagCheck.insertArguments(selector, (String)entry.getValue());
                linkedList.add(new ChangePropertyKeyCommand(osmPrimitive, (String)object, string));
            }
            return new SequenceCommand(I18n.tr("Fix of {0}", this.getDescriptionForMatchingSelector(osmPrimitive, selector)), linkedList);
        }

        String getMessage(OsmPrimitive osmPrimitive) {
            if (this.errors.isEmpty()) {
                return this.rule.declaration.toString();
            }
            Object object = this.errors.keySet().iterator().next().val;
            return String.valueOf(object instanceof Expression ? ((Expression)object).evaluate(new Environment().withPrimitive(osmPrimitive)) : object);
        }

        String getDescription(OsmPrimitive osmPrimitive) {
            if (this.alternatives.isEmpty()) {
                return this.getMessage(osmPrimitive);
            }
            return I18n.tr("{0}, use {1} instead", this.getMessage(osmPrimitive), Utils.join(I18n.tr(" or ", new Object[0]), this.alternatives));
        }

        String getDescriptionForMatchingSelector(OsmPrimitive osmPrimitive, Selector selector) {
            return TagCheck.insertArguments(selector, this.getDescription(osmPrimitive));
        }

        Severity getSeverity() {
            return this.errors.isEmpty() ? null : this.errors.values().iterator().next();
        }

        public String toString() {
            return this.getDescription(null);
        }

        TestError getErrorForPrimitive(OsmPrimitive osmPrimitive) {
            Environment environment = new Environment().withPrimitive(osmPrimitive);
            return this.getErrorForPrimitive(osmPrimitive, this.whichSelectorMatchesEnvironment(environment), environment);
        }

        TestError getErrorForPrimitive(OsmPrimitive osmPrimitive, Selector selector, Environment environment) {
            if (selector != null && !this.errors.isEmpty()) {
                Command command = this.fixPrimitive(osmPrimitive);
                String string = this.getDescriptionForMatchingSelector(osmPrimitive, selector);
                List<OsmPrimitive> list = environment.child != null ? Arrays.asList(osmPrimitive, environment.child) : Collections.singletonList(osmPrimitive);
                if (command != null) {
                    return new FixableTestError(null, this.getSeverity(), string, null, selector.toString(), 3000, list, command);
                }
                return new TestError(null, this.getSeverity(), string, null, selector.toString(), 3000, list);
            }
            return null;
        }

        static abstract class PrimitiveToTag
        implements Utils.Function<OsmPrimitive, Tag> {
            PrimitiveToTag() {
            }

            static PrimitiveToTag ofMapCSSObject(final Object object, final boolean bl) {
                if (object instanceof Expression) {
                    return new PrimitiveToTag(){

                        @Override
                        public Tag apply(OsmPrimitive osmPrimitive) {
                            String string = (String)((Expression)object).evaluate(new Environment().withPrimitive(osmPrimitive));
                            return bl ? new Tag(string) : Tag.ofString(string);
                        }
                    };
                }
                if (object instanceof String) {
                    final Tag tag = bl ? new Tag((String)object) : Tag.ofString((String)object);
                    return new PrimitiveToTag(){

                        @Override
                        public Tag apply(OsmPrimitive osmPrimitive) {
                            return tag;
                        }
                    };
                }
                return null;
            }
        }
    }
}

