/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PurgeCommand
extends Command {
    protected List<OsmPrimitive> toPurge;
    protected Storage<PrimitiveData> makeIncompleteData;
    protected Map<PrimitiveId, PrimitiveData> makeIncompleteData_byPrimId;
    protected final ConflictCollection purgedConflicts = new ConflictCollection();
    protected final DataSet ds;

    public PurgeCommand(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2) {
        super(osmDataLayer);
        this.ds = osmDataLayer.data;
        this.toPurge = PurgeCommand.topoSort(collection);
        this.saveIncomplete(collection2);
    }

    protected final void saveIncomplete(Collection<OsmPrimitive> collection) {
        this.makeIncompleteData = new Storage<PrimitiveId>(new Storage.PrimitiveIdHash());
        this.makeIncompleteData_byPrimId = this.makeIncompleteData.foreignKey(new Storage.PrimitiveIdHash());
        for (OsmPrimitive osmPrimitive : collection) {
            this.makeIncompleteData.add(osmPrimitive.save());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand() {
        this.ds.beginUpdate();
        try {
            this.purgedConflicts.get().clear();
            for (int i = this.toPurge.size() - 1; i >= 0; --i) {
                Object object;
                OsmPrimitive osmPrimitive = this.toPurge.get(i);
                if (this.makeIncompleteData_byPrimId.containsKey(osmPrimitive)) {
                    switch (osmPrimitive.getType()) {
                        case NODE: {
                            object = new NodeData();
                            break;
                        }
                        case WAY: {
                            object = new WayData();
                            break;
                        }
                        case RELATION: {
                            object = new RelationData();
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    ((PrimitiveData)object).setId(osmPrimitive.getUniqueId());
                    ((PrimitiveData)object).setIncomplete(true);
                    osmPrimitive.load((PrimitiveData)object);
                    continue;
                }
                this.ds.removePrimitive(osmPrimitive);
                object = this.getLayer().getConflicts().getConflictForMy(osmPrimitive);
                if (object == null) continue;
                this.purgedConflicts.add((Conflict<?>)object);
                this.getLayer().getConflicts().remove((Conflict<?>)object);
            }
        }
        finally {
            this.ds.endUpdate();
        }
        return true;
    }

    @Override
    public void undoCommand() {
        if (this.ds == null) {
            return;
        }
        for (OsmPrimitive object : this.toPurge) {
            PrimitiveData primitiveData = this.makeIncompleteData_byPrimId.get(object);
            if (primitiveData != null) {
                if (this.ds.getPrimitiveById(object) != object) {
                    throw new AssertionError((Object)String.format("Primitive %s has been made incomplete when purging, but it cannot be found on undo.", object));
                }
                object.load(primitiveData);
                continue;
            }
            if (this.ds.getPrimitiveById(object) != null) {
                throw new AssertionError((Object)String.format("Primitive %s was removed when purging, but is still there on undo", object));
            }
            this.ds.addPrimitive(object);
        }
        for (Conflict conflict : this.purgedConflicts) {
            this.getLayer().getConflicts().add(conflict);
        }
    }

    public static List<OsmPrimitive> topoSort(Collection<OsmPrimitive> collection) {
        Comparable<Integer> comparable;
        Relation relation;
        Object object2;
        Object object3;
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(hashSet.size());
        HashSet<Object> hashSet2 = new HashSet<Object>(hashSet.size());
        Object object4 = hashSet.iterator();
        block0: while (object4.hasNext()) {
            object3 = (OsmPrimitive)object4.next();
            if (!(object3 instanceof Node)) continue;
            object2 = (Node)object3;
            for (OsmPrimitive object5 : ((OsmPrimitive)object2).getReferrers()) {
                if (!(object5 instanceof Way) || !hashSet.contains(object5)) continue;
                object4.remove();
                hashSet2.add(object2);
                continue block0;
            }
            object4.remove();
            arrayList.add((OsmPrimitive)object2);
        }
        object4 = hashSet.iterator();
        while (object4.hasNext()) {
            object3 = (OsmPrimitive)object4.next();
            if (!(object3 instanceof Way)) continue;
            object2 = (Way)object3;
            object4.remove();
            for (Node node : ((Way)object2).getNodes()) {
                if (!hashSet2.contains(node)) continue;
                hashSet2.remove(node);
                arrayList.add(node);
            }
            arrayList.add((OsmPrimitive)object2);
        }
        if (!hashSet2.isEmpty()) {
            throw new AssertionError((Object)"topo sort algorithm failed (nodes remaining)");
        }
        object4 = hashSet;
        object3 = new HashSet();
        object2 = new ArrayList(object4.size());
        HashMap hashMap = new HashMap();
        Iterator iterator = object4.iterator();
        while (iterator.hasNext()) {
            relation = (Relation)iterator.next();
            hashMap.put(relation, 0);
        }
        Iterator iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            relation = (Relation)iterator2.next();
            for (OsmPrimitive osmPrimitive : relation.getReferrers()) {
                if (!(osmPrimitive instanceof Relation)) {
                    throw new AssertionError();
                }
                comparable = (Integer)hashMap.get(osmPrimitive);
                if (comparable == null) continue;
                hashMap.put((Relation)osmPrimitive, comparable + 1);
            }
        }
        Iterator iterator3 = object4.iterator();
        while (iterator3.hasNext()) {
            relation = (Relation)iterator3.next();
            if (!((Integer)hashMap.get(relation)).equals(0)) continue;
            object3.add(relation);
        }
        while (!object3.isEmpty()) {
            Iterator iterator4 = object3.iterator();
            relation = (Relation)iterator4.next();
            iterator4.remove();
            object2.add(relation);
            for (OsmPrimitive osmPrimitive : relation.getReferrers()) {
                comparable = (Relation)osmPrimitive;
                Integer n = (Integer)hashMap.get(comparable);
                if (n == null) continue;
                hashMap.put(comparable, n - 1);
                if (n - 1 != 0) continue;
                object3.add(comparable);
            }
        }
        if (object2.size() != object4.size()) {
            throw new AssertionError((Object)"topo sort algorithm failed");
        }
        arrayList.addAll((Collection<OsmPrimitive>)object2);
        return arrayList;
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Purged {0} object", "Purged {0} objects", this.toPurge.size(), this.toPurge.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "purge");
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.toPurge;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }
}

