/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.ModifiersSpec;
import org.openstreetmap.josm.actions.mapmode.ParallelWays;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ParallelWayAction
extends MapMode
implements AWTEventListener,
MapViewPaintable,
Preferences.PreferenceChangedListener {
    private Mode mode;
    private boolean copyTags;
    private boolean copyTagsDefault;
    private boolean snap;
    private boolean snapDefault;
    private double snapThreshold;
    private double snapDistanceMetric;
    private double snapDistanceImperial;
    private double snapDistanceChinese;
    private double snapDistanceNautical;
    private ModifiersSpec snapModifierCombo;
    private ModifiersSpec copyTagsModifierCombo;
    private ModifiersSpec addToSelectionModifierCombo;
    private ModifiersSpec toggleSelectedModifierCombo;
    private ModifiersSpec setSelectedModifierCombo;
    private int initialMoveDelay;
    private final MapView mv;
    private Point mousePressedPos;
    private boolean mouseIsDown;
    private long mousePressedTime;
    private boolean mouseHasBeenDragged;
    private WaySegment referenceSegment;
    private ParallelWays pWays;
    private Set<Way> sourceWays;
    private EastNorth helperLineStart;
    private EastNorth helperLineEnd;
    Stroke helpLineStroke;
    Stroke refLineStroke;
    Color mainColor;

    public ParallelWayAction(MapFrame mapFrame) {
        super(I18n.tr("Parallel", new Object[0]), "parallel", I18n.tr("Make parallel copies of ways", new Object[0]), Shortcut.registerShortcut("mapmode:parallel", I18n.tr("Mode: {0}", I18n.tr("Parallel", new Object[0])), 80, 5005), mapFrame, ImageProvider.getCursor("normal", "parallel"));
        this.putValue("help", HelpUtil.ht("/Action/Parallel"));
        this.mv = mapFrame.mapView;
        this.updateModeLocalPreferences();
        Main.pref.addPreferenceChangeListener(this);
    }

    @Override
    public void enterMode() {
        this.setMode(Mode.normal);
        this.pWays = null;
        this.updateAllPreferences();
        super.enterMode();
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.addTemporaryLayer(this);
        this.helpLineStroke = GuiHelper.getCustomizedStroke(this.getStringPref("stroke.hepler-line", "1"));
        this.refLineStroke = GuiHelper.getCustomizedStroke(this.getStringPref("stroke.ref-line", "1 2 2"));
        this.mainColor = Main.pref.getColor(I18n.marktr("make parallel helper line"), null);
        if (this.mainColor == null) {
            this.mainColor = PaintColors.SELECTED.get();
        }
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
        this.sourceWays = new LinkedHashSet<Way>(ParallelWayAction.getCurrentDataSet().getSelectedWays());
        for (Way way : this.sourceWays) {
            way.setHighlighted(true);
        }
        this.mv.repaint();
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.removeTemporaryLayer(this);
        Main.map.statusLine.setDist(-1.0);
        Main.map.statusLine.repaint();
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
        this.removeWayHighlighting(this.sourceWays);
        this.pWays = null;
        this.sourceWays = null;
        this.referenceSegment = null;
        this.mv.repaint();
    }

    @Override
    public String getModeHelpText() {
        switch (this.mode) {
            case normal: {
                return I18n.tr("Select ways as in Select mode. Drag selected ways or a single way to create a parallel copy (Alt toggles tag preservation)", new Object[0]);
            }
            case dragging: {
                return I18n.tr("Hold Ctrl to toggle snapping", new Object[0]);
            }
        }
        return "";
    }

    private void updateAllPreferences() {
        this.updateModeLocalPreferences();
    }

    private void updateModeLocalPreferences() {
        this.snapThreshold = Main.pref.getDouble(this.prefKey("snap-threshold-percent"), 0.7);
        this.snapDefault = Main.pref.getBoolean(this.prefKey("snap-default"), true);
        this.copyTagsDefault = Main.pref.getBoolean(this.prefKey("copy-tags-default"), true);
        this.initialMoveDelay = Main.pref.getInteger(this.prefKey("initial-move-delay"), 200);
        this.snapDistanceMetric = Main.pref.getDouble(this.prefKey("snap-distance-metric"), 0.5);
        this.snapDistanceImperial = Main.pref.getDouble(this.prefKey("snap-distance-imperial"), 1.0);
        this.snapDistanceChinese = Main.pref.getDouble(this.prefKey("snap-distance-chinese"), 1.0);
        this.snapDistanceNautical = Main.pref.getDouble(this.prefKey("snap-distance-nautical"), 0.1);
        this.snapModifierCombo = new ModifiersSpec(this.getStringPref("snap-modifier-combo", "?sC"));
        this.copyTagsModifierCombo = new ModifiersSpec(this.getStringPref("copy-tags-modifier-combo", "As?"));
        this.addToSelectionModifierCombo = new ModifiersSpec(this.getStringPref("add-to-selection-modifier-combo", "aSc"));
        this.toggleSelectedModifierCombo = new ModifiersSpec(this.getStringPref("toggle-selection-modifier-combo", "asC"));
        this.setSelectedModifierCombo = new ModifiersSpec(this.getStringPref("set-selection-modifier-combo", "asc"));
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (Main.map == null || this.mv == null || !this.mv.isActiveLayerDrawable()) {
            return;
        }
        if (this.updateModifiersState((InputEvent)aWTEvent)) {
            this.updateStatusLine();
            this.updateCursor();
        }
    }

    private boolean updateModifiersState(InputEvent inputEvent) {
        boolean bl = this.alt;
        boolean bl2 = this.shift;
        boolean bl3 = this.ctrl;
        this.updateKeyModifiers(inputEvent);
        return bl != this.alt || bl2 != this.shift || bl3 != this.ctrl;
    }

    private void updateCursor() {
        Cursor cursor = null;
        switch (this.mode) {
            case normal: {
                if (this.matchesCurrentModifiers(this.setSelectedModifierCombo)) {
                    cursor = ImageProvider.getCursor("normal", "parallel");
                    break;
                }
                if (this.matchesCurrentModifiers(this.addToSelectionModifierCombo)) {
                    cursor = ImageProvider.getCursor("normal", "parallel");
                    break;
                }
                if (!this.matchesCurrentModifiers(this.toggleSelectedModifierCombo)) break;
                cursor = ImageProvider.getCursor("normal", "parallel");
                break;
            }
            case dragging: {
                cursor = this.snap ? Cursor.getPredefinedCursor(13) : Cursor.getPredefinedCursor(13);
            }
        }
        if (cursor != null) {
            this.mv.setNewCursor(cursor, (Object)this);
        }
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        this.updateCursor();
        this.updateStatusLine();
    }

    private boolean sanityCheck() {
        boolean bl;
        boolean bl2 = bl = this.mv.isActiveLayerVisible() && this.mv.isActiveLayerDrawable() && (Boolean)this.getValue("active") != false;
        assert (bl);
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInMapView();
        this.updateModifiersState(mouseEvent);
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!this.sanityCheck()) {
            return;
        }
        this.updateFlagsOnlyChangeableOnPress();
        this.updateFlagsChangeableAlways();
        if (this.pWays != null && this.pWays.ways != null) {
            ParallelWayAction.getCurrentDataSet().clearSelection(this.pWays.ways);
            this.pWays = null;
        }
        this.mouseIsDown = true;
        this.mousePressedPos = mouseEvent.getPoint();
        this.mousePressedTime = System.currentTimeMillis();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateModifiersState(mouseEvent);
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!this.mouseHasBeenDragged) {
            Way way = this.mv.getNearestWay(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
            if (way == null) {
                if (this.matchesCurrentModifiers(this.setSelectedModifierCombo)) {
                    this.clearSourceWays();
                }
                this.resetMouseTrackingState();
                return;
            }
            boolean bl = way.isSelected();
            if (this.matchesCurrentModifiers(this.addToSelectionModifierCombo)) {
                if (!bl) {
                    this.addSourceWay(way);
                }
            } else if (this.matchesCurrentModifiers(this.toggleSelectedModifierCombo)) {
                if (bl) {
                    this.removeSourceWay(way);
                } else {
                    this.addSourceWay(way);
                }
            } else if (this.matchesCurrentModifiers(this.setSelectedModifierCombo)) {
                this.clearSourceWays();
                this.addSourceWay(way);
            }
        } else if (this.mode == Mode.dragging) {
            this.clearSourceWays();
        }
        this.setMode(Mode.normal);
        this.resetMouseTrackingState();
        this.mv.repaint();
    }

    private void removeWayHighlighting(Collection<Way> collection) {
        if (collection == null) {
            return;
        }
        for (Way way : collection) {
            way.setHighlighted(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        double d;
        if (!this.mouseIsDown) {
            return;
        }
        boolean bl = this.updateModifiersState(mouseEvent);
        this.updateFlagsChangeableAlways();
        if (bl) {
            this.updateStatusLine();
            this.updateCursor();
        }
        if (System.currentTimeMillis() - this.mousePressedTime < (long)this.initialMoveDelay) {
            return;
        }
        this.mouseHasBeenDragged = true;
        Point point = mouseEvent.getPoint();
        if (this.mode == Mode.normal) {
            if (!this.isModifiersValidForDragMode()) {
                return;
            }
            if (!this.initParallelWays(this.mousePressedPos, this.copyTags)) {
                return;
            }
            this.setMode(Mode.dragging);
        }
        EastNorth eastNorth = this.mv.getEastNorth((int)point.getX(), (int)point.getY());
        EastNorth eastNorth2 = Geometry.closestPointToLine(this.referenceSegment.getFirstNode().getEastNorth(), this.referenceSegment.getSecondNode().getEastNorth(), eastNorth);
        double d2 = eastNorth.distance(eastNorth2);
        double d3 = d = this.mv.getProjection().eastNorth2latlon(eastNorth).greatCircleDistance(this.mv.getProjection().eastNorth2latlon(eastNorth2));
        boolean bl2 = Geometry.isToTheRightSideOfLine(this.referenceSegment.getFirstNode(), this.referenceSegment.getFirstNode(), this.referenceSegment.getSecondNode(), new Node(eastNorth));
        if (this.snap) {
            NavigatableComponent.SystemOfMeasurement systemOfMeasurement = NavigatableComponent.getSystemOfMeasurement();
            double d4 = systemOfMeasurement.equals(NavigatableComponent.CHINESE_SOM) ? this.snapDistanceChinese * NavigatableComponent.CHINESE_SOM.aValue : (systemOfMeasurement.equals(NavigatableComponent.IMPERIAL_SOM) ? this.snapDistanceImperial * NavigatableComponent.IMPERIAL_SOM.aValue : (systemOfMeasurement.equals(NavigatableComponent.NAUTICAL_MILE_SOM) ? this.snapDistanceNautical * NavigatableComponent.NAUTICAL_MILE_SOM.aValue : this.snapDistanceMetric));
            double d5 = d % d4;
            double d6 = d5 < d4 / 2.0 ? d - d5 : d + (d4 - d5);
            d3 = Math.abs(d6 - d) < this.snapThreshold * d4 ? d6 : d6 + Math.signum(d - d6) * d4;
        }
        d2 = d3 * (d2 / d);
        this.helperLineStart = eastNorth2;
        this.helperLineEnd = eastNorth;
        if (bl2) {
            d2 = -d2;
        }
        this.pWays.changeOffset(d2);
        Main.map.statusLine.setDist(Math.abs(d3));
        Main.map.statusLine.repaint();
        this.mv.repaint();
    }

    private boolean matchesCurrentModifiers(ModifiersSpec modifiersSpec) {
        return modifiersSpec.matchWithKnown(this.alt, this.shift, this.ctrl);
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (this.mode == Mode.dragging) {
            if (mapView == null) {
                return;
            }
            graphics2D.setStroke(this.refLineStroke);
            graphics2D.setColor(this.mainColor);
            Point point = mapView.getPoint(this.referenceSegment.getFirstNode().getEastNorth());
            Point point2 = mapView.getPoint(this.referenceSegment.getSecondNode().getEastNorth());
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            graphics2D.setStroke(this.helpLineStroke);
            graphics2D.setColor(this.mainColor);
            point = mapView.getPoint(this.helperLineStart);
            point2 = mapView.getPoint(this.helperLineEnd);
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    private boolean isModifiersValidForDragMode() {
        return !this.alt && !this.shift && !this.ctrl || this.matchesCurrentModifiers(this.snapModifierCombo) || this.matchesCurrentModifiers(this.copyTagsModifierCombo);
    }

    private void updateFlagsOnlyChangeableOnPress() {
        this.copyTags = this.copyTagsDefault != this.matchesCurrentModifiers(this.copyTagsModifierCombo);
    }

    private void updateFlagsChangeableAlways() {
        this.snap = this.snapDefault != this.matchesCurrentModifiers(this.snapModifierCombo);
    }

    private void addSourceWay(Way way) {
        assert (this.sourceWays != null);
        ParallelWayAction.getCurrentDataSet().addSelected(way);
        way.setHighlighted(true);
        this.sourceWays.add(way);
    }

    private void removeSourceWay(Way way) {
        assert (this.sourceWays != null);
        ParallelWayAction.getCurrentDataSet().clearSelection(way);
        way.setHighlighted(false);
        this.sourceWays.remove(way);
    }

    private void clearSourceWays() {
        assert (this.sourceWays != null);
        ParallelWayAction.getCurrentDataSet().clearSelection(this.sourceWays);
        for (Way way : this.sourceWays) {
            way.setHighlighted(false);
        }
        this.sourceWays.clear();
    }

    private void resetMouseTrackingState() {
        this.mouseIsDown = false;
        this.mousePressedPos = null;
        this.mouseHasBeenDragged = false;
    }

    private boolean initParallelWays(Point point, boolean bl) {
        this.referenceSegment = this.mv.getNearestWaySegment(point, Way.isUsablePredicate, true);
        if (this.referenceSegment == null) {
            return false;
        }
        if (!this.sourceWays.contains(this.referenceSegment.way)) {
            this.clearSourceWays();
            this.addSourceWay(this.referenceSegment.way);
        }
        try {
            int n = -1;
            int n2 = 0;
            for (Way way : this.sourceWays) {
                if (way == this.referenceSegment.way) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.pWays = new ParallelWays(this.sourceWays, bl, n);
            this.pWays.commit();
            ParallelWayAction.getCurrentDataSet().setSelected(this.pWays.ways);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("ParallelWayAction\nThe ways selected must form a simple branchless path", new Object[0]), I18n.tr("Make parallel way error", new Object[0]), 1);
            this.resetMouseTrackingState();
            this.pWays = null;
            return false;
        }
    }

    private String prefKey(String string) {
        return "edit.make-parallel-way-action." + string;
    }

    private String getStringPref(String string, String string2) {
        return Main.pref.get(this.prefKey(string), string2);
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith(this.prefKey(""))) {
            this.updateAllPreferences();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        Main.pref.removePreferenceChangeListener(this);
    }

    private static enum Mode {
        dragging,
        normal;

    }
}

