/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class JMapViewer
extends JPanel
implements TileLoaderListener {
    private static final long serialVersionUID = 1L;
    protected static final Point[] move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    public static final int MAX_ZOOM = 22;
    public static final int MIN_ZOOM = 0;
    protected List<MapMarker> mapMarkerList;
    protected List<MapRectangle> mapRectangleList;
    protected List<MapPolygon> mapPolygonList;
    protected boolean mapMarkersVisible;
    protected boolean mapRectanglesVisible;
    protected boolean mapPolygonsVisible;
    protected boolean tileGridVisible;
    protected boolean scrollWrapEnabled;
    protected TileController tileController;
    protected Point center;
    protected int zoom;
    protected JSlider zoomSlider;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected ZOOM_BUTTON_STYLE zoomButtonStyle;
    protected TileSource tileSource;
    protected AttributionSupport attribution = new AttributionSupport();
    protected EventListenerList listenerList = new EventListenerList();

    public JMapViewer() {
        this(new MemoryTileCache(), 8);
        new DefaultMapController(this);
    }

    public JMapViewer(TileCache tileCache, int n) {
        JobDispatcher.setMaxWorkers(n);
        this.tileSource = new OsmTileSource.Mapnik();
        this.tileController = new TileController(this.tileSource, tileCache, this);
        this.mapMarkerList = new LinkedList<MapMarker>();
        this.mapPolygonList = new LinkedList<MapPolygon>();
        this.mapRectangleList = new LinkedList<MapRectangle>();
        this.mapMarkersVisible = true;
        this.mapRectanglesVisible = true;
        this.mapPolygonsVisible = true;
        this.tileGridVisible = false;
        this.setLayout(null);
        this.initializeZoomSlider();
        this.setMinimumSize(new Dimension(this.tileSource.getTileSize(), this.tileSource.getTileSize()));
        this.setPreferredSize(new Dimension(400, 400));
        this.setDisplayPosition(new Coordinate(50.0, 9.0), 3);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return super.getToolTipText(mouseEvent);
    }

    protected void initializeZoomSlider() {
        ImageIcon imageIcon;
        this.zoomSlider = new JSlider(0, this.tileController.getTileSource().getMaxZoom());
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(10, 10, 30, 150);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JMapViewer.this.setZoom(JMapViewer.this.zoomSlider.getValue());
            }
        });
        this.zoomSlider.setFocusable(false);
        this.add(this.zoomSlider);
        int n = 18;
        try {
            imageIcon = new ImageIcon(JMapViewer.class.getResource("images/plus.png"));
            this.zoomInButton = new JButton(imageIcon);
        }
        catch (Exception exception) {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("sansserif", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setBounds(4, 155, n, n);
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewer.this.zoomIn();
            }
        });
        this.zoomInButton.setFocusable(false);
        this.add(this.zoomInButton);
        try {
            imageIcon = new ImageIcon(JMapViewer.class.getResource("images/minus.png"));
            this.zoomOutButton = new JButton(imageIcon);
        }
        catch (Exception exception) {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("sansserif", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setBounds(8 + n, 155, n, n);
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewer.this.zoomOut();
            }
        });
        this.zoomOutButton.setFocusable(false);
        this.add(this.zoomOutButton);
    }

    public void setDisplayPosition(Coordinate coordinate, int n) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), coordinate, n);
    }

    public void setDisplayPosition(Point point, Coordinate coordinate, int n) {
        int n2 = this.tileSource.LonToX(coordinate.getLon(), n);
        int n3 = this.tileSource.LatToY(coordinate.getLat(), n);
        this.setDisplayPosition(point, n2, n3, n);
    }

    public void setDisplayPosition(int n, int n2, int n3) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point point, int n, int n2, int n3) {
        if (n3 > this.tileController.getTileSource().getMaxZoom() || n3 < 0) {
            return;
        }
        Point point2 = new Point();
        point2.x = n - point.x + this.getWidth() / 2;
        point2.y = n2 - point.y + this.getHeight() / 2;
        this.center = point2;
        this.setIgnoreRepaint(true);
        try {
            int n4 = this.zoom;
            this.zoom = n3;
            if (n4 != n3) {
                this.zoomChanged(n4);
            }
            if (this.zoomSlider.getValue() != n3) {
                this.zoomSlider.setValue(n3);
            }
        }
        finally {
            this.setIgnoreRepaint(false);
            this.repaint();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDisplayToFitMapElements(boolean bl, boolean bl2, boolean bl3) {
        void var13_24;
        int n;
        int n2;
        int n4 = 0;
        if (bl && this.mapMarkerList != null) {
            n4 += this.mapMarkerList.size();
        }
        if (bl2 && this.mapRectangleList != null) {
            n4 += this.mapRectangleList.size();
        }
        if (bl3 && this.mapPolygonList != null) {
            n4 += this.mapPolygonList.size();
        }
        if (n4 == 0) {
            return;
        }
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MIN_VALUE;
        int n9 = this.tileController.getTileSource().getMaxZoom();
        if (bl) {
            for (MapMarker mapObject : this.mapMarkerList) {
                if (!mapObject.isVisible()) continue;
                int n3 = this.tileSource.LonToX(mapObject.getLon(), n9);
                int n10 = this.tileSource.LatToY(mapObject.getLat(), n9);
                n7 = Math.max(n7, n3);
                n8 = Math.max(n8, n10);
                n5 = Math.min(n5, n3);
                n6 = Math.min(n6, n10);
            }
        }
        if (bl2) {
            for (MapRectangle mapRectangle : this.mapRectangleList) {
                if (!mapRectangle.isVisible()) continue;
                n7 = Math.max(n7, this.tileSource.LonToX(mapRectangle.getBottomRight().getLon(), n9));
                n8 = Math.max(n8, this.tileSource.LatToY(mapRectangle.getTopLeft().getLat(), n9));
                n5 = Math.min(n5, this.tileSource.LonToX(mapRectangle.getTopLeft().getLon(), n9));
                n6 = Math.min(n6, this.tileSource.LatToY(mapRectangle.getBottomRight().getLat(), n9));
            }
        }
        if (bl3) {
            for (MapPolygon mapPolygon : this.mapPolygonList) {
                if (!mapPolygon.isVisible()) continue;
                for (ICoordinate iCoordinate : mapPolygon.getPoints()) {
                    n2 = this.tileSource.LonToX(iCoordinate.getLon(), n9);
                    n = this.tileSource.LatToY(iCoordinate.getLat(), n9);
                    n7 = Math.max(n7, n2);
                    n8 = Math.max(n8, n);
                    n5 = Math.min(n5, n2);
                    n6 = Math.min(n6, n);
                }
            }
        }
        int n11 = Math.max(0, this.getHeight());
        int n12 = Math.max(0, this.getWidth());
        int n13 = n9;
        int n14 = n7 - n5;
        for (n2 = n8 - n6; var13_24 > n12 || n2 > n11; var13_24 >>= 1, n2 >>= 1) {
            --n13;
        }
        int n15 = n5 + (n7 - n5) / 2;
        n2 = n6 + (n8 - n6) / 2;
        n = 1 << n9 - n13;
        int n16 = n15 / n;
        this.setDisplayPosition(n16, n2 /= n, n13);
    }

    public void setDisplayToFitMapMarkers() {
        this.setDisplayToFitMapElements(true, false, false);
    }

    public void setDisplayToFitMapRectangles() {
        this.setDisplayToFitMapElements(false, true, false);
    }

    public void setDisplayToFitMapPolygons() {
        this.setDisplayToFitMapElements(false, false, true);
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point point) {
        this.center = point;
    }

    public Coordinate getPosition() {
        double d = this.tileSource.XToLon(this.center.x, this.zoom);
        double d2 = this.tileSource.YToLat(this.center.y, this.zoom);
        return new Coordinate(d2, d);
    }

    public Coordinate getPosition(Point point) {
        return this.getPosition(point.x, point.y);
    }

    public Coordinate getPosition(int n, int n2) {
        int n3 = this.center.x + n - this.getWidth() / 2;
        int n4 = this.center.y + n2 - this.getHeight() / 2;
        double d = this.tileSource.XToLon(n3, this.zoom);
        double d2 = this.tileSource.YToLat(n4, this.zoom);
        return new Coordinate(d2, d);
    }

    public Point getMapPosition(double d, double d2, boolean bl) {
        int n = this.tileSource.LonToX(d2, this.zoom);
        int n2 = this.tileSource.LatToY(d, this.zoom);
        if (bl && ((n -= this.center.x - this.getWidth() / 2) < 0 || (n2 -= this.center.y - this.getHeight() / 2) < 0 || n > this.getWidth() || n2 > this.getHeight())) {
            return null;
        }
        return new Point(n, n2);
    }

    public Integer getLatOffset(double d, double d2, boolean bl) {
        int n = this.tileSource.LatToY(d + d2, this.zoom);
        if (bl && ((n -= this.center.y - this.getHeight() / 2) < 0 || n > this.getHeight())) {
            return null;
        }
        return n;
    }

    public Point getMapPosition(double d, double d2) {
        return this.getMapPosition(d, d2, true);
    }

    public Integer getRadius(MapMarker mapMarker, Point point) {
        if (mapMarker.getMarkerStyle() == MapMarker.STYLE.FIXED) {
            return (int)mapMarker.getRadius();
        }
        if (point != null) {
            Integer n = this.getLatOffset(mapMarker.getLat(), mapMarker.getRadius(), false);
            n = n == null ? null : Integer.valueOf(point.y - n);
            return n;
        }
        return null;
    }

    public Point getMapPosition(Coordinate coordinate) {
        if (coordinate != null) {
            return this.getMapPosition(coordinate.getLat(), coordinate.getLon());
        }
        return null;
    }

    public Point getMapPosition(ICoordinate iCoordinate, boolean bl) {
        if (iCoordinate != null) {
            return this.getMapPosition(iCoordinate.getLat(), iCoordinate.getLon(), bl);
        }
        return null;
    }

    public double getMeterPerPixel() {
        Point point = new Point(5, 5);
        Point point2 = new Point(this.getWidth() / 2, this.getHeight() / 2);
        double d = point2.distance(point);
        Coordinate coordinate = this.getPosition(point);
        Coordinate coordinate2 = this.getPosition(point2);
        double d2 = this.tileSource.getDistance(coordinate.getLat(), coordinate.getLon(), coordinate2.getLat(), coordinate2.getLon());
        return d2 / d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        boolean bl;
        super.paintComponent(graphics);
        int n2 = 0;
        int n3 = this.tileSource.getTileSize();
        int n4 = this.center.x / n3;
        int n5 = this.center.y / n3;
        int n6 = this.center.x % n3;
        int n7 = this.center.y % n3;
        int n8 = this.getWidth() / 2;
        int n9 = this.getHeight() / 2;
        int n10 = n8 - n6;
        int n11 = n9 - n7;
        int n12 = n6;
        int n13 = n3 - n6;
        int n14 = n7;
        int n15 = n3 - n7;
        boolean bl2 = n12 < n13;
        boolean bl3 = bl = n14 < n15;
        n2 = bl ? (bl2 ? 2 : 3) : (bl2 ? 1 : 0);
        int n16 = -n3;
        int n17 = -n3;
        int n18 = this.getWidth();
        int n19 = this.getHeight();
        int n20 = 1 << this.zoom;
        boolean bl4 = true;
        int n21 = 0;
        while (bl4) {
            bl4 = false;
            for (n = 0; n < 4; ++n) {
                if (n % 2 == 0) {
                    ++n21;
                }
                for (int i = 0; i < n21; ++i) {
                    if (n16 <= n10 && n10 <= n18 && n17 <= n11 && n11 <= n19) {
                        void var27_34;
                        if (this.scrollWrapEnabled) {
                            int n22 = (n4 % n20 + n20) % n20;
                            Tile tile = this.tileController.getTile(n22, n5, this.zoom);
                        } else {
                            Tile tile = this.tileController.getTile(n4, n5, this.zoom);
                        }
                        if (var27_34 != null) {
                            var27_34.paint(graphics, n10, n11);
                            if (this.tileGridVisible) {
                                graphics.drawRect(n10, n11, n3, n3);
                            }
                        }
                        bl4 = true;
                    }
                    Point object = move[n2];
                    n10 += object.x * n3;
                    n11 += object.y * n3;
                    n4 += object.x;
                    n5 += object.y;
                }
                n2 = (n2 + 1) % move.length;
            }
        }
        n = n3 << this.zoom;
        if (this.scrollWrapEnabled) {
            graphics.drawLine(0, n9 - this.center.y, this.getWidth(), n9 - this.center.y);
            graphics.drawLine(0, n9 - this.center.y + n, this.getWidth(), n9 - this.center.y + n);
        } else {
            graphics.drawRect(n8 - this.center.x, n9 - this.center.y, n, n);
        }
        if (this.scrollWrapEnabled) {
            this.center.x %= n;
        }
        if (this.mapPolygonsVisible && this.mapPolygonList != null) {
            for (MapPolygon mapPolygon : this.mapPolygonList) {
                if (!mapPolygon.isVisible()) continue;
                this.paintPolygon(graphics, mapPolygon);
            }
        }
        if (this.mapRectanglesVisible && this.mapRectangleList != null) {
            for (MapRectangle mapRectangle : this.mapRectangleList) {
                if (!mapRectangle.isVisible()) continue;
                this.paintRectangle(graphics, mapRectangle);
            }
        }
        if (this.mapMarkersVisible && this.mapMarkerList != null) {
            for (MapMarker mapMarker : this.mapMarkerList) {
                if (!mapMarker.isVisible()) continue;
                this.paintMarker(graphics, mapMarker);
            }
        }
        this.attribution.paintAttribution(graphics, this.getWidth(), this.getHeight(), this.getPosition(0, 0), this.getPosition(this.getWidth(), this.getHeight()), this.zoom, this);
    }

    protected void paintMarker(Graphics graphics, MapMarker mapMarker) {
        Point point = this.getMapPosition(mapMarker.getLat(), mapMarker.getLon(), mapMarker.getMarkerStyle() == MapMarker.STYLE.FIXED);
        Integer n = this.getRadius(mapMarker, point);
        if (this.scrollWrapEnabled) {
            int n2;
            int n3 = this.tileSource.getTileSize();
            int n4 = n3 << this.zoom;
            if (point == null) {
                point = this.getMapPosition(mapMarker.getLat(), mapMarker.getLon(), false);
                n = this.getRadius(mapMarker, point);
            }
            mapMarker.paint(graphics, point, n);
            int n5 = n2 = point.x;
            while ((n5 -= n4) >= -15) {
                point.x = n5;
                mapMarker.paint(graphics, point, n);
            }
            n5 = n2;
            while ((n5 += n4) <= this.getWidth() + 15) {
                point.x = n5;
                mapMarker.paint(graphics, point, n);
            }
        } else if (point != null) {
            mapMarker.paint(graphics, point, n);
        }
    }

    protected void paintRectangle(Graphics graphics, MapRectangle mapRectangle) {
        Coordinate coordinate = mapRectangle.getTopLeft();
        Coordinate coordinate2 = mapRectangle.getBottomRight();
        if (coordinate != null && coordinate2 != null) {
            Point point = this.getMapPosition(coordinate, false);
            Point point2 = this.getMapPosition(coordinate2, false);
            if (point != null && point2 != null) {
                mapRectangle.paint(graphics, point, point2);
                if (this.scrollWrapEnabled) {
                    int n;
                    int n2;
                    int n3 = this.tileSource.getTileSize();
                    int n4 = n3 << this.zoom;
                    int n5 = n2 = point.x;
                    int n6 = n = point2.x;
                    while ((n6 -= n4) >= 0) {
                        point.x = n5 -= n4;
                        point2.x = n6;
                        mapRectangle.paint(graphics, point, point2);
                    }
                    n5 = n2;
                    n6 = n;
                    while ((n5 += n4) <= this.getWidth()) {
                        point.x = n5;
                        point2.x = n6 += n4;
                        mapRectangle.paint(graphics, point, point2);
                    }
                }
            }
        }
    }

    protected void paintPolygon(Graphics graphics, MapPolygon mapPolygon) {
        List<? extends ICoordinate> list = mapPolygon.getPoints();
        if (list != null && list.size() >= 3) {
            Cloneable cloneable;
            LinkedList<Point> linkedList = new LinkedList<Point>();
            for (ICoordinate iCoordinate : list) {
                cloneable = this.getMapPosition(iCoordinate, false);
                if (cloneable == null) {
                    return;
                }
                linkedList.add((Point)cloneable);
            }
            mapPolygon.paint(graphics, linkedList);
            if (this.scrollWrapEnabled) {
                Point point;
                Iterator iterator;
                int n = this.tileSource.getTileSize();
                int n2 = n << this.zoom;
                cloneable = new LinkedList<Point>(linkedList);
                boolean bl = true;
                while (bl) {
                    iterator = cloneable.iterator();
                    while (iterator.hasNext()) {
                        point = (Point)iterator.next();
                        point.x -= n2;
                        if (point.x >= 0) continue;
                        bl = false;
                    }
                    mapPolygon.paint(graphics, (List<Point>)((Object)cloneable));
                }
                cloneable = new LinkedList<Point>(linkedList);
                bl = true;
                while (bl) {
                    iterator = cloneable.iterator();
                    while (iterator.hasNext()) {
                        point = (Point)iterator.next();
                        point.x += n2;
                        if (point.x <= this.getWidth()) continue;
                        bl = false;
                    }
                    mapPolygon.paint(graphics, (List<Point>)((Object)cloneable));
                }
            }
        }
    }

    public void moveMap(int n, int n2) {
        this.tileController.cancelOutstandingJobs();
        this.center.x += n;
        this.center.y += n2;
        this.repaint();
        this.fireJMVEvent(new JMVCommandEvent(JMVCommandEvent.COMMAND.MOVE, this));
    }

    public int getZoom() {
        return this.zoom;
    }

    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    public void zoomIn(Point point) {
        this.setZoom(this.zoom + 1, point);
    }

    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    public void zoomOut(Point point) {
        this.setZoom(this.zoom - 1, point);
    }

    public void setZoom(int n, Point point) {
        if (n > this.tileController.getTileSource().getMaxZoom() || n < this.tileController.getTileSource().getMinZoom() || n == this.zoom) {
            return;
        }
        Coordinate coordinate = this.getPosition(point);
        this.tileController.cancelOutstandingJobs();
        this.setDisplayPosition(point, coordinate, n);
        this.fireJMVEvent(new JMVCommandEvent(JMVCommandEvent.COMMAND.ZOOM, this));
    }

    public void setZoom(int n) {
        this.setZoom(n, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    protected void zoomChanged(int n) {
        this.zoomSlider.setToolTipText("Zoom level " + this.zoom);
        this.zoomInButton.setToolTipText("Zoom to level " + (this.zoom + 1));
        this.zoomOutButton.setToolTipText("Zoom to level " + (this.zoom - 1));
        this.zoomOutButton.setEnabled(this.zoom > this.tileController.getTileSource().getMinZoom());
        this.zoomInButton.setEnabled(this.zoom < this.tileController.getTileSource().getMaxZoom());
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean bl) {
        this.tileGridVisible = bl;
        this.repaint();
    }

    public boolean getMapMarkersVisible() {
        return this.mapMarkersVisible;
    }

    public void setMapMarkerVisible(boolean bl) {
        this.mapMarkersVisible = bl;
        this.repaint();
    }

    public void setMapMarkerList(List<MapMarker> list) {
        this.mapMarkerList = list;
        this.repaint();
    }

    public List<MapMarker> getMapMarkerList() {
        return this.mapMarkerList;
    }

    public void setMapRectangleList(List<MapRectangle> list) {
        this.mapRectangleList = list;
        this.repaint();
    }

    public List<MapRectangle> getMapRectangleList() {
        return this.mapRectangleList;
    }

    public void setMapPolygonList(List<MapPolygon> list) {
        this.mapPolygonList = list;
        this.repaint();
    }

    public List<MapPolygon> getMapPolygonList() {
        return this.mapPolygonList;
    }

    public void addMapMarker(MapMarker mapMarker) {
        this.mapMarkerList.add(mapMarker);
        this.repaint();
    }

    public void removeMapMarker(MapMarker mapMarker) {
        this.mapMarkerList.remove(mapMarker);
        this.repaint();
    }

    public void removeAllMapMarkers() {
        this.mapMarkerList.clear();
        this.repaint();
    }

    public void addMapRectangle(MapRectangle mapRectangle) {
        this.mapRectangleList.add(mapRectangle);
        this.repaint();
    }

    public void removeMapRectangle(MapRectangle mapRectangle) {
        this.mapRectangleList.remove(mapRectangle);
        this.repaint();
    }

    public void removeAllMapRectangles() {
        this.mapRectangleList.clear();
        this.repaint();
    }

    public void addMapPolygon(MapPolygon mapPolygon) {
        this.mapPolygonList.add(mapPolygon);
        this.repaint();
    }

    public void removeMapPolygon(MapPolygon mapPolygon) {
        this.mapPolygonList.remove(mapPolygon);
        this.repaint();
    }

    public void removeAllMapPolygons() {
        this.mapPolygonList.clear();
        this.repaint();
    }

    public void setZoomContolsVisible(boolean bl) {
        this.zoomSlider.setVisible(bl);
        this.zoomInButton.setVisible(bl);
        this.zoomOutButton.setVisible(bl);
    }

    public boolean getZoomContolsVisible() {
        return this.zoomSlider.isVisible();
    }

    public void setTileSource(TileSource tileSource) {
        if (tileSource.getMaxZoom() > 22) {
            throw new RuntimeException("Maximum zoom level too high");
        }
        if (tileSource.getMinZoom() < 0) {
            throw new RuntimeException("Minumim zoom level too low");
        }
        Coordinate coordinate = this.getPosition();
        this.tileSource = tileSource;
        this.tileController.setTileSource(tileSource);
        this.zoomSlider.setMinimum(tileSource.getMinZoom());
        this.zoomSlider.setMaximum(tileSource.getMaxZoom());
        this.tileController.cancelOutstandingJobs();
        if (this.zoom > tileSource.getMaxZoom()) {
            this.setZoom(tileSource.getMaxZoom());
        }
        this.attribution.initialize(tileSource);
        this.setDisplayPosition(coordinate, this.zoom);
        this.repaint();
    }

    @Override
    public void tileLoadingFinished(Tile tile, boolean bl) {
        this.repaint();
    }

    public boolean isMapRectanglesVisible() {
        return this.mapRectanglesVisible;
    }

    public void setMapRectanglesVisible(boolean bl) {
        this.mapRectanglesVisible = bl;
        this.repaint();
    }

    public boolean isMapPolygonsVisible() {
        return this.mapPolygonsVisible;
    }

    public void setMapPolygonsVisible(boolean bl) {
        this.mapPolygonsVisible = bl;
        this.repaint();
    }

    public boolean isScrollWrapEnabled() {
        return this.scrollWrapEnabled;
    }

    public void setScrollWrapEnabled(boolean bl) {
        this.scrollWrapEnabled = bl;
        this.repaint();
    }

    public ZOOM_BUTTON_STYLE getZoomButtonStyle() {
        return this.zoomButtonStyle;
    }

    public void setZoomButtonStyle(ZOOM_BUTTON_STYLE zOOM_BUTTON_STYLE) {
        this.zoomButtonStyle = zOOM_BUTTON_STYLE;
        if (this.zoomSlider == null || this.zoomInButton == null || this.zoomOutButton == null) {
            return;
        }
        switch (zOOM_BUTTON_STYLE) {
            case HORIZONTAL: {
                this.zoomSlider.setBounds(10, 10, 30, 150);
                this.zoomInButton.setBounds(4, 155, 18, 18);
                this.zoomOutButton.setBounds(26, 155, 18, 18);
                break;
            }
            case VERTICAL: {
                this.zoomSlider.setBounds(10, 27, 30, 150);
                this.zoomInButton.setBounds(14, 8, 20, 20);
                this.zoomOutButton.setBounds(14, 176, 20, 20);
                break;
            }
            default: {
                this.zoomSlider.setBounds(10, 10, 30, 150);
                this.zoomInButton.setBounds(4, 155, 18, 18);
                this.zoomOutButton.setBounds(26, 155, 18, 18);
            }
        }
        this.repaint();
    }

    public TileController getTileController() {
        return this.tileController;
    }

    @Override
    public TileCache getTileCache() {
        return this.tileController.getTileCache();
    }

    public void setTileLoader(TileLoader tileLoader) {
        this.tileController.setTileLoader(tileLoader);
    }

    public AttributionSupport getAttribution() {
        return this.attribution;
    }

    public void addJMVListener(JMapViewerEventListener jMapViewerEventListener) {
        this.listenerList.add(JMapViewerEventListener.class, jMapViewerEventListener);
    }

    public void removeJMVListener(JMapViewerEventListener jMapViewerEventListener) {
        this.listenerList.remove(JMapViewerEventListener.class, jMapViewerEventListener);
    }

    void fireJMVEvent(JMVCommandEvent jMVCommandEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != JMapViewerEventListener.class) continue;
            ((JMapViewerEventListener)objectArray[i + 1]).processCommand(jMVCommandEvent);
        }
    }

    public static enum ZOOM_BUTTON_STYLE {
        HORIZONTAL,
        VERTICAL;

    }
}

