/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class ResolveUtil {
    public static final PsiScopeProcessor.Event DECLARATION_SCOPE_PASSED = new PsiScopeProcessor.Event(){};

    private ResolveUtil() {
    }

    public static boolean treeWalkUp(PsiElement place, PsiScopeProcessor processor, boolean processNonCodeMethods) {
        PsiElement lastParent = null;
        Project project = place.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        for (PsiElement run = place; run != null; run = run.getContext()) {
            if (!run.processDeclarations(processor, ResolveState.initial(), lastParent, place)) {
                return false;
            }
            if (processNonCodeMethods) {
                PsiClass psiClass;
                if (run instanceof GrTypeDefinition) {
                    ResolveUtil.processNonCodeMethods((PsiType)factory.createType((PsiClass)((GrTypeDefinition)run)), processor, project, place, false);
                } else if (run instanceof GroovyFileBase && ((GroovyFileBase)run).isScript() && (psiClass = ((GroovyFileBase)run).getScriptClass()) != null) {
                    ResolveUtil.processNonCodeMethods((PsiType)factory.createType(psiClass), processor, project, place, false);
                }
            }
            lastParent = run;
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        }
        return true;
    }

    public static boolean processChildren(PsiElement element, PsiScopeProcessor processor, ResolveState substitutor, PsiElement lastParent, PsiElement place) {
        PsiElement run;
        PsiElement psiElement = run = lastParent == null ? element.getLastChild() : lastParent.getPrevSibling();
        while (run != null) {
            if (!run.processDeclarations(processor, substitutor, null, place)) {
                return false;
            }
            run = run.getPrevSibling();
        }
        return true;
    }

    public static boolean processElement(PsiScopeProcessor processor, PsiNamedElement namedElement) {
        String name;
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint == null ? null : nameHint.getName(ResolveState.initial());
        if (name == null || name.equals(namedElement.getName())) {
            return processor.execute((PsiElement)namedElement, ResolveState.initial());
        }
        return true;
    }

    public static boolean processNonCodeMethods(PsiType type, PsiScopeProcessor processor, Project project, PsiElement place, boolean forCompletion) {
        return ResolveUtil.processNonCodeMethods(type, processor, project, new HashSet<String>(), place, forCompletion);
    }

    private static boolean processNonCodeMethods(PsiType type, PsiScopeProcessor processor, Project project, Set<String> visited, PsiElement place, boolean forCompletion) {
        String qName = ResolveUtil.rawCanonicalText(type);
        if (qName != null) {
            if (!visited.add(qName)) {
                return true;
            }
            for (PsiMethod defaultMethod : GroovyPsiManager.getInstance(project).getDefaultMethods(qName)) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)defaultMethod)) continue;
                return false;
            }
            for (PsiMethod method : DynamicManager.getInstance(project).getMethods(qName)) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)method)) continue;
                return false;
            }
            for (PsiVariable var : DynamicManager.getInstance(project).getProperties(qName)) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)var)) continue;
                return false;
            }
            for (NonCodeMembersProcessor nonCodeMembersProcessor : (NonCodeMembersProcessor[])NonCodeMembersProcessor.EP_NAME.getExtensions()) {
                if (nonCodeMembersProcessor.processNonCodeMembers(type, processor, place, forCompletion)) continue;
                return false;
            }
            if (visited.size() == 1) {
                PsiClass psiClass;
                if (type instanceof PsiArrayType) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    PsiClassType t = factory.createTypeByFQClassName("java.lang.Object", GlobalSearchScope.allScope((Project)project));
                    if (!ResolveUtil.processNonCodeMethods((PsiType)t, processor, project, visited, place, forCompletion)) {
                        return false;
                    }
                    t = factory.createTypeByFQClassName("java.lang.Comparable", GlobalSearchScope.allScope((Project)project));
                    if (!ResolveUtil.processNonCodeMethods((PsiType)t, processor, project, visited, place, forCompletion)) {
                        return false;
                    }
                    t = factory.createTypeByFQClassName("java.io.Serializable", GlobalSearchScope.allScope((Project)project));
                    if (!ResolveUtil.processNonCodeMethods((PsiType)t, processor, project, visited, place, forCompletion)) {
                        return false;
                    }
                } else if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && !GroovyDslFileIndex.processExecutors(psiClass, place, processor)) {
                    return false;
                }
            }
            for (NonCodeMembersProcessor nonCodeMembersProcessor : type.getSuperTypes()) {
                if (ResolveUtil.processNonCodeMethods(TypeConversionUtil.erasure((PsiType)nonCodeMembersProcessor), processor, project, visited, place, forCompletion)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static String rawCanonicalText(PsiType type) {
        String result = type.getCanonicalText();
        if (result == null) {
            return null;
        }
        int i = result.indexOf(60);
        if (i > 0) {
            return result.substring(0, i);
        }
        return result;
    }

    @Nullable
    public static PsiType getListTypeForSpreadOperator(GrReferenceExpression refExpr, PsiType componentType) {
        PsiTypeParameter[] typeParameters;
        PsiClass clazz = ResolveUtil.findListClass(refExpr.getManager(), refExpr.getResolveScope());
        if (clazz != null && (typeParameters = clazz.getTypeParameters()).length == 1) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.put(typeParameters[0], componentType);
            return JavaPsiFacade.getInstance((Project)refExpr.getProject()).getElementFactory().createType(clazz, substitutor);
        }
        return null;
    }

    @Nullable
    public static PsiClass findListClass(PsiManager manager, GlobalSearchScope resolveScope) {
        return JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.List", resolveScope);
    }

    public static GroovyPsiElement resolveProperty(GroovyPsiElement place, String name) {
        PropertyResolverProcessor processor = new PropertyResolverProcessor(name, place);
        return (GroovyPsiElement)ResolveUtil.resolveExistingElement(place, processor, GrVariable.class, GrReferenceExpression.class);
    }

    @Nullable
    public static PsiClass resolveClass(GroovyPsiElement place, String name) {
        ClassResolverProcessor processor = new ClassResolverProcessor(name, place);
        return (PsiClass)ResolveUtil.resolveExistingElement(place, processor, PsiClass.class);
    }

    @Nullable
    public static <T> T resolveExistingElement(GroovyPsiElement place, ResolverProcessor processor, Class<? extends T> ... classes) {
        GroovyResolveResult[] candidates;
        ResolveUtil.treeWalkUp(place, processor, true);
        for (GroovyResolveResult candidate : candidates = processor.getCandidates()) {
            PsiElement element = candidate.getElement();
            if (element == place) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(element)) continue;
                return (T)element;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Pair<GrStatement, GrLabeledStatement> resolveLabelTargets(@Nullable String labelName, @Nullable PsiElement element, boolean isBreak) {
        Pair pair;
        if (element == null) {
            pair = new Pair(null, null);
            if (pair == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil.resolveLabelTargets must not return null");
            return pair;
        }
        if (labelName == null) {
            do {
                if ((element = element.getParent()) != null && !(element instanceof GrClosableBlock) && !(element instanceof GrMember) && !(element instanceof GroovyFile)) continue;
                pair = new Pair(null, null);
                if (pair == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil.resolveLabelTargets must not return null");
                return pair;
            } while (!(element instanceof GrLoopStatement) && (!isBreak || !(element instanceof GrSwitchStatement)));
            pair = new Pair((Object)((GrStatement)element), null);
            if (pair == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil.resolveLabelTargets must not return null");
            return pair;
        }
        GrStatement statement = null;
        do {
            PsiElement last = element;
            if ((element = element.getParent()) == null || element instanceof GrMember || element instanceof GroovyFile) break;
            if (element instanceof GrStatement && !(element instanceof GrClosableBlock)) {
                statement = (GrStatement)element;
            }
            for (PsiElement sibling = element; sibling != null; sibling = sibling.getPrevSibling()) {
                GrLabeledStatement labelStatement = ResolveUtil.findLabelStatementIn(sibling, last, labelName);
                if (labelStatement == null) continue;
                pair = new Pair((Object)statement, (Object)labelStatement);
                if (pair == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil.resolveLabelTargets must not return null");
                return pair;
            }
        } while (!(element instanceof GrClosableBlock));
        if ((pair = new Pair(null, null)) != null) return pair;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/ResolveUtil.resolveLabelTargets must not return null");
    }

    private static boolean isApplicableLabelStatement(PsiElement element, String labelName) {
        return element instanceof GrLabeledStatement && labelName.equals(((GrLabeledStatement)element).getLabelName());
    }

    @Nullable
    private static GrLabeledStatement findLabelStatementIn(PsiElement element, PsiElement lastChild, String labelName) {
        if (ResolveUtil.isApplicableLabelStatement(element, labelName)) {
            return (GrLabeledStatement)element;
        }
        for (PsiElement child = element.getFirstChild(); child != null && child != lastChild; child = child.getNextSibling()) {
            GrLabeledStatement statement = ResolveUtil.findLabelStatementIn(child, child, labelName);
            if (statement == null) continue;
            return statement;
        }
        return null;
    }

    @Nullable
    public static GrLabeledStatement resolveLabeledStatement(@Nullable String labelName, @Nullable PsiElement element, boolean isBreak) {
        return (GrLabeledStatement)ResolveUtil.resolveLabelTargets((String)labelName, (PsiElement)element, (boolean)isBreak).second;
    }

    @Nullable
    public static GrStatement resolveLabelTargetStatement(@Nullable String labelName, @Nullable PsiElement element, boolean isBreak) {
        return (GrStatement)ResolveUtil.resolveLabelTargets((String)labelName, (PsiElement)element, (boolean)isBreak).first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processCategoryMembers(PsiElement place, ResolverProcessor processor) {
        PsiElement prev = null;
        while (place != null && !(place instanceof GrMember)) {
            PsiElement resolved;
            GrExpression[] args;
            GrArgumentList argList;
            GrClosableBlock[] closures;
            GrMethodCallExpression call;
            GrExpression invoked;
            if (place instanceof GrMethodCallExpression && (invoked = (call = (GrMethodCallExpression)place).getInvokedExpression()) instanceof GrReferenceExpression && "use".equals(((GrReferenceExpression)invoked).getReferenceName()) && (closures = call.getClosureArguments()).length == 1 && closures[0].equals(prev) && ResolveUtil.useCategoryClass(call) && (argList = call.getArgumentList()) != null && (args = argList.getExpressionArguments()).length == 1 && args[0] instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)args[0]).resolve()) instanceof PsiClass) {
                try {
                    processor.setCurrentFileResolveContext(call);
                    if (!resolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, place)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    processor.setCurrentFileResolveContext(null);
                }
            }
            prev = place;
            place = place.getContext();
        }
        return true;
    }

    private static boolean useCategoryClass(GrMethodCallExpression call) {
        PsiMethod resolved = call.resolveMethod();
        if (resolved instanceof GrGdkMethod) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)call.getProject()).getElementFactory();
            GlobalSearchScope scope = call.getResolveScope();
            PsiType[] parametersType = new PsiType[]{factory.createTypeByFQClassName("java.lang.Class", scope), factory.createTypeByFQClassName("groovy.lang.Closure", scope)};
            MethodSignature pattern = MethodSignatureUtil.createMethodSignature((String)"use", (PsiType[])parametersType, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            return resolved.getSignature(PsiSubstitutor.EMPTY).equals(pattern);
        }
        return false;
    }

    public static PsiElement[] mapToElements(GroovyResolveResult[] candidates) {
        PsiElement[] elements = new PsiElement[candidates.length];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = candidates[i].getElement();
        }
        return elements;
    }

    public static GroovyResolveResult[] filterSameSignatureCandidates(Collection<GroovyResolveResult> candidates, int argumentCount) {
        GroovyResolveResult[] array = candidates.toArray(new GroovyResolveResult[candidates.size()]);
        if (array.length == 1) {
            return array;
        }
        ArrayList<GroovyResolveResult> result = new ArrayList<GroovyResolveResult>();
        result.add(array[0]);
        block0: for (int i = 1; i < array.length; ++i) {
            PsiElement currentElement = array[i].getElement();
            if (currentElement instanceof PsiMethod) {
                PsiMethod currentMethod = (PsiMethod)currentElement;
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    GroovyResolveResult otherResolveResult = (GroovyResolveResult)iterator.next();
                    PsiElement element = otherResolveResult.getElement();
                    if (!(element instanceof PsiMethod)) continue;
                    PsiMethod method = (PsiMethod)element;
                    if (ResolveUtil.dominated(currentMethod, array[i].getSubstitutor(), method, otherResolveResult.getSubstitutor(), argumentCount)) continue block0;
                    if (!ResolveUtil.dominated(method, otherResolveResult.getSubstitutor(), currentMethod, array[i].getSubstitutor(), argumentCount)) continue;
                    iterator.remove();
                }
            }
            result.add(array[i]);
        }
        return result.toArray(new GroovyResolveResult[result.size()]);
    }

    public static boolean dominated(PsiMethod method1, PsiSubstitutor substitutor1, PsiMethod method2, PsiSubstitutor substitutor2, int argumentCount) {
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        if (argumentCount != params1.length && argumentCount == params2.length) {
            return true;
        }
        if (params1.length != params2.length) {
            return false;
        }
        for (int i = 0; i < params2.length; ++i) {
            PsiType type2;
            PsiType type1 = substitutor1.substitute(params1[i].getType());
            if (type1.equals(type2 = substitutor2.substitute(params2[i].getType()))) continue;
            return false;
        }
        return true;
    }

    public static GroovyResolveResult[] getMethodVariants(GroovyPsiElement place) {
        PsiElement parent = place.getParent();
        GroovyResolveResult[] variants = GroovyResolveResult.EMPTY_ARRAY;
        if (parent instanceof GrCallExpression) {
            variants = ((GrCallExpression)parent).getMethodVariants();
        } else if (parent instanceof GrConstructorInvocation) {
            PsiClass clazz = ((GrConstructorInvocation)parent).getDelegatedClass();
            if (clazz != null) {
                PsiMethod[] constructors = clazz.getConstructors();
                variants = ResolveUtil.getConstructorResolveResult(constructors, place);
            }
        } else if (parent instanceof GrAnonymousClassDefinition) {
            PsiElement element = ((GrAnonymousClassDefinition)parent).getBaseClassReferenceGroovy().resolve();
            if (element instanceof PsiClass) {
                PsiMethod[] constructors = ((PsiClass)element).getConstructors();
                variants = ResolveUtil.getConstructorResolveResult(constructors, place);
            }
        } else if (parent instanceof GrApplicationStatement) {
            GrExpression funExpr = ((GrApplicationStatement)parent).getFunExpression();
            if (funExpr instanceof GrReferenceExpression) {
                variants = ((GrReferenceExpression)funExpr).getSameNameVariants();
            }
        } else if (place instanceof GrReferenceExpression) {
            variants = ((GrReferenceExpression)place).getSameNameVariants();
        }
        return variants;
    }

    public static GroovyResolveResult[] getConstructorResolveResult(PsiMethod[] constructors, PsiElement place) {
        GroovyResolveResult[] variants = new GroovyResolveResult[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            boolean isAccessible = PsiUtil.isAccessible((PsiMember)constructors[i], (PsiElement)place, null);
            variants[i] = new GroovyResolveResultImpl((PsiElement)constructors[i], isAccessible);
        }
        return variants;
    }
}

