/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class CollectClassMembersUtil {
    private static final Key<CachedValue<Trinity<Map<String, CandidateInfo>, Map<String, List<CandidateInfo>>, Map<String, CandidateInfo>>>> CACHED_MEMBERS = Key.create((String)"CACHED_CLASS_MEMBERS");
    private static final Key<CachedValue<Trinity<Map<String, CandidateInfo>, Map<String, List<CandidateInfo>>, Map<String, CandidateInfo>>>> CACHED_MEMBERS_INCLUDING_SYNTHETIC = Key.create((String)"CACHED_MEMBERS_INCLUDING_SYNTHETIC");

    private CollectClassMembersUtil() {
    }

    public static Map<String, List<CandidateInfo>> getAllMethods(PsiClass aClass, boolean includeSynthetic) {
        return (Map)CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getSecond();
    }

    @NotNull
    private static Trinity<Map<String, CandidateInfo>, Map<String, List<CandidateInfo>>, Map<String, CandidateInfo>> getCachedMembers(PsiClass aClass, boolean includeSynthetic) {
        Key<CachedValue<Trinity<Map<String, CandidateInfo>, Map<String, List<CandidateInfo>>, Map<String, CandidateInfo>>>> key = includeSynthetic ? CACHED_MEMBERS_INCLUDING_SYNTHETIC : CACHED_MEMBERS;
        CachedValue<Trinity<Map<String, CandidateInfo>, Map<String, List<CandidateInfo>>, Map<String, CandidateInfo>>> cachedValue = (CachedValue<Trinity<Map<String, CandidateInfo>, Map<String, List<CandidateInfo>>, Map<String, CandidateInfo>>>)aClass.getUserData(key);
        if (cachedValue == null) {
            cachedValue = CollectClassMembersUtil.buildCache(aClass, includeSynthetic);
            aClass.putUserData(key, cachedValue);
        }
        Trinity trinity = (Trinity)cachedValue.getValue();
        if (trinity == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/CollectClassMembersUtil.getCachedMembers must not return null");
        }
        return trinity;
    }

    public static Map<String, CandidateInfo> getAllInnerClasses(PsiClass aClass, boolean includeSynthetic) {
        return (Map)CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).getThird();
    }

    public static Map<String, CandidateInfo> getAllFields(PsiClass aClass) {
        return (Map)CollectClassMembersUtil.getCachedMembers(aClass, false).getFirst();
    }

    private static CachedValue<Trinity<Map<String, CandidateInfo>, Map<String, List<CandidateInfo>>, Map<String, CandidateInfo>>> buildCache(final PsiClass aClass, final boolean includeSynthetic) {
        return CachedValuesManager.getManager((Project)aClass.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Trinity<Map<String, CandidateInfo>, Map<String, List<CandidateInfo>>, Map<String, CandidateInfo>>>(){

            public CachedValueProvider.Result<Trinity<Map<String, CandidateInfo>, Map<String, List<CandidateInfo>>, Map<String, CandidateInfo>>> compute() {
                HashMap allFields = new HashMap();
                HashMap allMethods = new HashMap();
                HashMap allInnerClasses = new HashMap();
                CollectClassMembersUtil.processClass(aClass, (Map)allFields, (Map)allMethods, (Map)allInnerClasses, (Set)new HashSet(), PsiSubstitutor.EMPTY, includeSynthetic);
                return CachedValueProvider.Result.create((Object)Trinity.create((Object)allFields, (Object)allMethods, (Object)allInnerClasses), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        }, false);
    }

    private static void processClass(PsiClass aClass, Map<String, CandidateInfo> allFields, Map<String, List<CandidateInfo>> allMethods, Map<String, CandidateInfo> allInnerClasses, Set<PsiClass> visitedClasses, PsiSubstitutor substitutor, boolean includeSynthetic) {
        String name;
        if (visitedClasses.contains(aClass)) {
            return;
        }
        visitedClasses.add(aClass);
        for (PsiField psiField : aClass.getFields()) {
            CandidateInfo candidateInfo;
            PsiElement element;
            name = psiField.getName();
            if (!allFields.containsKey(name)) {
                allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
                continue;
            }
            if (!CollectClassMembersUtil.hasExplicitVisibilityModifiers(psiField) || !((element = (candidateInfo = allFields.get(name)).getElement()) instanceof GrField) || ((GrField)element).getModifierList().hasExplicitVisibilityModifiers() || aClass != ((GrField)element).getContainingClass()) continue;
            allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
        }
        for (PsiField psiField : includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getMethods() : ((GrTypeDefinition)aClass).getGroovyMethods()) {
            CollectClassMembersUtil.addMethod(allMethods, (PsiMethod)psiField, substitutor);
        }
        for (PsiField psiField : aClass.getInnerClasses()) {
            name = psiField.getName();
            if (name == null || allInnerClasses.containsKey(name)) continue;
            allInnerClasses.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
        }
        for (PsiField psiField : aClass.getSuperTypes()) {
            PsiClass superClass = psiField.resolve();
            if (superClass == null) continue;
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)substitutor);
            CollectClassMembersUtil.processClass(superClass, allFields, allMethods, allInnerClasses, visitedClasses, superSubstitutor, includeSynthetic);
        }
    }

    private static boolean hasExplicitVisibilityModifiers(PsiField field) {
        if (field instanceof GrField) {
            return ((GrModifierList)field.getModifierList()).hasExplicitVisibilityModifiers();
        }
        return true;
    }

    private static void addMethod(Map<String, List<CandidateInfo>> allMethods, PsiMethod method, PsiSubstitutor substitutor) {
        String name = method.getName();
        List<CandidateInfo> methods = allMethods.get(name);
        if (methods == null) {
            methods = new ArrayList<CandidateInfo>();
            allMethods.put(name, methods);
            methods.add(new CandidateInfo((PsiElement)method, substitutor));
        } else {
            methods.add(new CandidateInfo((PsiElement)method, substitutor));
        }
    }
}

