/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyExpressionPattern;

public class GroovyMethodCallPattern
extends GroovyExpressionPattern<GrCallExpression, GroovyMethodCallPattern> {
    GroovyMethodCallPattern() {
        super(GrCallExpression.class);
    }

    public GroovyMethodCallPattern withArguments(final ElementPattern<? extends GrExpression> ... arguments) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>("withArguments"){

            public boolean accepts(@NotNull GrCallExpression callExpression, ProcessingContext context) {
                if (callExpression == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern$1.accepts must not be null");
                }
                GrArgumentList argumentList = callExpression.getArgumentList();
                if (argumentList == null) {
                    return false;
                }
                GrExpression[] actualArguments = argumentList.getExpressionArguments();
                if (arguments.length != actualArguments.length) {
                    return false;
                }
                for (int i = 0; i < actualArguments.length; ++i) {
                    if (arguments[i].accepts((Object)actualArguments[i], context)) continue;
                    return false;
                }
                return true;
            }
        });
    }
}

