/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.closure.ForToEachPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class ForToEachIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ForToEachPredicate forToEachPredicate = new ForToEachPredicate();
        if (forToEachPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/closure/ForToEachIntention.getElementPredicate must not return null");
        }
        return forToEachPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        String bodyText;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/closure/ForToEachIntention.processIntention must not be null");
        }
        GrForStatement parentStatement = (GrForStatement)element;
        GrForInClause clause = (GrForInClause)parentStatement.getClause();
        GrVariable var = clause.getDeclaredVariables()[0];
        GrStatement body = parentStatement.getBody();
        if (body instanceof GrBlockStatement) {
            String text = body.getText();
            bodyText = text.substring(1, text.length() - 1);
        } else {
            bodyText = body.getText();
        }
        GrExpression collection = clause.getIteratedExpression();
        assert (collection != null);
        String statement = "x.each{" + var.getText() + " -> " + bodyText + " }";
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(parentStatement.getProject());
        GrMethodCallExpression eachExpression = (GrMethodCallExpression)factory.createTopElementFromText(statement);
        ((GrReferenceExpression)eachExpression.getInvokedExpression()).getQualifierExpression().replaceWithExpression(collection, true);
        parentStatement.replaceWithStatement(eachExpression);
    }
}

